/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterXmlConverter;
import com.ibm.arcs.basic.strings.StringInputStreamUtils;
import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractXmlSerializer
implements XmlSerializer {
    @Override
    public String toString(Object object, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        HierarchicalParameter hierarchicalParameter = this.toHierarchicalParameter(object, xmlSerializerCatalog);
        try {
            return HierarchicalParameterXmlConverter.getSharedInstance().toString(hierarchicalParameter);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "unable to convert object to string", (Throwable)exception));
        }
    }

    @Override
    public InputStream toInputStream(Object object, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        return StringInputStreamUtils.toInputStream((String)this.toString(object, xmlSerializerCatalog));
    }

    @Override
    public Object fromXml(String string, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        HierarchicalParameter hierarchicalParameter;
        try {
            hierarchicalParameter = HierarchicalParameterXmlConverter.getSharedInstance().read(string);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "unable to convert string to hierarchical parameter", (Throwable)exception));
        }
        return this.fromXml(hierarchicalParameter, xmlSerializerCatalog);
    }

    @Override
    public Object fromXml(InputStream inputStream, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        HierarchicalParameter hierarchicalParameter;
        try {
            hierarchicalParameter = HierarchicalParameterXmlConverter.getSharedInstance().read(inputStream);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "unable to convert input stream to hierarchical parameter", (Throwable)exception));
        }
        return this.fromXml(hierarchicalParameter, xmlSerializerCatalog);
    }
}

