/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml.catalog;

import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerMap;
import com.ibm.arcs.serialization.xml.catalog.XmlTagMap;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractXmlSerializerCatalog
implements XmlSerializerCatalog {
    protected final XmlSerializerMap xmlSerializerMap = new XmlSerializerMap();
    protected final XmlTagMap xmlTagMap = new XmlTagMap();
    protected final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.rwlock.readLock();
    protected final Lock writeLock = this.rwlock.writeLock();

    @Override
    public final XmlSerializer getSerializerForClass(Class<?> clazz) {
        try {
            this.readLock.lock();
            XmlSerializer xmlSerializer = this.xmlSerializerMap.getXmlSerializer(clazz);
            return xmlSerializer;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final XmlSerializer getSerializerForClassByName(String string) {
        try {
            this.readLock.lock();
            XmlSerializer xmlSerializer = this.xmlSerializerMap.getXmlSerializerForClassByName(string);
            return xmlSerializer;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final XmlSerializer getSerializerForTag(String string) {
        try {
            XmlSerializer xmlSerializer;
            this.readLock.lock();
            Class<?> clazz = this.xmlTagMap.getClass(string);
            XmlSerializer xmlSerializer2 = xmlSerializer = this.xmlSerializerMap.getXmlSerializer(clazz);
            return xmlSerializer2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final String getTagForClass(Class<?> clazz) {
        try {
            this.readLock.lock();
            String string = this.xmlTagMap.getTag(clazz);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Set<String> getTags() {
        try {
            this.readLock.lock();
            Set<String> set = this.xmlTagMap.getTags();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Set<XmlSerializer> getSerializers() {
        try {
            this.readLock.lock();
            Set<XmlSerializer> set = this.xmlSerializerMap.getXmlSerializers();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected final void clearXmlSerializerMap() {
        try {
            this.writeLock.lock();
            this.xmlSerializerMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected final void clearXmlTagMap() {
        try {
            this.writeLock.lock();
            this.xmlTagMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

