/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml.serializer.number;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.serialization.xml.AbstractXmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;
import java.math.BigDecimal;

public class BigDecimalXmlSerializer
extends AbstractXmlSerializer {
    private static final String ID = "java.lang.BigDecimal";

    @Override
    public boolean accepts(Class<?> clazz) {
        return clazz.equals(BigDecimal.class);
    }

    @Override
    public HierarchicalParameter toHierarchicalParameter(Object object, XmlSerializerCatalog xmlSerializerCatalog) {
        if (this.accepts(object.getClass())) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return ObjectSerializer.createSkeletonHierarchicalParameter(ID, bigDecimal.toString());
        }
        throw new IllegalArgumentException("unsupported object type");
    }

    @Override
    public Object fromXml(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) {
        if (!hierarchicalParameter.getKey().equals("object")) {
            throw new IllegalArgumentException("not an xml serializable object");
        }
        if (!hierarchicalParameter.getAttribute("class").getValue().equals(ID)) {
            throw new IllegalArgumentException("not an xml serializable BigDecimal");
        }
        return new BigDecimal(hierarchicalParameter.getValue());
    }
}

