/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml.serializer.number;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.serialization.xml.AbstractXmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;

public class LongXmlSerializer
extends AbstractXmlSerializer {
    private static final String ID = "java.lang.Long";

    @Override
    public boolean accepts(Class<?> clazz) {
        return clazz.equals(Long.class);
    }

    @Override
    public HierarchicalParameter toHierarchicalParameter(Object object, XmlSerializerCatalog xmlSerializerCatalog) {
        if (this.accepts(object.getClass())) {
            Long l = (Long)object;
            return ObjectSerializer.createSkeletonHierarchicalParameter(ID, l.toString());
        }
        throw new IllegalArgumentException("unsupported object type");
    }

    @Override
    public Object fromXml(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) {
        if (!hierarchicalParameter.getKey().equals("object")) {
            throw new IllegalArgumentException("not an xml serializable object");
        }
        if (!hierarchicalParameter.getAttribute("class").getValue().equals(ID)) {
            throw new IllegalArgumentException("not an xml serializable Long");
        }
        return Long.parseLong(hierarchicalParameter.getValue());
    }
}

