/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxASFException;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataInputStream
extends FilterInputStream {
    private InputStream is;
    private final int one = 1;
    private final short DEF_PREC = 0;
    private byte[] smint_buf = new byte[2];
    private byte[] int_buf = new byte[4];
    private byte[] lgint_buf = new byte[10];
    private byte[] long_buf = new byte[8];
    private String ClientLocale = null;
    private IfxToJavaType ifxtojava = new IfxToJavaType();

    public IfxDataInputStream(InputStream inputStream) {
        super(inputStream);
        this.is = inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.is.read(byArray);
    }

    public byte readByte() throws IOException {
        int n = this.is.read();
        return (byte)n;
    }

    public int readFully(byte[] byArray) throws IOException {
        return this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.is.read(byArray, n, n2);
    }

    public int readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.is.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new IOException();
        }
        return n3;
    }

    public int readPadded(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        n3 = this.readFully(byArray, n, n2);
        if ((n2 & 1) >= 1) {
            this.read();
        }
        return n3;
    }

    public int readPadded(byte[] byArray) throws IOException {
        int n = this.readFully(byArray, 0, byArray.length);
        if ((byArray.length & 1) >= 1) {
            this.read();
        }
        return n;
    }

    public int skipBytes(int n) throws IOException {
        int n2 = 0;
        while ((n2 += (int)this.is.skip(n - n2)) < n) {
        }
        return n;
    }

    public int readInt() throws IOException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaInt(this.int_buf);
    }

    public String readChar() throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        n = this.readFully(byArray, n2, n3);
        n3 -= n;
        n2 += n;
        if ((byArray.length & 1) >= 1) {
            this.read();
        }
        return this.ifxtojava.IfxToJavaChar(byArray);
    }

    public String readChar(String string) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        n = this.readFully(byArray, n2, n3);
        n3 -= n;
        n2 += n;
        if ((byArray.length & 1) >= 1) {
            this.read();
        }
        return this.ifxtojava.IfxToJavaChar(byArray, string);
    }

    public Date readDate() throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaDate(this.int_buf);
    }

    public Timestamp readDateTime(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDateTime(byArray, s);
    }

    public byte[] readRawDateTime(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.read();
        }
        return byArray;
    }

    public Interval readInterval(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaInterval(byArray, s);
    }

    public BigDecimal readDecimal(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDecimal(byArray, s);
    }

    public double readDouble(short s) throws IOException, IfxASFException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaDouble(this.long_buf);
    }

    public float readReal(short s) throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaReal(this.int_buf);
    }

    public short readSmallInt() throws IOException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        return IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
    }

    public short readShort() throws IOException {
        return this.readSmallInt();
    }

    public long readLongInt() throws IOException {
        this.readFully(this.lgint_buf, 0, this.lgint_buf.length);
        return IfxToJavaType.IfxToJavaLongInt(this.lgint_buf);
    }

    public long readLong() throws IOException {
        return this.readLongInt();
    }

    public void setClientLocale(String string) {
        this.ClientLocale = string;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }

    public long readLongBigint() throws IOException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaLongBigInt(this.long_buf);
    }
}

