/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.crypto.IfxCipher;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEncPkt;
import java.io.ByteArrayInputStream;
import java.util.Vector;

class IfxCipherElem {
    int cipherType;
    int mode;
    private static int CPHRELMLIST_COUNT_CSIZE = 2;
    private static int CPHR_CSIZE = 2;
    private static int MODE_CSIZE = 2;

    IfxCipherElem(int n, int n2) {
        this.cipherType = n;
        this.mode = n2;
    }

    int getCipherType() {
        return this.cipherType;
    }

    int getMode() {
        return this.mode;
    }

    IfxCipher getCipher() {
        return IfxCipher.FindCipherByID(this.cipherType);
    }

    public boolean equals(Object object) {
        IfxCipherElem ifxCipherElem;
        return object != null && this.getClass() == object.getClass() && this.mode == (ifxCipherElem = (IfxCipherElem)object).getMode() && this.cipherType == ifxCipherElem.getCipherType();
    }

    boolean isStrongerThan(IfxCipherElem ifxCipherElem) {
        return this.mode > ifxCipherElem.getMode() || this.mode == ifxCipherElem.getMode() && this.cipherType > ifxCipherElem.getCipherType();
    }

    static boolean isCipherInList(IfxCipherElem ifxCipherElem, Vector vector) {
        return vector.contains(ifxCipherElem);
    }

    static int cryptoGetCiphers(IfxCsmBuffer ifxCsmBuffer, IfxCryptoCtx ifxCryptoCtx) {
        int n = 0;
        boolean bl = false;
        Vector vector = ifxCryptoCtx.RegisteredCiphers;
        if (vector == null || vector.isEmpty()) {
            n = -20;
        } else {
            ifxCsmBuffer.reset();
            ifxCsmBuffer.write(IfxCryptoUtils.JavaToIfxInt(vector.size(), CPHRELMLIST_COUNT_CSIZE));
            for (int i = 0; i < vector.size(); ++i) {
                IfxCipherElem ifxCipherElem = (IfxCipherElem)vector.get(i);
                ifxCsmBuffer.write(IfxCryptoUtils.JavaToIfxInt(ifxCipherElem.getCipherType(), CPHR_CSIZE));
                ifxCsmBuffer.write(IfxCryptoUtils.JavaToIfxInt(ifxCipherElem.getMode(), MODE_CSIZE));
            }
        }
        if (n != 0) {
            IfxCryptoCtx.printError(null, "CryptoGetCiphers", n);
        }
        return n;
    }

    static int negotiateCipher(IfxEncPkt ifxEncPkt, byte[] byArray, IfxCryptoCtx ifxCryptoCtx) {
        int n;
        int n2;
        IfxCipherElem ifxCipherElem;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n3 = 0;
        int n4 = 0;
        Object var6_6 = null;
        Vector vector = ifxCryptoCtx.RegisteredCiphers;
        n4 = IfxCryptoUtils.readInt(byteArrayInputStream, CPHRELMLIST_COUNT_CSIZE);
        while (!(n4-- <= 0 || n3 != 0 || IfxCipher.isCipherElementValid(ifxCipherElem = new IfxCipherElem(n2 = IfxCryptoUtils.readInt(byteArrayInputStream, CPHR_CSIZE), n = IfxCryptoUtils.readInt(byteArrayInputStream, MODE_CSIZE))) && IfxCipherElem.isCipherInList(ifxCipherElem, vector) && (n3 = IfxCipher.insertCipher(ifxCipherElem, ifxEncPkt.NegoaitedCipherList)) != 0)) {
        }
        if (n3 == 0 && ifxEncPkt.NegoaitedCipherList.isEmpty()) {
            n3 = -20;
        }
        if (n3 != 0) {
            IfxCryptoCtx.printError(ifxEncPkt, "CryptoNegotiateCiphers", n3);
        }
        return n3;
    }

    String getTransformString() {
        IfxCipher ifxCipher = null;
        ifxCipher = this.getCipher();
        String string = ifxCipher.getAlgorithmName();
        String string2 = IfxCipher.FindNameByMode(this.mode);
        String string3 = IfxCipher.getPaddingScheme(this);
        String string4 = string + "/" + string2 + "/" + string3;
        return string4;
    }
}

