/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmException;
import com.informix.csm.crypto.IfxCHash;
import com.informix.csm.crypto.IfxCipherElem;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEDPkt;
import com.informix.csm.crypto.IfxEncPkt;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class IfxCryptoEngine {
    static final String PKCS5PADDINGSCHEME = "PKCS5Padding";
    static final String NOPADDINGSCHEME = "NoPadding";
    static final String TRANSFORM_SEPARATOR = "/";
    private static final String DH_ALGO = "DH";
    private static final String DH_MODULUS_string = "CB4AAD9AD0B42AF666B42B57463C7325B781EFA79B5063AB0CCE98D23B3AA975475549A99E3E75EC1DBC9503CD6C1303BA6184FC769ED599966DA4BD84558EB7";
    private static final BigInteger DH_MODULUS = new BigInteger("CB4AAD9AD0B42AF666B42B57463C7325B781EFA79B5063AB0CCE98D23B3AA975475549A99E3E75EC1DBC9503CD6C1303BA6184FC769ED599966DA4BD84558EB7", 16);
    private static final BigInteger DH_GENERATOR = BigInteger.valueOf(5L);
    static DHParameterSpec dhParamSpec = null;
    static KeyPairGenerator dhKeyPairGenerator = null;
    static KeyFactory dhKeyFactory = null;
    static final int ENCRYPT = 1;
    static final int DECRYPT = 2;
    private static final int DESX_KEY_LENGTH = 16;
    private static final int RC5_WORD_SIZE = 64;
    private static final int RC5_VERSION = 3;
    Cipher cipher;
    IfxEDPkt edPkt = null;
    int mode;
    IfxCipherElem cryptoEngineCipherElem;

    IfxCryptoEngine(IfxEncPkt ifxEncPkt, int n) throws IfxCsmException {
        this.mode = n;
        this.edPkt = n == 1 ? ifxEncPkt.Encrypt : ifxEncPkt.Decrypt;
        this.cryptoEngineCipherElem = this.getCipherElem();
        this.instantiateCipher();
    }

    void initCipher() throws IfxCsmException {
        IfxCHash.generateHash(this.edPkt.IV, this.getBlockSize(), this.edPkt.SecretKey);
        this.initCipher(this.mode, this.cryptoEngineCipherElem, this.edPkt.SecretKey, this.edPkt.IV.Hash);
    }

    private void initCipher(int n, IfxCipherElem ifxCipherElem, byte[] byArray, byte[] byArray2) throws IfxCsmException {
        boolean bl = false;
        try {
            switch (ifxCipherElem.getCipherType()) {
                case 1: {
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, 8, ifxCipherElem.getCipher().getAlgorithmName());
                    this.cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
                    break;
                }
                case 2: 
                case 8: {
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, 24, ifxCipherElem.getCipher().getAlgorithmName());
                    this.cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
                    break;
                }
                case 3: {
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, 16, ifxCipherElem.getCipher().getAlgorithmName());
                    this.cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, ifxCipherElem.getCipher().getKeySize(), ifxCipherElem.getCipher().getAlgorithmName());
                    this.cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, ifxCipherElem.getCipher().getKeySize(), ifxCipherElem.getCipher().getAlgorithmName());
                    RC2ParameterSpec rC2ParameterSpec = new RC2ParameterSpec(ifxCipherElem.getCipher().getRC2Key(), byArray2);
                    this.cipher.init(n, (Key)secretKeySpec, rC2ParameterSpec);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, ifxCipherElem.getCipher().getKeySize(), ifxCipherElem.getCipher().getAlgorithmName());
                    RC5ParameterSpec rC5ParameterSpec = new RC5ParameterSpec(3, ifxCipherElem.getCipher().getRC5Rounds(), 64, byArray2);
                    this.cipher.init(n, (Key)secretKeySpec, rC5ParameterSpec);
                    break;
                }
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw IfxCryptoSession.getCsmErrException(-10, invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw IfxCryptoSession.getCsmErrException(-10, invalidAlgorithmParameterException);
        }
    }

    byte[] updateCipher(byte[] byArray, int n, int n2) {
        return this.cipher.update(byArray, n, n2);
    }

    byte[] updateCipher(byte[] byArray) {
        return this.cipher.update(byArray);
    }

    byte[] doFinal() throws IfxCsmException {
        try {
            return this.cipher.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
            throw this.getGenericEDecryptException(illegalStateException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw this.getGenericEDecryptException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw this.getGenericEDecryptException(badPaddingException);
        }
    }

    byte[] doFinal(byte[] byArray, int n, int n2) throws IfxCsmException {
        try {
            return this.cipher.doFinal(byArray, n, n2);
        }
        catch (BadPaddingException badPaddingException) {
            throw this.getGenericEDecryptException(badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw this.getGenericEDecryptException(illegalBlockSizeException);
        }
        catch (IllegalStateException illegalStateException) {
            throw this.getGenericEDecryptException(illegalStateException);
        }
    }

    byte[] doFinal(byte[] byArray) throws IfxCsmException {
        return this.doFinal(byArray, 0, byArray.length);
    }

    int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    private void instantiateCipher() throws IfxCsmException {
        try {
            this.cipher = Cipher.getInstance(this.cryptoEngineCipherElem.getTransformString());
        }
        catch (Exception exception) {
            try {
                this.cipher = Cipher.getInstance(this.cryptoEngineCipherElem.getTransformString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw IfxCryptoSession.getCsmErrException(-10, noSuchAlgorithmException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw IfxCryptoSession.getCsmErrException(-10, noSuchPaddingException);
            }
        }
    }

    static byte[] generateHMAC(byte[] byArray, IfxEDPkt ifxEDPkt) throws IfxCsmException {
        IfxCHash.generateHash(ifxEDPkt.MAC, 36, ifxEDPkt.MacKey);
        return IfxCryptoEngine.internalGenerateHMAC(ifxEDPkt.MAC.Hash, byArray, 0, byArray.length);
    }

    static byte[] internalGenerateHMAC(byte[] byArray, byte[] byArray2) throws IfxCsmException {
        return IfxCryptoEngine.internalGenerateHMAC(byArray, byArray2, 0, byArray2.length);
    }

    static byte[] internalGenerateHMAC(byte[] byArray, byte[] byArray2, int n, int n2) throws IfxCsmException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
        Mac mac = null;
        try {
            mac = Mac.getInstance(secretKeySpec.getAlgorithm());
            mac.init(secretKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw IfxCryptoSession.getCsmErrException(-12, noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw IfxCryptoSession.getCsmErrException(-12, invalidKeyException);
        }
        mac.update(byArray2, n, n2);
        return mac.doFinal();
    }

    private IfxCsmException getGenericEDecryptException(Exception exception) {
        if (this.mode == 1) {
            return IfxCryptoSession.getCsmErrException(-6, exception);
        }
        return IfxCryptoSession.getCsmErrException(-7, exception);
    }

    static KeyAgreement generateDHKeyAgreement() throws IfxCsmException {
        KeyAgreement keyAgreement = null;
        try {
            keyAgreement = KeyAgreement.getInstance(DH_ALGO);
        }
        catch (Exception exception) {
            try {
                keyAgreement = KeyAgreement.getInstance(DH_ALGO);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw IfxCryptoSession.getCsmErrException(-4, noSuchAlgorithmException);
            }
        }
        return keyAgreement;
    }

    static byte[] generatePublicKey(IfxEncPkt ifxEncPkt) throws IfxCsmException {
        if (ifxEncPkt.DH == null) {
            ifxEncPkt.DH = IfxCryptoEngine.generateDHKeyAgreement();
        }
        return IfxCryptoEngine.generatePublicKey(ifxEncPkt.DH);
    }

    static byte[] generatePublicKey(IfxEDPkt ifxEDPkt) throws IfxCsmException {
        if (ifxEDPkt.DH == null) {
            ifxEDPkt.DH = IfxCryptoEngine.generateDHKeyAgreement();
        }
        return IfxCryptoEngine.generatePublicKey(ifxEDPkt.DH);
    }

    static byte[] generatePublicKey(KeyAgreement keyAgreement) throws IfxCsmException {
        if (dhKeyPairGenerator == null) {
            if (dhParamSpec == null) {
                dhParamSpec = new DHParameterSpec(DH_MODULUS, DH_GENERATOR);
            }
            try {
                dhKeyPairGenerator = KeyPairGenerator.getInstance(DH_ALGO);
                dhKeyPairGenerator.initialize(dhParamSpec);
            }
            catch (Exception exception) {
                try {
                    dhKeyPairGenerator = KeyPairGenerator.getInstance(DH_ALGO);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw IfxCryptoSession.getCsmErrException(-4, noSuchAlgorithmException);
                }
            }
        }
        KeyPair keyPair = dhKeyPairGenerator.genKeyPair();
        DHPublicKey dHPublicKey = (DHPublicKey)keyPair.getPublic();
        try {
            keyAgreement.init(keyPair.getPrivate());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw IfxCryptoSession.getCsmErrException(-4, invalidKeyException);
        }
        BigInteger bigInteger = dHPublicKey.getY();
        return IfxCryptoUtils.bigIntegerToBinary(bigInteger);
    }

    static byte[] acceptPublicKey(KeyAgreement keyAgreement, byte[] byArray) throws IfxCsmException {
        if (dhKeyFactory == null) {
            try {
                dhKeyFactory = KeyFactory.getInstance(DH_ALGO);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw IfxCryptoSession.getCsmErrException(-5, noSuchAlgorithmException);
            }
        }
        BigInteger bigInteger = IfxCryptoUtils.binaryToBigInteger(byArray);
        DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, DH_MODULUS, DH_GENERATOR);
        PublicKey publicKey = null;
        try {
            publicKey = dhKeyFactory.generatePublic(dHPublicKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw IfxCryptoSession.getCsmErrException(-5, invalidKeySpecException);
        }
        try {
            keyAgreement.doPhase(publicKey, true);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw IfxCryptoSession.getCsmErrException(-5, invalidKeyException);
        }
        catch (IllegalStateException illegalStateException) {
            throw IfxCryptoSession.getCsmErrException(-5, illegalStateException);
        }
        return keyAgreement.generateSecret();
    }

    private IfxCipherElem getCipherElem() {
        IfxCipherElem ifxCipherElem = this.edPkt.cipherElem;
        return ifxCipherElem;
    }
}

