/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.lang.IfxToJavaType;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;

class IfxCryptoUtils {
    static final int BYTESHIFT = 8;
    static final int IFX_INT4_SIZE = 4;
    static final int IFX_INT3_SIZE = 3;
    static final int IFX_INT2_SIZE = 2;
    static final int IFX_INT1_SIZE = 1;
    static final int IFX_UINT4_SIZE = 4;

    IfxCryptoUtils() {
    }

    static byte[] JavaToIfxInt(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i <= n2 - 1; ++i) {
            byArray[i] = (byte)(n >> 8 * (n2 - 1 - i));
        }
        return byArray;
    }

    static byte[] JavaToIfx2Int(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 2;
        for (int i = 0; i <= n3 - 1; ++i) {
            byArray[i] = (byte)(n >> 8 * (n3 - 1 - i));
        }
        return byArray;
    }

    static byte[] JavaToIfxLong(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i <= n - 1; ++i) {
            byArray[i] = (byte)(l >> 8 * (n - 1 - i));
        }
        return byArray;
    }

    static int Ifx4ToJavaInt(byte[] byArray, int n) {
        return IfxToJavaType.IfxToJavaInt(byArray, n);
    }

    static int Ifx4ToJavaInt(byte[] byArray) {
        return IfxCryptoUtils.Ifx4ToJavaInt(byArray, 0);
    }

    static long Ifx4ToJavaLong(byte[] byArray, int n) {
        long l = IfxCryptoUtils.widenByte(byArray[0 + n]);
        l = (((l << 8) + (long)IfxCryptoUtils.widenByte(byArray[1 + n]) << 8) + (long)IfxCryptoUtils.widenByte(byArray[2 + n]) << 8) + (long)IfxCryptoUtils.widenByte(byArray[3 + n]);
        return l;
    }

    static long Ifx4ToJavaLong(byte[] byArray) {
        return IfxCryptoUtils.Ifx4ToJavaLong(byArray, 0);
    }

    static int Ifx3ToJavaInt(byte[] byArray, int n) {
        int n2 = IfxCryptoUtils.widenByte(byArray[0 + n]);
        n2 = ((n2 << 8) + IfxCryptoUtils.widenByte(byArray[1 + n]) << 8) + IfxCryptoUtils.widenByte(byArray[2 + n]);
        return n2;
    }

    static int Ifx3ToJavaInt(byte[] byArray) {
        return IfxCryptoUtils.Ifx3ToJavaInt(byArray, 0);
    }

    static int Ifx2ToJavaInt(byte[] byArray, int n) {
        int n2 = IfxCryptoUtils.widenByte(byArray[0 + n]);
        n2 = (n2 << 8) + IfxCryptoUtils.widenByte(byArray[1 + n]);
        return n2;
    }

    static int Ifx2ToJavaInt(byte[] byArray) {
        return IfxCryptoUtils.Ifx2ToJavaInt(byArray, 0);
    }

    static int Ifx1ToJavaInt(byte[] byArray, int n) {
        short s = IfxCryptoUtils.widenByte(byArray[0 + n]);
        return s;
    }

    private static final short widenByte(byte by) {
        return (short)((short)by & 0xFF);
    }

    private static int readInt3(ByteArrayInputStream byteArrayInputStream) {
        return IfxCryptoUtils.Ifx3ToJavaInt(IfxCryptoUtils.readByteInputStream(byteArrayInputStream, 3));
    }

    private static int readInt4(ByteArrayInputStream byteArrayInputStream) {
        return IfxCryptoUtils.Ifx4ToJavaInt(IfxCryptoUtils.readByteInputStream(byteArrayInputStream, 4));
    }

    private static int readInt2(ByteArrayInputStream byteArrayInputStream) {
        return IfxCryptoUtils.Ifx2ToJavaInt(IfxCryptoUtils.readByteInputStream(byteArrayInputStream, 2));
    }

    private static int readInt1(ByteArrayInputStream byteArrayInputStream) {
        return IfxCryptoUtils.Ifx2ToJavaInt(IfxCryptoUtils.readByteInputStream(byteArrayInputStream, 1));
    }

    static long readUInt4(ByteArrayInputStream byteArrayInputStream) {
        return IfxCryptoUtils.Ifx4ToJavaLong(IfxCryptoUtils.readByteInputStream(byteArrayInputStream, 4));
    }

    static long readUInt4(ByteArrayInputStream byteArrayInputStream, int n) {
        switch (n) {
            case 4: {
                return IfxCryptoUtils.readUInt4(byteArrayInputStream);
            }
        }
        return IfxCryptoUtils.readUInt4(byteArrayInputStream);
    }

    static int readInt(ByteArrayInputStream byteArrayInputStream, int n) {
        switch (n) {
            case 1: {
                return IfxCryptoUtils.readInt1(byteArrayInputStream);
            }
            case 2: {
                return IfxCryptoUtils.readInt2(byteArrayInputStream);
            }
            case 3: {
                return IfxCryptoUtils.readInt3(byteArrayInputStream);
            }
            case 4: {
                return IfxCryptoUtils.readInt4(byteArrayInputStream);
            }
        }
        return IfxCryptoUtils.readInt4(byteArrayInputStream);
    }

    static byte[] readByteInputStream(ByteArrayInputStream byteArrayInputStream, int n) {
        byte[] byArray = new byte[n];
        byteArrayInputStream.read(byArray, 0, byArray.length);
        return byArray;
    }

    static byte[] readFullyByteInputStream(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[byteArrayInputStream.available()];
        byteArrayInputStream.read(byArray, 0, byteArrayInputStream.available());
        byteArrayInputStream.reset();
        return byArray;
    }

    static void stringBufferToLowerCase(StringBuffer stringBuffer) {
        String string = stringBuffer.toString().toLowerCase();
        stringBuffer.replace(0, stringBuffer.length(), string);
    }

    static boolean isLengthZero(StringBuffer stringBuffer) {
        return stringBuffer.length() <= 0;
    }

    static void removeWhiteSpaces(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (!Character.isWhitespace(stringBuffer.charAt(i))) continue;
            stringBuffer.deleteCharAt(i);
            --i;
        }
    }

    static long getCurrentTimeinSec() {
        return System.currentTimeMillis() / 1000L;
    }

    static boolean areArrayElemntsEqual(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        try {
            if (byArray.length < n + n3) {
                return false;
            }
            if (byArray2.length < n2 + n3) {
                return false;
            }
            for (int i = 0; i < n3; ++i) {
                if (byArray[n + i] == byArray2[n2 + i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static byte[] bigIntegerToBinary(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] != 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        return byArray2;
    }

    static BigInteger binaryToBigInteger(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    static byte[] createCopy(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    static boolean isFlagSet(int n, int n2) {
        return (n & n2) > 0;
    }

    static boolean isClassInClasspath(String string) {
        try {
            if (Class.forName(string) != null) {
                // empty if block
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

