/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSmartLobOutputStream;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxBblob
extends IfxLob
implements Blob {
    public IfxBblob() {
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    public IfxBblob(IfxLocator ifxLocator) {
        this.locatorPointer = ifxLocator;
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    public IfxBblob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this.conn = ifxConnection;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
        this.smb = new IfxSmartBlob(ifxConnection);
        this.smb.IfxLoOpen(ifxLocator, ifxConnection.isReadOnly() ? 4 : 8);
    }

    public IfxBblob(IfxConnection ifxConnection, IfxLocator ifxLocator, int n) throws SQLException {
        this.conn = ifxConnection;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
        this.smb = new IfxSmartBlob(ifxConnection);
        this.smb.IfxLoOpen(ifxLocator, ifxConnection.isReadOnly() ? 4 : 8);
    }

    protected IfxBblob(byte[] byArray) {
        this.blobBuffer = byArray;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
    }

    public IfxBblob(InputStream inputStream) {
        this.blobStream = inputStream;
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    protected IfxBblob(IfxTmpFile ifxTmpFile) {
        this.tempBlobFile = ifxTmpFile;
        this.tempBlobFile.incRefCount();
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n) throws SQLException {
        super(connection, inputStream, n);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n, String string) throws SQLException {
        super(connection, inputStream, n, string);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, inputStream, n, ifxLobDescriptor);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray) throws SQLException {
        super(connection, byArray);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray, String string) throws SQLException {
        super(connection, byArray, string);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, byArray, ifxLobDescriptor);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    @Override
    public IfxLocator getLocator() throws SQLException {
        return super.getLocator();
    }

    @Override
    public long length() throws SQLException {
        return this.blobSize;
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        return super.getPortion(l, n);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return super.getStream();
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        long l2 = l - 1L;
        byte[] byArray2 = super.getPortion(1L, this.blobSize);
        if (byArray2 == null) {
            return -1L;
        }
        String string = new String(byArray2);
        long l3 = string.indexOf(new String(byArray), (int)l2);
        if (l3 >= 0L) {
            ++l3;
        }
        return l3;
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    public void setBinaryStream(long l, InputStream inputStream, int n) throws SQLException {
        this.verifyBlob();
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        super.setStream(inputStream, n);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }

    @Override
    public long seek(long l, int n) throws SQLException {
        return super.seek(l, n);
    }

    @Override
    public long where() throws SQLException {
        return super.where();
    }

    @Override
    public IfxLoStat getLoStat() throws SQLException {
        return super.getLoStat();
    }

    @Override
    public void truncate(long l) throws SQLException {
        super.truncate(l);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.verifyBlob();
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        return super.setBuffer(byArray, n, n2);
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        this.verifyBlob();
        return new IfxSmartLobOutputStream(this, l);
    }

    protected synchronized void finalize() {
        try {
            if (this.smb != null) {
                super.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verifyBlob() throws SQLException {
        if (this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        this.verifySmbMode();
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getBinaryStream", (IfxConnection)null);
    }

    @Override
    public void free() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "free", (IfxConnection)null);
    }
}

