/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxBigInt
extends IfxObject {
    private long value;
    public static final long IFX_BIGINT_NULL = Long.MIN_VALUE;

    IfxBigInt() throws SQLException {
        this.setIfxType(52);
    }

    IfxBigInt(long l) throws SQLException {
        this.setIfxType(52);
        this.value = l;
        this.unnullify();
    }

    IfxBigInt(Long l) throws SQLException {
        this.setIfxType(52);
        this.value = l;
        this.unnullify();
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxLongBigInt(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[8];
            memoryUtil.byfill(byArray, (byte)0);
            return byArray;
        }
        return JavaToIfxType.JavaToIfxLongBigInt(this.value);
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.value);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        this.value = IfxToJavaType.IfxToJavaLongBigInt(byArray, n);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.value = by;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.value = by.longValue();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.value = s.longValue();
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (int)this.value;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.value = n;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.value = n.longValue();
            this.unnullify();
        }
    }

    public void fromShort(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.value = n.longValue();
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = l;
        this.unnullify();
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.value = l;
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = (long)f;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.value = f.longValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = (long)d;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.value = d.longValue();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(Long.toString(this.value));
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.longValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0L;
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl ? 1 : 0;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.value = bl == true ? 1 : 0;
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            this.value = Long.valueOf(string.trim());
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        return object instanceof IfxBigInt && this.value == ((IfxBigInt)object).value;
    }

    @Override
    public short getEncodedLength() {
        short s = 4864;
        return s;
    }

    public boolean isIfxNull() {
        return this.value == Long.MIN_VALUE;
    }
}

