/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

class IfxBoolean
extends IfxBaseType {
    boolean value;
    public static final byte IFX_BOOL_NULL = -1;

    IfxBoolean() throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
    }

    IfxBoolean(boolean bl) throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
        this.unnullify();
        this.value = bl;
    }

    IfxBoolean(Boolean bl) throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
        this.unnullify();
        this.value = bl;
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        super.fromIfx(byArray, n, n2);
        if (!this.isNull()) {
            byte by = this.inputStream.readByte();
            if (by == 1) {
                this.value = true;
            } else if (by == 0) {
                this.value = false;
            } else if (by == -1) {
                this.nullify();
            }
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            byte by = this.value ? (byte)1 : 0;
            this.outputStream.writeByte(by);
        }
        return super.toIfx();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        byte[] byArray;
        if (this.isNull()) {
            byArray = new byte[5];
            memoryUtil.byfill(byArray, (byte)0);
            byArray[0] = 1;
        } else {
            byArray = new byte[6];
            byArray[0] = 0;
            byte[] byArray2 = this.toIfx();
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[i + 1] = byArray2[i];
            }
        }
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxBoolean)) {
            return false;
        }
        IfxBoolean ifxBoolean = (IfxBoolean)object;
        if (ifxBoolean.isNull()) {
            return false;
        }
        return this.value == ifxBoolean.value;
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Boolean(this.value);
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0;
        }
        return 1;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = s == 1;
        this.unnullify();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.toInt();
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = d == 1.0;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d);
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.toInt();
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = (double)f == 1.0;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.fromFloat(f.floatValue());
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0;
        }
        return 1;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.value = n == 1;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = l == 1L;
        this.unnullify();
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
            this.unnullify();
        }
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        if (by == 255) {
            this.nullify();
        } else {
            this.value = by == 1;
            this.unnullify();
        }
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        this.fromByte((byte)by);
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value;
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
        }
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            this.value = bigDecimal.compareTo(new BigDecimal("1")) == 0;
            this.unnullify();
        } else {
            this.nullify();
        }
    }

    @Override
    public BigDecimal toDecimal() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return new BigDecimal(1);
        }
        return new BigDecimal(0);
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return "t";
        }
        return "f";
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            String string2 = string.trim();
            if (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true")) {
                this.value = true;
            } else if (string2.equalsIgnoreCase("f") || string2.equalsIgnoreCase("false")) {
                this.value = false;
            } else {
                throw IfxErrMsg.getSQLException(-79771, this.conn);
            }
            this.unnullify();
        }
    }
}

