/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxCallableStatement;
import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxCallableStatement
extends IfxPreparedStatement
implements CallableStatement,
IfmxCallableStatement {
    private IfxConnection conn = null;
    private boolean null_ind = false;
    private IfxClientResultSet crs = null;
    private String signature = null;
    private boolean isProcedure = true;
    outParam[] outParamsInfo = null;
    private boolean multipleUdrOutSupported = false;
    int totalOutParams = 0;
    int indexOfLastOutParameterRead = 0;
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int INOUT = 2;
    ResultSetMetaData idescParamApp;
    String routineDbName;
    int routineFpHandle;
    boolean routineUnique = false;

    IfxCallableStatement(Connection connection, String string) throws SQLException {
        super((IfxConnection)connection);
        Object object;
        this.conn = (IfxConnection)connection;
        this.setSqlString(string);
        try {
            this.setupExecutePrepare();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -9752) {
                this.hasOutParameter = true;
                if (((IfxSqliConnect)this.conn).isNamedParametersSupported()) {
                    object = sQLException.getMessage();
                    int n = ((String)object).indexOf(":");
                    int n2 = ((String)object).indexOf(":", n + 1);
                    int n3 = ((String)object).indexOf(":", n2 + 1);
                    String string2 = ((String)object).substring(n + 1, n2);
                    String string3 = ((String)object).substring(n2 + 1, n3);
                    String string4 = ((String)object).substring(n3 + 1);
                    this.routineDbName = string2;
                    this.routineFpHandle = Integer.parseInt(string3);
                    this.routineUnique = string4.equals("1");
                }
            }
            throw sQLException;
        }
        if (!this.hasOutParameter) {
            return;
        }
        try {
            if (((IfxSqliConnect)this.conn).isFPDescribeSupported()) {
                if (((IfxSqliConnect)this.conn).isNamedParametersSupported()) {
                    this.setSignature(this.isProcedure);
                }
                this.getParameterMetaData();
            }
        }
        catch (SQLException sQLException) {
            object = IfxErrMsg.getSQLException(-79716, sQLException.toString(), this.conn);
            object = IfxErrMsg.setSQLExceptionCause((SQLException)object, sQLException);
            throw object;
        }
        if (((IfxSqliConnect)this.conn).isMultipleUdrOutSupported()) {
            this.multipleUdrOutSupported = true;
        }
        String string5 = IfxErrMsg.getMessage(-79820);
        this.chainWarnings(new SQLWarning(string5, "U0001", 79820));
        this.outParamsInfo = new outParam[this.numqmarks];
        for (int i = 0; i < this.numqmarks; ++i) {
            this.outParamsInfo[i] = new outParam();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        ResultSet resultSet = null;
        if (!this.hasOutParameter) {
            resultSet = super.executeQuery(this.isRsHoldable());
        } else {
            if (this.signature == null) {
                if (!((IfxSqliConnect)this.conn).isFPDescribeSupported()) {
                    this.isProcedure = false;
                }
                this.setSignature(this.isProcedure);
            }
            resultSet = this.executeFastPath(true);
        }
        return resultSet;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (!this.hasOutParameter) {
            return super.getResultSet();
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.chkAndSetGetRsltCalledFlag();
        if (this.crs.isClosed()) {
            return null;
        }
        return this.crs;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.hasOutParameter && this.crs != null) {
            this.crs.close();
        }
        return super.getMoreResults();
    }

    @Override
    public void close() throws SQLException {
        if (this.crs != null) {
            this.crs.close();
        }
        super.close();
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        ResultSet resultSet = null;
        if (!this.hasOutParameter) {
            return super.execute(this.isRsHoldable());
        }
        if (this.signature == null) {
            this.setSignature(this.isProcedure);
        }
        try {
            resultSet = this.executeFastPath(true);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -674) {
                this.isProcedure = false;
                this.setSignature(this.isProcedure);
                resultSet = this.executeFastPath(true);
            }
            throw sQLException;
        }
        return resultSet != null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (!this.hasOutParameter) {
            return super.executeUpdate();
        }
        if (this.signature == null) {
            this.setSignature(this.isProcedure);
        }
        this.executeFastPath(true);
        return 0;
    }

    @Override
    public void IfxSetNull(int n, int n2) throws SQLException {
        super.setNull(n, 0, n2);
    }

    @Override
    public void IfxSetNull(int n, int n2, String string) throws SQLException {
        if (!IfxTypes.isComplexType(n2) && n2 != 40 && n2 != 41) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        super.setNull(n, 0, n2, string);
    }

    @Override
    public void setArray(int n, Array array, String string) throws SQLException {
        super.setArray(n, array, string);
    }

    @Override
    public void setObject(int n, Array array, String string) throws SQLException {
        super.setObject(n, (Object)array, string);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setBoolean(n, bl, 45);
    }

    private void setSignature(boolean bl) throws SQLException {
        if (((IfxSqliConnect)this.conn).isNamedParametersSupported()) {
            this.signature = this.routineDbName + "^" + this.routineFpHandle;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.totalOutParams == 0) {
            throw IfxErrMsg.getSQLException(-79822, this.jconn);
        }
        String string = "(    ";
        StringTokenizer stringTokenizer = new StringTokenizer(this.commandString.toLowerCase().trim(), string);
        String string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        if (bl) {
            stringBuffer.append("procedure");
        } else {
            stringBuffer.append("function");
        }
        stringBuffer.append(" ");
        string2 = stringTokenizer.nextToken();
        stringBuffer.append(string2);
        stringBuffer.append("(");
        IfxObject ifxObject = null;
        for (int i = 0; i < this.numqmarks; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (this.outParamsInfo[i].thisIsValidOutParam) {
                this.getTypeName(this.outParamsInfo[i].ifxType, this.outParamsInfo[i].scale, this.outParamsInfo[i].name, stringBuffer);
                continue;
            }
            ifxObject = (IfxObject)this.vector.elementAt(i);
            if (ifxObject == null) {
                throw IfxErrMsg.getSQLException(-79823, this.jconn);
            }
            int n = ifxObject.getIfxType();
            short s = ifxObject.getEncodedLength();
            String string3 = ifxObject.getExtendedTypeName().trim();
            this.getTypeName(n, s, string3, stringBuffer);
        }
        stringBuffer.append(")");
        this.signature = stringBuffer.toString();
    }

    private void getTypeName(int n, int n2, String string, StringBuffer stringBuffer) throws SQLException {
        switch (n) {
            case 10: 
            case 14: {
                if (n2 == 0) {
                    throw IfxErrMsg.getSQLException(-79717, this.jconn);
                }
                stringBuffer.append(IfxTypes.IfxTypeToName((short)n));
                stringBuffer.append(" ");
                stringBuffer.append(IfxDateTime.getQualifierName((short)n2, n));
                break;
            }
            case 3: {
                stringBuffer.append("double precision");
                break;
            }
            case 40: 
            case 41: {
                if (string == null || string.length() == 0) {
                    throw IfxErrMsg.getSQLException(-79825, this.jconn);
                }
                stringBuffer.append(string);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                if (string == null || string.length() == 0) {
                    throw IfxErrMsg.getSQLException(-79825, this.jconn);
                }
                stringBuffer.append(string);
                break;
            }
            default: {
                stringBuffer.append(IfxTypes.IfxTypeToName(n));
            }
        }
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        String string = null;
        if (n2 == 2003 || n2 == 2002) {
            IfxResultSetMetaData ifxResultSetMetaData = null;
            IfxColumnInfo ifxColumnInfo = null;
            ifxResultSetMetaData = this.inputParamMeta;
            if (ifxResultSetMetaData != null) {
                this.verify(n);
                ifxColumnInfo = ifxResultSetMetaData.getColumnInfo(n);
                if (ifxColumnInfo != null) {
                    string = ifxColumnInfo.ExtendedName;
                }
            }
        }
        this.registerOutParameter(n, n2, 0, string);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (string != null && n2 != 2003 && n2 != 2000 && n2 != 2002 && n2 != 2001) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        this.registerOutParameter(n, n2, 0, string);
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.registerOutParameter(n, n2, n3, null);
    }

    private void registerOutParameter(int n, int n2, int n3, String string) throws SQLException {
        int n4;
        if (!this.hasOutParameter && this.conn instanceof IfxSqliConnect && ((IfxSqliConnect)this.conn).ifxAllowOut) {
            this.setObject(n, null);
            return;
        }
        this.verify(n);
        if (string == null && this.ambiguousSQLType(n2)) {
            throw IfxErrMsg.getSQLException(-79826, this.jconn);
        }
        if (n2 == 6 && !this.jconn.getMapFloat()) {
            n2 = 7;
        }
        if ((n4 = IfxTypes.FromJDBCToIfxType(n2)) == 49) {
            throw IfxErrMsg.getSQLException(-79826, this.jconn);
        }
        this.outParamsInfo[n - 1].ifxType = n4;
        this.outParamsInfo[n - 1].scale = n3;
        this.outParamsInfo[n - 1].name = string;
        if (!this.outParamsInfo[n - 1].thisIsValidOutParam) {
            this.outParamsInfo[n - 1].thisIsValidOutParam = true;
            ++this.totalOutParams;
        }
        if (this.outParamsInfo[n - 1].scale == 0 && this.outParamsInfo[n - 1].ifxType == 10) {
            this.outParamsInfo[n - 1].scale = n2 == 93 ? (int)IfxDateTime.getQualifier((byte)0, (byte)15) : (int)IfxDateTime.getQualifier((byte)6, (byte)10);
        }
    }

    @Override
    public void IfxRegisterOutParameter(int n, int n2) throws SQLException {
        this.IfxRegisterOutParameter(n, n2, 0, null);
    }

    @Override
    public void IfxRegisterOutParameter(int n, int n2, String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (!IfxTypes.isComplexType(n2) && n2 != 40 && n2 != 41) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        this.IfxRegisterOutParameter(n, n2, 0, string);
    }

    @Override
    public void IfxRegisterOutParameter(int n, int n2, int n3) throws SQLException {
        this.IfxRegisterOutParameter(n, n2, n3, null);
    }

    private void IfxRegisterOutParameter(int n, int n2, int n3, String string) throws SQLException {
        this.verify(n);
        this.outParamsInfo[n - 1].ifxType = n2;
        this.outParamsInfo[n - 1].scale = n3;
        this.outParamsInfo[n - 1].name = string;
        if (!this.outParamsInfo[n - 1].thisIsValidOutParam) {
            this.outParamsInfo[n - 1].thisIsValidOutParam = true;
            ++this.totalOutParams;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (!this.hasOutParameter || this.outParamsInfo[this.indexOfLastOutParameterRead - 1].paramValue == null) {
            throw IfxErrMsg.getSQLException(-79827, this.jconn);
        }
        return this.outParamsInfo[this.indexOfLastOutParameterRead - 1].paramValue.isNull();
    }

    @Override
    public String getString(int n) throws SQLException {
        String string = null;
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[n - 1].paramValue);
        string = this.outParamsInfo[n - 1].paramValue.toString();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return string;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return false;
        }
        boolean bl = this.outParamsInfo[n - 1].paramValue.toBoolean();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bl;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return 0;
        }
        byte by = this.outParamsInfo[n - 1].paramValue.toByte();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return by;
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return 0;
        }
        short s = this.outParamsInfo[n - 1].paramValue.toShort();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return s;
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return 0;
        }
        int n2 = this.outParamsInfo[n - 1].paramValue.toInt();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return n2;
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return 0L;
        }
        long l = this.outParamsInfo[n - 1].paramValue.toLong();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return l;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return 0.0f;
        }
        float f = this.outParamsInfo[n - 1].paramValue.toFloat();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return f;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return 0.0;
        }
        double d = this.outParamsInfo[n - 1].paramValue.toDouble();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = this.outParamsInfo[n - 1].paramValue.toDecimal().setScale(n2, 4);
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return null;
        }
        return this.outParamsInfo[n - 1].paramValue.toDecimal();
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[n - 1].paramValue);
        byte[] byArray = this.outParamsInfo[n - 1].paramValue.toBytes();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return byArray;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return null;
        }
        Date date = this.outParamsInfo[n - 1].paramValue.toDate();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return date;
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return null;
        }
        Time time = this.outParamsInfo[n - 1].paramValue.toTime();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return time;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        long l = time.getTime() - (long)(calendar2.get(15) + calendar2.get(16)) + (long)(calendar.get(15) + calendar.get(16));
        return new Time(l);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        IfxObject ifxObject = this.outParamsInfo[n - 1].paramValue;
        if (ifxObject == null) {
            return null;
        }
        if (ifxObject instanceof IfxDateTime) {
            return ((IfxDateTime)ifxObject).toTimestampFromRawData(calendar);
        }
        if (ifxObject.isNull()) {
            return null;
        }
        Timestamp timestamp = this.outParamsInfo[n - 1].paramValue.toTimestamp();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return timestamp;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        Object object = null;
        object = this.jconn != null ? this.getObject(n, this.jconn.getTypeMap()) : this.getObject(n, (Map)null);
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        Object object = null;
        if (this.outParamsInfo[n - 1].paramValue != null && !this.outParamsInfo[n - 1].paramValue.isNull()) {
            if (this.currentResult == null) {
                throw IfxErrMsg.getSQLException(-79733, this.jconn);
            }
            this.currentResult.blobCheck(this.outParamsInfo[n - 1].paramValue);
            this.outParamsInfo[n - 1].paramValue.setTypeMap(map);
            object = this.outParamsInfo[n - 1].paramValue.toObject();
            DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
            if (dataTruncation != null) {
                this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
            }
        }
        return object;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        IfxCollection ifxCollection = (IfxCollection)this.outParamsInfo[n - 1].paramValue;
        Array array = null;
        if (this.outParamsInfo[n - 1].paramValue != null && !this.outParamsInfo[n - 1].paramValue.isNull()) {
            array = ifxCollection.toArray();
        }
        return array;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[n - 1].paramValue);
        Blob blob = this.outParamsInfo[n - 1].paramValue.toBlob();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return blob;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        if (this.outParamsInfo[n - 1].paramValue == null || this.outParamsInfo[n - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[n - 1].paramValue);
        Clob clob = this.outParamsInfo[n - 1].paramValue.toClob();
        DataTruncation dataTruncation = this.outParamsInfo[n - 1].paramValue.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return clob;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": CallableStatement.getRef(int).", this.jconn);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.verify(n);
        this.indexOfLastOutParameterRead = n;
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        long l = date.getTime() - (long)(calendar2.get(15) + calendar2.get(16)) + (long)(calendar.get(15) + calendar.get(16));
        return new Date(l);
    }

    @Override
    public boolean hasOutParameter() {
        return this.hasOutParameter;
    }

    public void putOutParamInfoIntoVector() throws SQLException {
        for (int i = 0; i < this.numqmarks; ++i) {
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(i);
            if (ifxObject != null || !this.outParamsInfo[i].thisIsValidOutParam) continue;
            --this.ordinalCalls;
            if (this.outParamsInfo[i].name != null) {
                this.setNull(i + 1, 0, this.outParamsInfo[i].ifxType, this.outParamsInfo[i].name);
                continue;
            }
            this.setNull(i + 1, 0, this.outParamsInfo[i].ifxType);
        }
    }

    private ResultSet executeFastPath(boolean bl) throws SQLException {
        int n;
        if (this.currentResult == null) {
            this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        }
        IfxFParam ifxFParam = null;
        IfxResultSetMetaData ifxResultSetMetaData = null;
        IfxObject ifxObject = null;
        Vector<IfxObject> vector = null;
        this.resetMethodCalledFlags();
        if (this.signature == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        this.putOutParamInfoIntoVector();
        if (this.inputParamMeta != null) {
            this.inputParamMeta.routineDbName = this.routineDbName;
            this.inputParamMeta.fpHandle = this.routineFpHandle;
        }
        vector = this.currentResult.executeFastPath(this.signature, this.inputParamMeta, this.vector, this.hasOutParameter, bl);
        if (!((IfxConnection)super.getConnection()).isDirect()) {
            ifxFParam = this.currentResult.getFParam();
            for (n = 0; n < ifxFParam.numberOfOutParams; ++n) {
                int n2 = ifxFParam.outParamSequence[n];
                this.outParamsInfo[n2].paramValue = (IfxObject)vector.elementAt(n);
                this.outParamsInfo[n2].paramInfo = ifxFParam.colInfoArray[n];
            }
            this.indexOfLastOutParameterRead = ifxFParam.nargs;
            if (ifxFParam.nrets > 0) {
                ifxResultSetMetaData = new IfxResultSetMetaData(ifxFParam.nrets, this.jconn);
                for (n = 0; n < ifxFParam.nrets; ++n) {
                    ifxResultSetMetaData.copyColumnInfo(n + 1, ifxFParam.colInfoArray[this.totalOutParams + n]);
                    ifxFParam.colInfoArray[this.totalOutParams + n] = null;
                }
                ifxObject = (IfxObject)vector.elementAt(this.totalOutParams);
            }
        } else {
            n = 0;
            ifxResultSetMetaData = (IfxResultSetMetaData)this.currentResult.getMetaData();
            vector = new Vector<IfxObject>();
            vector.setSize(1);
            n = ifxResultSetMetaData.getColumnCount();
            ifxObject = this.currentResult.getValueFastPath(n);
            vector.setElementAt(ifxObject, 0);
            this.outParamsInfo[n - 1].paramValue = (IfxObject)vector.elementAt(0);
            this.outParamsInfo[n - 1].paramInfo = ifxResultSetMetaData.getColumnInfo(n);
            ifxObject = this.currentResult.getValueFastPath(1);
        }
        if (this.jconn.isDirect() || ifxFParam.nrets > 0) {
            this.crs = new IfxClientResultSet(this.jconn, ifxResultSetMetaData);
            this.crs.newRow(1);
            if (this.jconn.isDirect()) {
                if (ifxObject.isNull()) {
                    this.crs.updateNull(1, 1);
                } else {
                    this.crs.updateIfxObject(1, 1, (Object)ifxObject);
                }
            } else {
                for (n = 0; n < ifxFParam.nrets; ++n) {
                    ifxObject = (IfxObject)vector.elementAt(this.totalOutParams + n);
                    if (ifxObject.isNull()) {
                        this.crs.updateNull(1, n + 1);
                        continue;
                    }
                    this.crs.updateIfxObject(1, n + 1, (Object)ifxObject);
                }
            }
            this.crs.beforeFirst();
            this.crs.setType(1003);
            this.crs.setFetchDirection(1000);
            this.crs.setConcurrency(1007);
            return this.crs;
        }
        return null;
    }

    private void verify(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (!this.hasOutParameter) {
            throw IfxErrMsg.getSQLException(-79827, this.jconn);
        }
        this.checkParameterIndex(n, this.numqmarks);
        if (this.hasOutParameter && this.conn.isDirect() && n != this.numqmarks) {
            throw IfxErrMsg.getSQLException(-79828, this.jconn);
        }
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            this.registerOutParameter(n2, n);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        try {
            int n3 = this.handleParameterName(string);
            this.registerOutParameter(n3, n, n2);
        }
        catch (SQLException sQLException) {
            int n4 = sQLException.getErrorCode();
            if (n4 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n4, this.jconn);
        }
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            this.registerOutParameter(n2, n, string2);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getURL(int)", this.conn);
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setURL(int, URL)", this.jconn);
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            super.setNull(n2, n);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            super.setNull(n2, n, string2);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setByte(n, by);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setShort(n, s);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            super.setInt(n2, n);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setLong(n, l);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setString(n, string2);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setDate(n, date);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setTime(n, time);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            super.setAsciiStream(n2, inputStream, n);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            super.setBinaryStream(n2, inputStream, n);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            super.setObject(n2, object, n);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        try {
            int n3 = this.handleParameterName(string);
            super.setObject(n3, object, n, n2);
        }
        catch (SQLException sQLException) {
            int n4 = sQLException.getErrorCode();
            if (n4 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n4, this.jconn);
        }
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setObject(n, object);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        try {
            int n2 = this.handleParameterName(string);
            super.setCharacterStream(n2, reader, n);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n3, this.jconn);
        }
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            super.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getString(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getBoolean(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getByte(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getShort(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getInt(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getLong(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getFloat(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getDouble(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getBytes(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getDate(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getTime(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Object getObject(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getObject(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getObject(n, map);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getRef(String)", this.jconn);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getBlob(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getClob(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Array getArray(String string) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getArray(n);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            int n = this.handleParameterName(string);
            return this.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n != -79882) {
                throw sQLException;
            }
            throw IfxErrMsg.getSQLException(n, this.jconn);
        }
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getURL(String)", this.conn);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (((IfxSqliConnect)this.jconn).isDescribeInputSupported() && this.hasOutParameter && !((IfxSqliConnect)this.jconn).isFPDescribeSupported()) {
            String string = IfxErrMsg.getMessage(-79820);
            throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getParameterMetaData()\n" + string, this.jconn);
        }
        if (this.hasOutParameter) {
            String string = this.getProcDetails();
            try {
                return super.getParameterMetaData(this.signature, this.isProcedure, string, this.numqmarks);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != -674) {
                    throw sQLException;
                }
                this.isProcedure = false;
                return super.getParameterMetaData(null, this.isProcedure, string, this.numqmarks);
            }
        }
        return super.getParameterMetaData();
    }

    private String getProcDetails() {
        String string = "(    ";
        StringTokenizer stringTokenizer = new StringTokenizer(this.commandString.trim(), string);
        String string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        int n = string2.indexOf(46);
        String string3 = null;
        string3 = n > 0 ? string2.substring(0, n + 1) + string2.substring(n + 1).toLowerCase() : string2.toLowerCase();
        return string3;
    }

    protected int handleParameterName(String string) throws SQLException {
        String string2;
        int n;
        int n2;
        if (!((IfxSqliConnect)this.conn).isNamedParametersSupported()) {
            throw IfxErrMsg.getSQLException(-79882, this.jconn);
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.namedCalls != this.ordinalCalls) {
            throw IfxErrMsg.getSQLException(-79888, this.jconn);
        }
        if (!this.hasOutParameter && this.inputParamMeta == null) {
            this.getParameterMetaData();
        }
        int n3 = this.inputParamMeta.numArgsRoutine;
        if (this.hasOutParameter && n3 == -1) {
            n3 = this.inputParamMeta.getColumnCount();
        }
        if (this.idescParamApp == null && this.numqmarks < n3) {
            this.idescParamApp = this.inputParamMeta;
            n2 = this.commandString.indexOf(40);
            if (n2 > (n = this.commandString.indexOf(41)) || n2 < 0 || n < 0) {
                throw IfxErrMsg.getSQLException(-79716, "L" + n2 + "R" + n, this.conn);
            }
            string2 = this.commandString.substring(0, n);
            for (int i = this.numqmarks; i < n3; ++i) {
                string2 = string2 + (i == 0 ? "?" : ",?");
            }
            string2 = string2 + this.commandString.substring(n);
            this.setSqlString(string2);
            try {
                this.setupExecutePrepare();
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -9752) {
                    this.hasOutParameter = true;
                    String string3 = sQLException.getMessage();
                    int n4 = string3.indexOf(":");
                    int n5 = string3.indexOf(":", n4 + 1);
                    int n6 = string3.indexOf(":", n5 + 1);
                    String string4 = string3.substring(n4 + 1, n5);
                    String string5 = string3.substring(n5 + 1, n6);
                    String string6 = string3.substring(n6 + 1);
                    this.routineDbName = string4;
                    this.routineFpHandle = Integer.parseInt(string5);
                    this.routineUnique = string6.equals("1");
                }
                throw sQLException;
            }
            if (!this.hasOutParameter) {
                this.inputParamMeta = ((IfxSqli)this.prot).executeDescribeInput();
            } else {
                this.setSignature(this.isProcedure);
                this.inputParamMeta = ((IfxSqli)this.prot).executeFPDescribe(this.signature, this.isProcedure, this.getProcDetails(), this.numqmarks);
                if (((IfxSqliConnect)this.conn).isMultipleUdrOutSupported()) {
                    this.multipleUdrOutSupported = true;
                }
                String string7 = IfxErrMsg.getMessage(-79820);
                this.chainWarnings(new SQLWarning(string7, "U0001", 79820));
                this.outParamsInfo = new outParam[this.numqmarks];
                for (int i = 0; i < this.numqmarks; ++i) {
                    this.outParamsInfo[i] = new outParam();
                }
            }
        }
        if (this.hasOutParameter && !this.routineUnique || !this.hasOutParameter && !this.inputParamMeta.wasRoutineUnique()) {
            throw IfxErrMsg.getSQLException(-9700, this.getProcDetails(), this.jconn);
        }
        ++this.namedCalls;
        n2 = this.inputParamMeta.getColumnCount();
        for (n = 1; n <= n2; ++n) {
            string2 = this.inputParamMeta.getArgumentName(n);
            if (!string2.equalsIgnoreCase(string)) continue;
            return n;
        }
        ++this.ordinalCalls;
        throw IfxErrMsg.getSQLException(-79887, this.jconn);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getObject", (IfxConnection)null);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getObject", (IfxConnection)null);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNClob", (IfxConnection)null);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNClob", (IfxConnection)null);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setNClob", (IfxConnection)null);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setNClob", (IfxConnection)null);
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setNClob", (IfxConnection)null);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setBlob", (IfxConnection)null);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setBlob", (IfxConnection)null);
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setBlob", (IfxConnection)null);
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setClob", (IfxConnection)null);
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setClob", (IfxConnection)null);
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setClob", (IfxConnection)null);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setCharacterStream", (IfxConnection)null);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setCharacterStream", (IfxConnection)null);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getCharacterStream", (IfxConnection)null);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getCharacterStream", (IfxConnection)null);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNCharacterStream", (IfxConnection)null);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setNString", (IfxConnection)null);
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNString", (IfxConnection)null);
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNString", (IfxConnection)null);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getSQLXML", (IfxConnection)null);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getSQLXML", (IfxConnection)null);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setSQLXML", (IfxConnection)null);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setBinaryStream", (IfxConnection)null);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setBinaryStream", (IfxConnection)null);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setAsciiStream", (IfxConnection)null);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setAsciiStream", (IfxConnection)null);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getRowId", (IfxConnection)null);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getRowId", (IfxConnection)null);
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "setRowId", (IfxConnection)null);
    }

    private class outParam {
        int ifxType = -1;
        int scale = -1;
        String name = null;
        IfxObject paramValue = null;
        IfxColumnInfo paramInfo = null;
        boolean thisIsValidOutParam = false;

        outParam() {
        }
    }
}

