/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSmartLobOutputStream;
import com.informix.jdbc.IfxSmartLobWriter;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.stringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxCblob
extends IfxLob
implements Clob {
    public IfxCblob() {
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    public IfxCblob(IfxLocator ifxLocator) {
        this.locatorPointer = ifxLocator;
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    public IfxCblob(IfxConnection ifxConnection, IfxLocator ifxLocator, int n) throws SQLException {
        this.conn = ifxConnection;
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
        this.smb = new IfxSmartBlob(ifxConnection);
        this.smb.IfxLoOpen(ifxLocator, n);
    }

    public IfxCblob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this(ifxConnection, ifxLocator, ifxConnection.isReadOnly() ? 4 : 8);
    }

    protected IfxCblob(byte[] byArray) {
        this.blobBuffer = byArray;
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
    }

    public IfxCblob(Connection connection, byte[] byArray) throws SQLException {
        this.conn = (IfxConnection)connection;
        this.blobBuffer = byArray;
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
    }

    public IfxCblob(InputStream inputStream) {
        this.blobStream = inputStream;
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    protected IfxCblob(IfxTmpFile ifxTmpFile) {
        this.tempBlobFile = ifxTmpFile;
        this.tempBlobFile.incRefCount();
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
    }

    public IfxCblob(Connection connection, InputStream inputStream, int n) throws SQLException {
        super(connection, inputStream, n);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, InputStream inputStream, int n, String string) throws SQLException {
        super(connection, inputStream, n, string);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, InputStream inputStream, int n, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, inputStream, n, ifxLobDescriptor);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, String string) throws SQLException {
        super(connection, string.getBytes());
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, String string, String string2) throws SQLException {
        super(connection, string.getBytes(), string2);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, String string, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, string.getBytes(), ifxLobDescriptor);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    @Override
    public IfxLocator getLocator() throws SQLException {
        return super.getLocator();
    }

    @Override
    public long length() {
        return this.blobSize;
    }

    @Override
    public String getSubString(long l, int n) {
        byte[] byArray = super.getPortion(l, n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        String string = this.conn.getdbEncoding();
        try {
            if (string != null) {
                return new InputStreamReader(super.getStream(), string);
            }
            return new InputStreamReader(super.getStream());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return super.getStream();
    }

    @Override
    public long position(String string, long l) throws SQLException {
        long l2 = l - 1L;
        byte[] byArray = super.getPortion(1L, this.blobSize);
        if (byArray == null) {
            return -1L;
        }
        String string2 = new String(byArray);
        long l3 = string2.indexOf(string, (int)l2);
        if (l3 >= 0L) {
            ++l3;
        }
        return l3;
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    public void setAsciiStream(long l, InputStream inputStream, int n) throws SQLException {
        this.verifyClob();
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        super.setStream(inputStream, n);
    }

    public void setSubString(long l, String string, int n) throws SQLException {
        this.verifyClob();
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        try {
            super.setBuffer(stringUtil.getBytes(string, this.conn));
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.smb != null) {
            if (this.smb.getHandle() != -1) {
                this.smb.IfxLoClose(this.smb.getHandle());
            }
            this.smb = null;
        }
        super.close();
    }

    @Override
    public long seek(long l, int n) throws SQLException {
        return super.seek(l, n);
    }

    @Override
    public long where() throws SQLException {
        return super.where();
    }

    @Override
    public IfxLoStat getLoStat() throws SQLException {
        return super.getLoStat();
    }

    @Override
    public void truncate(long l) throws SQLException {
        super.truncate(l);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        this.verifyClob();
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        try {
            return super.setBuffer(stringUtil.getBytes(string, this.conn));
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.verifyClob();
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        try {
            return super.setBuffer(stringUtil.getBytes(string.substring(n, n + n2), this.conn));
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        this.verifyClob();
        return new IfxSmartLobOutputStream(this, l);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        this.verifyClob();
        return new IfxSmartLobWriter(new IfxSmartLobOutputStream(this, l), this.conn.getdbEncoding());
    }

    protected synchronized void exfinalize() {
        try {
            if (this.smb != null) {
                super.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verifyClob() throws SQLException {
        if (this.ifxType != 3) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        this.verifySmbMode();
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getCharacterStream", (IfxConnection)null);
    }

    @Override
    public void free() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "free", (IfxConnection)null);
    }
}

