/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxScrollableResultSet;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMessage;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class IfxClientResultSet
extends IfxScrollableResultSet
implements ResultSet,
IfmxResultSet {
    private int fetchDirection = 1000;
    private int resultSetType = 1004;
    private int concurrency = 1008;
    private final int VECTOR_CAPACITY = 20;
    private int totalRowCount = 0;
    private Vector rowVector = null;
    private int curRowID = 0;
    private int savedRowID = 0;
    boolean isClosed = false;

    public IfxClientResultSet(IfxConnection ifxConnection, ResultSetMetaData resultSetMetaData) throws SQLException {
        super(ifxConnection, resultSetMetaData);
    }

    public void executeQuery() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.executeQuery().", this.conn);
    }

    public int executeUpdate() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.executeUpdate().", this.conn);
    }

    public void execute() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.execute().", this.conn);
    }

    @Override
    public void updateRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateRow().", this.conn);
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (this.insertMode) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        if (this.totalRowCount == 0) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        this.rowVector.removeElementAt(this.curRowID - 1);
        --this.totalRowCount;
    }

    void deleteRow(int n) throws SQLException {
        if (this.concurrency == 1008) {
            this.rowVector.removeElementAt(n - 1);
            --this.totalRowCount;
        } else {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.insertMode) {
            throw IfxErrMsg.getSQLException(-79815, this.conn);
        }
        if (this.insertRowVector == null) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        this.savedRowID = this.curRowID;
        if (this.curRowID == this.rowVector.size()) {
            this.rowVector.setSize(this.rowVector.size() + 20);
        }
        int n = this.curRowID;
        if (this.isAfterLast()) {
            n = this.curRowID - 1;
        }
        if (this.rowVector.get(this.curRowID) == null) {
            this.rowVector.setElementAt(this.insertRowVector, this.curRowID);
        } else {
            this.rowVector.add(this.curRowID, this.insertRowVector);
        }
        if (n == this.curRowID) {
            ++this.curRowID;
        }
        ++this.totalRowCount;
        this.insertRowVector = null;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.cancelRowUpdates().", this.conn);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.refreshRow().", this.conn);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetType;
    }

    void setType(int n) throws SQLException {
        if (n != 1004 && n != 1003) {
            SQLWarning sQLWarning = new SQLWarning(IfxMessage.getMessage(-79775, this.conn.getclLocale()), "01000", -79775);
            this.chainWarnings(sQLWarning);
        }
        this.resultSetType = n == 1005 ? 1004 : n;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    void setConcurrency(int n) throws SQLException {
        if (n != 1008 && n != 1007) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        this.concurrency = n;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw IfxErrMsg.getSQLException(-79764, this.conn);
        }
        if (this.resultSetType == 1003 && n != 1000) {
            throw IfxErrMsg.getSQLException(-79765, this.conn);
        }
        this.fetchDirection = n;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (this.conn.isClosed()) {
            throw IfxErrMsg.getSQLException(-79730, this.conn);
        }
        if (this.rowVector == null || this.totalRowCount == 0) {
            return false;
        }
        if (this.curRowID >= this.totalRowCount) {
            return false;
        }
        ++this.curRowID;
        this.insertMode = false;
        this.colVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        this.insertMode = true;
        if (this.rowVector == null) {
            this.rowVector = new Vector(20, 20);
            this.rowVector.setSize(20);
            this.totalRowCount = 0;
        }
    }

    public void newRow() throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (this.rowVector == null) {
            this.rowVector = new Vector(20, 20);
            this.rowVector.setSize(20);
            this.totalRowCount = 0;
        } else if (this.totalRowCount >= this.rowVector.size()) {
            this.rowVector.setSize(this.rowVector.size() + 20);
        }
        this.insertMode = false;
        this.colVector = new Vector(this.rsmd.getColumnCount());
        this.colVector.setSize(this.rsmd.getColumnCount());
        ++this.totalRowCount;
        this.rowVector.setElementAt(this.colVector, this.totalRowCount - 1);
        this.curRowID = this.totalRowCount;
    }

    public void newRow(int n) throws SQLException {
        if (this.rowVector == null && n < 20) {
            this.rowVector = new Vector(n, 20);
            this.rowVector.setSize(n);
        }
        for (int i = 0; i < n; ++i) {
            this.newRow();
        }
    }

    @Override
    public int getRow() throws SQLException {
        return this.curRowID;
    }

    public int getRowCount() {
        return this.totalRowCount;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        if (this.totalRowCount == 0) {
            return false;
        }
        if (n == 0) {
            this.curRowID = 0;
            this.colVector = null;
            return false;
        }
        if (n > this.totalRowCount + 1) {
            this.curRowID = this.totalRowCount + 1;
            this.colVector = null;
            return false;
        }
        if (n < 0) {
            this.curRowID = this.totalRowCount + n + 1;
            if (this.curRowID < 1) {
                this.curRowID = 0;
                return false;
            }
        } else {
            this.curRowID = n;
        }
        this.colVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        if (this.curRowID == 0 || this.totalRowCount == 0) {
            return false;
        }
        --this.curRowID;
        this.colVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        if (this.totalRowCount == 0) {
            return false;
        }
        if (n == 0) {
            return this.curRowID == 0 || this.curRowID == this.totalRowCount;
        }
        int n2 = this.curRowID + n;
        if (n2 >= this.totalRowCount + 1) {
            this.afterLast();
            return false;
        }
        if (n2 < 0) {
            this.beforeFirst();
            return false;
        }
        this.curRowID = n2;
        this.colVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.curRowID == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.totalRowCount > 0 && this.curRowID == this.totalRowCount + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.curRowID == 1;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        if (this.savedRowID != 0) {
            this.curRowID = this.savedRowID;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.totalRowCount > 0 && this.curRowID == this.totalRowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.insertMode = false;
        this.curRowID = 0;
        this.colVector = null;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.totalRowCount == 0) {
            return;
        }
        this.insertMode = false;
        this.curRowID = this.totalRowCount + 1;
        this.colVector = null;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.totalRowCount == 0) {
            return false;
        }
        this.insertMode = false;
        this.curRowID = 1;
        this.colVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.resultSetType == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.totalRowCount == 0) {
            return false;
        }
        this.insertMode = false;
        this.curRowID = this.totalRowCount;
        this.colVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.rowUpdated().", this.conn);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.rowInserted().", this.conn);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.rowDeleted().", this.conn);
    }

    public void updateNull(int n, int n2) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateNull(n2);
    }

    public void updateNull(int n, String string) throws SQLException {
        this.updateNull(n, this.findColumn(string));
    }

    public void updateBoolean(int n, int n2, boolean bl) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateBoolean(n2, bl);
    }

    public void updateBoolean(int n, String string, boolean bl) throws SQLException {
        this.updateBoolean(n, this.findColumn(string), bl);
    }

    public void updateByte(int n, int n2, byte by) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateByte(n2, by);
    }

    public void updateByte(int n, String string, byte by) throws SQLException {
        this.updateByte(n, this.findColumn(string), by);
    }

    public void updateShort(int n, int n2, short s) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateShort(n2, s);
    }

    public void updateShort(int n, String string, short s) throws SQLException {
        this.updateShort(n, this.findColumn(string), s);
    }

    public void updateInt(int n, int n2, int n3) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateInt(n2, n3);
    }

    public void updateInt(int n, String string, int n2) throws SQLException {
        this.updateInt(n, this.findColumn(string), n2);
    }

    public void updateLong(int n, int n2, long l) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateLong(n2, l);
    }

    public void updateLong(int n, String string, long l) throws SQLException {
        this.updateLong(n, this.findColumn(string), l);
    }

    public void updateFloat(int n, int n2, float f) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateFloat(n2, f);
    }

    public void updateFloat(int n, String string, float f) throws SQLException {
        this.updateFloat(n, this.findColumn(string), f);
    }

    public void updateDouble(int n, int n2, double d) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateDouble(n2, d);
    }

    public void updateDouble(int n, String string, double d) throws SQLException {
        this.updateDouble(n, this.findColumn(string), d);
    }

    public void updateBigDecimal(int n, int n2, BigDecimal bigDecimal) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateBigDecimal(n2, bigDecimal);
    }

    public void updateBigDecimal(int n, String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(n, this.findColumn(string), bigDecimal);
    }

    public void updateString(int n, int n2, String string) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateString(n2, string);
    }

    public void updateString(int n, String string, String string2) throws SQLException {
        this.updateString(n, this.findColumn(string), string2);
    }

    public void updateBytes(int n, int n2, byte[] byArray) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateBytes(n2, byArray);
    }

    public void updateBytes(int n, String string, byte[] byArray) throws SQLException {
        this.updateBytes(n, this.findColumn(string), byArray);
    }

    public void updateDate(int n, int n2, Date date) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateDate(n2, date);
    }

    public void updateDate(int n, String string, Date date) throws SQLException {
        this.updateDate(n, this.findColumn(string), date);
    }

    public void updateTime(int n, int n2, Time time) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateTime(n2, time);
    }

    public void updateTime(int n, String string, Time time) throws SQLException {
        this.updateTime(n, this.findColumn(string), time);
    }

    public void updateTimestamp(int n, int n2, Timestamp timestamp) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateTimestamp(n2, timestamp);
    }

    public void updateTimestamp(int n, String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(n, this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(int n, int n2, InputStream inputStream, int n3) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateAsciiStream(n2, inputStream, n3);
    }

    public void updateAsciiStream(int n, String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(n, this.findColumn(string), inputStream, n2);
    }

    public void updateBinaryStream(int n, int n2, InputStream inputStream, int n3) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateBinaryStream(n2, inputStream, n3);
    }

    public void updateBinaryStream(int n, String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, this.findColumn(string), inputStream, n2);
    }

    public void updateCharacterStream(int n, int n2, Reader reader, int n3) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateCharacterStream(n2, reader, n3);
    }

    public void updateCharacterStream(int n, String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(n, this.findColumn(string), reader, n2);
    }

    public void updateObject(int n, int n2, Object object) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateObject(n2, object);
    }

    public void updateObject(int n, String string, Object object) throws SQLException {
        this.updateObject(n, this.findColumn(string), object);
    }

    public void updateIfxObject(int n, int n2, Object object) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (!this.absolute(n)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        super.updateIfxObject(n2, object);
    }

    public void updateIfxObject(int n, String string, Object object) throws SQLException {
        this.updateIfxObject(n, this.findColumn(string), object);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateNull(n);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateBoolean(n, bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateByte(n, by);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateShort(n, s);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateInt(n, n2);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateLong(n, l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateFloat(n, f);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateDouble(n, d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateBigDecimal(n, bigDecimal);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateString(n, string);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateBytes(n, byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateDate(n, date);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateTime(n, time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateTimestamp(n, timestamp);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateAsciiStream(n, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateCharacterStream(n, reader, n2);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateObject(n, object, n2);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (this.concurrency != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        super.updateObject(n, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public String getCursorName() throws SQLException {
        return "ClientResultCurs";
    }

    protected void setInsertMode(boolean bl) {
        this.insertMode = bl;
    }

    protected boolean getInsertMode() {
        return this.insertMode;
    }

    @Override
    public void close() {
        this.isClosed = true;
        if (this.rowVector != null) {
            for (int i = 0; i < this.totalRowCount; ++i) {
                Vector vector = (Vector)this.rowVector.elementAt(i);
                vector.removeAllElements();
            }
            this.rowVector.removeAllElements();
            this.rowVector = null;
        }
        this.insertMode = false;
        this.insertRowVector = null;
        this.colVector = null;
    }

    @Override
    protected void finalize() {
        this.close();
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getURL(int)", this.conn);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.getURL(String)", this.conn);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateRef(int)", this.conn);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateRef(String)", this.conn);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBlob(int, Blob)", this.conn);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateBlob(String, Blob)", this.conn);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateClob(int, Clob)", this.conn);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateClob(String, Clob)", this.conn);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateArray(int, Array)", this.conn);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.updateArray(String, Array)", this.conn);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getObject", (IfxConnection)null);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getObject", (IfxConnection)null);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateClob", (IfxConnection)null);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateClob", (IfxConnection)null);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateClob", (IfxConnection)null);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateClob", (IfxConnection)null);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBlob", (IfxConnection)null);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBlob", (IfxConnection)null);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBlob", (IfxConnection)null);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBlob", (IfxConnection)null);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNCharacterStream", (IfxConnection)null);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNCharacterStream", (IfxConnection)null);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNString", (IfxConnection)null);
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNString", (IfxConnection)null);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNString", (IfxConnection)null);
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNString", (IfxConnection)null);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBinaryStream", (IfxConnection)null);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBinaryStream", (IfxConnection)null);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBinaryStream", (IfxConnection)null);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBinaryStream", (IfxConnection)null);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateAsciiStream", (IfxConnection)null);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateAsciiStream", (IfxConnection)null);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateAsciiStream", (IfxConnection)null);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateAsciiStream", (IfxConnection)null);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateSQLXML", (IfxConnection)null);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateSQLXML", (IfxConnection)null);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getSQLXML", (IfxConnection)null);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getSQLXML", (IfxConnection)null);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNClob", (IfxConnection)null);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNClob", (IfxConnection)null);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getHoldability", (IfxConnection)null);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateRowId", (IfxConnection)null);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateRowId", (IfxConnection)null);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getRowId", (IfxConnection)null);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getRowId", (IfxConnection)null);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "isWrapperFor", (IfxConnection)null);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "unwrap", (IfxConnection)null);
    }
}

