/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxComplexSQLInput;
import com.informix.jdbc.IfxArray;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSQLInput;
import com.informix.jdbc.IfxStruct;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

public class IfxComplexInput
extends IfxSQLInput
implements IfmxComplexSQLInput {
    private Vector parentTypeInfoVector = null;
    private Vector typeInfoVector = null;
    private Vector elementOffsetVector = null;
    private int typeIndex = -1;
    private boolean isRow = false;
    private boolean isStruct = false;
    private int currentIfxType;
    private int currentExtendedId;
    private String currentExtendedName;
    private int currentIfxLength;
    private int currentSourceType;
    private Map typeMap = null;
    private boolean isNested = false;
    Vector ifxObjectVector = null;

    IfxComplexInput(byte[] byArray, int n, int n2, Vector vector, boolean bl, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection, byArray, n, n2);
        this.isNested = bl;
        this.parentTypeInfoVector = vector;
        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(0);
        if (ifxColumnInfo.SQLtype == 22) {
            this.isRow = true;
        } else {
            this.isRow = false;
            this.typeIndex = 0;
        }
        this.typeInfoVector = ((IfxColumnInfo)this.parentTypeInfoVector.get((int)0)).child;
        ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(0);
        this.currentIfxType = ifxColumnInfo.SQLtype;
        this.currentExtendedId = ifxColumnInfo.ExtendedId;
        this.currentExtendedName = ifxColumnInfo.ExtendedName;
        this.currentIfxLength = ifxColumnInfo.ColLength;
        this.currentSourceType = ifxColumnInfo.SourceType;
        this.ifxObjectVector = new Vector(vector.size());
        for (int i = 0; i < this.typeInfoVector.size(); ++i) {
            ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(i);
            IfxObject ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
            this.ifxObjectVector.addElement(ifxObject);
        }
        if ((this.isRow || IfxTypes.isUDT(this.currentIfxType) || IfxTypes.isComplexType(this.currentIfxType) || this.currentIfxType == 13) && byArray != null && n2 > 0) {
            byte[] byArray2 = new byte[4];
            this.elementOffsetVector = new Vector();
            for (int i = n + n2 - 4; i > 0; i -= 4) {
                System.arraycopy(byArray, i, byArray2, 0, 4);
                int n3 = IfxToJavaType.IfxToJavaInt(byArray2);
                if (n3 == -1) break;
                this.elementOffsetVector.add(new Integer(n3));
            }
        }
    }

    @Override
    void setTypeMap(Map map) {
        this.typeMap = map;
    }

    @Override
    public Blob readBlob() throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentExtendedId != 10) {
            IfxComplex.badTypeException(this.currentIfxType, (short)102, this.trace, null);
        }
        IfxObject ifxObject = this.convLob();
        Blob blob = null;
        if (!ifxObject.isNull()) {
            blob = ifxObject.toBlob();
        }
        return blob;
    }

    @Override
    public Clob readClob() throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentExtendedId != 11) {
            IfxComplex.badTypeException(this.currentIfxType, (short)101, this.trace, string);
        }
        Clob clob = null;
        IfxObject ifxObject = this.convLob();
        if (!ifxObject.isNull()) {
            clob = ifxObject.toClob();
        }
        return clob;
    }

    @Override
    public byte readByte() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readByte().", this.conn);
    }

    @Override
    public Date readDate() throws SQLException {
        Date date = null;
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 7) {
            date = super.readDate();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)7, this.trace, string);
        }
        return date;
    }

    @Override
    public double readDouble() throws SQLException {
        double d = 0.0;
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 3) {
            d = super.readDouble();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)3, this.trace, string);
        }
        return d;
    }

    @Override
    public float readFloat() throws SQLException {
        float f = 0.0f;
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 4) {
            f = super.readFloat();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)4, this.trace, string);
        }
        return f;
    }

    @Override
    public int readInt() throws SQLException {
        int n = 0;
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 2 || this.currentIfxType == 6) {
            n = super.readInt();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)2, this.trace, string);
        }
        return n;
    }

    @Override
    public long readLong() throws SQLException {
        long l = 0L;
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 17 || this.currentIfxType == 18) {
            l = super.readLong();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)17, this.trace, string);
        }
        return l;
    }

    @Override
    public long readLongBigint() throws SQLException {
        long l = 0L;
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 52 || this.currentIfxType == 53) {
            l = super.readLongBigint();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)52, this.trace, string);
        }
        return l;
    }

    @Override
    public short readShort() throws SQLException {
        short s = 0;
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 1) {
            s = super.readShort();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)1, this.trace, string);
        }
        return s;
    }

    @Override
    public Time readTime() throws SQLException {
        byte[] byArray = null;
        int n = 0;
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 10) {
            n = this.getLength(this.currentIfxLength);
            byArray = new byte[n];
            this.bStream.read(byArray, 0, n);
            ifxObject.fromIfx(byArray, (short)this.currentIfxLength);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)10, this.trace, string);
        }
        return ifxObject.toTime();
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        byte[] byArray = null;
        int n = 0;
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 10) {
            n = this.getLength(this.currentIfxLength);
            byArray = new byte[n];
            this.bStream.read(byArray, 0, n);
            ifxObject.fromIfx(byArray, (short)this.currentIfxLength);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)10, this.trace, string);
        }
        return ifxObject.toTimestamp();
    }

    private int getLength(int n) {
        return ((n >> 8 & 0xFF) + (n & 0xFF & 1) + 3) / 2;
    }

    @Override
    public Interval readInterval() throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 14) {
            byte[] byArray = null;
            int n = 0;
            n = this.getLength(this.currentIfxLength);
            byArray = new byte[n];
            this.bStream.read(byArray, 0, n);
            ifxObject.fromIfx(byArray, (short)this.currentIfxLength);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)14, this.trace, string);
        }
        return (Interval)ifxObject.toObject();
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        byte[] byArray = null;
        int n = 0;
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 5 || this.currentIfxType == 8) {
            n = this.getLength(this.currentIfxLength);
            byArray = new byte[n];
            this.bStream.read(byArray, 0, n);
            ifxObject.fromIfx(byArray, (short)this.currentIfxLength);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)5, this.trace, string);
        }
        return (BigDecimal)ifxObject.toObject();
    }

    @Override
    public boolean readBoolean() throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        byte[] byArray = null;
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 45 || this.currentIfxType == 41 && this.currentExtendedId == 5) {
            byArray = new byte[6];
            this.bStream.read(byArray, 0, 6);
            ifxObject.fromIfx(byArray);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)45, this.trace, string);
        }
        return ifxObject.toBoolean();
    }

    @Override
    public String readString() throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 40 && (this.currentSourceType == 1 || this.currentExtendedId == 1)) {
            return (String)this.readUDT(true);
        }
        String string2 = null;
        byte[] byArray = null;
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 13 || this.currentIfxType == 16) {
            byArray = new byte[1];
            this.bStream.read(byArray, 0, 1);
            int n = byArray[0] & 0xFF;
            byArray = new byte[n + 1];
            byArray[0] = (byte)n;
            this.bStream.read(byArray, 1, n);
        } else if (this.currentIfxType == 0 || this.currentIfxType == 15) {
            byArray = new byte[this.currentIfxLength];
            this.bStream.read(byArray, 0, this.currentIfxLength);
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)0, this.trace, string);
        }
        ifxObject.fromIfx(byArray);
        string2 = ifxObject.toString();
        this.isNull = ifxObject.isNull();
        return string2;
    }

    @Override
    public Object readObject() throws SQLException {
        Object object;
        int n = this.currentIfxType;
        int n2 = this.currentExtendedId;
        String string = this.currentExtendedName;
        int n3 = this.currentIfxLength;
        int n4 = this.currentSourceType;
        if (this.isRow && !this.isStruct) {
            if (this.typeIndex + 1 < this.typeInfoVector.size()) {
                IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex + 1);
                n = ifxColumnInfo.SQLtype;
                n2 = ifxColumnInfo.ExtendedId;
                string = ifxColumnInfo.ExtendedName;
                n3 = ifxColumnInfo.ColLength;
                n4 = ifxColumnInfo.SourceType;
            } else {
                throw IfxErrMsg.getSQLException(-79773, this.conn);
            }
        }
        switch (n) {
            case 40: 
            case 41: {
                if (n2 <= 11) {
                    throw IfxErrMsg.getSQLException(-79777, this.conn);
                }
                object = this.readUDT(false);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                object = this.readNestedComplex().toObject();
                break;
            }
            case 14: {
                object = this.readInterval();
                break;
            }
            default: {
                throw IfxErrMsg.getSQLException(-79777, this.conn);
            }
        }
        return object;
    }

    public String readString(Collection collection) throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 40 && (this.currentSourceType == 1 || this.currentExtendedId == 1)) {
            String string2 = (String)this.readUDT(true);
            collection.add(string2);
            return string2;
        }
        String string3 = null;
        byte[] byArray = null;
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 13 || this.currentIfxType == 16) {
            byte[] byArray2 = new byte[1];
            this.bStream.read(byArray2, 0, 1);
            int n = byArray2[0] & 0xFF;
            byArray = new byte[n + 1];
            byArray[0] = byArray2[0];
            int n2 = this.bStream.read(byArray, 1, n);
            if (byArray2[0] != -1 || n2 < 3 || byArray[1] != -1 || byArray[2] != -1 || byArray[3] != -1) {
                ifxObject.fromIfx(byArray);
                string3 = ifxObject.toString();
                collection.add(string3);
            } else {
                int n3 = this.bStream.available();
                if (n3 > 0) {
                    byArray = new byte[n3];
                    this.bStream.read(byArray, 0, n3);
                }
            }
        } else if (this.currentIfxType == 0 || this.currentIfxType == 15) {
            byArray = new byte[this.currentIfxLength];
            this.bStream.read(byArray, 0, this.currentIfxLength);
            ifxObject.fromIfx(byArray);
            string3 = ifxObject.toString();
            collection.add(string3);
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)0, this.trace, string);
        }
        this.isNull = ifxObject.isNull();
        return string3;
    }

    private IfxObject readNestedComplex() throws SQLException {
        boolean bl;
        Object var1_1 = null;
        byte[] byArray = null;
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[2];
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxComplex ifxComplex = (IfxComplex)this.ifxObjectVector.get(this.typeIndex);
        this.bStream.read(byArray3, 0, 2);
        short s = IfxToJavaType.IfxToJavaSmallInt(byArray3);
        if (s > 0) {
            bl = false;
            if (s > 1) {
                int n = IfxComplexOutput.getUDToffset(this.currentPosition() - 2, this.trace);
                byArray = new byte[n + 2];
                s = (short)(s - (n += 2));
                this.bStream.read(byArray, 0, n);
                this.bStream.read(byArray2, 0, 4);
                int n2 = IfxToJavaType.IfxToJavaInt(byArray2);
                s = (short)(s - 4);
            } else {
                bl = true;
            }
        } else {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        byArray = new byte[s];
        this.bStream.read(byArray, 0, s);
        ifxComplex.fromIfx(byArray, (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex), bl);
        ifxComplex.setTypeMap(this.typeMap);
        return ifxComplex;
    }

    private Object readUDT(boolean bl) throws SQLException {
        Object object = null;
        if (this.isRow && !this.isStruct && !bl) {
            this.getNextType();
        }
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        byte[] byArray = new byte[1];
        this.bStream.read(byArray, 0, 1);
        byte[] byArray2 = new byte[4];
        this.bStream.read(byArray2, 0, 4);
        if (this.currentIfxType == 40 && byArray[0] == 1) {
            byArray2[3] = 0;
        }
        if (this.currentIfxType == 41 && byArray[0] == 1) {
            byArray2 = JavaToIfxType.JavaToIfxInt(ifxObject.getEncodedLength());
        }
        int n = IfxToJavaType.IfxToJavaInt(byArray2);
        byte[] byArray3 = new byte[5 + n];
        System.arraycopy(byArray, 0, byArray3, 0, 1);
        System.arraycopy(byArray2, 0, byArray3, 1, 4);
        this.bStream.read(byArray3, 5, n);
        ifxObject.fromIfx(byArray3);
        this.isNull = ifxObject.isNull();
        object = this.isNull ? null : ifxObject.toObject(true);
        return object;
    }

    Object readRow() throws SQLException {
        Object object = null;
        Class clazz = this.getTypeClass(this.typeMap, (IfxColumnInfo)this.parentTypeInfoVector.get(0), this.conn.getDatabaseType());
        if (clazz == null) {
            object = this.readStruct();
        } else {
            try {
                SQLData sQLData = (SQLData)clazz.newInstance();
                sQLData.readSQL(this, ((IfxColumnInfo)this.parentTypeInfoVector.get((int)0)).ExtendedName);
                object = sQLData;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return object;
    }

    Object readCollection() throws SQLException {
        Collection collection;
        Object object;
        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.parentTypeInfoVector.get(0);
        Class clazz = this.getTypeClass(this.typeMap, ifxColumnInfo, this.conn.getDatabaseType());
        int n = ifxColumnInfo.SQLtype;
        if (clazz != null) {
            try {
                object = (Collection)clazz.newInstance();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
            if (!(object instanceof Collection)) {
                throw IfxErrMsg.getSQLException(-79778, this.conn);
            }
            collection = object;
        } else {
            collection = n == 21 || n == 20 ? new ArrayList() : new HashSet();
        }
        object = (IfxColumnInfo)this.typeInfoVector.get(0);
        if (this.elementOffsetVector != null) {
            int n2 = this.elementOffsetVector.size();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.currentPosition();
                int n4 = (Integer)this.elementOffsetVector.get(i);
                try {
                    if (n3 < n4) {
                        this.is.skipBytes(n4 - n3);
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.readElement(collection);
            }
        } else {
            while (this.bStream.available() > 0) {
                this.readElement(collection);
            }
        }
        return collection;
    }

    Object[] readStructAttributes() throws SQLException {
        this.isStruct = true;
        ArrayList arrayList = new ArrayList();
        do {
            this.getNextType();
            this.readElement(arrayList);
        } while (this.typeIndex + 1 < this.typeInfoVector.size());
        return arrayList.toArray();
    }

    Object readArrayElements(int n) throws SQLException {
        int n2;
        int n3;
        Object object;
        Object object2 = null;
        ArrayList arrayList = new ArrayList();
        if (this.bStream.available() > 0) {
            object = (IfxColumnInfo)this.typeInfoVector.get(0);
            if (this.elementOffsetVector != null) {
                n3 = this.elementOffsetVector.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    int n4 = this.currentPosition();
                    int n5 = (Integer)this.elementOffsetVector.get(n2);
                    try {
                        if (n4 < n5) {
                            this.is.skipBytes(n5 - n4);
                        }
                    }
                    catch (Exception exception) {
                        throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                    }
                    this.readElement(arrayList);
                }
            } else {
                while (this.bStream.available() > 0) {
                    this.readElement(arrayList);
                }
            }
        }
        object = arrayList.toArray();
        n3 = ((Object[])object).length;
        switch (n) {
            case 5: {
                short[] sArray = new short[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    sArray[n2] = (Short)object[n2];
                }
                object2 = sArray;
                break;
            }
            case 4: {
                int[] nArray = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray[n2] = (Integer)object[n2];
                }
                object2 = nArray;
                break;
            }
            case -5: {
                long[] lArray = new long[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    lArray[n2] = (Long)object[n2];
                }
                object2 = lArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    fArray[n2] = ((Float)object[n2]).floatValue();
                }
                object2 = fArray;
                break;
            }
            case 8: {
                double[] dArray = new double[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray[n2] = (Double)object[n2];
                }
                object2 = dArray;
                break;
            }
            case 1111: {
                String string = null;
                if (((Object[])object).length > 1 && (string = object[0].getClass().getName()).equals("java.lang.Boolean")) {
                    boolean[] blArray = new boolean[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        blArray[n2] = (Boolean)object[n2];
                    }
                    object2 = blArray;
                    break;
                }
            }
            default: {
                object2 = object;
            }
        }
        return object2;
    }

    private void readElement(Collection collection) throws SQLException {
        switch (this.currentIfxType) {
            case 0: 
            case 13: 
            case 15: 
            case 16: 
            case 43: {
                String string = this.readString(collection);
                break;
            }
            case 1: {
                Short s = new Short(this.readShort());
                if (this.isNull) {
                    s = null;
                }
                collection.add(s);
                break;
            }
            case 2: 
            case 6: {
                Integer n = new Integer(this.readInt());
                if (this.isNull) {
                    n = null;
                }
                collection.add(n);
                break;
            }
            case 3: {
                Double d = new Double(this.readDouble());
                if (this.isNull) {
                    d = null;
                }
                collection.add(d);
                break;
            }
            case 4: {
                Float f = new Float(this.readFloat());
                if (this.isNull) {
                    f = null;
                }
                collection.add(f);
                break;
            }
            case 5: 
            case 8: {
                BigDecimal bigDecimal = this.readBigDecimal();
                collection.add(bigDecimal);
                break;
            }
            case 7: {
                Date date = this.readDate();
                collection.add(date);
                break;
            }
            case 10: {
                java.util.Date date = (byte)((this.currentIfxLength & 0xFF) >> 4 & 0xF) < 6 ? this.readTimestamp() : this.readTime();
                collection.add(date);
                break;
            }
            case 14: {
                Interval interval = this.readInterval();
                collection.add(interval);
                break;
            }
            case 17: 
            case 18: {
                Long l = new Long(this.readLong());
                if (this.isNull) {
                    l = null;
                }
                collection.add(l);
                break;
            }
            case 52: 
            case 53: {
                Long l = new Long(this.readLongBigint());
                if (this.isNull) {
                    l = null;
                }
                collection.add(l);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                Object object = this.readNestedComplex().toObject();
                collection.add(object);
                break;
            }
            case 40: 
            case 41: {
                Object object;
                if (this.currentExtendedId == 5) {
                    object = new Boolean(this.readBoolean());
                    if (this.isNull) {
                        object = null;
                    }
                } else {
                    object = this.currentExtendedId == 10 ? this.readBlob() : (this.currentExtendedId == 11 ? this.readClob() : this.readUDT(false));
                }
                collection.add(object);
                break;
            }
            case 45: {
                Boolean bl = new Boolean(this.readBoolean());
                if (this.isNull) {
                    bl = null;
                }
                collection.add(bl);
                break;
            }
            default: {
                throw IfxErrMsg.getSQLException(-9970, this.conn);
            }
        }
    }

    @Override
    public Array readArray() throws SQLException {
        IfxObject ifxObject = this.readNestedComplex();
        if (!(ifxObject instanceof IfxCollection)) {
            ClassCastException classCastException = new ClassCastException();
            throw new SQLException(classCastException.toString());
        }
        return (IfxArray)((IfxCollection)ifxObject).toArray();
    }

    IfxArray readIfxArray() throws SQLException {
        byte[] byArray = new byte[this.bStream.available()];
        this.bStream.read(byArray, 0, this.bStream.available());
        return new IfxArray(byArray, this.parentTypeInfoVector, this.conn);
    }

    Object readStruct() throws SQLException {
        byte[] byArray = new byte[this.bStream.available()];
        this.bStream.read(byArray, 0, this.bStream.available());
        IfxStruct ifxStruct = new IfxStruct(byArray, this.parentTypeInfoVector, this.conn);
        return ifxStruct;
    }

    private void getNextType() throws SQLException {
        if (this.isRow) {
            ++this.typeIndex;
            if (this.typeIndex < this.typeInfoVector.size()) {
                IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
                this.currentIfxType = ifxColumnInfo.SQLtype;
                this.currentExtendedId = ifxColumnInfo.ExtendedId;
                this.currentExtendedName = ifxColumnInfo.ExtendedName;
                this.currentIfxLength = ifxColumnInfo.ColLength;
                this.currentSourceType = ifxColumnInfo.SourceType;
            } else {
                throw IfxErrMsg.getSQLException(-79773, this.conn);
            }
        }
    }

    private Class getTypeClass(Map map, IfxColumnInfo ifxColumnInfo, int n) {
        Class clazz = null;
        String string = null;
        if (map == null) {
            return null;
        }
        if (IfxTypes.isCollection(ifxColumnInfo.SQLtype)) {
            string = IfxTypes.IfxTypeToName(ifxColumnInfo.SQLtype);
        } else if (ifxColumnInfo.IsNamedRow) {
            string = ifxColumnInfo.ExtendedName;
        }
        if (string != null && (clazz = (Class)map.get(string)) == null && n == 1) {
            clazz = (Class)map.get(ifxColumnInfo.ExtendedOwner + "." + string);
        }
        return clazz;
    }

    private IfxObject convLob() throws SQLException {
        String string = null;
        if (this.conn != null) {
            string = this.conn.getclLocale();
        }
        byte[] byArray = null;
        IfxObject ifxObject = (IfxObject)this.ifxObjectVector.get(this.typeIndex);
        if (this.currentExtendedId == 10 || this.currentExtendedId == 11) {
            int n = 77;
            byArray = new byte[n];
            this.bStream.read(byArray, 0, n);
            ifxObject.fromIfx(byArray);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)102, this.trace, string);
        }
        return ifxObject;
    }

    @Override
    public IfxUDTInfo getUDTInfo(int n) throws SQLException {
        return this.conn.getUDTInfo(n);
    }

    @Override
    public IfxUDTInfo getUDTInfo(String string, String string2) throws SQLException {
        return this.conn.getUDTInfo(string, string2);
    }

    @Override
    public URL readURL() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readURL()", this.conn);
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "readRowId", (IfxConnection)null);
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "readSQLXML", (IfxConnection)null);
    }

    @Override
    public String readNString() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "readNString", (IfxConnection)null);
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "readNClob", (IfxConnection)null);
    }
}

