/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxParameterMetaData;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.mdinfo;
import com.informix.jdbc.rowinfo;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxDatabaseMetaData
implements DatabaseMetaData {
    private IfxConnection conn;
    private Trace trace = null;
    private Stack stmtStack = null;
    private static int nextTempTableId;
    private static int nMdInfoRows;
    private static int nStdRowTypes;
    private static int nXtdRowTypes;
    private static int nXtdRowTypesSupported;
    private static mdinfo[] lmd;
    private rowinfo[] lrow = null;
    private static rowinfo[] lrowgeneric;
    private static rowinfo[] lrowLvc32k;

    private synchronized String nextTempTableName() {
        String string = "dbmd" + nextTempTableId;
        ++nextTempTableId;
        return string;
    }

    IfxDatabaseMetaData(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
        this.lrow = this.conn != null && this.conn.isLvcGtThan2kSupported() ? lrowLvc32k : lrowgeneric;
        if (this.conn != null) {
            this.trace = this.conn.getTrace();
        }
    }

    int getMaxLvarcharSize() {
        int n = 0;
        for (n = 0; n < this.lrow.length && !this.lrow[n].tname.equalsIgnoreCase("lvarchar"); ++n) {
        }
        return this.lrow[n].precision;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        if (this.conn != null) {
            return this.conn.getURL();
        }
        return null;
    }

    @Override
    public String getUserName() throws SQLException {
        if (this.conn != null) {
            return this.conn.getUserName();
        }
        return null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.conn != null) {
            return this.conn.isReadOnly();
        }
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (this.conn != null) {
            return this.conn.getDbProductName();
        }
        return "Informix Dynamic Server";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.conn != null) {
            int n;
            String string = this.conn.getDbVersion();
            String string2 = string.substring(0, n = string.indexOf(".")) + string.substring(n + 1, n + 3);
            if (Integer.parseInt(string2) > 950 && Integer.parseInt(string2) < 1000) {
                try {
                    ((IfxSqliConnect)this.conn).startMetaDataQuery();
                    Statement statement = this.conn.createStatement();
                    String string3 = "select dbinfo('version','full') from informix.systables where tabname = 'systables'";
                    ResultSet resultSet = statement.executeQuery(string3);
                    resultSet.next();
                    String string4 = resultSet.getString(1);
                    int n2 = string4.indexOf("Version");
                    ((IfxSqliConnect)this.conn).externalVersion = string4.substring(n2 + 7).trim();
                    ((IfxSqliConnect)this.conn).endMetaDataQuery();
                    return string4.substring(n2 + 7).trim();
                }
                catch (SQLException sQLException) {
                    ((IfxSqliConnect)this.conn).endMetaDataQuery();
                    throw sQLException;
                }
            }
            return this.conn.getDbVersion();
        }
        return null;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "IBM Informix JDBC Driver for IBM Informix Dynamic Server";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return IfxDriver.getJDBCVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        try {
            return IfxDriver.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public int getDriverMinorVersion() {
        try {
            return IfxDriver.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return !this.conn.isOnLine();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return !this.conn.isOnLine();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isDelimIdentSet();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (this.conn == null) {
            return true;
        }
        return !this.conn.isDelimIdentSet();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isDelimIdentSet();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (this.conn == null || !this.conn.isDelimIdentSet()) {
            return " ";
        }
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        String string = null;
        string = this.conn.isUSVER() ? new String("after,ansi,append,attach,audit,before,bitmap,boolean,buffered,byte,cache,call,cluster,clustersize,codeset,database,datafiles,dataskip,datetime,dba,dbdate,dbmoney,debug,define,delimiter,deluxe,detach,dirty,distributions,document,each,elif,exclusive,exit,explain,express,expression,extend,extent,file,fillfactor,foreach,format,fraction,fragment,gk,hash,high,hold,hybrid,if,index,init,labeleq,labelge,labelgt,labelle,labellt,let,listing,lock,log,low,matches,maxerrors,medium,mode,modify,money,mounting,new,nvarchar,off,old,operational,optical,optimization,page,pdqpriority,pload,private,raise,range,raw,recordend,recover,referencing,rejectfile,release,remainder,rename,reserve,resolution,resource,resume,return,returning,returns,ridlist,robin,rollforward,round,row,rowids,sameas,samples,schedule,scratch,serial,share,skall,skinhibit,skshow,smallfloat,stability,standard,start,static,statistics,stdev,step,sync,synonym,system,temp,text,timeout,trace,trigger,units,unlock,variance,wait,while,xload,xunload") : new String("after,ansi,append,attach,audit,before,bitmap,buffered,byte,cache,call,cluster,clustersize,codeset,database,datafiles,dataskip,datetime,dba,dbdate,dbmoney,debug,define,delimiter,deluxe,detach,dirty,distributions,document,each,elif,exclusive,exit,explain,express,expression,extend,extent,file,fillfactor,foreach,format,fraction,fragment,gk,hash,high,hold,hybrid,if,index,init,labeleq,labelge,labelgt,labelle,labellt,let,listing,lock,log,low,matches,maxerrors,medium,mode,modify,money,mounting,new,nvarchar,off,old,operational,optical,optimization,page,pdqpriority,pload,private,raise,range,raw,recordend,recover,referencing,rejectfile,release,remainder,rename,reserve,resolution,resource,resume,return,returning,returns,ridlist,robin,rollforward,round,row,rowids,sameas,samples,schedule,scratch,serial,share,skall,skinhibit,skshow,smallfloat,stability,standard,start,static,statistics,stdev,step,sync,synonym,system,temp,text,timeout,trace,trigger,units,unlock,variance,wait,while,xload,xunload");
        return string;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "abs,mod,pow,root,round,sqrt,exp,logn,log10,cos,sin,tan,asin,acos,atan,atan2";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "trunc,length";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "avg,max,min,sum,count,range,stdev,variance,trim,hex,filetoblob,filetoclob,lotofile,lotocopy";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "date,day,month,weekday,year,extend,mdy";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        if (this.conn == null) {
            return "";
        }
        if (this.conn.isLongID()) {
            return "$";
        }
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        int n = this.getDatabaseMajorVersion();
        if (n > 9) {
            return true;
        }
        return n == 9 && this.getDatabaseMinorVersion() >= 40;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return !((IfxSqliConnect)this.conn).isCTSCompliant();
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "user";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    private String getTmpTableTerm() {
        if (this.conn.isXPS()) {
            return "scratch";
        }
        return "temp";
    }

    private String getNoLogTerm() {
        if (this.conn.isXPS()) {
            return "";
        }
        return "with no log";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ":";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 256;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 255;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 32;
        }
        return 8;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.conn == null) {
            return 0;
        }
        int n = this.conn.getDatabaseType();
        if (n == 1) {
            return 4;
        }
        if (n == 2) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return this.conn.getDatabaseType() != 3;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        int n2;
        block7: {
            block6: {
                if (this.conn == null) {
                    return false;
                }
                if (!(n == 1 || n == 2 || n == 4 || n == 8 || n == 0 || n == 5 && this.conn.IsLastCommittedSupported())) {
                    return false;
                }
                n2 = this.conn.getDatabaseType();
                if (n2 == 1) break block6;
                if (n2 != 2) break block7;
            }
            if (n != 0) {
                return true;
            }
        }
        return n2 == 3 && (n == 1 || n == 0);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        String string4;
        Object object;
        IfxStatement ifxStatement;
        IfxStatement ifxStatement2 = null;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string2 = this.toSchemaCaseLikeServer(string2);
            string3 = string3.toLowerCase();
        }
        try {
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement2.setAutoFree(true);
            if (this.conn.isOnLine()) {
                ifxStatement2.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "( " + "  PROCEDURE_CAT    varchar(129), " + "  PROCEDURE_SCHEM  varchar(129), " + "  PROCEDURE_NAME  varchar(129) ) " + this.getNoLogTerm() + ";");
            } else {
                ifxStatement2.executeUpdate("create temp table " + string5 + "( " + "  PROCEDURE_CAT    char(18), " + "  PROCEDURE_SCHEM  char(18), " + "  PROCEDURE_NAME   char(40) );");
            }
            ifxStatement2.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            object = this.getMetaDbName(string);
            string4 = this.conn.isOnLine() ? "select '" + (String)object + "', " + "owner, " + "procname " + "from " + (String)object + ":informix.sysprocedures" : "select '" + (String)object + "', " + "owner, " + "procname " + "from " + "informix.sysprocedures";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        try {
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement2.setAutoFree(true);
            while (resultSet.next()) {
                ifxStatement2.executeUpdate("insert into " + string5 + " values( " + " '" + resultSet.getString(1) + " '" + ", '" + resultSet.getString(2).trim() + "', '" + resultSet.getString(3) + "' )");
            }
            ifxStatement2.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string4 = "select unique PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, '' as RESERVED1, '' as RESERVED2, '' as RESERVED3, '' as REMARKS, 0 as PROCEDURE_TYPE from " + string5 + " where " + "PROCEDURE_NAME like '" + string3 + "' " + "and PROCEDURE_SCHEM like '" + string2 + "'" + " order by 2, 3";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        object = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return object;
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        if (this.conn.isUSVER()) {
            ((IfxSqliConnect)this.conn).startMetaDataQuery();
            if (string2 == null || string2.length() == 0) {
                string2 = "%";
            }
            if (string3 == null || string3.length() == 0) {
                string3 = "%";
            }
            if (string4 == null || string4.length() == 0) {
                string4 = "%";
            }
            if (!this.conn.isDelimIdentSet()) {
                string2 = this.toSchemaCaseLikeServer(string2);
                string3 = string3.toLowerCase();
            }
            String string6 = this.getMetaDbName(string);
            try {
                ifxStatement = (IfxStatement)this.conn.createStatement();
                ifxStatement.setAutoFree(true);
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "( " + "  PROCEDURE_CAT    varchar(129), " + "  PROCEDURE_SCHEM  varchar(129), " + "  PROCEDURE_NAME   varchar(129), " + "  COLUMN_NAME varchar(129), " + "  COLUMN_TYPE int," + "  DATA_TYPE   int," + "  TYPE_NAME   varchar(100)," + "  PRECISION   int," + "  LENGTH\t int," + "  SCALE       int," + "  RADIX       int," + "  NULLABLE    int," + "  REMARKS     lvarchar," + "  ser\t serial\t) " + this.getNoLogTerm() + ";");
                ifxStatement.close();
                if (string3.equals("%") && string2.equals("%")) {
                    ifxStatement2 = (IfxStatement)this.conn.createStatement();
                    boolean bl = false;
                    if (this.conn.isANSI() && this.conn.getAutoCommit()) {
                        bl = true;
                    }
                    ResultSet resultSet = ifxStatement2.executeQuery("select unique procname from informix.sysprocedures", bl);
                    while (resultSet.next()) {
                        string3 = resultSet.getString(1);
                        this.processProcName(string3, string2, string6, string5);
                    }
                    ifxStatement2.close();
                } else {
                    this.processProcName(string3, string2, string6, string5);
                }
                String string7 = null;
                string7 = this.supportsNamedParameters() ? "select * from " + string5 + " where " + "COLUMN_NAME like  '" + string4 + "' " + " order by 2, 3, 14" : "select * from " + string5 + " order by 2, 3, 14 ";
                IfxStatement ifxStatement3 = (IfxStatement)this.conn.createStatement();
                ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement3.executeQuery(string7, true) : ifxStatement3.executeQuery(string7, false);
                ResultSet resultSet2 = this.populateClientResultSet(resultSet);
                ifxStatement3.close();
                this.dropTempTable(string5);
                ((IfxSqliConnect)this.conn).endMetaDataQuery();
                return resultSet2;
            }
            catch (SQLException sQLException) {
                ((IfxSqliConnect)this.conn).endMetaDataQuery();
                if (sQLException.getErrorCode() == -329) {
                    IfxStatement ifxStatement4 = (IfxStatement)this.conn.createStatement();
                    IfxResultSet ifxResultSet = new IfxResultSet(ifxStatement4, this.conn, ifxStatement4.prot);
                    return ifxResultSet;
                }
                throw sQLException;
            }
        }
        return null;
    }

    private void processProcName(String string, String string2, String string3, String string4) throws SQLException {
        Statement statement = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        boolean bl = false;
        IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
        IfxStatement ifxStatement2 = (IfxStatement)this.conn.createStatement();
        ifxStatement.setAutoFree(true);
        ifxStatement2.setAutoFree(true);
        String string14 = "select  procid from " + string3 + ":informix.sysprocedures where " + "procname like '" + string + "' " + "and owner like '" + string2 + "';";
        ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string14, true) : ifxStatement.executeQuery(string14, false);
        while (resultSet.next()) {
            if (!bl) {
                bl = true;
                statement = this.conn.prepareStatement("insert into " + string4 + "(PROCEDURE_CAT, PROCEDURE_SCHEM," + "PROCEDURE_NAME, COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, TYPE_NAME," + "NULLABLE, REMARKS)" + "values (?,?,?,?,?,?,?,?,?);");
            }
            int n = resultSet.getInt(1);
            string14 = "select owner, procname,isproc, ifx_param_types(" + n + ")," + "ifx_param_ids(" + n + ")," + "ifx_ret_types(" + n + "), " + "ifx_ret_ids(" + n + ") " + "from informix.sysprocedures where procid = " + n + ";";
            ResultSet resultSet2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement2.executeQuery(string14, true) : ifxStatement2.executeQuery(string14, false);
            while (resultSet2.next()) {
                Vector vector;
                Vector vector2;
                string5 = resultSet2.getString(1).trim();
                string6 = resultSet2.getString(2);
                string11 = resultSet2.getString(3);
                string12 = string11.equals("t") ? "create procedure " : "create function ";
                string12 = string12 + string5 + "." + string6.trim() + "(";
                string13 = string11.equals("t") ? "execute procedure " : "execute function ";
                string13 = string13 + string5 + "." + string6.trim() + "(";
                string8 = resultSet2.getString(4);
                string7 = resultSet2.getString(5);
                string10 = resultSet2.getString(6);
                string9 = resultSet2.getString(7);
                statement.setString(1, string3);
                statement.setString(2, string5);
                statement.setString(3, string6);
                statement.setInt(8, 2);
                if (!string10.equals("")) {
                    string12 = !string8.equals("") ? string12 + string8 + ") returning " + string10 + ";" : string12 + ") returning " + string10 + ";";
                    vector2 = this.parseTypes(string10);
                    vector = this.parseIds(string9);
                    statement.setInt(5, 5);
                    statement.setString(9, string12);
                    for (int i = 0; vector.size() > i && vector2.size() > i; ++i) {
                        statement.setString(4, "null");
                        Integer n2 = (Integer)vector.elementAt(i);
                        String string15 = (String)vector2.elementAt(i);
                        statement.setInt(6, n2);
                        statement.setString(7, string15);
                        statement.executeUpdate();
                    }
                }
                if (!string8.equals("")) {
                    if (string10.equals("")) {
                        string12 = string12 + string8 + ")";
                    }
                    vector2 = this.parseTypes(string8);
                    vector = this.parseIds(string7);
                    Vector vector3 = this.parseParameterNames(string13, vector2);
                    statement.setInt(5, 1);
                    statement.setString(9, string12);
                    int n3 = Math.min(vector.size(), Math.min(vector2.size(), vector3.size()));
                    for (int i = 0; i < n3; ++i) {
                        statement.setString(4, (String)vector3.elementAt(i));
                        statement.setInt(6, (Integer)vector.elementAt(i));
                        statement.setString(7, (String)vector2.elementAt(i));
                        statement.executeUpdate();
                    }
                }
                if (!string8.equals("") || !string10.equals("")) continue;
                string12 = string12 + ")";
                statement.setString(4, "null");
                statement.setInt(5, 0);
                statement.setInt(6, 0);
                statement.setString(7, "NULL");
                statement.setString(9, string12);
                statement.executeUpdate();
            }
        }
        if (statement != null) {
            statement.close();
        }
        ifxStatement.close();
        ifxStatement2.close();
        if (!bl) {
            throw IfxErrMsg.getSQLException(-9753, this.conn);
        }
    }

    private Vector parseTypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>(20);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    private Vector parseIds(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(,)");
        boolean bl = true;
        Vector<Integer> vector = new Vector<Integer>(20);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                int n = Integer.valueOf(string2.trim());
                int n2 = IfxTypes.FromIfxToJDBC2Type(n);
                if (n == 4 && !this.conn.getMapReal()) {
                    n2 = 6;
                }
                vector.add(new Integer(n2));
                bl = false;
                continue;
            }
            bl = true;
        }
        return vector;
    }

    Vector parseParameterNames(String string, Vector vector) throws SQLException {
        int n;
        Object object;
        String string2 = "";
        Vector<String> vector2 = null;
        int n2 = vector.size();
        if (!this.supportsNamedParameters()) {
            vector2 = new Vector<String>(n2);
            for (int i = 0; i < n2; ++i) {
                vector2.add("null");
            }
            return vector2;
        }
        for (int i = 0; i < n2; ++i) {
            String string3;
            object = (String)vector.elementAt(i);
            n = ((String)object).lastIndexOf(46) + 1;
            if (n == 0) {
                n = ((String)object).lastIndexOf(32) + 1;
            }
            string2 = (string3 = ((String)object).substring(n)).equalsIgnoreCase("datetime") || string3.equalsIgnoreCase("interval") ? string2 + (i == 0 ? "?" : ",?") : string2 + (i == 0 ? "?::" : ",?::") + string3;
        }
        try {
            CallableStatement callableStatement = this.conn.prepareCall(string + string2 + ");");
            object = callableStatement.getParameterMetaData();
            n = object.getParameterCount();
            vector2 = new Vector(n);
            for (int i = 1; i <= n; ++i) {
                if (((IfxParameterMetaData)object).getArgumentName(i).length() >= 4) {
                    if (((IfxParameterMetaData)object).getArgumentName(i).substring(0, 4).equals("arg[")) {
                        vector2.add("null");
                        continue;
                    }
                    vector2.add(((IfxParameterMetaData)object).getArgumentName(i));
                    continue;
                }
                vector2.add(((IfxParameterMetaData)object).getArgumentName(i));
            }
            callableStatement.close();
            return vector2;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -201 || sQLException.getErrorCode() == -9963 || sQLException.getErrorCode() == -9628 || sQLException.getErrorCode() == -674) {
                vector2 = new Vector(n2);
                for (int i = 0; i < n2; ++i) {
                    vector2.add("null");
                }
                return vector2;
            }
            throw sQLException;
        }
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4;
        String string5 = this.nextTempTableName();
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        boolean bl5 = false;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
                if (stringArray[i].trim().equalsIgnoreCase("SYSTEM TABLE")) {
                    bl5 = true;
                    ++n;
                }
                if (stringArray[i].trim().equalsIgnoreCase("TABLE")) {
                    bl = true;
                    ++n;
                    continue;
                }
                if (stringArray[i].trim().equalsIgnoreCase("VIEW")) {
                    bl2 = true;
                    ++n;
                    continue;
                }
                if (stringArray[i].trim().equalsIgnoreCase("SYNONYM") && this.conn.isANSI()) {
                    bl4 = true;
                    ++n;
                    continue;
                }
                if (!stringArray[i].trim().equalsIgnoreCase("SYNONYM")) continue;
                bl4 = true;
                ++n;
                bl3 = true;
                ++n;
            }
        }
        String string7 = this.getMetaDbName(string);
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            boolean bl6;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "( " + "  table_cat    varchar(129), " + "  table_schem  varchar(129), " + "  table_name   varchar(129), " + "  table_type   varchar(129), " + "  remarks      varchar(129)) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat    char(18), " + "  table_schem  char(18), " + "  table_name   char(40), " + "  table_type   char(18), " + "  remarks      char(18)) ");
            }
            string4 = null;
            string4 = this.conn.isOnLine() ? "select tabname, tabtype, owner, tabid from " + string7 + ":informix.systables " : "select tabname, tabtype, owner, tabid from informix.systables ";
            int n2 = n;
            if (n > 0) {
                string4 = string4 + "where tabtype in (";
                string6 = " where table_type in (";
            }
            if (bl5) {
                string4 = string4 + "'T'";
                string6 = string6 + "'SYSTEM TABLE'";
                if (--n > 0) {
                    string4 = string4 + ",";
                    string6 = string6 + ",";
                }
            }
            if (bl) {
                string4 = string4 + "'T'";
                string6 = string6 + "'TABLE'";
                if (--n > 0) {
                    string4 = string4 + ",";
                    string6 = string6 + ",";
                }
            }
            if (bl2) {
                string4 = string4 + "'V'";
                string6 = string6 + "'VIEW'";
                if (--n > 0) {
                    string4 = string4 + ",";
                    string6 = string6 + ",";
                }
            }
            if (bl3) {
                string4 = string4 + "'S'";
                string6 = string6 + "'SYNONYM'";
                if (--n > 0) {
                    string4 = string4 + ",";
                }
            }
            if (bl4) {
                string4 = string4 + "'P'";
                if (!bl3) {
                    string6 = string6 + "'SYNONYM'";
                }
            }
            if (n2 > 0) {
                string4 = string4 + ")";
                string6 = string6 + ")";
            }
            boolean bl7 = bl6 = n2 > 0;
            if (string3 != null) {
                if (bl6) {
                    string4 = string4 + " and tabname like '" + string3 + "'";
                } else {
                    bl6 = true;
                    string4 = string4 + " where tabname like '" + string3 + "'";
                }
            }
            if (string2 != null) {
                string4 = bl6 ? string4 + " and owner like " + "'" + string2 + "'" : string4 + " where owner like " + "'" + string2 + "'";
            }
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                String string8;
                String string9 = resultSet.getString(1);
                String string10 = resultSet.getString(2);
                String string11 = resultSet.getString(3).trim();
                int n3 = resultSet.getInt(4);
                if (string10 != null && string10.length() > 0) {
                    switch (string10.charAt(0)) {
                        case 'T': {
                            if (n3 <= 99) {
                                string8 = "SYSTEM TABLE";
                                break;
                            }
                            string8 = "TABLE";
                            break;
                        }
                        case 'V': {
                            string8 = "VIEW";
                            break;
                        }
                        case 'P': 
                        case 'S': {
                            string8 = "SYNONYM";
                            break;
                        }
                        case 'L': {
                            string8 = "LOG";
                            break;
                        }
                        default: {
                            string8 = "UNKNOWN";
                            break;
                        }
                    }
                } else {
                    string8 = "UNKNOWN";
                }
                ifxStatement2.executeUpdate("insert into " + string5 + " values( '" + string7 + "', '" + string11 + "', '" + string9 + "', '" + string8 + "', null )");
            }
            ifxStatement2.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string4 = "select * from " + string5 + string6 + " order by 4, 2, 3";
        ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        ResultSet resultSet2 = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        string5 = null;
        return resultSet2;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ResultSet resultSet;
        String string;
        IfxStatement ifxStatement;
        String string2 = this.nextTempTableName();
        IfxStatement ifxStatement2 = null;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        try {
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement2.setAutoFree(true);
            if (this.conn.isOnLine()) {
                ifxStatement2.executeUpdate("create " + this.getTmpTableTerm() + " table " + string2 + "( " + "  TABLE_SCHEM   varchar(129), " + "  tabtype   char(1) ) " + this.getNoLogTerm() + ";");
            } else {
                ifxStatement2.executeUpdate("create temp table " + string2 + "( " + "  TABLE_SCHEM   char(18), " + "  tabtype   char(1) );");
            }
            ifxStatement2.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string = "select owner as TABLE_SCHEM, tabtype from informix.systables where tabtype != ''";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string, true) : ifxStatement.executeQuery(string, false);
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        try {
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement2.setAutoFree(true);
            while (resultSet.next()) {
                ifxStatement2.executeUpdate("insert into " + string2 + " values( " + " '" + resultSet.getString(1).trim() + "','" + resultSet.getString(2) + "' )");
            }
            ifxStatement2.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string = "select unique TABLE_SCHEM from " + string2 + " where " + "tabtype != '' order by 1";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string, true) : ifxStatement.executeQuery(string, false);
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ResultSet resultSet2 = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string2);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        IfxProtocol ifxProtocol;
        int n = 0;
        if (this.conn == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Class<?> clazz2 = Class.forName(this.conn.getConnClassName());
            Class[] classArray = new Class[]{clazz2};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.conn};
            ifxProtocol = (IfxProtocol)constructor.newInstance(objectArray);
            if (ifxProtocol == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
        ifxProtocol.executeGetDBList();
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(1, this.conn);
        ifxResultSetMetaData.setEncodedLength(1, 128);
        ifxResultSetMetaData.setNullable(1, 0);
        ifxResultSetMetaData.setMaxWidth(1, 128);
        ifxResultSetMetaData.setColtitle(1, "DB Name");
        ifxResultSetMetaData.setColumnName(1, "TABLE_CAT");
        ifxResultSetMetaData.setIfxColumnType(1, 0);
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, ifxResultSetMetaData);
        Vector vector = ifxProtocol.getDBList();
        n = vector.size();
        if (n > 0) {
            ifxClientResultSet.newRow(n);
            for (int i = 0; i < n; ++i) {
                ifxClientResultSet.updateString(i + 1, 1, (String)vector.elementAt(i) != null ? stringUtil.trimTrailings((String)vector.elementAt(i)) : null);
            }
            ifxClientResultSet.beforeFirst();
            ifxClientResultSet.setFetchDirection(1000);
            ifxClientResultSet.setConcurrency(1007);
            ifxClientResultSet.setType(1003);
        }
        ifxProtocol.clear();
        ifxProtocol = null;
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ResultSet resultSet;
        IfxStatement ifxStatement;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string = this.conn.getDatabaseType() == 1 ? "select unique 'SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'P'" : "select unique 'PRIVATE_SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'P'";
            String string2 = "select unique 'TABLE' as TABLE_TYPE from informix.systables where tabtype = 'T' union select unique 'SYSTEM TABLE' as TABLE_TYPE from informix.systables where tabtype = 'T' and tabid <= 99 union select unique 'VIEW' as TABLE_TYPE from informix.systables where tabtype = 'V' union select unique 'SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'S' union " + string;
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string2, true) : ifxStatement.executeQuery(string2, false);
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ResultSet resultSet2 = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string5;
        String string6 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string5 = this.getMetaDbName(string);
            if (!this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string6 + "( " + "  table_cat          char(50), " + "  table_schem        char(50), " + "  table_name         char(50), " + "  column_name        char(50), " + "  data_type          smallint, " + "  type_name          char(50), " + "  column_size        integer, " + "  buffer_length      smallint, " + "  decimal_digits     integer, " + "  num_prec_radix     integer, " + "  nullable           integer, " + "  remarks            char(18), " + "  column_def         char(255), " + "  sql_data_type      integer, " + "  sql_datetime_sub   integer, " + "  char_octet_length  integer, " + "  ordinal_position   integer, " + "  is_nullable        char(3) )");
            } else {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string6 + "( " + "  table_cat          varchar(129), " + "  table_schem        varchar(129), " + "  table_name         varchar(129), " + "  column_name        varchar(129), " + "  data_type          smallint, " + "  type_name          varchar(129), " + "  column_size        integer, " + "  buffer_length      smallint, " + "  decimal_digits     integer, " + "  num_prec_radix     integer, " + "  nullable           integer, " + "  remarks            char(18), " + "  column_def         varchar(255), " + "  sql_data_type      integer, " + "  sql_datetime_sub   integer, " + "  char_octet_length  integer, " + "  ordinal_position   integer, " + "  is_nullable        char(3) ) " + this.getNoLogTerm());
            }
            if (string3 != null) {
                if (!this.conn.isDelimIdentSet()) {
                    string3 = string3.toLowerCase();
                }
                string3 = string3.trim();
                string3 = this.checkSynonym(string3, string5);
            } else {
                string3 = "*";
            }
            if (string4 != null) {
                if (!this.conn.isDelimIdentSet()) {
                    string4 = string4.toLowerCase();
                }
                string4 = string4.trim();
            } else {
                string4 = "";
            }
            if (!this.conn.isDelimIdentSet()) {
                string2 = this.toSchemaCaseLikeServer(string2);
            }
            object = null;
            object = this.conn.isUSVER() ? "select st.tabname, sc.colname, sc.colno, sc.coltype, sc.collength, sc.colmin, sc.colmax, st.owner, sx.name,  sc.extended_id,  sdf.type, sdf.default from " + string5 + ":informix.systables st, " + string5 + ":informix.syscolumns sc," + "  outer " + string5 + ":informix.sysxtdtypes sx, " + "  outer " + string5 + ":informix.sysdefaults sdf " + "where st.tabname like " + "'" + string3 + "' and st.owner like " + "'" + string2 + "' and st.tabid = sc.tabid " + "  and st.tabid = sdf.tabid " + "  and sc.colno = sdf.colno " + "  and sc.extended_id = sx.extended_id " : (this.conn.isOnLine() ? "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength,  sc.colmin, sc.colmax, st.owner,   sdf.type, sdf.default from " + string5 + ":informix.systables st, " + string5 + ":informix.syscolumns sc, " + "   outer " + string5 + ":informix.sysdefaults sdf " + "where st.tabname like " + "'" + string3 + "' and st.owner like " + "'" + string2 + "' and st.tabid = sc.tabid " + "  and st.tabid = sdf.tabid " + "  and sc.colno = sdf.colno " : "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength, st.owner,   sdf.type, sdf.default from informix.systables st, informix.syscolumns sc,   outer informix.sysdefaults sdf where st.tabname like '" + string3 + "' and st.owner like " + "'" + string2 + "' and st.tabid = sc.tabid " + "  and st.tabid = sdf.tabid " + "  and sc.colno = sdf.colno ");
            if (string4.length() > 0) {
                object = (String)object + " and sc.colname like '" + string4 + "'";
            }
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                int n;
                short s = resultSet.getShort(4);
                short s2 = (short)(s & 0xFF);
                short s3 = resultSet.getShort(5);
                String string7 = this.conn.isOnLine() ? resultSet.getString(8).trim() : resultSet.getString(6).trim();
                short s4 = 0;
                if (this.conn.isUSVER()) {
                    s4 = resultSet.getShort(10);
                }
                int n2 = this.getJDBCColumnSize(s2, s4, s3);
                String string8 = this.conn.isUSVER() ? resultSet.getString(11) : (this.conn.isOnLine() ? resultSet.getString(9) : resultSet.getString(7));
                String string9 = string8 == null ? null : (string8.equals("N") ? null : (string8.equals("C") ? "current" : (string8.equals("T") ? "today" : (string8.equals("U") ? "user" : (string8.equals("S") ? "dbservername" : (string8.equals("L") ? (this.conn.isUSVER() ? resultSet.getString(12) : (this.conn.isOnLine() ? resultSet.getString(10) : resultSet.getString(8))) : null))))));
                String string10 = IfxTypes.IfxTypeToName(s2);
                if (this.conn.isUSVER()) {
                    if ((s2 == 41 || s2 == 40) && (string10 = resultSet.getString(9)) == null) {
                        IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo(resultSet.getInt(10));
                        if (ifxUDTInfo == null) {
                            throw IfxErrMsg.getSQLException(-79770, this.conn);
                        }
                        string10 = ifxUDTInfo.getName();
                    }
                    if ((s & 0x800) == 2048) {
                        string10 = resultSet.getString(9);
                    }
                }
                string10 = string10.trim();
                int n3 = IfxTypes.FromIfxToJDBCType(s2);
                if (s2 == 4 && !this.conn.getMapReal()) {
                    n3 = 6;
                }
                if (this.conn.isUSVER()) {
                    if ((s & 0x800) == 2048) {
                        n3 = 2001;
                    }
                    if (string10.equals("boolean")) {
                        n3 = IfxDriver.compareJDKVersion("1.4") < 0 ? 1111 : 16;
                    } else if (string10.equals("lvarchar")) {
                        n3 = -1;
                    } else if (string10.equals("blob")) {
                        n3 = 2004;
                    } else if (string10.equals("clob")) {
                        n3 = 2005;
                    }
                }
                if (s == 10) {
                    n = IfxDateTime.getStartCode(s3);
                    n3 = n >= 6 ? 92 : 93;
                }
                int n4 = 0;
                int n5 = 0;
                if (s2 == 1 || s2 == 2 || s2 == 6) {
                    n5 = 2;
                    n4 = 10;
                } else if (this.conn.isUSVER() && (s2 == 17 || s2 == 18 || s2 == 52 || s2 == 53)) {
                    n4 = 10;
                } else if (s2 == 5 || s2 == 8) {
                    n5 = s3 - s3 / 256 * 256;
                    n4 = 10;
                } else if (s2 == 3) {
                    n5 = 15;
                    n4 = 10;
                } else if (s2 == 4) {
                    n5 = 7;
                    n4 = 10;
                } else if (this.conn.isUSVER() && s2 == 41 && (string10.equals("boolean") || (s & 0x4000) == 16384)) {
                    n4 = 2;
                }
                int n6 = 1;
                String string11 = "YES";
                if ((s & 0x100) == 256) {
                    n6 = 0;
                    string11 = "NO";
                }
                short s5 = 0;
                if (s2 == 0) {
                    s5 = s3;
                }
                if (string9 != null) {
                    if (!(string9.equals("") || !string8.equals("L") || string10.equals("char") || string10.equals("nchar") || string10.equals("nvarchar") || string10.equals("varchar") || string10.equals("lvarchar") || string10.equals("boolean"))) {
                        n = string9.indexOf(" ");
                        while (string9.charAt(n + 1) == ' ' && string9.length() != ++n + 1) {
                        }
                        string9 = string9.substring(n + 1);
                    }
                    ifxStatement2.executeUpdate("insert into " + string6 + " values( '" + string5 + "', '" + string7 + "', " + "'" + resultSet.getString(1) + "', '" + resultSet.getString(2) + "'," + n3 + ", '" + string10 + "', " + n2 + "," + "0," + n5 + "," + n4 + "," + n6 + "," + "null,  '" + string9.trim() + "'," + "0," + "0," + s5 + "," + resultSet.getShort(3) + ", '" + string11 + "' )");
                    continue;
                }
                ifxStatement2.executeUpdate("insert into " + string6 + " values( '" + string5 + "', '" + string7 + "', " + "'" + resultSet.getString(1) + "', '" + resultSet.getString(2) + "'," + n3 + ", '" + string10 + "', " + n2 + "," + "0," + n5 + "," + n4 + "," + n6 + "," + "null,  " + string9 + "," + "0," + "0," + s5 + "," + resultSet.getShort(3) + ", '" + string11 + "' )");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement2.close();
        string5 = "select * from " + string6 + " order by 2,3,17";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
        object = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string6);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return object;
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet resultSet;
        String string5;
        String string6 = this.nextTempTableName();
        String string7 = "NO";
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string5 = this.getMetaDbName(string);
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string6 + "( " + "  table_cat     varchar(129), " + "  table_schem   varchar(129), " + "  table_name    varchar(129), " + "  column_name   varchar(129), " + "  grantor       varchar(129), " + "  grantee       varchar(129), " + "  privilege     char(20), " + "  is_grantable  char(3) ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string6 + "( " + "  table_cat     char(50), " + "  table_schem   char(50), " + "  table_name    char(50), " + "  column_name   char(18), " + "  grantor       char(18), " + "  grantee       char(18), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            }
            if (string3 != null && !this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
            }
            if (string4 != null && !this.conn.isDelimIdentSet()) {
                string4 = string4.toLowerCase();
            }
            if (string2 != null && !this.conn.isDelimIdentSet()) {
                string2 = this.toSchemaCaseLikeServer(string2);
            }
            boolean bl = false;
            if (this.conn.isANSI() && this.conn.getAutoCommit()) {
                bl = true;
            }
            String string8 = null;
            string8 = this.conn.isOnLine() ? "select sc.colname, sa.grantor, sa.grantee, sa.colauth, st.tabname, st.owner from " + string5 + ":informix.systables st, " + string5 + ":informix.syscolumns sc, " + string5 + ":informix.syscolauth sa where " + "st.tabname = '" + string3 + "' and st.tabid = sa.tabid and " + "sc.tabid = st.tabid and sc.colname like '" + string4 + "' and sc.colno = sa.colno " + "and st.owner like '" + string2 + "'" + "union " + "select sc.colname, sa.grantor, sa.grantee, sa.tabauth, " + "st.tabname, st.owner from " + string5 + ":informix.systables st, " + string5 + ":informix.syscolumns sc, " + string5 + ":informix.systabauth sa where " + "st.tabname = '" + string3 + "' and st.tabid = sa.tabid and " + "sc.tabid = st.tabid and sc.colname like '" + string4 + "' and st.owner like '" + string2 + "'" + " order by 1" : "select sc.colname, sa.grantor, sa.grantee, sa.colauth, st.tabname, st.owner from informix.systables st, informix.syscolumns sc, informix.syscolauth sa where st.tabname = '" + string3 + "' and st.tabid = sa.tabid and " + "sc.tabid = st.tabid and sc.colname like '" + string4 + "' and sc.colno = sa.colno " + "and st.owner like '" + string2 + "'" + "union " + "select sc.colname, sa.grantor, sa.grantee, sa.tabauth, " + "st.tabname, st.owner from " + "informix.systables st, " + "informix.syscolumns sc, " + "informix.systabauth sa where " + "st.tabname = '" + string3 + "' and st.tabid = sa.tabid and " + "sc.tabid = st.tabid and sc.colname like '" + string4 + "' and st.owner like '" + string2 + "'" + " order by 1";
            resultSet = ifxStatement.executeQuery(string8, bl);
            String string9 = "";
            String string10 = "";
            while (resultSet.next()) {
                String string11 = string9;
                string9 = resultSet.getString(1);
                String string12 = resultSet.getString(4);
                if (string9 != null) {
                    string9 = string9.trim();
                }
                if (string12 != null) {
                    string12 = string12.trim();
                }
                if (!string9.equals(string11)) {
                    string10 = "";
                }
                for (int i = 0; i < string12.length(); ++i) {
                    String string13 = null;
                    char c = string12.charAt(i);
                    switch (c) {
                        case 'R': 
                        case 'r': {
                            if (string10.indexOf(c) != -1) break;
                            string10 = string10 + "r";
                            string13 = "REFERENCES";
                            break;
                        }
                        case 'S': 
                        case 's': {
                            if (string10.indexOf(c) != -1) break;
                            string10 = string10 + "s";
                            string13 = "SELECT";
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            if (string10.indexOf(c) != -1) break;
                            string10 = string10 + "u";
                            string13 = "UPDATE";
                        }
                    }
                    if (string13 == null) continue;
                    string7 = Character.isUpperCase(c) ? "YES" : "NO";
                    String string14 = resultSet.getString(2);
                    string14 = resultSet.wasNull() || string14 == null ? "null" : "'" + string14 + "'";
                    ifxStatement2.executeUpdate("insert into " + string6 + " values( '" + string5 + "', '" + resultSet.getString(6) + "', '" + resultSet.getString(5) + "', '" + resultSet.getString(1) + "', " + string14 + ", '" + resultSet.getString(3) + "', '" + string13 + "', '" + string7 + "' )");
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string5 = "select * from " + string6 + " order by 4, 7";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
        ResultSet resultSet2 = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        ifxStatement2.close();
        this.dropTempTable(string6);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        String string6 = "NO";
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string4 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "( " + "  table_cat     varchar(129), " + "  table_schem   varchar(129), " + "  table_name    varchar(129), " + "  grantor       varchar(129), " + "  grantee       varchar(129), " + "  privilege     char(20), " + "  is_grantable  char(3) ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat     char(18), " + "  table_schem   char(18), " + "  table_name    char(40), " + "  grantor       char(18), " + "  grantee       char(18), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            }
            object = null;
            object = this.conn.isOnLine() ? "select st.tabname, sa.grantor, sa.grantee, sa.tabauth, st.owner from " + string4 + ":informix.systables st, " + string4 + ":informix.systabauth sa " + "where st.tabname like '" + string3 + "' and " + "st.tabid = sa.tabid and st.owner like '" + string2 + "'" : "select st.tabname, sa.grantor, sa.grantee, sa.tabauth, st.owner from informix.systables st, informix.systabauth sa where st.tabname like '" + string3 + "' and " + "st.tabid = sa.tabid and st.owner like '" + string2 + "'";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                String string8 = resultSet.getString(3);
                String string9 = resultSet.getString(3);
                String string10 = resultSet.getString(4);
                for (int i = 0; i < string10.length(); ++i) {
                    String string11 = null;
                    char c = string10.charAt(i);
                    switch (c) {
                        case 'S': 
                        case 's': {
                            string11 = "SELECT";
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            string11 = "UPDATE";
                            break;
                        }
                        case 'I': 
                        case 'i': {
                            string11 = "INSERT";
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            string11 = "DELETE";
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            string11 = "INDEX";
                            break;
                        }
                        case 'A': 
                        case 'a': {
                            string11 = "ALTER";
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            string11 = "REFERENCES";
                            break;
                        }
                        case 'N': 
                        case 'n': {
                            string11 = "UNDER";
                        }
                    }
                    if (string11 == null) continue;
                    string6 = Character.isUpperCase(c) ? "YES" : "NO";
                    ifxStatement2.executeUpdate("insert into " + string5 + " values( '" + string4 + "', '" + resultSet.getString(5).trim() + "', '" + string7 + "', '" + string8.trim() + "', '" + string9.trim() + "', '" + string11 + "', '" + string6 + "' )");
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement2.close();
        string4 = "select * from " + string5 + " order by 3, 6, 4, 5, 7";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return object;
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        ResultSet resultSet;
        String string4;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String string6 = this.getMetaDbName(string);
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            String string7;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            if (!this.conn.isDelimIdentSet()) {
                string7 = string3.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
            } else {
                string7 = string3;
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "( " + "  scope          smallint, " + "  column_name    varchar(129), " + "  data_type      smallint, " + "  type_name      varchar(129), " + "  column_size    integer, " + "  buffer_length  integer, " + "  decimal_digits smallint, " + "  pseudo_column  smallint ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  scope          smallint, " + "  column_name    char(18), " + "  data_type      smallint, " + "  type_name      char(18), " + "  column_size    integer, " + "  buffer_length  integer, " + "  decimal_digits smallint, " + "  pseudo_column  smallint )");
            }
            string4 = "select sc.colname, sc.colno, sc.coltype, sc.collength from " + string6 + ":informix.systables st, " + string6 + ":informix.sysconstraints so, " + string6 + ":informix.sysindexes si, " + string6 + ":informix.syscolumns sc " + "where (st.tabname like '" + string3 + "' or " + "st.tabname like '" + string7 + "' ) and " + "st.tabid = so.tabid and " + "so.constrtype = 'P' and " + "so.idxname = si.idxname and " + "sc.tabid = st.tabid and " + "st.owner like '" + string2 + "' and " + "  (sc.colno = si.part1 or " + "   sc.colno = si.part2 or " + "   sc.colno = si.part3 or " + "   sc.colno = si.part4 or " + "   sc.colno = si.part5 or " + "   sc.colno = si.part6 or " + "   sc.colno = si.part7 or " + "   sc.colno = si.part8 ";
            if (this.conn.isOnLine()) {
                string4 = string4 + " or sc.colno = si.part9 or     sc.colno = si.part10 or     sc.colno = si.part11 or     sc.colno = si.part12 or     sc.colno = si.part13 or     sc.colno = si.part14 or     sc.colno = si.part15 or     sc.colno = si.part16 ";
            }
            string4 = string4 + ")";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                String string8 = resultSet.getString(1);
                short s = resultSet.getShort(3);
                short s2 = (short)(s & 0xFF);
                s2 = (short)(s & 0xFF);
                int n2 = IfxTypes.FromIfxToJDBCType(s2);
                if (s2 == 4 && !this.conn.getMapReal()) {
                    n2 = 6;
                }
                ifxStatement2.executeUpdate("insert into " + string5 + " values( " + 2 + ", '" + string8 + "', " + n2 + ", '" + IfxTypes.IfxTypeToName(s2) + "', " + resultSet.getShort(4) + ", " + "0, " + "0, " + 1 + ") ");
            }
            resultSet.close();
            ifxStatement2.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by scope";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        ResultSet resultSet2 = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        IfxStatement ifxStatement;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String string4 = this.getMetaDbName(string);
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = this.conn.isOnLine() ? "select '' as SCOPE, c.colname as COLUMN_NAME, c.coltype as DATA_TYPE, '' as TYPE_NAME, '' as COLUMN_SIZE, c.collength as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from " + string4 + ":informix.systables t, " + string4 + ":informix.syscolumns c " + "where t.tabid = c.tabid and t.owner like '" + string2 + "' " + "and t.tabname like '" + string3 + "' " + "and mod(c.coltype,256) = 6" : "select '' as SCOPE, c.colname as COLUMN_NAME, c.coltype as DATA_TYPE, '' as TYPE_NAME, '' as COLUMN_SIZE, c.collength as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from informix.systables t, informix.syscolumns c where t.tabid = c.tabid and t.owner like '" + string2 + "' " + "and t.tabname like '" + string3 + "' " + "and mod(c.coltype,256) = 6";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ResultSet resultSet2 = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        String string6 = null;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string6 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        } else {
            string6 = string3;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        IfxStatement ifxStatement3 = null;
        try {
            int n;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement3 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            ifxStatement3.setAutoFree(true);
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("  create " + this.getTmpTableTerm() + " table " + string5 + "( " + "  table_cat      varchar(129), " + "  table_schem    varchar(129), " + "  table_name     varchar(129), " + "  column_name    varchar(129), " + "  key_seq        smallint, " + "  pk_name        varchar(129)) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("  create temp table " + string5 + "( " + "  table_cat      char(18), " + "  table_schem    char(18), " + "  table_name     char(18), " + "  column_name    char(18), " + "  key_seq        smallint, " + "  pk_name        char(18) ) ");
            }
            string4 = this.getMetaDbName(string);
            object = "  select   sc.colname,  so.constrname,   st.tabname,   st.owner,   sc.colno,   ABS(si.part1),ABS(si.part2),ABS(si.part3),ABS(si.part4),  ABS(si.part5),ABS(si.part6),ABS(si.part7),ABS(si.part8) " + (this.conn.isOnLine() ? " ,ABS(si.part9),ABS(si.part10),ABS(si.part11),ABS(si.part12), ABS(si.part13),ABS(si.part14),ABS(si.part15),ABS(si.part16) " : " ") + " from " + string4 + ":informix.systables st," + string4 + ":informix.sysconstraints so," + string4 + ":informix.sysindexes si," + string4 + ":informix.syscolumns sc " + "  where " + "  ( st.tabname like '" + string3 + "' or " + "  st.tabname like '" + string6 + "' ) and" + "  st.tabid = so.tabid and" + "  so.constrtype = 'P' and" + "  so.idxname = si.idxname and" + "  sc.tabid = st.tabid and" + "  st.owner like '" + string2 + "' and" + "  (sc.colno = ABS(si.part1) or " + "   sc.colno = ABS(si.part2) or " + "   sc.colno = ABS(si.part3) or " + "   sc.colno = ABS(si.part4) or " + "   sc.colno = ABS(si.part5) or " + "   sc.colno = ABS(si.part6) or " + "   sc.colno = ABS(si.part7) or " + "   sc.colno = ABS(si.part8) ";
            if (this.conn.isOnLine()) {
                object = (String)object + " or sc.colno = ABS(si.part9) or     sc.colno = ABS(si.part10) or     sc.colno = ABS(si.part11) or     sc.colno = ABS(si.part12) or     sc.colno = ABS(si.part13) or     sc.colno = ABS(si.part14) or     sc.colno = ABS(si.part15) or     sc.colno = ABS(si.part16) ";
            }
            object = (String)object + ")";
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = n = this.conn.isOnLine() ? 16 : 8;
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                String string8 = resultSet.getString(2);
                String string9 = resultSet.getString(3);
                String string10 = resultSet.getString(4);
                if (string7 != null) {
                    string7 = string7.trim();
                }
                if (string8 != null) {
                    string8 = string8.trim();
                }
                if (string9 != null) {
                    string9 = string9.trim();
                }
                if (string10 != null) {
                    string10 = string10.trim();
                }
                int n3 = resultSet.getInt(5);
                short s = 0;
                for (int i = 0; i < n; ++i) {
                    if (n3 != resultSet.getInt(6 + i)) continue;
                    s = (short)(i + 1);
                    break;
                }
                ifxStatement2.executeUpdate(" insert into " + string5 + " values( '" + string4 + "', '" + string10 + "', '" + string9 + "', '" + string7 + "', " + s + ", '" + string8 + "' )");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        ifxStatement2.close();
        string4 = " select table_cat as TABLE_CAT,  table_schem as TABLE_SCHEM,  table_name as TABLE_NAME,  column_name as COLUMN_NAME,  key_seq  as KEY_SEQ,  pk_name as PK_NAME  from " + string5 + " order by column_name";
        ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement3.executeQuery(string4, true) : ifxStatement3.executeQuery(string4, false);
        object = this.populateClientResultSet(resultSet);
        ifxStatement3.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        string5 = null;
        return object;
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        short s = 0;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            int n;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string4 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint) " + this.getNoLogTerm() + ";");
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            object = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno,   ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) " + (this.conn.isOnLine() ? ",ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16) " : " ") + " from " + string4 + ":informix.systables pt, " + string4 + ":informix.syscolumns pc, " + string4 + ":informix.sysindexes pi, " + string4 + ":informix.sysconstraints pk, " + string4 + ":informix.systables ft, " + string4 + ":informix.syscolumns fc, " + string4 + ":informix.sysindexes fi, " + string4 + ":informix.sysconstraints fk, " + string4 + ":informix.sysreferences r where pt.tabid=pc.tabid " + "and pc.tabid=pi.tabid and pt.tabid=pk.tabid " + "and pk.constrid=r.primary and r.constrid=fk.constrid " + "and pi.idxname=pk.idxname and fi.idxname=fk.idxname " + "and ft.tabid=fc.tabid and fc.tabid=fi.tabid " + "and ft.tabid=fk.tabid " + "and pt.owner like '" + string2 + "' and " + "(pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or " + "pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or " + "pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or " + "pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or " + "pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or " + "pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or " + "pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or " + "pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8)";
            if (this.conn.isOnLine()) {
                object = (String)object + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16))";
            }
            object = (String)object + "and ft.owner like '" + string2 + "' " + "and ft.tabname like '" + string3 + "' ;";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
            int n2 = n = this.conn.isOnLine() ? 16 : 8;
            while (resultSet.next()) {
                String string6 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                String string8 = resultSet.getString(3);
                String string9 = resultSet.getString(4);
                String string10 = resultSet.getString(5);
                String string11 = resultSet.getString(6);
                String string12 = resultSet.getString(7);
                String string13 = resultSet.getString(8);
                String string14 = resultSet.getString(9);
                int n3 = resultSet.getInt(10);
                s = 0;
                for (int i = 0; i < n; ++i) {
                    if (n3 != resultSet.getInt(11 + i)) continue;
                    s = (short)(i + 1);
                    break;
                }
                int n4 = string13.equals("C") ? 0 : 1;
                ifxStatement2.executeUpdate("insert into " + string5 + " values('" + string4 + "', '" + string14 + "', '" + string6 + "', '" + string7 + "', '" + string4 + "', '" + string8 + "', '" + string9 + "', '" + string10 + "', " + s + ", " + "1, " + n4 + ", '" + string11 + "', '" + string12 + "', " + "7)");
            }
            ifxStatement2.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by 1,2,3,9";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return object;
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        short s = 0;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            int n;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string4 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint) " + this.getNoLogTerm() + ";");
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            object = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno, ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) " + (this.conn.isOnLine() ? ",ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16) " : " ") + " from " + string4 + ":informix.systables pt, " + string4 + ":informix.syscolumns pc, " + string4 + ":informix.sysindexes pi, " + string4 + ":informix.sysconstraints pk, " + string4 + ":informix.systables ft, " + string4 + ":informix.syscolumns fc, " + string4 + ":informix.sysindexes fi, " + string4 + ":informix.sysconstraints fk, " + string4 + ":informix.sysreferences r where pt.tabid=pc.tabid " + "and pc.tabid=pi.tabid and pt.tabid=pk.tabid " + "and pk.constrid=r.primary and r.constrid=fk.constrid " + "and pi.idxname=pk.idxname and fi.idxname=fk.idxname " + "and ft.tabid=fc.tabid and fc.tabid=fi.tabid " + "and ft.tabid=fk.tabid and " + "(pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or " + "pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or " + "pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or " + "pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or " + "pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or " + "pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or " + "pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or " + "pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8) ";
            if (this.conn.isOnLine()) {
                object = (String)object + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
            }
            object = (String)object + "and pt.owner like '" + string2 + "' " + "and pt.tabname like '" + string3 + "' ;";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
            int n2 = n = this.conn.isOnLine() ? 16 : 8;
            while (resultSet.next()) {
                String string6 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                String string8 = resultSet.getString(3);
                String string9 = resultSet.getString(4);
                String string10 = resultSet.getString(5);
                String string11 = resultSet.getString(6);
                String string12 = resultSet.getString(7);
                String string13 = resultSet.getString(8);
                String string14 = resultSet.getString(9);
                int n3 = resultSet.getInt(10);
                s = 0;
                for (int i = 0; i < n; ++i) {
                    if (n3 != resultSet.getInt(11 + i)) continue;
                    s = (short)(i + 1);
                    break;
                }
                int n4 = string13.equals("C") ? 0 : 1;
                ifxStatement2.executeUpdate("insert into " + string5 + " values('" + string4 + "', '" + string14 + "', '" + string6 + "', '" + string7 + "', '" + string4 + "', '" + string8 + "', '" + string9 + "', '" + string10 + "', " + s + ", " + "1, " + n4 + ", '" + string11 + "', '" + string12 + "', " + "7)");
            }
            ifxStatement2.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by 5,6,7,9";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return object;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        ResultSet resultSet;
        String string7;
        String string8 = this.nextTempTableName();
        short s = 0;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string5 == null || string5.length() == 0) {
            string5 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw IfxErrMsg.getSQLException(-79708, this.conn);
        }
        if (string6 == null || string6.length() == 0) {
            string6 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            int n;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string7 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string6 = string6.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
                string5 = this.toSchemaCaseLikeServer(string5);
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string8 + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint) " + this.getNoLogTerm() + ";");
            } else {
                ifxStatement.executeUpdate("create temp table " + string8 + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            String string9 = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno,  ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) " + (this.conn.isOnLine() ? ",ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16) " : " ") + " from " + string7 + ":informix.systables pt, " + string7 + ":informix.syscolumns pc, " + string7 + ":informix.sysindexes pi, " + string7 + ":informix.sysconstraints pk, " + string7 + ":informix.systables ft, " + string7 + ":informix.syscolumns fc, " + string7 + ":informix.sysindexes fi, " + string7 + ":informix.sysconstraints fk, " + string7 + ":informix.sysreferences r " + "where pt.tabid=pc.tabid and " + "pc.tabid=pi.tabid and pt.tabid=pk.tabid " + "and pk.constrid=r.primary and r.constrid=fk.constrid " + "and pi.idxname=pk.idxname and fi.idxname=fk.idxname " + "and ft.tabid=fc.tabid and fc.tabid=fi.tabid " + "and ft.tabid=fk.tabid " + "and " + "((pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1)) or " + " (pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2)) or " + " (pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3)) or " + " (pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4)) or " + " (pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5)) or " + " (pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6)) or " + " (pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7)) or " + " (pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8))  ";
            if (this.conn.isOnLine()) {
                string9 = string9 + " or (pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9))  or (pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10))  or (pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11))  or (pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12))  or (pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13))  or (pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14))  or (pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15))  or (pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
            }
            string9 = string9 + ") and pt.owner like '" + string2 + "' " + "and ft.owner like '" + string5 + "' " + "and pt.tabname like '" + string3 + "' " + "and ft.tabname like '" + string6 + "' ;";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string9, true) : ifxStatement.executeQuery(string9, false);
            int n2 = n = this.conn.isOnLine() ? 16 : 8;
            while (resultSet.next()) {
                String string10 = resultSet.getString(1);
                String string11 = resultSet.getString(2);
                String string12 = resultSet.getString(3);
                String string13 = resultSet.getString(4);
                String string14 = resultSet.getString(5);
                String string15 = resultSet.getString(6);
                String string16 = resultSet.getString(7);
                String string17 = resultSet.getString(8);
                String string18 = resultSet.getString(9);
                int n3 = resultSet.getInt(10);
                s = 0;
                for (int i = 0; i < n; ++i) {
                    if (n3 != resultSet.getInt(11 + i)) continue;
                    s = (short)(i + 1);
                    break;
                }
                int n4 = string17.equals("C") ? 0 : 1;
                ifxStatement2.executeUpdate("insert into " + string8 + " values('" + string7 + "', '" + string18.trim() + "', '" + string10 + "', '" + string11 + "', '" + string7 + "', '" + string12.trim() + "', '" + string13 + "', '" + string14 + "', " + s + ", 1, " + n4 + ", '" + string15 + "', '" + string16 + "', " + "7)");
            }
            ifxStatement2.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string7 = "select * from " + string8 + " order by 5,6,7,9";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string7, true) : ifxStatement.executeQuery(string7, false);
        ResultSet resultSet2 = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string8);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        int n;
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(lmd.length, this.conn);
        for (int i = 0; i < lmd.length; ++i) {
            n = i + 1;
            ifxResultSetMetaData.setTableName(n, "SQL_TYPES");
            ifxResultSetMetaData.setColumnName(n, IfxDatabaseMetaData.lmd[i].colname);
            ifxResultSetMetaData.setIfxColumnType(n, IfxDatabaseMetaData.lmd[i].coltype & 0xFF);
            ifxResultSetMetaData.setEncodedLength(n, IfxDatabaseMetaData.lmd[i].collen);
            ifxResultSetMetaData.setNullable(n, IfxDatabaseMetaData.lmd[i].nullable ? 1 : 0);
            ifxResultSetMetaData.setColumnStartPosition(n, IfxDatabaseMetaData.lmd[i].stpos);
        }
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, ifxResultSetMetaData);
        n = this.conn.isUSVER() ? nXtdRowTypesSupported : nStdRowTypes;
        ifxClientResultSet.newRow(n);
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            ifxClientResultSet.updateString(n2, 1, this.lrow[i].tname);
            ifxClientResultSet.updateShort(n2, 2, (short)this.lrow[i].jsqltype);
            ifxClientResultSet.updateInt(n2, 3, this.lrow[i].precision);
            ifxClientResultSet.updateString(n2, 4, this.lrow[i].lprefix);
            ifxClientResultSet.updateString(n2, 5, this.lrow[i].lsuffix);
            ifxClientResultSet.updateString(n2, 6, this.lrow[i].cparams);
            ifxClientResultSet.updateShort(n2, 7, (short)this.lrow[i].nullable);
            ifxClientResultSet.updateBoolean(n2, 8, this.lrow[i].casesen);
            ifxClientResultSet.updateShort(n2, 9, (short)this.lrow[i].searchable);
            ifxClientResultSet.updateBoolean(n2, 10, this.lrow[i].unsign);
            ifxClientResultSet.updateBoolean(n2, 11, this.lrow[i].money);
            ifxClientResultSet.updateBoolean(n2, 12, this.lrow[i].autoincrement);
            ifxClientResultSet.updateString(n2, 13, this.lrow[i].ltname);
            ifxClientResultSet.updateShort(n2, 14, (short)this.lrow[i].minscale);
            ifxClientResultSet.updateShort(n2, 15, (short)this.lrow[i].maxscale);
            ifxClientResultSet.updateInt(n2, 16, this.lrow[i].sqldatatype);
            ifxClientResultSet.updateInt(n2, 17, this.lrow[i].sqldatetime);
            ifxClientResultSet.updateInt(n2, 18, this.lrow[i].numradix);
        }
        ifxClientResultSet.beforeFirst();
        ifxClientResultSet.setFetchDirection(1000);
        ifxClientResultSet.setConcurrency(1007);
        ifxClientResultSet.setType(1003);
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            int n;
            String string6;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string4 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string6 = string3.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
            } else {
                string6 = string3;
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "( " + "  table_cat        varchar(129), " + "  table_schem      varchar(129), " + "  table_name       varchar(129), " + "  non_unique       smallint, " + "  index_qualifier  varchar(129), " + "  index_name       varchar(129), " + "  type             smallint, " + "  ordinal_position smallint, " + "  column_name      varchar(129), " + "  asc_or_desc      char(1), " + "  cardinality      integer, " + "  pages            integer, " + "  filter_condition  varchar(129) ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat        char(18), " + "  table_schem      char(18), " + "  table_name       char(18), " + "  non_unique       smallint, " + "  index_qualifier  char(18), " + "  index_name       char(18), " + "  type             smallint, " + "  ordinal_position smallint, " + "  column_name      char(18), " + "  asc_or_desc      char(1), " + "  cardinality      integer, " + "  pages            integer, " + "  filter_condition  char(18) )");
            }
            object = "select sc.colname, si.idxname, si.clustered, si.idxtype, st.tabname, st.owner, sc.colno, ABS(si.part1),ABS(si.part2),ABS(si.part3),ABS(si.part4),ABS(si.part5),ABS(si.part6),ABS(si.part7),ABS(si.part8)" + (this.conn.isOnLine() ? ",ABS(si.part9),ABS(si.part10),ABS(si.part11),ABS(si.part12),ABS(si.part13),ABS(si.part14),ABS(si.part15),ABS(si.part16) " : " ") + "from " + string4 + ":informix.systables st, " + string4 + ":informix.sysindexes si, " + string4 + ":informix.syscolumns sc where (st.tabname like '" + string3 + "' or st.tabname like '" + string6 + "') and " + "st.tabid = si.tabid and " + "sc.tabid = st.tabid and " + "st.owner like '" + string2 + "' and " + "  (sc.colno = ABS(si.part1) or " + "   sc.colno = ABS(si.part2) or " + "   sc.colno = ABS(si.part3) or " + "   sc.colno = ABS(si.part4) or " + "   sc.colno = ABS(si.part5) or " + "   sc.colno = ABS(si.part6) or " + "   sc.colno = ABS(si.part7) or " + "   sc.colno = ABS(si.part8) ";
            if (this.conn.isOnLine()) {
                object = (String)object + " or sc.colno = ABS(si.part9) or     sc.colno = ABS(si.part10) or     sc.colno = ABS(si.part11) or     sc.colno = ABS(si.part12) or     sc.colno = ABS(si.part13) or     sc.colno = ABS(si.part14) or     sc.colno = ABS(si.part15) or     sc.colno = ABS(si.part16) ";
            }
            object = (String)object + ") order by si.idxname";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = n = this.conn.isOnLine() ? 16 : 8;
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                String string8 = resultSet.getString(2);
                String string9 = resultSet.getString(3);
                String string10 = resultSet.getString(4);
                String string11 = resultSet.getString(5);
                String string12 = resultSet.getString(6);
                int n3 = resultSet.getInt(7);
                short s = 0;
                for (int i = 0; i < n; ++i) {
                    if (n3 != resultSet.getInt(8 + i)) continue;
                    s = (short)(i + 1);
                    break;
                }
                ifxStatement2.executeUpdate("insert into " + string5 + " values( '" + string4 + "', '" + string12.trim() + "', '" + string11 + "', " + (string10.equals("D") ? "1" : "0") + ", " + "null, '" + string8 + "', " + 3 + ", " + s + ", '" + string7 + "', null, " + "0, 0, null )");
            }
            ifxStatement2.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by non_unique, index_name, ordinal_position";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = this.populateClientResultSet(resultSet);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return object;
    }

    void close() throws SQLException {
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1004 || n == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n2 == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        Object object;
        AutoCloseable autoCloseable;
        Object object2;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isUSVER() && !this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String string4 = this.getMetaDbName(string);
        if (string2 == null || string2.equals("")) {
            string2 = "%";
        }
        if (string3 == null || string3.equals("")) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string5 = "";
        if (nArray != null) {
            int n = 0;
            block13: for (int i = 0; i < nArray.length; ++i) {
                switch (nArray[i]) {
                    case 2000: {
                        if (bl) continue block13;
                        bl = true;
                        if (++n == 1) {
                            string5 = string5 + "'B'";
                            continue block13;
                        }
                        string5 = string5 + ",'B'";
                        continue block13;
                    }
                    case 2002: {
                        if (bl2) continue block13;
                        bl2 = true;
                        if (++n == 1) {
                            string5 = string5 + "'R'";
                            continue block13;
                        }
                        string5 = string5 + ",'R'";
                        continue block13;
                    }
                    case 2001: {
                        if (bl3) continue block13;
                        bl3 = true;
                        string5 = ++n == 1 ? string5 + "'D'" : string5 + ",'D'";
                    }
                }
            }
        }
        IfxStatement ifxStatement = null;
        String string6 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            object2 = (IfxStatement)this.conn.createStatement();
            autoCloseable = (IfxStatement)this.conn.createStatement();
            object = "create procedure mode_decode (mode char(1)) returns varchar(26);   if mode = 'B' then      return 'java.sql.Types.JAVA_OBJECT';   elif mode = 'R' then      return 'java.sql.Types.STRUCT';   elif mode = 'D' then      return 'java.sql.Types.DISTINCT';   else      return 'unknown mode';   end if; end procedure; ";
            autoCloseable.executeUpdate((String)object);
            string6 = this.nextTempTableName();
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string6 + " ( " + "TYPE_CAT varchar(129), " + "TYPE_SCHEM varchar(129), " + "TYPE_NAME varchar(129), " + "CLASS_NAME varchar(129), " + "DATA_TYPE varchar(129), " + "REMARKS varchar(129) " + " ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string6 + " ( " + "TYPE_CAT char(18), " + "TYPE_SCHEM char(18), " + "TYPE_NAME char(18), " + "CLASS_NAME char(25), " + "DATA_TYPE char(30), " + "REMARKS char(255) " + " ) ");
            }
            String string7 = "select owner, name, mode, type, source from " + string4 + ":informix.sysxtdtypes " + "where owner != 'informix' " + "and owner like '" + string2 + "' " + "and name like '" + string3 + "' ";
            if (!string5.equals("")) {
                string7 = string7 + "and mode in (" + string5 + ") ";
            }
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string7, true) : ifxStatement.executeQuery(string7, false);
            while (resultSet.next()) {
                String string8 = resultSet.getString("owner");
                String string9 = resultSet.getString("name");
                String string10 = resultSet.getString("mode");
                int n = resultSet.getInt("type");
                int n2 = resultSet.getInt("source");
                String string11 = null;
                if (!(string10 = string10.trim()).equals("D")) {
                    string11 = "java.sql.SQLData";
                } else if (n2 == 0) {
                    string11 = IfxTypes.FromIfxTypeToJava(n & 0xFF);
                } else {
                    boolean bl4 = false;
                    block15: while (!bl4) {
                        switch (n2) {
                            case 1: {
                                string11 = "java.lang.String";
                                bl4 = true;
                                continue block15;
                            }
                            case 5: {
                                string11 = "java.lang.Boolean";
                                bl4 = true;
                                continue block15;
                            }
                            case 11: {
                                string11 = "java.sql.Clob";
                                bl4 = true;
                                continue block15;
                            }
                            case 10: {
                                string11 = "java.sql.Blob";
                                bl4 = true;
                                continue block15;
                            }
                        }
                        ResultSet resultSet2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ((IfxStatement)object2).executeQuery("select type, source from " + string4 + ":informix.sysxtdtypes " + "where extended_id = " + n2, true) : ((IfxStatement)object2).executeQuery("select type, source from " + string4 + ":informix.sysxtdtypes " + "where extended_id = " + n2, false);
                        if (!resultSet2.next()) {
                            bl4 = true;
                            string11 = "unknown";
                            continue;
                        }
                        int n3 = resultSet2.getInt("type");
                        n2 = resultSet2.getInt("source");
                        if (n2 != 0) continue;
                        string11 = n3 == 40 || n3 == 41 ? "java.sql.SQLData" : IfxTypes.FromIfxTypeToJava(n & 0xFF);
                        bl4 = true;
                    }
                }
                String string12 = "insert into " + string6 + " values ( " + "'" + string4 + "', " + "'" + string8 + "', " + "'" + string9 + "', " + "'" + string11 + "', " + "mode_decode(" + "'" + string10 + "'), " + "'' )";
                ((IfxStatement)object2).executeUpdate(string12);
            }
            resultSet.close();
            ((IfxStatement)object2).close();
            object = "drop procedure mode_decode";
            autoCloseable.executeUpdate((String)object);
            autoCloseable.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        object2 = "select TYPE_CAT, TYPE_SCHEM, TYPE_NAME, CLASS_NAME, DATA_TYPE, REMARKS from " + string6 + " " + "order by DATA_TYPE, TYPE_SCHEM, TYPE_NAME";
        autoCloseable = null;
        autoCloseable = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object2, true) : ifxStatement.executeQuery((String)object2, false);
        object = this.populateClientResultSet((ResultSet)autoCloseable);
        this.dropTempTable(string6);
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return object;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    private void dropTempTable(String string) {
        try {
            Statement statement = this.conn.createStatement();
            statement.executeUpdate("drop table " + string);
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ResultSet populateClientResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, resultSetMetaData);
        int n = resultSetMetaData.getColumnCount();
        Object object = null;
        ifxClientResultSet.moveToInsertRow();
        while (resultSet.next()) {
            for (int i = 1; i <= n; ++i) {
                object = resultSet.getObject(i);
                if (resultSet.wasNull()) {
                    ifxClientResultSet.updateNull(i);
                    continue;
                }
                ifxClientResultSet.updateObject(i, object);
            }
            ifxClientResultSet.insertRow();
        }
        ifxClientResultSet.beforeFirst();
        ifxClientResultSet.setType(1003);
        ifxClientResultSet.setFetchDirection(1000);
        ifxClientResultSet.setConcurrency(1007);
        return ifxClientResultSet;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        if (this.conn != null) {
            return ((IfxSqliConnect)this.conn).isNamedParametersSupported();
        }
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (this.conn != null) {
            return ((IfxSqliConnect)this.conn).isAutoGeneratedKeysSupported();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        if (this.conn == null || !this.conn.isDbOpen()) {
            return null;
        }
        if (!this.conn.isUSVER()) {
            return null;
        }
        SQLException sQLException = null;
        ResultSet resultSet = null;
        String string4 = this.getMetaDbName(string);
        if (string2 == null || string2.equals("")) {
            string2 = "%";
        }
        if (string3 == null || string3.equals("")) {
            string3 = "%";
        } else {
            int n = string3.indexOf(58);
            int n2 = string3.indexOf(46);
            if (n != -1) {
                string4 = string3.substring(0, n);
                if (n2 > n) {
                    string2 = string3.substring(n + 1, n2);
                    string3 = string3.substring(n2 + 1);
                }
            } else if (n2 != -1) {
                string2 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        try {
            ((IfxSqliConnect)this.conn).startMetaDataQuery();
            IfxStatement ifxStatement = null;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = "select '" + string4 + "' as  TYPE_CAT," + "s1.owner  as TYPE_SCHEM," + "s1.name  as TYPE_NAME," + "'" + string4 + "' as SUPERTYPE_CAT ," + "s2.owner as SUPERTYPE_SCHEM ," + "s2.name as  SUPERTYPE_NAME " + "from " + string4 + ":informix.sysxtdtypes s1, " + string4 + ":informix.sysxtdtypes s2 , " + string4 + ":informix.sysinherits s3 " + "where s1.name like '" + string3 + "'" + "and s1.owner like '" + string2 + "'" + " and s1.extended_id =  s3.child and " + "s1.name != s2.name and " + "s2.extended_id = s3.parent " + "order by  TYPE_NAME , TYPE_SCHEM";
            ResultSet resultSet2 = null;
            resultSet2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
            resultSet = this.populateClientResultSet(resultSet2);
            ifxStatement.close();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
        if (sQLException != null) {
            throw sQLException;
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        if (this.conn == null || !this.conn.isDbOpen()) {
            return null;
        }
        if (!this.conn.isUSVER()) {
            return null;
        }
        SQLException sQLException = null;
        ResultSet resultSet = null;
        String string4 = this.getMetaDbName(string);
        if (string2 == null || string2.equals("")) {
            string2 = "%";
        }
        if (string3 == null || string3.equals("")) {
            string3 = "%";
        } else {
            int n = string3.indexOf(58);
            int n2 = string3.indexOf(46);
            if (n != -1) {
                string4 = string3.substring(0, n);
                if (n2 > n) {
                    string2 = string3.substring(n + 1, n2);
                    string3 = string3.substring(n2 + 1);
                }
            } else if (n2 != -1) {
                string2 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        try {
            ((IfxSqliConnect)this.conn).startMetaDataQuery();
            IfxStatement ifxStatement = null;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = "select '" + string4 + "' " + "as  TABLE_CAT," + "s1.owner  as TABLE_SCHEM," + "s1.tabname  as TABLE_NAME," + "s2.tabname as  SUPERTABLE_NAME " + "from " + string4 + ":informix.systables s1, " + string4 + ":informix.systables s2 , " + string4 + ":informix.sysinherits s3 " + "where s1.tabname like '" + string3 + "'" + "and s1.owner like '" + string2 + "'" + " and s1.tabid =  s3.child and " + "s1.tabname != s2.tabname and " + "s2.tabid = s3.parent " + "order by  TABLE_NAME , TABLE_SCHEM";
            ResultSet resultSet2 = null;
            resultSet2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
            resultSet = this.populateClientResultSet(resultSet2);
            ifxStatement.close();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
        if (sQLException != null) {
            throw sQLException;
        }
        return resultSet;
    }

    private int getNumberParentColumns(int n, String string) throws SQLException {
        int n2 = 0;
        boolean bl = false;
        String string2 = "select parent from " + string + ":informix.sysinherits where class = 't' and child = " + n;
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        } else {
            bl = true;
        }
        resultSet.close();
        statement.close();
        if (!bl) {
            string2 = "select mode, source from " + string + ":informix.sysxtdtypes where extended_id=?";
            PreparedStatement preparedStatement = this.conn.prepareStatement(string2);
            while (!bl) {
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    if (!resultSet.getString(1).equals("D")) {
                        bl = true;
                    } else {
                        n = resultSet.getInt(2);
                    }
                }
                resultSet.close();
            }
            preparedStatement.close();
            string2 = "select count(*) from " + string + ":informix.sysattrtypes where extended_id=" + n;
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
        }
        return n2;
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        Object object;
        Object object2;
        if (this.conn == null || !this.conn.isDbOpen()) {
            return null;
        }
        if (!this.conn.isUSVER()) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxDatabaseMetaData.getAttributes()", this.conn);
        }
        String string5 = this.nextTempTableName();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string4 = string4.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        string3 = string3.trim();
        string4 = string4.trim();
        String string6 = this.getMetaDbName(string);
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "( " + "  type_cat           varchar(129), " + "  type_schem         varchar(129), " + "  type_name          varchar(129), " + "  attr_name          varchar(129), " + "  data_type          smallint, " + "  attr_type_name     varchar(129), " + "  attr_size          integer, " + "  decimal_digits     integer, " + "  num_prec_radix     integer, " + "  nullable           integer, " + "  remarks            char(18), " + "  attr_def           varchar(255), " + "  sql_data_type      integer, " + "  sql_datetime_sub   integer, " + "  char_octet_length  integer, " + "  ordinal_position   integer, " + "  is_nullable        char(3), " + "  scope_catalog      varchar(129), " + "  scope_schema       varchar(129), " + "  scope_table        varchar(129), " + "  source_data_type   smallint) " + this.getNoLogTerm());
            object2 = "select extended_id, tabname from " + string6 + ":informix.sysxtdtypes sx, OUTER " + string6 + ":informix.systables st" + " where extended_id > 2047" + " and extended_id = type_xid " + " and ( mode = 'B' or mode = 'D' or mode = 'T' or mode = 'R' )" + " and name like '" + string3 + "'" + " and sx.owner like '" + string2 + "'";
            object = null;
            object = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object2, true) : ifxStatement.executeQuery((String)object2, false);
            while (object.next()) {
                int n = object.getInt(1);
                int n2 = this.getNumberParentColumns(n, string6);
                IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo(n);
                String string7 = object.getString(2);
                IfxResultSetMetaData ifxResultSetMetaData = ifxUDTInfo.getMetaData();
                if (ifxResultSetMetaData == null) continue;
                int n3 = ifxResultSetMetaData.getColumnCount();
                Vector vector = ifxResultSetMetaData.getColumnInfoVector();
                IfxColumnInfo ifxColumnInfo = null;
                for (int i = 1; i <= n3; ++i) {
                    ifxColumnInfo = (IfxColumnInfo)vector.elementAt(i - 1);
                    Vector vector2 = ifxColumnInfo.child;
                    if (n2 == 0) {
                        ++n2;
                    }
                    IfxColumnInfo ifxColumnInfo2 = null;
                    for (int j = n2 - 1; j < vector2.size(); ++j) {
                        String string8;
                        int n4;
                        ifxColumnInfo2 = (IfxColumnInfo)vector2.elementAt(j);
                        int n5 = ifxColumnInfo2.SQLtype;
                        short s = (short)(n5 & 0xFF);
                        int n6 = ifxColumnInfo2.ColLength;
                        int n7 = s == 5 || s == 8 ? ifxColumnInfo2.ColLength / 256 : ifxColumnInfo2.ColLength;
                        String string9 = IfxTypes.IfxTypeToName(s);
                        int n8 = 0;
                        int n9 = 0;
                        if (s == 1 || s == 2 || s == 6) {
                            n9 = 2;
                            n8 = 10;
                        } else if (s == 17 || s == 18 || s == 52 || s == 53) {
                            n8 = 10;
                        } else if (s == 5 || s == 8) {
                            n9 = n6 - n6 / 256 * 256;
                            n8 = 10;
                        } else if (s == 3) {
                            n9 = 15;
                            n8 = 10;
                        } else if (s == 4) {
                            n9 = 7;
                            n8 = 10;
                        } else if (s == 41 && (string9.equals("boolean") || (n5 & 0x4000) == 16384)) {
                            n8 = 2;
                        }
                        if (ifxColumnInfo2.Nullable == 0) {
                            n4 = 0;
                            string8 = "NO";
                        } else if (ifxColumnInfo2.Nullable == 1) {
                            n4 = 1;
                            string8 = "YES";
                        } else {
                            n4 = 2;
                            string8 = "";
                        }
                        int n10 = 0;
                        if (s == 0) {
                            n10 = n6;
                        }
                        String string10 = "insert into " + string5 + " values( '" + string6 + "', " + "'" + ifxUDTInfo.owner + "', " + "'" + ifxUDTInfo.name + "', " + "'" + ifxColumnInfo2.ColName + "'," + ifxColumnInfo2.SQLtype + ", " + "'" + string9 + "', " + n7 + "," + n9 + "," + n8 + "," + n4 + "," + "null," + "null," + "0," + "0," + n10 + ", " + ifxColumnInfo2.Fieldno + ", " + "'" + string8 + "', " + "null," + "null," + "null,";
                        string10 = ifxColumnInfo2.IsDistinct ? string10.concat(ifxColumnInfo2.SourceType + ")") : string10.concat("null)");
                        ifxStatement2.executeUpdate(string10);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        object2 = null;
        object = "select * from " + string5 + " where attr_name like '" + string4 + "'" + " order by TYPE_SCHEM, TYPE_NAME, ORDINAL_POSITION";
        object2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
        ResultSet resultSet = this.populateClientResultSet((ResultSet)object2);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        boolean bl = false;
        if (n == 1 || n == 2) {
            bl = true;
        }
        return bl;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        String string = this.getDatabaseProductVersion();
        return IfxDriver.extractMajorVersion(string);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        String string = this.getDatabaseProductVersion();
        return IfxDriver.extractMinorVersion(string);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return IfxDriver.getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return IfxDriver.getJDBCMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    private String checkSynonym(String string, String string2) throws SQLException {
        String string3 = string;
        ResultSet resultSet = null;
        String string4 = "T";
        int n = 0;
        IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
        String string5 = null;
        string5 = this.conn.isOnLine() ? "select tabid, tabtype from " + string2 + ":informix.systables where (tabname = '" + string3 + "' and owner like '%')" : "select tabid, tabtype from informix.systables where (tabname = '" + string3 + "' and owner like '%')";
        resultSet = ifxStatement.executeQuery(string5);
        if (resultSet.next()) {
            n = resultSet.getInt(1);
            string4 = resultSet.getString(2);
        }
        if (string4.equalsIgnoreCase("S") || string4.equalsIgnoreCase("P")) {
            int n2 = 0;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            string5 = "select btabid, servername, dbname, owner, tabname from " + string2 + ":informix.syssyntable where tabid = " + n;
            resultSet = ifxStatement.executeQuery(string5);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
                string6 = resultSet.getString(2);
                string7 = resultSet.getString(3);
                string8 = resultSet.getString(4);
                string9 = resultSet.getString(5);
            }
            if (n2 != 0) {
                string5 = "select tabname from " + string2 + ":informix.systables where tabid = " + n2;
                resultSet = ifxStatement.executeQuery(string5);
                if (resultSet.next()) {
                    string3 = resultSet.getString(1);
                }
            } else {
                string3 = string7 + "@" + string6 + ":" + string8 + "." + string9;
            }
        }
        resultSet.close();
        ifxStatement.close();
        return string3;
    }

    private String getMetaDbName(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            return this.conn.getDbName();
        }
        return string;
    }

    private int getJDBCColumnSize(short s, short s2, int n) {
        if (this.lrow == null) {
            return n;
        }
        switch (s) {
            case 5: 
            case 8: {
                return n >>> 8;
            }
            case 11: 
            case 12: {
                return rowinfo.getPrecisionForIfxType(this.lrow, s, s2);
            }
            case 41: {
                if (s2 == 10 || s2 == 11) {
                    return rowinfo.getPrecisionForIfxType(this.lrow, s, s2);
                }
                return n;
            }
        }
        return n;
    }

    private String toSchemaCaseLikeServer(String string) {
        if (this.conn.isANSI() && !string.toUpperCase().equals("INFORMIX")) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "generatedKeyAlwaysReturned", (IfxConnection)null);
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getPseudoColumns", (IfxConnection)null);
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getFunctionColumns", (IfxConnection)null);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getFunctions", (IfxConnection)null);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getClientInfoProperties", (IfxConnection)null);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "autoCommitFailureClosesAllResultSets", (IfxConnection)null);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "supportsStoredFunctionsUsingCallSyntax", (IfxConnection)null);
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getSchemas", (IfxConnection)null);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getRowIdLifetime", (IfxConnection)null);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "isWrapperFor", (IfxConnection)null);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "unwrap", (IfxConnection)null);
    }

    static {
        int n;
        nextTempTableId = 1;
        nMdInfoRows = 18;
        nStdRowTypes = 19;
        nXtdRowTypes = 31;
        nXtdRowTypesSupported = 27;
        lmd = null;
        lrowgeneric = null;
        lrowLvc32k = null;
        if (lmd == null) {
            n = 0;
            lmd = new mdinfo[nMdInfoRows];
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("TYPE_NAME", 0, 128, true, 0);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("DATA_TYPE", 1, 2, true, 128);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("PRECISION", 2, 4, true, 130);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LITERAL_PREFIX", 0, 128, true, 134);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LITERAL_SUFFIX", 0, 128, true, 262);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("CREATE_PARAMS", 0, 128, true, 390);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("NULLABLE", 1, 2, true, 518);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("CASE_SENSITIVE", 1, 2, true, 520);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SEARCHABLE", 2, 4, true, 522);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("UNSIGNED_ATTRIBUTE", 1, 2, true, 526);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("FIXED_PREC_SCALE", 1, 2, true, 528);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("AUTO_INCREMENT", 1, 2, true, 530);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LOCAL_TYPE_NAME", 0, 128, true, 532);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("MINIMUM_SCALE", 1, 2, true, 660);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("MAXIMUM_SCALE", 1, 2, true, 662);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SQL_DATA_TYPE", 2, 4, true, 664);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SQL_DATETIME_SUB", 2, 4, true, 668);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("NUM_PREC_RADIX", 2, 4, true, 672);
        }
        if (lrowgeneric == null) {
            n = 0;
            lrowgeneric = new rowinfo[nXtdRowTypes];
            lrowLvc32k = new rowinfo[nXtdRowTypes];
            int n2 = n;
            int n3 = n++;
            rowinfo rowinfo2 = new rowinfo("byte", -4, 11, 0, Integer.MAX_VALUE, "", "", 1, false, 0, false, false, 0, Short.MAX_VALUE, 0);
            IfxDatabaseMetaData.lrowgeneric[n3] = rowinfo2;
            IfxDatabaseMetaData.lrowLvc32k[n2] = rowinfo2;
            int n4 = n;
            int n5 = n++;
            rowinfo rowinfo3 = new rowinfo("char", 1, 0, 0, Short.MAX_VALUE, "'", "'", 1, true, 3, false, false, 0, Short.MAX_VALUE, 0);
            IfxDatabaseMetaData.lrowgeneric[n5] = rowinfo3;
            IfxDatabaseMetaData.lrowLvc32k[n4] = rowinfo3;
            int n6 = n;
            int n7 = n++;
            rowinfo rowinfo4 = new rowinfo("character varying", 12, 13, 0, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n7] = rowinfo4;
            IfxDatabaseMetaData.lrowLvc32k[n6] = rowinfo4;
            int n8 = n;
            int n9 = n++;
            rowinfo rowinfo5 = new rowinfo("date", 91, 7, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n9] = rowinfo5;
            IfxDatabaseMetaData.lrowLvc32k[n8] = rowinfo5;
            int n10 = n;
            int n11 = n++;
            rowinfo rowinfo6 = new rowinfo("datetime year to fraction(5)", 93, 10, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n11] = rowinfo6;
            IfxDatabaseMetaData.lrowLvc32k[n10] = rowinfo6;
            int n12 = n;
            int n13 = n++;
            rowinfo rowinfo7 = new rowinfo("decimal", 3, 5, 0, 32, "'", "'", 1, false, 2, true, false, 1, 32, 10);
            IfxDatabaseMetaData.lrowgeneric[n13] = rowinfo7;
            IfxDatabaseMetaData.lrowLvc32k[n12] = rowinfo7;
            int n14 = n;
            int n15 = n++;
            rowinfo rowinfo8 = new rowinfo("double precision", 3, 3, 0, 17, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n15] = rowinfo8;
            IfxDatabaseMetaData.lrowLvc32k[n14] = rowinfo8;
            int n16 = n;
            int n17 = n++;
            rowinfo rowinfo9 = new rowinfo("float", 6, 3, 0, 17, "'", "'", 1, false, 2, false, false, 1, 8, 10);
            IfxDatabaseMetaData.lrowgeneric[n17] = rowinfo9;
            IfxDatabaseMetaData.lrowLvc32k[n16] = rowinfo9;
            int n18 = n;
            int n19 = n++;
            rowinfo rowinfo10 = new rowinfo("integer", 4, 2, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n19] = rowinfo10;
            IfxDatabaseMetaData.lrowLvc32k[n18] = rowinfo10;
            int n20 = n;
            int n21 = n++;
            rowinfo rowinfo11 = new rowinfo("interval", 1111, 14, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n21] = rowinfo11;
            IfxDatabaseMetaData.lrowLvc32k[n20] = rowinfo11;
            int n22 = n;
            int n23 = n++;
            rowinfo rowinfo12 = new rowinfo("nchar", 1, 15, 0, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n23] = rowinfo12;
            IfxDatabaseMetaData.lrowLvc32k[n22] = rowinfo12;
            int n24 = n;
            int n25 = n++;
            rowinfo rowinfo13 = new rowinfo("nvarchar", 12, 16, 0, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n25] = rowinfo13;
            IfxDatabaseMetaData.lrowLvc32k[n24] = rowinfo13;
            int n26 = n;
            int n27 = n++;
            rowinfo rowinfo14 = new rowinfo("money", 3, 8, 0, 32, "'", "'", 1, false, 2, true, false, 16, 32, 10);
            IfxDatabaseMetaData.lrowgeneric[n27] = rowinfo14;
            IfxDatabaseMetaData.lrowLvc32k[n26] = rowinfo14;
            int n28 = n;
            int n29 = n++;
            rowinfo rowinfo15 = new rowinfo("numeric", 2, 5, 0, 32, "'", "'", 1, false, 2, true, false, 1, 32, 10);
            IfxDatabaseMetaData.lrowgeneric[n29] = rowinfo15;
            IfxDatabaseMetaData.lrowLvc32k[n28] = rowinfo15;
            int n30 = n;
            int n31 = n++;
            rowinfo rowinfo16 = new rowinfo("serial", 4, 6, 0, 0, "'", "'", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n31] = rowinfo16;
            IfxDatabaseMetaData.lrowLvc32k[n30] = rowinfo16;
            int n32 = n;
            int n33 = n++;
            rowinfo rowinfo17 = new rowinfo("smallint", 5, 1, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n33] = rowinfo17;
            IfxDatabaseMetaData.lrowLvc32k[n32] = rowinfo17;
            int n34 = n;
            int n35 = n++;
            rowinfo rowinfo18 = new rowinfo("smallfloat", 7, 4, 0, 6, "'", "'", 1, false, 2, false, false, 1, 6, 10);
            IfxDatabaseMetaData.lrowgeneric[n35] = rowinfo18;
            IfxDatabaseMetaData.lrowLvc32k[n34] = rowinfo18;
            int n36 = n;
            int n37 = n++;
            rowinfo rowinfo19 = new rowinfo("text", -1, 12, 0, Integer.MAX_VALUE, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n37] = rowinfo19;
            IfxDatabaseMetaData.lrowLvc32k[n36] = rowinfo19;
            int n38 = n;
            int n39 = n++;
            rowinfo rowinfo20 = new rowinfo("varchar", 12, 13, 0, 255, "'", "'", 1, true, 3, false, false, 0, 255, 0);
            IfxDatabaseMetaData.lrowgeneric[n39] = rowinfo20;
            IfxDatabaseMetaData.lrowLvc32k[n38] = rowinfo20;
            if (IfxDriver.compareJDKVersion("1.4") < 0) {
                int n40 = n;
                int n41 = n++;
                rowinfo rowinfo21 = new rowinfo("boolean", 1111, 45, 5, 0, "'", "'", 1, false, 2, false, false, 0, 0, 2);
                IfxDatabaseMetaData.lrowgeneric[n41] = rowinfo21;
                IfxDatabaseMetaData.lrowLvc32k[n40] = rowinfo21;
            } else {
                int n42 = n;
                int n43 = n++;
                rowinfo rowinfo22 = new rowinfo("boolean", 16, 45, 5, 0, "'", "'", 1, false, 2, false, false, 0, 0, 2);
                IfxDatabaseMetaData.lrowgeneric[n43] = rowinfo22;
                IfxDatabaseMetaData.lrowLvc32k[n42] = rowinfo22;
            }
            int n44 = n;
            int n45 = n++;
            rowinfo rowinfo23 = new rowinfo("int8", -5, 17, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n45] = rowinfo23;
            IfxDatabaseMetaData.lrowLvc32k[n44] = rowinfo23;
            int n46 = n;
            int n47 = n++;
            rowinfo rowinfo24 = new rowinfo("serial8", -5, 18, 0, 0, "'", "'", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n47] = rowinfo24;
            IfxDatabaseMetaData.lrowLvc32k[n46] = rowinfo24;
            int n48 = n;
            int n49 = n++;
            rowinfo rowinfo25 = new rowinfo("bigint", -5, 52, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n49] = rowinfo25;
            IfxDatabaseMetaData.lrowLvc32k[n48] = rowinfo25;
            int n50 = n;
            int n51 = n++;
            rowinfo rowinfo26 = new rowinfo("bigserial", -5, 53, 0, 0, "'", "'", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n51] = rowinfo26;
            IfxDatabaseMetaData.lrowLvc32k[n50] = rowinfo26;
            int n52 = n;
            int n53 = n++;
            rowinfo rowinfo27 = new rowinfo("clob", 2005, 41, 11, Integer.MAX_VALUE, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n53] = rowinfo27;
            IfxDatabaseMetaData.lrowLvc32k[n52] = rowinfo27;
            int n54 = n;
            int n55 = n++;
            rowinfo rowinfo28 = new rowinfo("blob", 2004, 41, 10, Integer.MAX_VALUE, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n55] = rowinfo28;
            IfxDatabaseMetaData.lrowLvc32k[n54] = rowinfo28;
            IfxDatabaseMetaData.lrowLvc32k[n] = new rowinfo("lvarchar", -1, 43, 1, 32739, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n++] = new rowinfo("lvarchar", -1, 43, 1, 2048, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            int n56 = n;
            int n57 = n++;
            rowinfo rowinfo29 = new rowinfo("list", 1111, 21, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n57] = rowinfo29;
            IfxDatabaseMetaData.lrowLvc32k[n56] = rowinfo29;
            int n58 = n;
            int n59 = n++;
            rowinfo rowinfo30 = new rowinfo("multiset", 1111, 20, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n59] = rowinfo30;
            IfxDatabaseMetaData.lrowLvc32k[n58] = rowinfo30;
            int n60 = n;
            int n61 = n++;
            rowinfo rowinfo31 = new rowinfo("set", 1111, 19, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n61] = rowinfo31;
            IfxDatabaseMetaData.lrowLvc32k[n60] = rowinfo31;
            int n62 = n;
            int n63 = n++;
            rowinfo rowinfo32 = new rowinfo("unnamed row", 1111, 22, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n63] = rowinfo32;
            IfxDatabaseMetaData.lrowLvc32k[n62] = rowinfo32;
        }
    }
}

