/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class IfxDateTime
extends IfxObject {
    private long value = 0L;
    private int nanos = 0;
    private boolean isTime = false;
    private short qualifier = 0;
    protected Calendar dbCalendar = null;
    private byte[] rawData = null;
    private short storedQualifier = 0;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;

    IfxDateTime() throws SQLException {
        this.setIfxType(10);
    }

    IfxDateTime(Time time) throws SQLException {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
        if (time != null) {
            this.value = time.getTime();
            this.isTime = true;
            this.unnullify();
        }
    }

    IfxDateTime(Timestamp timestamp) throws SQLException {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
        if (timestamp != null) {
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() {
        if (this.isTime) {
            return JavaToIfxType.JavaToIfxDateTime(new Time(this.value));
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return JavaToIfxType.JavaToIfxDateTime(timestamp, this.dbCalendar);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] byArray = this.toIfx();
        return Decimal.fromBindToTuple(byArray, IfxDecimal.decLength(this.encodedLength));
    }

    @Override
    public void fromIfx(byte[] byArray, short s) {
        this.fromIfx(byArray, 0, byArray.length, s);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2, short s) {
        this.rawData = new byte[n2];
        System.arraycopy(byArray, n, this.rawData, 0, n2);
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            this.nullify();
        } else {
            this.storedQualifier = s;
            this.qualifier = s;
            Timestamp timestamp = IfxToJavaType.IfxToJavaDateTime(byArray, n, n2, s, this.dbCalendar);
            this.value = timestamp.getTime();
            if (IfxDateTime.getStartCode(this.qualifier) >= 6 && IfxDateTime.getEndCode(this.qualifier) <= 10) {
                this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
                this.nanos = 0;
                this.isTime = true;
            } else {
                this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
                this.nanos = timestamp.getNanos();
                this.isTime = false;
            }
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        if (this.isTime) {
            return Time.valueOf(new Time(this.value).toString());
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    @Override
    public java.sql.Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return new java.sql.Date(this.value);
    }

    @Override
    public void fromDate(java.sql.Date date) throws SQLException {
        if (date == null) {
            this.nullify();
        } else {
            this.value = date.getTime();
            this.nanos = 0;
            this.isTime = false;
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.nullify();
        } else {
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
            this.unnullify();
        }
    }

    public void fromRawDateTime(byte[] byArray, short s) throws SQLException {
        if (byArray == null) {
            this.nullify();
        } else {
            int n = byArray.length;
            this.rawData = new byte[n];
            System.arraycopy(byArray, 0, this.rawData, 0, n);
            if (byArray[0] == 0 && byArray[1] == 0) {
                this.nullify();
            } else {
                this.isTime = false;
                this.storedQualifier = s;
                this.unnullify();
            }
        }
    }

    Timestamp toTimestampFromRawData(Calendar calendar) throws SQLException {
        if (this.rawData == null || this.rawData.length == 0 || this.storedQualifier == 0) {
            return null;
        }
        Decimal decimal = new Decimal(this.rawData, 0, this.rawData.length, this.storedQualifier, true);
        Timestamp timestamp = decimal.timestampValue(calendar);
        this.value = timestamp.getTime();
        this.nanos = timestamp.getNanos();
        return timestamp;
    }

    public void fromTimestamp(Timestamp timestamp, short s) throws SQLException {
        if (timestamp == null) {
            this.nullify();
        } else {
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.qualifier = s;
            this.unnullify();
        }
    }

    @Override
    public Time toTime() throws SQLException {
        int n;
        if (this.isNull()) {
            return null;
        }
        Time time = new Time(this.value);
        String string = time.toString();
        if (string == null) {
            return null;
        }
        Time time2 = null;
        int n2 = string.indexOf(58);
        if (n2 > 0 & (n = string.indexOf(58, n2 + 1)) > 0 & n < string.length() - 1) {
            int n3 = Integer.parseInt(string.substring(0, n2));
            int n4 = Integer.parseInt(string.substring(n2 + 1, n));
            int n5 = Integer.parseInt(string.substring(n + 1));
            time2 = new Time(n3, n4, n5);
            time = null;
        }
        return time2;
    }

    @Override
    public void fromTime(Time time) throws SQLException {
        if (time == null) {
            this.nullify();
        } else {
            this.value = time.getTime();
            this.isTime = true;
            this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        String string = null;
        if (this.isNull()) {
            return null;
        }
        try {
            if (this.isTime) {
                Time time = new Time(this.value);
                string = dateUtil.convertDateTimeStr(time, this.conn, this.value);
            } else if (this.value + (long)(this.nanos / 1000000) != 0L || this.rawData == null || this.rawData.length < 1) {
                Timestamp timestamp = this.toTimestamp();
                string = dateUtil.convertDateTimeStr(timestamp, this.conn, this.value);
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.rawData.length * 3 + 2);
                for (int i = 0; i < this.rawData.length; ++i) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.rawData[i]);
                }
                string = new String(stringBuffer);
            }
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    @Override
    public String toUnloadString() {
        if (this.isNull()) {
            return null;
        }
        return IfxToJavaType.IfxToDateTimeUnloadString(this.rawData, 0, this.rawData.length, this.storedQualifier);
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            String string2 = string.trim();
            boolean bl = false;
            try {
                Timestamp timestamp = (Timestamp)dateUtil.convertDateTimeObj(string2, this.conn, bl);
                this.value = timestamp.getTime();
                this.nanos = timestamp.getNanos();
                this.isTime = false;
                this.unnullify();
            }
            catch (SQLException sQLException) {
                try {
                    bl = true;
                    Object object = dateUtil.convertDateTimeObj(string2, this.conn, bl);
                    this.value = ((Date)object).getTime();
                    Time time = new Time(this.value);
                    this.nanos = 0;
                    this.isTime = true;
                    this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
                    this.unnullify();
                }
                catch (Exception exception) {
                    this.nullify();
                    this.value = 0L;
                    this.nanos = 0;
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
            }
            catch (Exception exception) {
                this.nullify();
                this.value = 0L;
                this.nanos = 0;
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxDateTime) {
            IfxDateTime ifxDateTime = (IfxDateTime)object;
            if (ifxDateTime.isNull()) {
                return false;
            }
            if (ifxDateTime.value == this.value && ifxDateTime.nanos == this.nanos) {
                return true;
            }
        }
        return false;
    }

    static short getQualifier(byte by, byte by2) {
        short s = (short)(by2 - by + (by == 0 ? 4 : 2));
        short s2 = (short)((byte)s << 8 | by << 4 | by2);
        return s2;
    }

    static byte getLength(short s) {
        byte by = (byte)(s >> 8);
        return by;
    }

    public static byte getStartCode(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        return by;
    }

    public static byte getEndCode(short s) {
        byte by = (byte)(s & 0xF);
        return by;
    }

    @Override
    public short getEncodedLength() {
        if (this.qualifier == 0) {
            byte by = 0;
            byte by2 = 15;
            this.qualifier = IfxDateTime.getQualifier(by, by2);
        }
        return this.qualifier;
    }

    static String getQualifierName(short s, int n) {
        if (s == 0) {
            return null;
        }
        byte by = IfxDateTime.getStartCode(s);
        byte by2 = IfxDateTime.getEndCode(s);
        byte by3 = IfxDateTime.getLength(s);
        String string = IfxDateTime.getFieldName(by, true);
        if (n == 14 && by <= 10) {
            int n2 = by3 - by2 + by;
            string = string + "(" + n2 + ")";
        }
        string = string + " to ";
        string = string + IfxDateTime.getFieldName(by2, false);
        return string;
    }

    static String getFieldName(byte by, boolean bl) {
        if (bl && by >= 11) {
            return "fraction";
        }
        switch (by) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public boolean isTimeValue() {
        return this.isTime;
    }
}

