/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxDistinctInput;
import com.informix.jdbc.IfxDistinctOutput;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxUDT;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class IfxDistinct
extends IfxObject {
    IfxObject data = null;
    private static final short NO_SCALE = -1;
    private IfxDistinctInput inputStream = null;
    private IfxDistinctOutput outputStream = null;

    IfxDistinct() throws SQLException {
    }

    @Override
    public void fromObject(Object object) throws SQLException {
        this.fromObject(object, -1);
    }

    @Override
    public void fromObject(Object object, int n) throws SQLException {
        this.checkObject();
        if (object == null || this.data == null) {
            this.nullify();
        } else {
            if (this.typeMap != null) {
                this.data.setTypeMap(this.typeMap);
            }
            if (this.outputStream == null) {
                this.outputStream = new IfxDistinctOutput(this.data, this.conn);
            } else {
                this.outputStream.reset();
            }
            if (!(object instanceof SQLData)) {
                if (n == -1) {
                    this.data.fromObject(object);
                } else {
                    this.data.fromObject(object, n);
                }
            } else {
                ((SQLData)object).writeSQL(this.outputStream);
                String string = ((SQLData)object).getSQLTypeName();
                if (string != null) {
                    this.setExtendedTypeName(string);
                }
            }
            this.unnullify();
        }
    }

    @Override
    public Object toObject() throws SQLException {
        return this.toObject(false);
    }

    @Override
    public Object toObject(boolean bl) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.data instanceof IfxObject) {
            Class clazz;
            if (this.typeMap == null || (clazz = (Class)this.typeMap.get(this.extendedName)) == null) {
                if (bl && (this.data instanceof IfxUDT || this.data instanceof IfxDistinct)) {
                    return this.data.toObject(bl);
                }
                return this.data.toObject();
            }
            SQLData sQLData = null;
            try {
                sQLData = (SQLData)clazz.newInstance();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
            this.data.setTypeMap(this.typeMap);
            this.inputStream = new IfxDistinctInput(this.data, this.conn);
            sQLData.readSQL(this.inputStream, this.extendedName);
            return sQLData;
        }
        throw IfxErrMsg.getSQLException(-79716, this.conn);
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        this.checkObject();
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 22 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        this.data.fromIfx(byArray, n, n2);
        this.checkNull();
    }

    @Override
    public void fromIfx(byte[] byArray, short s) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length, s);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2, short s) throws SQLException {
        this.checkObject();
        this.data = IfxValue.makeInstanceFromIfxType(this.conn, this.ifxType);
        this.data.fromIfx(byArray, n, n2, s);
        this.checkNull();
    }

    @Override
    public byte[] toIfx() throws SQLException {
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        return this.data.toIfx();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        return this.data.toIfxTuple();
    }

    private void checkNull() {
        if (this.data == null || this.data.isNull()) {
            this.writeTrace(99, "IfxDistinct: data is null");
            this.nullify();
        } else {
            this.writeTrace(99, "IfxDistinct: data is not null");
            this.unnullify();
        }
    }

    private void checkObject() throws SQLException {
        if (this.data == null) {
            IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
            ifxColumnInfo.SQLtype = this.ifxType;
            ifxColumnInfo.ExtendedOwner = this.extendedOwner;
            ifxColumnInfo.ExtendedId = this.sourceType;
            ifxColumnInfo.ExtendedName = this.ifxType == 40 || this.ifxType == 41 || this.ifxType == 44 || this.ifxType == 19 || this.ifxType == 20 || this.ifxType == 21 || this.ifxType == 22 ? this.conn.getXnameByXid(ifxColumnInfo.ExtendedId) : this.extendedName;
            this.data = IfxValue.makeInstance(this.conn, ifxColumnInfo);
            if (this.data == null) {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
            this.setIfxType(this.data.getIfxType());
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toInt();
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.checkObject();
        this.data.fromInt(n);
        this.checkNull();
    }

    @Override
    public short toShort() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toShort();
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.checkObject();
        this.data.fromShort(s);
        this.checkNull();
    }

    @Override
    public String toString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    @Override
    public void fromString(String string) throws SQLException {
        this.checkObject();
        this.data.fromString(string);
        this.checkNull();
    }

    @Override
    public long toLong() throws SQLException {
        if (this.data == null) {
            return 0L;
        }
        return this.data.toLong();
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.checkObject();
        this.data.fromLong(l);
        this.checkNull();
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        this.checkObject();
        this.data.fromLong(l);
        this.checkNull();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toDecimal();
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        this.checkObject();
        this.data.fromDecimal(bigDecimal);
        this.checkNull();
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        this.checkObject();
        this.data.fromDecimal(bigDecimal, n);
        this.checkNull();
    }

    @Override
    public byte toByte() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toByte();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        this.checkObject();
        this.data.fromByte(by);
        this.checkNull();
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.checkObject();
        this.data.fromByte(by);
        this.checkNull();
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.toFloat();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        this.checkObject();
        this.data.fromFloat(f);
        this.checkNull();
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.checkObject();
        this.data.fromFloat(f);
        this.checkNull();
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.data == null) {
            return 0.0;
        }
        return this.data.toDouble();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        this.checkObject();
        this.data.fromDouble(d);
        this.checkNull();
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.checkObject();
        this.data.fromDouble(d);
        this.checkNull();
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.data == null) {
            return false;
        }
        return this.data.toBoolean();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        this.checkObject();
        this.data.fromBoolean(bl);
        this.checkNull();
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.checkObject();
        this.data.fromBoolean(bl);
        this.checkNull();
    }

    @Override
    public Time toTime() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toTime();
    }

    @Override
    public void fromTime(Time time) throws SQLException {
        this.checkObject();
        this.data.fromTime(time);
        this.checkNull();
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toTimestamp();
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        this.checkObject();
        this.data.fromTimestamp(timestamp);
        this.checkNull();
    }

    @Override
    public Date toDate() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toDate();
    }

    @Override
    public void fromDate(Date date) throws SQLException {
        this.checkObject();
        this.data.fromDate(date);
        this.checkNull();
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toInputStream();
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.checkObject();
        this.data.fromInputStream(inputStream, n);
        this.checkNull();
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toAsciiStream();
    }

    @Override
    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.checkObject();
        this.data.fromAsciiStream(inputStream, n);
        this.checkNull();
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toBinaryStream();
    }

    @Override
    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.checkObject();
        this.data.fromBinaryStream(inputStream, n);
        this.checkNull();
    }

    @Override
    public IntervalYM toIntervalYM() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toIntervalYM();
    }

    @Override
    public void fromIntervalYM(IntervalYM intervalYM) throws SQLException {
        this.checkObject();
        this.data.fromIntervalYM(intervalYM);
        this.checkNull();
    }

    @Override
    public IntervalDF toIntervalDF() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toIntervalDF();
    }

    @Override
    public void fromIntervalDF(IntervalDF intervalDF) throws SQLException {
        this.checkObject();
        this.data.fromIntervalDF(intervalDF);
        this.checkNull();
    }

    @Override
    public Clob toClob() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toClob();
    }

    @Override
    public void fromClob(Clob clob) throws SQLException {
        this.checkObject();
        this.data.fromClob(clob);
        this.checkNull();
    }

    @Override
    public Blob toBlob() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toBlob();
    }

    @Override
    public void fromBlob(Blob blob) throws SQLException {
        this.checkObject();
        this.data.fromBlob(blob);
        this.checkNull();
    }
}

