/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.dateUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class IfxDriver
implements Driver {
    private static Trace trace = null;
    private String errMsg;
    private int errNum;
    private final String INFORMIXSQLI = "informix-sqli";
    private final String INFORMIXDIRECT = "informix-direct";
    private final String CONNECTIONCLASS = "CONNECTIONCLASS";
    private final String PROTOCOLCLASS = "PROTOCOLCLASS";
    private final String PROXY = "PROXY";
    private final String DEFAULTDIRECTCONN = "com.informix.jdbc.IfxDirectConnection";
    private final String DEFAULTDIRECTPROT = "com.informix.jdbc.IfxDirectProtocol";
    private final String DEFAULTSQLICONN = "com.informix.jdbc.IfxSqliConnect";
    private final String DEFAULTSQLIPROT = "com.informix.jdbc.IfxSqli";
    private String DbName = null;
    private String SubProtocol = null;
    private String OrigUrl = null;
    private String NewUrl = null;
    private String Proxy = null;
    private String ClientLocale = null;
    private static String staticClientLocale = null;
    private static final String JDBCRelVer = "3.10.J";
    protected static String jdkVersion;

    private static void setJDKVersion() {
        try {
            jdkVersion = System.getProperty("java.version");
        }
        catch (Exception exception) {
            System.out.println(IfxErrMsg.getMessage(-79880, (String)null));
        }
    }

    protected static int compareJDKVersion(String string) {
        Object var1_1 = null;
        boolean bl = false;
        String string2 = null;
        if (jdkVersion != null && string != null) {
            int n = jdkVersion.length();
            int n2 = 0;
            while (!bl && n2 < n) {
                char c = jdkVersion.charAt(n2);
                if (c >= '0' && c <= '9') {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            string2 = jdkVersion.substring(n2);
            return string2.compareTo(string);
        }
        throw new Error("Error In Comparing JDK Versions");
    }

    @Override
    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        this.checkClientLocale(string, properties);
        if (this.checkURL(string)) {
            Object object;
            String string2;
            Properties properties2 = new Properties();
            Connection connection = null;
            if (properties == null) {
                properties2.clear();
            } else {
                string2 = null;
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    string2 = object.nextElement().toString();
                    properties2.put(string2.toUpperCase(), properties.getProperty(string2));
                }
                string2 = null;
            }
            this.getPropertiesFromUrl(string, properties2);
            string2 = properties2.getProperty("CONNECTIONCLASS");
            try {
                object = Class.forName(properties2.getProperty("CONNECTIONCLASS"));
                if (string2.equals("com.informix.jdbc.IfxSqliConnect")) {
                    Class[] classArray = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), string.getClass(), properties2.getClass()};
                    Object[] objectArray = new Object[]{properties2.getProperty("USER"), properties2.getProperty("PASSWORD"), this.NewUrl, properties2};
                    Constructor constructor = ((Class)object).getConstructor(classArray);
                    connection = (Connection)constructor.newInstance(objectArray);
                } else {
                    Class[] classArray = new Class[]{string.getClass(), properties2.getClass()};
                    Object[] objectArray = new Object[]{this.NewUrl, properties2};
                    Constructor constructor = ((Class)object).getConstructor(classArray);
                    connection = (Connection)constructor.newInstance(objectArray);
                }
            }
            catch (Exception exception) {
                Throwable throwable;
                int n;
                if (exception instanceof InvocationTargetException && ((n = ((SQLException)(throwable = ((InvocationTargetException)exception).getTargetException())).getErrorCode()) == -952 || n == -23197)) {
                    throw (SQLException)throwable;
                }
                throwable = IfxErrMsg.getLocSQLException(-79704, exception.toString(), this.ClientLocale);
                throw IfxErrMsg.setSQLExceptionCause((SQLException)throwable, exception);
            }
            return connection;
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        if (string == null || string.length() < 13 || !string.substring(0, 13).equalsIgnoreCase("jdbc:informix")) {
            return false;
        }
        return this.checkURL(string);
    }

    @Override
    public synchronized DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String[] stringArray = new String[]{"DATABASE", "INFORMIXSERVER", "USER", "PASSWORD"};
        Properties properties2 = new Properties();
        if (!this.checkURL(string)) {
            throw IfxErrMsg.getLocSQLException(-79705, this.errMsg, this.ClientLocale);
        }
        this.getPropertiesFromUrl(string, properties2);
        String string2 = null;
        Properties properties3 = new Properties();
        DriverPropertyInfo[] driverPropertyInfoArray = properties.propertyNames();
        while (driverPropertyInfoArray.hasMoreElements()) {
            string2 = driverPropertyInfoArray.nextElement().toString();
            properties3.put(string2.toUpperCase(), properties.get(string2));
        }
        string2 = null;
        driverPropertyInfoArray = new DriverPropertyInfo[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (properties3.get(stringArray[i]) != null || properties2.get(stringArray[i]) != null) continue;
            driverPropertyInfoArray[n++] = new DriverPropertyInfo(stringArray[i].toLowerCase(), null);
        }
        DriverPropertyInfo[] driverPropertyInfoArray2 = new DriverPropertyInfo[n];
        while (n-- > 0) {
            driverPropertyInfoArray2[n] = driverPropertyInfoArray[n];
        }
        return driverPropertyInfoArray2;
    }

    @Override
    public int getMajorVersion() {
        try {
            return IfxDriver.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return IfxDriver.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public static int getMajorMinorVersion() {
        try {
            int n = IfxDriver.getJDBCMajorVersion() * 100;
            int n2 = IfxDriver.getJDBCMinorVersion();
            return n + n2;
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private synchronized boolean checkURL(String string) throws SQLException {
        boolean bl = true;
        this.DbName = null;
        this.SubProtocol = null;
        this.OrigUrl = null;
        this.NewUrl = null;
        boolean bl2 = false;
        if (string.indexOf(58) == -1) {
            this.errNum = -80004;
            this.errMsg = IfxErrMsg.getMinorMsg(-80035, this.ClientLocale) + " '" + string + "'" + IfxErrMsg.getMinorMsg(-80004, this.ClientLocale) + " ':'";
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=", true);
        String string2 = stringTokenizer.nextToken();
        boolean bl3 = false;
        boolean bl4 = true;
        if (string2.charAt(string2.length() - 1) == ':') {
            bl3 = true;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":", true);
        String string3 = stringTokenizer2.nextToken();
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("=")) {
            bl4 = false;
        }
        if (!string3.equalsIgnoreCase("jdbc")) {
            this.errNum = -79756;
            this.errMsg = IfxErrMsg.getMinorMsg(-80035, this.ClientLocale) + " '" + string + "' " + IfxErrMsg.getMessage(-79756, this.ClientLocale);
            return false;
        }
        String string4 = stringTokenizer2.nextToken();
        String string5 = stringTokenizer2.nextToken();
        if (stringTokenizer2.hasMoreTokens()) {
            string4 = stringTokenizer2.nextToken();
        }
        if (string5 != null && string5.charAt(0) == '/' && string5.charAt(1) == '/') {
            string5 = string5.substring(2, string5.length());
        }
        if (string5.equals("informix-sqli")) {
            this.SubProtocol = new String("informix-sqli");
            if (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
            }
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
            }
        } else if (string5.equals("informix-direct")) {
            this.SubProtocol = new String("informix-direct");
            bl = false;
            if (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
                if (!string5.equals(":") && stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken();
                }
            } else {
                string5 = null;
            }
        } else {
            this.errNum = -79757;
            this.errMsg = IfxErrMsg.getMessage(-79757, this.ClientLocale) + ": '" + string5 + "'";
            return false;
        }
        if (string5 != null && string5.charAt(0) == '/' && string5.charAt(1) == '/') {
            string5 = string5.substring(2, string5.length());
            if (bl) {
                bl2 = true;
            }
        }
        if (!bl) {
            if (string5 != null && string5.length() > 0 && string5.charAt(0) == '/') {
                String string6 = string5;
                StringTokenizer stringTokenizer3 = new StringTokenizer(string6, "/");
                String string7 = stringTokenizer3.nextToken();
                if (!this.validDatabaseIdentifier(string7)) {
                    this.errNum = -79760;
                    this.errMsg = IfxErrMsg.getMessage(-79760, this.ClientLocale) + ": '" + string7 + "'";
                    return false;
                }
                this.DbName = new String(string7);
                this.NewUrl = null;
            }
        } else {
            int n;
            int n2 = stringTokenizer2.countTokens();
            int n3 = n = bl3 ? 3 : 4;
            if (bl2 && n2 <= n) {
                bl2 = false;
            }
            if (bl2) {
                string5 = string5 + ":";
                while (n2 > n) {
                    string5 = string5 + stringTokenizer2.nextToken();
                    --n2;
                }
                string4 = stringTokenizer2.nextToken();
            }
            StringTokenizer stringTokenizer4 = new StringTokenizer(string5, ".");
            String string8 = stringTokenizer4.nextToken();
            if (bl4 || stringTokenizer2.hasMoreTokens()) {
                if (string8.indexOf("/") == -1) {
                    if (!bl2 && this.isANum(string8)) {
                        if (stringTokenizer4.countTokens() != 3 || !this.isAIPNum(string8)) {
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + string5 + "'", this.ClientLocale);
                        }
                        while (stringTokenizer4.hasMoreTokens()) {
                            string8 = stringTokenizer4.nextToken();
                            if (this.isAIPNum(string8)) continue;
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + string5 + "'", this.ClientLocale);
                        }
                    } else {
                        while (!bl2 && stringTokenizer4.hasMoreTokens()) {
                            string8 = stringTokenizer4.nextToken();
                            if (!this.isANum(string8)) continue;
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + string5 + "'", this.ClientLocale);
                        }
                    }
                    if (!stringTokenizer2.hasMoreTokens()) {
                        throw IfxErrMsg.getLocSQLException(-79705, this.ClientLocale);
                    }
                    String string9 = stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens()) {
                        string4 = stringTokenizer2.nextToken();
                    }
                    if (string9 != null && string9.indexOf(47) == -1) {
                        if (!this.isANum(string9)) {
                            throw IfxErrMsg.getLocSQLException(-79759, ": '" + string9 + "'", this.ClientLocale);
                        }
                        this.NewUrl = new String(string5 + ":" + string9);
                    } else if (string9 != null) {
                        StringTokenizer stringTokenizer5 = new StringTokenizer(string9, "/");
                        if (!this.isANum(string9 = stringTokenizer5.nextToken())) {
                            throw IfxErrMsg.getLocSQLException(-79759, ": '" + string9 + "'", this.ClientLocale);
                        }
                        this.NewUrl = new String(string5 + ":" + string9);
                        String string10 = stringTokenizer5.nextToken(":").substring(1);
                        if (string10 == null || string10.length() == 0) {
                            this.errNum = -79760;
                            this.errMsg = IfxErrMsg.getMessage(-79760, this.ClientLocale) + ": '" + string10 + "'";
                            return false;
                        }
                        if (!this.validDatabaseIdentifier(string10)) {
                            throw IfxErrMsg.getLocSQLException(-79760, ": '" + string10 + "'", this.ClientLocale);
                        }
                        this.DbName = new String(string10);
                    }
                } else {
                    this.DbName = string8.substring(1, string8.length());
                    this.NewUrl = null;
                }
            } else {
                this.NewUrl = null;
            }
        }
        this.OrigUrl = new String(string);
        return true;
    }

    private boolean isAIPNum(String string) {
        try {
            int n = Integer.parseInt(string);
            return n >= 0 && n <= 255;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isANum(String string) {
        try {
            Integer n = new Integer(string);
            return n >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void getPropertiesFromUrl(String string, Properties properties) throws SQLException {
        int n;
        int n2 = -1;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        if (properties.get("DATABASE") == null && this.DbName != null) {
            properties.put("DATABASE", this.DbName);
        }
        if ((n = string.indexOf(61)) != -1) {
            int n3 = -1;
            while ((n3 = string.indexOf(58, (n2 = n3) + 1)) != -1 && n3 < n) {
            }
            if (n2 == -1) {
                return;
            }
        }
        if ((string2 = string.substring(n2 + 1)) != null) {
            stringTokenizer = new StringTokenizer(string2, ";");
        }
        if (string2 != null && string2.indexOf(61) != -1 && stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken(";");
                stringTokenizer2 = new StringTokenizer(string3, "=");
                String string4 = stringTokenizer2.nextToken();
                String string5 = stringTokenizer2.nextToken(";").substring(1);
                if (string4.equalsIgnoreCase("CSM")) {
                    if (string5 == null || !string5.startsWith("(") || !string5.endsWith(")")) {
                        throw IfxErrMsg.getLocSQLException(-79705, this.ClientLocale);
                    }
                    String string6 = string5.substring(1, string5.length() - 1);
                    properties.put("CSM", string6);
                    continue;
                }
                properties.put(string4.toUpperCase(), string5);
            }
        }
        if (this.SubProtocol.equals("informix-direct")) {
            if (properties.get("PROTOCOLCLASS") == null) {
                properties.put("PROTOCOLCLASS", "com.informix.jdbc.IfxDirectProtocol");
            }
            if (properties.get("CONNECTIONCLASS") == null) {
                properties.put("CONNECTIONCLASS", "com.informix.jdbc.IfxDirectConnection");
            }
        } else {
            if (properties.get("PROTOCOLCLASS") == null) {
                properties.put("PROTOCOLCLASS", "com.informix.jdbc.IfxSqli");
            }
            if (properties.get("CONNECTIONCLASS") == null) {
                properties.put("CONNECTIONCLASS", "com.informix.jdbc.IfxSqliConnect");
            }
        }
        if ((this.Proxy = properties.getProperty("PROXY")) != null) {
            this.formatProxy(this.Proxy);
            properties.put("PROXY", this.Proxy);
        }
        properties.put("USERURL", this.OrigUrl);
        if (this.NewUrl == null && this.SubProtocol.equals("informix-direct")) {
            this.NewUrl = this.OrigUrl;
        }
    }

    private void checkTracing(String string, Properties properties) {
    }

    private void checkClientLocale(String string, Properties properties) {
        int n;
        String string2 = properties.getProperty("CLIENT_LOCALE");
        if (string2 == null && (n = string.indexOf("CLIENT_LOCALE")) != -1) {
            String string3 = null;
            string3 = string.substring(n, string.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken(";");
                if (string4.indexOf(61) == -1) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=");
                String string5 = stringTokenizer2.nextToken();
                String string6 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null;
                if (!string5.equals("CLIENT_LOCALE")) continue;
                string2 = string6;
            }
        }
        if (string2 != null) {
            this.ClientLocale = new String(string2);
            this.setStaticClientLocale(string2);
        }
    }

    private void setStaticClientLocale(String string) {
        staticClientLocale = string;
    }

    private boolean validDatabaseIdentifier(String string) {
        int n = 1;
        int n2 = 0;
        String string2 = null;
        n2 = string.lastIndexOf("/");
        string2 = n2 != -1 ? string.substring(n2 + 1) : string;
        int n3 = string2.length();
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (n = 1; n < n3; ++n) {
            c = string2.charAt(n);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '#') continue;
            return false;
        }
        return true;
    }

    private static String calcReleaseNum() {
        long l = 2454006L;
        String string = null;
        String string2 = "2017-02-08";
        long l2 = dateUtil.gregToJulian(string2);
        int n = (int)(l2 - l);
        string = n < 0 ? "000" : (n < 10 ? "00" + n : (n < 100 ? "0" + n : (n > 999 ? "999" : "" + n)));
        return string;
    }

    public static String getJDBCVersion() throws SQLException {
        return "3.10.JC1N" + IfxDriver.calcReleaseNum();
    }

    static int getJDBCMajorVersion() throws SQLException {
        String string = IfxDriver.getJDBCVersion();
        return IfxDriver.extractMajorVersion(string);
    }

    static int extractMajorVersion(String string) throws SQLException {
        Integer n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        return n;
    }

    static int extractMinorVersion(String string) throws SQLException {
        Integer n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        return n;
    }

    static int getJDBCMinorVersion() throws SQLException {
        String string = IfxDriver.getJDBCVersion();
        return IfxDriver.extractMinorVersion(string);
    }

    private boolean formatProxy(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringBuffer stringBuffer = new StringBuffer("http://");
        int n = string.indexOf(63);
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n, string.length());
        } else {
            string3 = string;
        }
        try {
            string5 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.toUpperCase().indexOf("HTTP") != -1 || string2.toUpperCase().indexOf("SERVLET") != -1 || string2.toUpperCase().indexOf("JDBCPROXY") != -1) continue;
            string5 = string2;
        }
        stringBuffer.append(string5);
        stringBuffer.append("/servlet/IfxJDBCProxy");
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        this.Proxy = new String(stringBuffer.toString());
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new IfxDriver());
        }
        catch (SQLException sQLException) {
            System.out.println(IfxErrMsg.getMinorMsg(-80034, (String)null) + " " + -79704 + "\n" + IfxErrMsg.getMessage(-79704, (String)null));
        }
        IfxDriver.setJDKVersion();
    }
}

