/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class IfxLobInputStream
extends InputStream {
    static final int LO_INTERNAL_BUF_MAX_SIZE = 4084;
    IfxConnection conn = null;
    IfxLocator locator = null;
    long lobSize = 0L;
    long total_read = 0L;
    private int loFd;
    private IfxLocator loPtr = null;
    private IfxSmartBlob smb = null;
    byte[] buffer = null;
    int pos = 0;
    int count = 0;

    public IfxLobInputStream(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException, IOException {
        this.conn = ifxConnection;
        this.locator = ifxLocator;
        try {
            this.smb = new IfxSmartBlob(this.conn);
            this.loFd = this.smb.IfxLoOpen(this.locator, 4);
            this.lobSize = this.smb.IfxLoSize(this.loFd);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    @Override
    public int read() throws IOException {
        int n = 0;
        if ((this.buffer == null || this.pos == this.count) && (n = this.readLob()) == -1) {
            return -1;
        }
        ++this.total_read;
        return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.read(byArray, 0, byArray.length);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        while (n3 < n2 && n4 >= 0) {
            if ((this.buffer == null || this.pos == this.count) && (n4 = this.readLob()) == -1) {
                if (!bl) continue;
                n3 = -1;
                return -1;
            }
            int n5 = Math.min(this.count - this.pos, n2 - n3);
            System.arraycopy(this.buffer, this.pos, byArray, n3 + n, n5);
            bl = false;
            n3 += n5;
            this.pos += n5;
        }
        this.total_read += (long)n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        try {
            return this.smb.IfxLoSeek(this.loFd, l, 1);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.smb.IfxLoSeek(this.loFd, 0L, 0);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.lobSize - this.total_read);
    }

    @Override
    public void close() throws IOException {
        try {
            this.smb.IfxLoClose(this.loFd);
            this.smb.IfxLoRelease(this.locator);
            this.smb = null;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    protected synchronized void finalize() throws IOException {
        try {
            if (this.smb != null) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int readLob() throws IOException {
        if (this.buffer == null) {
            this.buffer = this.lobSize > 4084L ? new byte[4084] : new byte[(int)this.lobSize];
        }
        try {
            this.pos = 0;
            this.count = this.smb.IfxLoRead(this.loFd, this.buffer, this.buffer.length);
            if (this.count == 0) {
                return -1;
            }
            return this.count;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    protected InputStream getStream() throws SQLException {
        if (this.lobSize == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            this.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.smb.IfxLoRead(this.loFd, (int)this.lobSize));
        return byteArrayInputStream;
    }
}

