/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUpdateResultSet;
import com.informix.jdbc.ResultSet2;
import com.informix.jdbcx.IfxXAReusableConnection;
import com.informix.jdbcx.IfxXid;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.transaction.xa.Xid;

public class IfxResultSet
extends IfxUpdateResultSet
implements IfmxResultSet,
ResultSet2 {
    static final int DIR_FIRST = 3;
    static final int DIR_LAST = 4;
    static final int DIR_ABSL = 6;
    static final int DIR_NEXT = 1;
    static final int DIR_PREV = 2;
    static final int DIR_RELT = 7;
    static final int DIR_CURR = 5;
    protected IfxProtocol prot;
    protected HashMap nameToIdxTable;
    protected int curRowID;
    protected int LastRowID = -1;
    protected boolean lastColWasNull;
    protected Vector colVector;
    protected Vector keyNameVector;
    protected boolean noMoreRows;
    static final int IS_XA_TX = 1;
    private int txType;
    protected boolean isClosed;
    private Xid connectXid = null;
    private boolean pending = false;
    private int FetchSize = 0;
    private int tupleSizeReceived = 0;
    protected boolean withHold = false;

    IfxResultSet(IfxStatement ifxStatement, IfxConnection ifxConnection, IfxProtocol ifxProtocol) throws SQLException {
        this.conn = ifxConnection;
        this.prot = ifxProtocol;
        this.stmt = ifxStatement;
        this.FetchSize = ifxStatement.getFetchSize();
        if (ifxConnection instanceof IfxSqliConnect) {
            boolean bl = this.pending = !((IfxSqliConnect)ifxConnection).autoCommit;
        }
        if (ifxConnection.isXAConnection()) {
            this.connectXid = ((IfxXAReusableConnection)ifxConnection).getCurrentXid();
        }
        this.setResultSetTxType();
    }

    void init() {
        this.isClosed = false;
    }

    protected void setTrace(Trace trace) {
    }

    public void executeQuery() throws SQLException {
        this.executeQuery(false);
    }

    void executeQuery(boolean bl) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        this.prot.executeStatementQuery(this.stmt, bl);
        this.curRowID = 0;
        this.LastRowID = 0;
        this.rsmd = (IfxResultSetMetaData)this.getMetaData();
    }

    void executeQuery(IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        this.executeQuery(ifxResultSetMetaData, false);
    }

    void executeQuery(IfxResultSetMetaData ifxResultSetMetaData, boolean bl) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        this.prot.executeStatementQuery(this.stmt, bl, ifxResultSetMetaData);
        this.curRowID = 0;
        this.LastRowID = 0;
    }

    int executeUpdate() throws SQLException {
        block5: {
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
            this.clearWarnings();
            this.setResultSetTxType();
            if (!(this.stmt instanceof IfxPreparedStatement) || ((IfxSqliConnect)this.conn).usePut) break block5;
            Vector vector = ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                short s;
                IfxSmBlob ifxSmBlob;
                block7: {
                    block6: {
                        IfxObject ifxObject = (IfxObject)vector.elementAt(i);
                        if (!(ifxObject instanceof IfxSmBlob)) continue;
                        ifxSmBlob = (IfxSmBlob)ifxObject;
                        s = ifxSmBlob.blobType;
                        if (ifxSmBlob.sm_size < 0L) continue;
                        if (s == 2) break block6;
                        if (s != 1) break block7;
                    }
                    ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                    continue;
                }
                if (s != 3) continue;
                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobCharInputStream, (int)ifxSmBlob.sm_size);
            }
        }
        this.prot.executeCommand(this.stmt);
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.getNumberOfRowsProcessed();
    }

    Vector executeFastPath(String string, ResultSetMetaData resultSetMetaData, Vector vector, boolean bl, boolean bl2) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        if (this.conn.isDirect()) {
            this.prot.executeFastPath(string, vector, bl, bl2);
        } else {
            ((IfxSqli)this.prot).executeFastPath(string, resultSetMetaData, vector, bl, bl2);
        }
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.getFPReturnVector();
    }

    IfxFParam getFParam() {
        return this.prot.getFParam();
    }

    boolean executeExecute(boolean bl) throws SQLException {
        block5: {
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
            this.clearWarnings();
            this.setResultSetTxType();
            if (!(this.stmt instanceof IfxPreparedStatement) || ((IfxSqliConnect)this.conn).usePut) break block5;
            Vector vector = ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                short s;
                IfxSmBlob ifxSmBlob;
                block7: {
                    block6: {
                        IfxObject ifxObject = (IfxObject)vector.elementAt(i);
                        if (!(ifxObject instanceof IfxSmBlob)) continue;
                        ifxSmBlob = (IfxSmBlob)ifxObject;
                        s = ifxSmBlob.blobType;
                        if (ifxSmBlob.sm_size < 0L) continue;
                        if (s == 2) break block6;
                        if (s != 1) break block7;
                    }
                    ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                    continue;
                }
                if (s != 3) continue;
                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobCharInputStream, (int)ifxSmBlob.sm_size);
            }
        }
        this.prot.executeExecute(this.stmt, bl);
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.isResultSet();
    }

    boolean executeExecute(boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        block5: {
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
            this.clearWarnings();
            this.setResultSetTxType();
            if (!(this.stmt instanceof IfxPreparedStatement) || ((IfxSqliConnect)this.conn).usePut) break block5;
            Vector vector = ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                short s;
                IfxSmBlob ifxSmBlob;
                block7: {
                    block6: {
                        IfxObject ifxObject = (IfxObject)vector.elementAt(i);
                        if (!(ifxObject instanceof IfxSmBlob)) continue;
                        ifxSmBlob = (IfxSmBlob)ifxObject;
                        s = ifxSmBlob.blobType;
                        if (ifxSmBlob.sm_size < 0L) continue;
                        if (s == 2) break block6;
                        if (s != 1) break block7;
                    }
                    ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                    continue;
                }
                if (s != 3) continue;
                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobCharInputStream, (int)ifxSmBlob.sm_size);
            }
        }
        this.prot.executeExecute(this.stmt, bl, ifxResultSetMetaData);
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.isResultSet();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.prot == null) {
            return false;
        }
        if (this.LastRowID == -1) {
            return false;
        }
        if (this.LastRowID != 0 && this.curRowID >= this.LastRowID) {
            if (this.curRowID == this.LastRowID) {
                ++this.curRowID;
            }
            return false;
        }
        var1_1 = this.stmt.getMaxRows();
        if (var1_1 != 0 && this.curRowID >= var1_1) {
            this.LastRowID = var1_1;
            this.curRowID = this.LastRowID + 1;
            return false;
        }
        v0 = var2_2 = this.stmt.getResultSetType() == 1004 ? 1 : 0;
        if (var2_2 == 1) {
            var3_3 = this.conn.isDirect() != false ? this.prot.getaRow(this.stmt.getFetchDirection(), ++this.curRowID, 6, var2_2, this.stmt) : this.prot.getaRow(this.stmt.getFetchDirection(), ++this.curRowID, 1, var2_2, this.stmt);
            if (!var3_3) {
                this.LastRowID = this.curRowID - 1;
            }
        } else {
            var3_3 = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 1, var2_2, this.stmt);
        }
        if (!var3_3) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector<E>();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) ** GOTO lbl46
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) ** GOTO lbl46
                this.UpdateColVector = (Vector)this.colVector.clone();
            }
            catch (SQLException var4_4) {
                throw var4_4;
            }
            catch (Exception var4_5) {
                var5_6 = IfxErrMsg.getSQLException(-79716, var4_5.toString(), this.conn);
                var5_6 = IfxErrMsg.setSQLExceptionCause(var5_6, var4_5);
                throw var5_6;
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
lbl46:
        // 6 sources

        if (var2_2 != 1) {
            ++this.curRowID;
        }
        return true;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        Integer n;
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                this.getMetaData();
            }
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int n2 = this.rsmd.getColumnCount();
            this.nameToIdxTable = new HashMap(n2);
            for (int i = 1; i <= n2; ++i) {
                this.nameToIdxTable.put(this.rsmd.getColumnName(i), new Integer(i));
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            if (this.conn != null && this.conn.isDirect()) {
                string = string.trim();
            }
            n = (Integer)this.nameToIdxTable.get(string.toLowerCase());
        } else {
            n = (Integer)this.nameToIdxTable.get(string);
        }
        if (n == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        return n;
    }

    IfxObject getValue(int n) throws SQLException {
        return this.getValue(n, null);
    }

    IfxObject getValue(int n, Calendar calendar) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        if (this.colVector == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (n < 1 || n > this.colVector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        IfxObject ifxObject = (IfxObject)this.colVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = this.prot instanceof IfxSqli ? ((IfxSqli)this.prot).getColumnInRow(n, calendar) : this.prot.getColumnInRow(n);
            this.colVector.setElementAt(ifxObject, n - 1);
        } else {
            if (calendar != null && ifxObject instanceof IfxDateTime) {
                ((IfxDateTime)ifxObject).dbCalendar = calendar;
            }
            this.prot.loadColumnData(n, ifxObject);
        }
        if (ifxObject.isNull()) {
            this.lastColWasNull = true;
            return null;
        }
        this.lastColWasNull = false;
        this.blobCheck(ifxObject);
        return ifxObject;
    }

    IfxObject getValueFastPath(int n) throws SQLException {
        IfxObject ifxObject = this.prot.getColumnInRow(n);
        return ifxObject;
    }

    @Override
    public String getString(int n) throws SQLException {
        String string;
        Object object;
        IfxObject ifxObject = this.getValue(n);
        IfxSqliConnect cfr_ignored_0 = (IfxSqliConnect)this.conn;
        IfxSqliConnect.GclEnv = true;
        if (ifxObject == null) {
            return null;
        }
        if (ifxObject.getClass().getName().endsWith("IfxSmBlob")) {
            object = ((IfxSmBlob)ifxObject).toClob(4);
            string = object.getSubString(1L, (int)object.length());
            ((IfxLob)object).close();
        } else {
            int n2;
            string = ifxObject.toString();
            if (this.stmt != null && (n2 = this.stmt.getMaxFieldSize()) > 0) {
                int n3 = this.rsmd.getColumnType(n);
                if (string.length() > n2 && (n3 == 1 || n3 == 12 || n3 == -1 || n3 == -2 || n3 == -3 || n3 == -4)) {
                    string = string.substring(0, n2);
                }
            }
        }
        object = ifxObject.getWarning();
        if (object != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, ((DataTruncation)object).getDataSize(), ((DataTruncation)object).getTransferSize()));
        }
        return string;
    }

    @Override
    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        Object object = null;
        object = this.conn != null ? this.getObject(n, this.conn.getTypeMap()) : this.getObject(n, (Map)null);
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.extendedID == 11 && ((IfxSqliConnect)this.conn).isConvText() ? ((IfxSqli)this.prot).toClobStream((IfxSmBlob)ifxObject) : ifxObject.toAsciiStream();
        return inputStream;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getAsciiStream(n);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Reader reader = ifxObject.toCharacterStream();
        return reader;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getCharacterStream(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = ifxObject.toDecimal().setScale(n2, 4);
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2, n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        return ifxObject.toDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return false;
        }
        boolean bl = ifxObject.toBoolean();
        return bl;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    @Override
    public short getShort(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        short s = ifxObject.toShort();
        return s;
    }

    @Override
    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        int n2 = ifxObject.toInt();
        return n2;
    }

    @Override
    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    @Override
    public long getLong(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0L;
        }
        long l = ifxObject.toLong();
        return l;
    }

    @Override
    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0f;
        }
        float f = ifxObject.toFloat();
        return f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        byte by = ifxObject.toByte();
        return by;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        byte[] byArray = ifxObject.toBytes();
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Date date = ifxObject.toDate();
        return date;
    }

    @Override
    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0;
        }
        double d = ifxObject.toDouble();
        return d;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Time time = ifxObject.toTime();
        return time;
    }

    @Override
    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = this.getValue(n, calendar);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        ifxObject.setConnection(this.conn);
        Timestamp timestamp = ifxObject.toTimestamp();
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.toBinaryStream();
        return inputStream;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBinaryStream(n);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.prot != null) {
            return this.prot.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.prot != null) {
            this.prot.clearWarnings();
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.stmt == null) {
            throw IfxErrMsg.getSQLException(-79740, this.conn);
        }
        return this.stmt.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.rsmd = (IfxResultSetMetaData)this.prot.getMetaData();
        return this.rsmd;
    }

    public Object getObject(int n, Map map) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        Object object = null;
        int n2 = this.rsmd.getColumnType(n);
        if (ifxObject != null && !ifxObject.isNull()) {
            ifxObject.setTypeMap(map);
            object = ifxObject.toObject();
        }
        return object;
    }

    public Object getObject(String string, Map map) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n, map);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastColWasNull;
    }

    int getUpdateCount() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.isClosed() || this.prot.isResultSet()) {
            return -1;
        }
        return this.prot.getNumberOfRowsProcessed();
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (this.prot != null && this.stmt.cursorOpen) {
            this.prot.executeClose(this.stmt);
        }
        if (!(this.stmt instanceof IfxPreparedStatement) && !(this.stmt instanceof IfxCallableStatement)) {
            this.closePrev();
        } else {
            this.clear();
        }
    }

    void clear() {
        if (this.nameToIdxTable != null) {
            this.nameToIdxTable.clear();
            this.nameToIdxTable = null;
        }
        this.lastColWasNull = false;
        this.curRowID = 0;
        this.LastRowID = 0;
        this.clearColumnVector();
        if (this.colVector != null) {
            this.colVector.removeAllElements();
            this.colVector = null;
        }
        if (this.keyNameVector != null) {
            this.keyNameVector.removeAllElements();
            this.keyNameVector = null;
        }
        if (this.WhereVal != null) {
            this.WhereVal.removeAllElements();
            this.WhereVal = null;
        }
    }

    void closePrev() throws SQLException {
        if (this.prot != null) {
            this.prot.executeRelease(this.stmt);
        }
        this.clear();
        if (this.UpdateColVector != null) {
            this.UpdateColVector.removeAllElements();
            this.UpdateColVector = null;
        }
    }

    private void clearColumnVector() {
        if (this.colVector != null) {
            int n = this.colVector.size();
            for (int i = 0; i < n; ++i) {
                IfxObject ifxObject = (IfxObject)this.colVector.elementAt(i);
                if (ifxObject == null) continue;
                ifxObject.clear();
            }
        }
    }

    void closeNow() throws SQLException {
        this.clear();
        this.prot = null;
        this.stmt = null;
        if (this.UpdateColVector != null) {
            this.UpdateColVector.removeAllElements();
            this.UpdateColVector = null;
        }
    }

    protected void blobCheck(IfxObject ifxObject) throws SQLException {
        IfxBlob ifxBlob;
        if (ifxObject instanceof IfxBlob && !(ifxBlob = (IfxBlob)ifxObject).isBlobLoaded()) {
            try {
                this.prot.executeFetchBlob(ifxBlob);
            }
            catch (Exception exception) {
                SQLException sQLException = IfxErrMsg.getSQLException(-79701, this.conn);
                if (exception instanceof SQLException) {
                    sQLException.setNextException((SQLException)exception);
                }
                sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                throw sQLException;
            }
            ifxBlob.setLoaded();
        }
    }

    int getSerial() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerialInsert();
    }

    long getSerial8() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerial8Inserted();
    }

    long getBigSerial() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getBigSerialInserted();
    }

    @Override
    public Interval getInterval(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Interval interval = ifxObject.toInterval();
        return interval;
    }

    @Override
    public Interval getInterval(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInterval(n);
    }

    @Override
    public IntervalYM getIntervalYM(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalYM intervalYM = ifxObject.toIntervalYM();
        return intervalYM;
    }

    @Override
    public IntervalYM getIntervalYM(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalYM(n);
    }

    @Override
    public IntervalDF getIntervalDF(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalDF intervalDF = ifxObject.toIntervalDF();
        return intervalDF;
    }

    @Override
    public IntervalDF getIntervalDF(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalDF(n);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    boolean isAccessible() {
        Xid xid;
        if (!this.conn.inXATransaction() && this.connectXid == null) {
            return true;
        }
        return this.conn.inXATransaction() && this.connectXid != null && IfxXid.equals((Xid)this.connectXid, (Xid)(xid = ((IfxXAReusableConnection)this.conn).getCurrentXid()));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.curRowID > 0 || this.LastRowID == -1) {
            return false;
        }
        if (this.conn.isDirect()) {
            return this.curRowID == 0;
        }
        int n = ((IfxSqli)this.prot).getNumberOfTuplesReceived();
        int n2 = ((IfxSqli)this.prot).getNumberOfFetches();
        if (n == 0 && n2 == 0 && this.first()) {
            this.previous();
        }
        if (((IfxSqli)this.prot).getNumberOfTuplesReceived() == 0) {
            this.LastRowID = -1;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.curRowID < 1 || this.LastRowID < 1) {
            return false;
        }
        return this.curRowID == this.LastRowID + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        return this.LastRowID > -1 && this.curRowID == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.LastRowID == -1) {
            return false;
        }
        if (this.LastRowID == 0) {
            int n = this.curRowID;
            boolean bl = this.last();
            this.LastRowID = this.curRowID;
            if (n == 0) {
                this.curRowID = 0;
            } else {
                bl = this.absolute(n);
            }
        }
        return this.curRowID > 0 && this.curRowID == this.LastRowID;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        if (this.curRowID == 0) {
            return;
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.curRowID = 0;
        if (this.absolute(1)) {
            this.previous();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID != 0) {
            this.curRowID = this.LastRowID + 1;
        } else {
            if (!this.conn.isDirect() && ((IfxSqli)this.prot).getNumberOfFetches() != 0 && ((IfxSqli)this.prot).getNumberOfTuplesReceived() == 0) {
                this.LastRowID = -1;
                return;
            }
            boolean bl = this.last();
            if (bl) {
                this.curRowID = this.LastRowID + 1;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID < 0) {
            return false;
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 6, 1, this.stmt);
        if (!bl) {
            this.LastRowID = -1;
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        boolean bl = false;
        if (this.LastRowID == -1) {
            return false;
        }
        bl = this.LastRowID == 0 ? this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, 1, this.stmt) : this.prot.getaRow(this.stmt.getFetchDirection(), this.LastRowID, 6, 1, this.stmt);
        if (!bl) {
            this.LastRowID = -1;
            return false;
        }
        this.LastRowID = this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        return this.curRowID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean absolute(int n) throws SQLException {
        boolean bl = false;
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (n == 0) {
            this.beforeFirst();
            return false;
        }
        if (this.LastRowID == -1) {
            return false;
        }
        if (n > 0) {
            if (this.LastRowID > 0 && n > this.LastRowID) {
                this.afterLast();
                return false;
            }
            bl = this.prot.getaRow(this.stmt.getFetchDirection(), n, 6, 1, this.stmt);
        } else if (n < 0) {
            if (this.LastRowID == 0 && !this.last()) {
                return false;
            }
            this.curRowID = this.LastRowID + n + 1;
            if (this.curRowID < 1) {
                this.curRowID = 0;
                return false;
            }
            bl = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID, 6, 1, this.stmt);
        }
        if (!bl) {
            this.afterLast();
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean relative(int n) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        if (this.LastRowID == -1 || this.isBeforeFirst() || this.isAfterLast()) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (n == 0) {
            return true;
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        int n2 = this.curRowID + n;
        if (n2 < 1) {
            this.beforeFirst();
            return false;
        }
        if (this.LastRowID > 0 && n2 > this.LastRowID) {
            this.afterLast();
            return false;
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), n2, 6, 1, this.stmt);
        if (!bl) {
            this.afterLast();
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    public boolean current() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        return this.curRowID != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID < 0 || this.curRowID <= 0) {
            return false;
        }
        this.curRowID += -1;
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID, 6, 1, this.stmt);
        if (!bl) {
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.stmt.setFetchDirection(n);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": ResultSet.setFetchSize(int).", this.conn);
        }
        this.FetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        return this.FetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(int).", this.conn);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Blob blob = ifxObject.toBlob();
        return blob;
    }

    public Blob getBlob(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        this.blobCheck(ifxObject);
        Blob blob = ifxObject.toBlob(n2);
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return blob;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        int n2 = this.rsmd.getColumnType(n);
        Clob clob = ifxObject.toClob();
        return clob;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        IfxCollection ifxCollection = (IfxCollection)this.getValue(n);
        Array array = null;
        if (ifxCollection != null && !ifxCollection.isNull()) {
            array = ifxCollection.toArray();
        }
        return array;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(String).", this.conn);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    public Blob getBlob(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBlob(n2, n);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getClob(n);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getArray(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        long l = date.getTime() + (long)calendar.get(15) - (long)calendar2.get(15) + (long)calendar.get(16) - (long)calendar2.get(16);
        return new Date(l);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        long l = time.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Time(l);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    private void getRSPKeys(String string, boolean bl) throws SQLException {
        Object object;
        int n;
        int n2;
        String string2 = null;
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n3 = string.indexOf(":");
        int n4 = string.indexOf(".");
        if (n3 < 0 && n4 < 0 || n3 == 0 || n4 == 0 || n4 + 1 == string.length() || n3 + 1 == string.length() || n4 > 0 && n3 + 1 >= n4) {
            string5 = string;
        } else {
            int n5 = 0;
            if (n3 > 0) {
                string3 = string.substring(0, n3);
                n5 = n3 + 1;
            }
            if (n4 > 0) {
                string4 = string.substring(n5, n4);
                n5 = n4 + 1;
            }
            string5 = string.substring(n5);
        }
        if (!bl) {
            int n6;
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("insert into ").append(string).append("(");
            boolean bl2 = false;
            int n7 = 0;
            for (n6 = 0; n6 < this.UpdateColVector.size(); ++n6) {
                IfxObject ifxObject = (IfxObject)this.UpdateColVector.elementAt(n6);
                if (ifxObject == null || !ifxObject.get_used_in_update()) continue;
                if (bl2) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.rsmd.getColumnName(n6 + 1));
                bl2 = true;
                ++n7;
            }
            stringBuffer.append(") values (");
            bl2 = false;
            for (n6 = 0; n6 < n7; ++n6) {
                if (bl2) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("?");
                bl2 = true;
            }
            stringBuffer.append(");");
            this.insertCmd = stringBuffer.toString();
            return;
        }
        if (this.keyNameVector == null) {
            this.keyNameVector = new Vector();
            this.WhereVal = new Vector();
            if (this.rsmd.findrowid() != -1) {
                this.keyNameVector.add("rowid");
                this.WhereVal.add(this.getValue(this.rsmd.rowidx));
            } else {
                string2 = this.rsmd.findserial();
                if (string2 != null) {
                    this.keyNameVector.add(string2);
                    this.WhereVal.add(this.getValue(this.rsmd.serialidx));
                } else {
                    resultSet = databaseMetaData.getPrimaryKeys(string3, string4, string5);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string6 = resultSet.getString(4);
                            this.keyNameVector.add(string6);
                            n2 = this.findColumn(string6);
                            this.WhereVal.add(this.getValue(n2));
                        }
                        resultSet.close();
                    }
                }
            }
            if (this.keyNameVector.size() == 0) {
                throw IfxErrMsg.getSQLException(-79817, this.conn);
            }
        } else {
            this.WhereVal.removeAllElements();
            if (this.rsmd.rowidx != -1) {
                this.WhereVal.add(this.getValue(this.rsmd.rowidx));
            } else if (this.rsmd.serialidx != -1) {
                this.WhereVal.add(this.getValue(this.rsmd.serialidx));
            } else {
                for (n = 0; n < this.keyNameVector.size(); ++n) {
                    String string7 = (String)this.keyNameVector.elementAt(n);
                    n2 = this.findColumn(string7);
                    this.WhereVal.add(this.getValue(n2));
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        n2 = 0;
        stringBuffer.append("update ").append(string).append(" set ");
        for (n = 0; n < this.UpdateColVector.size(); ++n) {
            object = (IfxObject)this.UpdateColVector.elementAt(n);
            if (object == null || !((IfxObject)object).get_used_in_update()) continue;
            if (n2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.rsmd.getColumnName(n + 1)).append(" = ? ");
            n2 = 1;
        }
        object = new StringBuffer(200);
        ((StringBuffer)object).append("delete from ").append(string).append(" ");
        StringBuffer stringBuffer2 = new StringBuffer(200);
        stringBuffer2.append("where ");
        for (n = 0; n < this.keyNameVector.size(); ++n) {
            stringBuffer2.append((String)this.keyNameVector.elementAt(n)).append(" = ?");
            if (n < this.keyNameVector.size() - 1) {
                stringBuffer2.append(" and ");
                continue;
            }
            stringBuffer2.append(" ");
        }
        stringBuffer2.append(";");
        ((StringBuffer)object).append(stringBuffer2.toString());
        stringBuffer.append(stringBuffer2.toString());
        this.updateCmd = stringBuffer.toString();
        this.deleteCmd = ((StringBuffer)object).toString();
    }

    private void validate_update_call(boolean bl) throws SQLException {
        String string = null;
        if (this.stmt.getResultSetConcurrency() != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (this.UpdateColVector == null || this.updatecanceled) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        string = this.stmt != null ? IfxResultSetMetaData.parseTableName(this.stmt.commandString) : this.rsmd.getTableName(1);
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79816, this.conn);
        }
        this.getRSPKeys(string, bl);
        this.updatecanceled = false;
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79815, this.conn);
        }
        this.validate_update_call(false);
        super.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        this.validate_update_call(true);
        super.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        this.validate_update_call(true);
        super.deleteRow();
    }

    int getTupleBufferSize() {
        return ((IfxSqli)this.prot).getTupleBufferSize();
    }

    int getTupleSize() throws SQLException {
        return ((IfxSqli)this.prot).getTupleSize();
    }

    public IfxProtocol getProtocol() {
        return this.prot;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getURL(int)", this.conn);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getURL(String)", this.conn);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateRef(int)", this.conn);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateRef(String)", this.conn);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public void releaseBlob() {
        if (((IfxSqliConnect)this.conn).autoCommit) {
            ((IfxSqliConnect)this.conn).releaseBlob();
        }
    }

    private void setResultSetTxType() {
        this.txType = this.conn.isXAConnection() && this.conn.inXATransaction() ? 1 : 0;
    }

    IfxResultSetMetaData executeDescribeInput() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.executeDescribeInput();
    }

    IfxResultSetMetaData executeFPDescribe(boolean bl, String string, int n) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.executeFPDescribe(null, bl, string, n);
    }

    void setPending(boolean bl) {
        this.pending = bl;
    }

    boolean isPending() {
        return this.pending;
    }

    @Override
    public String getUnloadString(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        ifxObject.setConnection(this.conn);
        return ifxObject.toUnloadString();
    }

    public int getNumberOfFetches() {
        return ((IfxSqli)this.prot).getNumberOfFetches();
    }

    int calculateFetchBufferSize() throws SQLException {
        if (this.rsmd == null) {
            return this.tupleSizeReceived;
        }
        IfxStatement ifxStatement = (IfxStatement)this.getStatement();
        int n = this.getFetchSize();
        int n2 = ifxStatement.getMaxRows();
        if (n == 0 && n2 == 0) {
            return 0;
        }
        int n3 = n;
        if (n2 != 0) {
            n3 = n != 0 ? Math.min(n, n2) : n2;
        }
        int n4 = this.rsmd.getColumnCount();
        int n5 = this.rsmd.getColumnStartPosition(n4) + this.rsmd.getColumnLength(n4);
        if (this.rsmd.isVariableLengthType(n4)) {
            n5 += 5;
        }
        int n6 = Math.max(n5, this.rsmd.getTupleSize());
        n6 = Math.max(n6, this.tupleSizeReceived);
        return n3 * n6;
    }

    protected void setTupleSizeReceived(int n) {
        this.tupleSizeReceived = n;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getObject", (IfxConnection)null);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getObject", (IfxConnection)null);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNClob", (IfxConnection)null);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateClob", (IfxConnection)null);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateClob", (IfxConnection)null);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateClob", (IfxConnection)null);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateClob", (IfxConnection)null);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBlob", (IfxConnection)null);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBlob", (IfxConnection)null);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBlob", (IfxConnection)null);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBlob", (IfxConnection)null);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNCharacterStream", (IfxConnection)null);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNCharacterStream", (IfxConnection)null);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNCharacterStream", (IfxConnection)null);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNString", (IfxConnection)null);
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNString", (IfxConnection)null);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateNString", (IfxConnection)null);
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNString", (IfxConnection)null);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBinaryStream", (IfxConnection)null);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBinaryStream", (IfxConnection)null);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBinaryStream", (IfxConnection)null);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateBinaryStream", (IfxConnection)null);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateAsciiStream", (IfxConnection)null);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateAsciiStream", (IfxConnection)null);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateAsciiStream", (IfxConnection)null);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateAsciiStream", (IfxConnection)null);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateSQLXML", (IfxConnection)null);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateSQLXML", (IfxConnection)null);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getSQLXML", (IfxConnection)null);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getSQLXML", (IfxConnection)null);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNClob", (IfxConnection)null);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getNClob", (IfxConnection)null);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getHoldability", (IfxConnection)null);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateRowId", (IfxConnection)null);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "updateRowId", (IfxConnection)null);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getRowId", (IfxConnection)null);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "getRowId", (IfxConnection)null);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "isWrapperFor", (IfxConnection)null);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "unwrap", (IfxConnection)null);
    }
}

