/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.ResultSet2;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public abstract class IfxScrollableResultSet
implements IfmxResultSet,
ResultSet2 {
    protected IfxResultSetMetaData rsmd = null;
    protected IfxConnection conn = null;
    protected Trace trace = null;
    protected Vector insertRowVector = null;
    protected Vector colVector = null;
    protected boolean insertMode = false;
    protected boolean lastColWasNull = false;
    protected Hashtable nameToIdxTable = null;
    protected boolean delimIdent = false;
    protected Map typeMap = null;
    protected SQLWarning warnings = null;

    IfxScrollableResultSet(IfxConnection ifxConnection, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.rsmd = (IfxResultSetMetaData)resultSetMetaData;
        if (ifxConnection != null) {
            this.conn = ifxConnection;
            this.trace = ifxConnection.getTrace();
            this.typeMap = ifxConnection.getTypeMap();
        }
    }

    private IfxObject getValue(int n) throws SQLException {
        return this.getValue(n, null);
    }

    private IfxObject getValue(int n, Calendar calendar) throws SQLException {
        Vector vector = null;
        vector = this.getRowVector(n);
        IfxObject ifxObject = (IfxObject)vector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
            vector.setElementAt(ifxObject, n - 1);
        } else if (ifxObject instanceof IfxDateTime && !((IfxDateTime)ifxObject).isTimeValue()) {
            ((IfxDateTime)ifxObject).toTimestampFromRawData(calendar);
        }
        this.lastColWasNull = ifxObject.isNull();
        return ifxObject;
    }

    private Vector getRowVector(int n) throws SQLException {
        Vector vector = null;
        try {
            if (this.insertMode) {
                if (this.insertRowVector == null) {
                    if (this.rsmd == null) {
                        throw IfxErrMsg.getSQLException(-79737, this.conn);
                    }
                    this.insertRowVector = new Vector(this.rsmd.getColumnCount());
                    this.insertRowVector.setSize(this.rsmd.getColumnCount());
                }
                vector = this.insertRowVector;
            } else {
                if (this.colVector == null) {
                    throw IfxErrMsg.getSQLException(-79739, this.conn);
                }
                vector = this.colVector;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (n < 1 || n > vector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        return vector;
    }

    @Override
    public boolean wasNull() {
        return this.lastColWasNull;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        Integer n;
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int n2 = this.rsmd.getColumnCount();
            this.nameToIdxTable = new Hashtable(n2);
            for (int i = 1; i <= n2; ++i) {
                if (!this.delimIdent) {
                    this.nameToIdxTable.put(this.rsmd.getColumnName(i).toLowerCase(), new Integer(i));
                    continue;
                }
                this.nameToIdxTable.put(this.rsmd.getColumnName(i), new Integer(i));
            }
        }
        if ((n = !this.delimIdent ? (Integer)this.nameToIdxTable.get(string.toLowerCase()) : (Integer)this.nameToIdxTable.get(string)) == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        return n;
    }

    protected void chainWarnings(SQLWarning sQLWarning) {
        if (sQLWarning != null) {
            if (this.warnings != null) {
                this.warnings.setNextWarning(sQLWarning);
            } else {
                this.warnings = sQLWarning;
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.nullify();
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromBoolean(bl);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromByte(by);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromShort(s);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromInt(n2);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromLong(l);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromFloat(f);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromDouble(d);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromDecimal(bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromString(string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromBytes(byArray);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromDate(date);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromTime(time);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromTimestamp(timestamp);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromAsciiStream(inputStream, n2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromBinaryStream(inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromCharacterStream(reader, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromObject(object);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        ifxObject.fromObject(object, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateIfxObject(int n, Object object) throws SQLException {
        this.setIfxValue(n, object);
    }

    public void updateIfxObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    private void setIfxValue(int n, Object object) throws SQLException {
        Vector vector = null;
        try {
            vector = this.getRowVector(n);
            IfxObject ifxObject = (IfxObject)object;
            vector.setElementAt(ifxObject, n - 1);
            this.lastColWasNull = ifxObject.isNull();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public String getString(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        String string = null;
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        string = ifxObject.toString();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return string;
    }

    @Override
    public String getUnloadString(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        ifxObject.setConnection(this.conn);
        return ifxObject.toUnloadString();
    }

    @Override
    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = null;
        object = this.conn != null ? this.getObject(n, this.conn.getTypeMap()) : this.getObject(n, (Map)null);
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        Object object = null;
        if (ifxObject != null && !ifxObject.isNull()) {
            ifxObject.setTypeMap(map);
            object = ifxObject.toObject();
            DataTruncation dataTruncation = ifxObject.getWarning();
            if (dataTruncation != null) {
                this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
            }
        }
        return object;
    }

    public Object getObject(String string, Map map) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n, map);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.toAsciiStream();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return inputStream;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getAsciiStream(n);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            return new StringReader(string);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getCharacterStream(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = ifxObject.toDecimal().setScale(n2, 4);
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2, n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        return ifxObject.toDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return false;
        }
        boolean bl = ifxObject.toBoolean();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bl;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    @Override
    public short getShort(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        short s = ifxObject.toShort();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return s;
    }

    @Override
    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        int n2 = ifxObject.toInt();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return n2;
    }

    @Override
    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    @Override
    public long getLong(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0L;
        }
        long l = ifxObject.toLong();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return l;
    }

    @Override
    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0f;
        }
        float f = ifxObject.toFloat();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        byte by = ifxObject.toByte();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return by;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        byte[] byArray = ifxObject.toBytes();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Date date = ifxObject.toDate();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return date;
    }

    @Override
    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0;
        }
        double d = ifxObject.toDouble();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return d;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Time time = ifxObject.toTime();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return time;
    }

    @Override
    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        IfxObject ifxObject = this.getValue(n, calendar);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Timestamp timestamp = ifxObject.toTimestamp();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.toBinaryStream();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return inputStream;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBinaryStream(n);
    }

    @Override
    public Interval getInterval(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Interval interval = ifxObject.toInterval();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return interval;
    }

    @Override
    public Interval getInterval(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInterval(n);
    }

    @Override
    public IntervalYM getIntervalYM(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalYM intervalYM = ifxObject.toIntervalYM();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return intervalYM;
    }

    @Override
    public IntervalYM getIntervalYM(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalYM(n);
    }

    @Override
    public IntervalDF getIntervalDF(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalDF intervalDF = ifxObject.toIntervalDF();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return intervalDF;
    }

    @Override
    public IntervalDF getIntervalDF(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalDF(n);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(int).", this.conn);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Blob blob = ifxObject.toBlob();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return blob;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Clob clob = ifxObject.toClob();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return clob;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        IfxCollection ifxCollection = (IfxCollection)this.getValue(n);
        Array array = null;
        if (ifxCollection != null && !ifxCollection.isNull()) {
            array = ifxCollection.toArray();
        }
        return array;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(String).", this.conn);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getClob(n);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getArray(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        long l = date.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Date(l);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        long l = time.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Time(l);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    protected void finalize() {
        if (this.insertRowVector != null) {
            this.insertRowVector.removeAllElements();
            this.insertRowVector = null;
        }
    }
}

