/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxShort
extends IfxObject {
    private short value;
    public static final short IFX_SMINT_NULL = Short.MIN_VALUE;

    IfxShort() throws SQLException {
        this.setIfxType(1);
    }

    IfxShort(short s) throws SQLException {
        this.setIfxType(1);
        this.value = s;
        this.unnullify();
    }

    IfxShort(Short s) throws SQLException {
        this.setIfxType(1);
        this.value = s;
        this.unnullify();
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[]{-128, 0};
            return byArray;
        }
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        this.value = IfxToJavaType.IfxToJavaSmallInt(byArray, n);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Short(this.value);
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.value = by;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.value = by.shortValue();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.value = s;
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.value = (short)n;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.value = n.shortValue();
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = (short)l;
        this.unnullify();
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.value = l.shortValue();
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = (short)f;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.value = f.shortValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = (short)d;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.value = d.shortValue();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = (short)bigDecimal.intValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0;
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.value = (short)(bl ? 1 : 0);
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.value = (short)(bl == true ? 1 : 0);
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.value);
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            this.value = Short.valueOf(string.trim());
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        return object instanceof IfxShort && this.value == ((IfxShort)object).value;
    }

    @Override
    public short getEncodedLength() {
        short s = 1280;
        return s;
    }

    public boolean isIfxNull() {
        return this.value == Short.MIN_VALUE;
    }
}

