/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxASFException;
import com.informix.jdbc.IfmxCancelQuery;
import com.informix.jdbc.IfmxStatement;
import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import java.lang.reflect.Constructor;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Vector;

public class IfxStatement
implements IfmxStatement {
    private String cursorName = null;
    protected boolean cursorOpen = false;
    private int maxRows = 0;
    private Trace trace = null;
    private boolean statementProcessed = false;
    private SQLWarning statementWarnings = null;
    private boolean calledgetResultSet = false;
    private boolean calledgetUpdateCount = false;
    private boolean autoFree = false;
    private boolean isRsHoldable = false;
    protected IfxConnection jconn = null;
    protected IfxProtocol prot = null;
    public String commandString = null;
    protected IfxResultSet currentResult = null;
    boolean escapeProcessing = true;
    protected int numqmarks = 0;
    private int ResultSetType = 1003;
    private int ResultSetConcurrency = 1007;
    private int FetchSize = 0;
    private int FetchDirection = 1000;
    protected Vector BatchVector = new Vector();
    protected Vector BatchParamVector = new Vector();
    protected boolean executeBatchInProgress = false;
    protected IfxResultSetMetaData outputMetaData = null;
    protected int statementType = 0;
    private int maxFieldSize;
    protected boolean Closed = false;
    private int timeoutSeconds = 0;
    private boolean versionCheckOK = false;
    Class cquery = null;
    protected static final short SGK_NO_KEYS = 0;
    protected static final short SGK_ALL_KEYS = 1;
    protected static final short SGK_KEYS_BY_INDEX = 2;
    protected static final short SGK_KEYS_BY_NAME = 3;
    short SGK_returnGeneratedKeys = 0;
    protected int[] SGK_indexes = null;
    protected String[] SGK_names = null;
    protected IfxResultSetMetaData SGK_metaData = null;
    protected IfxClientResultSet SGK_resultSet = null;

    IfxStatement(IfxConnection ifxConnection) throws SQLException {
        this.jconn = ifxConnection;
        if (this.jconn != null) {
            this.autoFree = ((IfxSqliConnect)this.jconn).getAutoFree();
        }
        if (this.jconn != null) {
            this.setResultSetHoldability(((IfxSqliConnect)this.jconn).isHoldable());
            try {
                Class<?> clazz = Class.forName(ifxConnection.getProtoClassName());
                Class<?> clazz2 = Class.forName(ifxConnection.getConnClassName());
                Class[] classArray = new Class[]{clazz2};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{ifxConnection};
                this.prot = (IfxProtocol)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79735, exception.toString(), ifxConnection);
            }
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(string);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeQueryImpl(this.isRsHoldable());
    }

    @Override
    public ResultSet executeQuery(String string, boolean bl) throws SQLException {
        this.validate(string);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeQueryImpl(bl);
    }

    void validate(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this.jconn == null || this.jconn.isClosed()) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.SGK_returnGeneratedKeys = 0;
        return this.executeUpdateBody(string);
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        if (n == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (n == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        return this.executeUpdateBody(string);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        if (nArray == null || nArray.length <= 0) {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])nArray.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        return this.executeUpdateBody(string);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        if (stringArray == null || stringArray.length <= 0) {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])stringArray.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        return this.executeUpdateBody(string);
    }

    private int executeUpdateBody(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(string);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeUpdateImpl();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.getGeneratedKeys()", this.jconn);
        }
        IfxSqli ifxSqli = (IfxSqli)this.prot;
        if (ifxSqli.SGK_rowColumn == null) {
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(0, this.jconn);
            this.SGK_resultSet = new IfxClientResultSet(this.jconn, ifxResultSetMetaData);
        } else {
            this.SGK_metaData = (IfxResultSetMetaData)ifxSqli.getSGK_metaData();
            this.SGK_resultSet = new IfxClientResultSet(this.jconn, this.SGK_metaData);
            while (ifxSqli.getNextSGKRow()) {
                this.SGK_resultSet.newRow(1);
                for (int i = 1; i <= this.SGK_metaData.getColumnCount(); ++i) {
                    IfxObject ifxObject = ifxSqli.SGK_rowColumn.getColumn(i);
                    this.SGK_resultSet.updateIfxObject(i, (Object)ifxObject);
                }
            }
        }
        this.SGK_resultSet.beforeFirst();
        this.SGK_resultSet.setType(1003);
        this.SGK_resultSet.setFetchDirection(1000);
        this.SGK_resultSet.setConcurrency(1007);
        return this.SGK_resultSet;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.Closed = true;
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        if (this.cursorOpen) {
            this.prot.executeClose(this);
        }
        this.prot.executeRelease(this);
        if (this.jconn != null) {
            ((IfxSqliConnect)this.jconn).removeFromStmtList(this);
        }
        this.cursorName = null;
        this.statementWarnings = null;
        this.jconn = null;
        this.commandString = null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79877, this.jconn);
        }
        this.maxFieldSize = n;
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLMinorException(-79731, -80007, this.jconn);
        }
        this.maxRows = n;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.escapeProcessing = bl;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.timeoutSeconds;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (IfxDriver.compareJDKVersion("1.4") < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": Statement.setQueryTimeout(int).", this.jconn);
        }
        if (!this.versionCheckOK) {
            try {
                Class<?> clazz = Class.forName("java.util.Timer");
                Class<?> clazz2 = Class.forName("java.util.TimerTask");
                this.cquery = Class.forName("com.informix.jdbc.IfxCancelQueryImpl");
                this.versionCheckOK = true;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79700, ": Statement.setQueryTimeout(int).", this.jconn);
            }
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79773, this.jconn);
        }
        this.timeoutSeconds = n;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (IfxDriver.compareJDKVersion("1.4") < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": Statement.cancel().", this.jconn);
        }
        try {
            ((IfxSqliConnect)this.jconn).asfconn.sOOBSocket();
        }
        catch (IfxASFException ifxASFException) {
            throw IfxErrMsg.getSQLException(-908, this.jconn);
        }
    }

    private void addWarning(String string, String string2) {
        if (this.statementWarnings == null) {
            this.statementWarnings = string2 != null ? IfxWarnMsg.getSQLWarning(string2, string, this.jconn) : IfxWarnMsg.getSQLWarning(string, this.jconn);
        } else if (string2 != null) {
            SQLWarning sQLWarning = IfxWarnMsg.getSQLWarning(string2, string, this.jconn);
            this.statementWarnings.setNextWarning(sQLWarning);
        } else {
            SQLWarning sQLWarning = IfxWarnMsg.getSQLWarning(string, this.jconn);
            this.statementWarnings.setNextWarning(sQLWarning);
        }
    }

    void chainWarnings(SQLWarning sQLWarning) throws SQLException {
        if (sQLWarning != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(sQLWarning);
            } else {
                this.statementWarnings = sQLWarning;
            }
        }
    }

    protected void transferWarnings() throws SQLException {
        SQLWarning sQLWarning;
        if (this.currentResult != null && (sQLWarning = this.currentResult.getWarnings()) != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(sQLWarning);
            } else {
                this.statementWarnings = sQLWarning;
            }
            this.currentResult.clearWarnings();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.chainWarnings(this.currentResult.getWarnings());
        }
        return this.statementWarnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.clearWarnings();
        }
        this.statementWarnings = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (string.length() <= 0) {
            throw IfxErrMsg.getSQLException(-79732, this.jconn);
        }
        this.cursorName = string;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.SGK_returnGeneratedKeys = 0;
        return this.executeBody(string);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, int)", this.jconn);
        }
        if (n == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (n == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        return this.executeBody(string);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, int[])", this.jconn);
        }
        if (nArray == null || nArray.length <= 0) {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])nArray.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        return this.executeBody(string);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, String[])", this.jconn);
        }
        if (stringArray == null || stringArray.length <= 0) {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])stringArray.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        return this.executeBody(string);
    }

    private boolean executeBody(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(string);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeImpl();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.chkAndSetGetRsltCalledFlag();
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        if (this.currentResult.isClosed() || this.currentResult.getUpdateCount() != -1) {
            return null;
        }
        return this.currentResult;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.calledgetUpdateCount) {
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetUpdateCount = true;
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        return this.currentResult.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.clearWarnings();
            this.currentResult.close();
        }
        this.resetMethodCalledFlags();
        return false;
    }

    public String getCursorName() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.cursorName != null) {
            return this.cursorName;
        }
        return this.getGeneratedCursor();
    }

    private String getGeneratedCursor() throws SQLException {
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        this.cursorName = this.jconn.getGeneratedCursor();
        return this.cursorName;
    }

    int getqmarks() {
        return this.numqmarks;
    }

    void setqmarks(int n) {
        this.numqmarks = n;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.jconn;
    }

    protected ResultSet executeQueryImpl(boolean bl) throws SQLException {
        this.resetMethodCalledFlags();
        IfmxCancelQuery ifmxCancelQuery = null;
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.clearWarnings();
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery = (IfmxCancelQuery)this.cquery.newInstance();
                ifmxCancelQuery.startCancel(this, this.timeoutSeconds);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        if (this.outputMetaData != null) {
            this.currentResult.executeQuery(this.outputMetaData, bl);
        } else {
            this.currentResult.executeQuery(bl);
        }
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery.stopCancel();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        this.transferWarnings();
        return this.currentResult;
    }

    int executeUpdateImpl() throws SQLException {
        this.resetMethodCalledFlags();
        int n = 0;
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.clearWarnings();
        n = this.currentResult.executeUpdate();
        if (n == 0 && this.commandString.toLowerCase().indexOf("isolation") != -1) {
            ((IfxSqliConnect)this.jconn).setTxnIsolationLvl(this.commandString);
        }
        this.transferWarnings();
        return n;
    }

    protected boolean executeImpl() throws SQLException {
        return this.executeImpl(this.isRsHoldable());
    }

    boolean executeImpl(boolean bl) throws SQLException {
        this.resetMethodCalledFlags();
        IfmxCancelQuery ifmxCancelQuery = null;
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.clearWarnings();
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery = (IfmxCancelQuery)this.cquery.newInstance();
                ifmxCancelQuery.startCancel(this, this.timeoutSeconds);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        boolean bl2 = this.outputMetaData != null ? this.currentResult.executeExecute(bl, this.outputMetaData) : this.currentResult.executeExecute(bl);
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery.stopCancel();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        this.transferWarnings();
        return bl2;
    }

    @Override
    public int getSerial() throws SQLException {
        if (this.currentResult == null) {
            return 0;
        }
        return this.currentResult.getSerial();
    }

    @Override
    public long getSerial8() throws SQLException {
        if (this.currentResult == null) {
            return 0L;
        }
        return this.currentResult.getSerial8();
    }

    @Override
    public long getBigSerial() throws SQLException {
        if (this.currentResult == null) {
            return 0L;
        }
        return this.currentResult.getBigSerial();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n != 1000 && n != 1001 && n != 1002) {
            throw IfxErrMsg.getSQLException(-79764, this.jconn);
        }
        if (this.getResultSetType() == 1003 && n != 1000) {
            throw IfxErrMsg.getSQLException(-79765, this.jconn);
        }
        this.FetchDirection = n;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.FetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0 || this.maxRows != 0 && n > this.maxRows) {
            throw IfxErrMsg.getSQLException(-79766, this.jconn);
        }
        this.FetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.FetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.ResultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.ResultSetType;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(string);
        this.commandString = this.commandString.trim();
        if (!this.commandString.endsWith(";")) {
            this.commandString = this.commandString + ";";
        }
        this.BatchVector.addElement(this.commandString);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.BatchVector.removeAllElements();
        if (!this.jconn.isDirect()) {
            this.scrubBatch();
        }
    }

    protected void scrubBatch() throws SQLException {
        IfxSqli ifxSqli;
        this.executeBatchInProgress = false;
        if (this.currentResult != null && (ifxSqli = (IfxSqli)this.prot) != null) {
            ifxSqli.clearBatch();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int n;
        int[] nArray = null;
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.executeBatchInProgress = true;
        this.commandString = "";
        if (this.BatchVector.size() == 0) {
            return new int[0];
        }
        for (n = 0; n < this.BatchVector.size(); ++n) {
            this.commandString = this.commandString + this.BatchVector.elementAt(n);
        }
        if (!this.jconn.isDirect() && ((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
            try {
                n = this.executeUpdateImpl();
                IfxSqli ifxSqli = (IfxSqli)this.prot;
                ArrayList arrayList = ifxSqli.batchRowStatus;
                nArray = new int[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                }
                ifxSqli.batchRowStatus.clear();
            }
            catch (SQLException sQLException) {
                IfxSqli ifxSqli = (IfxSqli)this.prot;
                ArrayList arrayList = ifxSqli.batchRowStatus;
                this.executeBatchInProgress = false;
                if (arrayList != null) {
                    nArray = new int[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        nArray[i] = (Integer)arrayList.get(i);
                    }
                    ifxSqli.batchRowStatus.clear();
                    this.clearBatch();
                    throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
                }
                this.clearBatch();
                throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new int[0]);
            }
        }
        try {
            nArray = new int[this.BatchVector.size()];
            nArray[0] = this.executeUpdateImpl();
            for (n = 1; n < this.BatchVector.size(); ++n) {
                nArray[n] = -2;
            }
        }
        catch (SQLException sQLException) {
            this.clearBatch();
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new int[0]);
        }
        this.clearBatch();
        this.executeBatchInProgress = false;
        return nArray;
    }

    protected void setResultSetType(int n) throws SQLException {
        if (n != 1004 && n != 1003) {
            this.addWarning(IfxErrMsg.getSQLException(-79775, this.jconn).toString(), "01000");
        }
        this.ResultSetType = n == 1005 ? 1004 : n;
    }

    protected void setResultSetConcurrency(int n) throws SQLException {
        if (n != 1008 && n != 1007) {
            throw IfxErrMsg.getSQLException(-79773, this.jconn);
        }
        this.ResultSetConcurrency = n;
    }

    @Override
    public void setAutoFree(boolean bl) {
        this.autoFree = bl && this.jconn.isAutoFree() ? bl : false;
    }

    void setResultSetHoldability(boolean bl) {
        this.isRsHoldable = bl;
    }

    @Override
    public boolean getAutoFree() {
        return this.autoFree;
    }

    protected void setStatementType(int n) {
        this.statementType = n;
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.getMoreResults(int)", this.jconn);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.isRsHoldable() ? 1 : 2;
    }

    boolean isRsHoldable() {
        return this.isRsHoldable;
    }

    protected void chkAndSetGetRsltCalledFlag() throws SQLException {
        if (this.calledgetResultSet) {
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetResultSet = true;
    }

    protected void resetMethodCalledFlags() {
        this.calledgetResultSet = false;
        this.calledgetUpdateCount = false;
    }

    void setIsReleased(boolean bl) {
        IfxSqli ifxSqli = (IfxSqli)this.prot;
        ifxSqli.setIsReleased(bl);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "isCloseOnCompletion", (IfxConnection)null);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "closeOnCompletion", (IfxConnection)null);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "isPoolable", (IfxConnection)null);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "poolable", (IfxConnection)null);
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "isClosed", (IfxConnection)null);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "isWrapperFor", (IfxConnection)null);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, "unwrap", (IfxConnection)null);
    }
}

