/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class JavaToIfxType {
    public static final int IFX_INT_SIZE = 4;
    public static final int BYTESHIFT = 8;
    public static final int BYTEMASK = 255;
    public static final int IFX_LGINT_SIZE = 10;
    public static final int IFX_SMINT_SIZE = 2;
    public static final int IFX_SMFLOAT_SIZE = 4;
    public static final int IFX_LONG_SIZE = 8;
    public static final int IFX_DOUBLE_SIZE = 8;
    public static final int DefDblScale = 10;
    public static final int DefFltScale = 10;
    static final String defaultEncoding = "ISO8859_1";
    CharsetEncoder enc = null;
    CharsetEncoder defenc = null;
    protected static final boolean TruncateFractSec = true;
    static final int NanosPerSecond = 1000000000;
    static final int MilliPerSecond = 1000;
    static final int SecondsPerMinute = 60;
    static final int SecondsPerHour = 3600;
    static final int SecondsPerDay = 86400;
    static final int MonthsPerYear = 12;
    public static byte[] DATETIME_PREC = new byte[2];
    public static short DP_SHORT;

    public static byte[] JavaToIfxInt(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public byte[] JavaToIfxChar(String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[n + 2];
        byte[] byArray2 = this.doConversion(string, defaultEncoding);
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        System.arraycopy(byArray2, 0, byArray, 2, n);
        return byArray;
    }

    public byte[] JavaToIfxChar(String string, String string2) throws IOException {
        byte[] byArray = null;
        byArray = string2 != null ? this.doConversion(string, string2) : this.doConversion(string, defaultEncoding);
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 2];
        byArray2[0] = (byte)(n >> 8 & 0xFF);
        byArray2[1] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 2, n);
        return byArray2;
    }

    public byte[] JavaToIfxVarChar(String string, String string2, int n) throws IOException {
        byte[] byArray = null;
        byArray = string2 != null ? this.doConversion(string, string2) : this.doConversion(string, defaultEncoding);
        byte[] byArray2 = new byte[n + 1];
        memoryUtil.byfill(byArray2, (byte)0);
        int n2 = byArray.length;
        int n3 = Math.min(n2, n);
        byArray2[0] = (byte)(n3 & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 1, n3);
        return byArray2;
    }

    public byte[] JavaToIfxLvarchar(String string, String string2) throws IOException {
        byte[] byArray = null;
        byArray = string2 != null ? this.doConversion(string, string2) : this.doConversion(string, defaultEncoding);
        return byArray;
    }

    public static byte[] JavaToIfxDate(Date date) {
        int n = IfxToJavaType.convertDateToDays(date);
        return JavaToIfxType.JavaToIfxInt(n);
    }

    public static String convertNanosToFract(int n) {
        char[] cArray = new char[5];
        double d = (double)n / 10000.0 + 0.0;
        String string = Integer.toString((int)d);
        Decimal.charfill(cArray, 0, 4, '0');
        int n2 = string.length() - 6;
        int n3 = 4;
        int n4 = string.length() - 1;
        while (n4 >= 0 && n4 >= n2) {
            cArray[n3] = string.charAt(n4);
            --n4;
            --n3;
        }
        return new String(cArray);
    }

    public static Decimal convertTimestampToDecimal(Timestamp timestamp) {
        return JavaToIfxType.convertTimestampToDecimal(timestamp, null);
    }

    public static Decimal convertTimestampToDecimal(Timestamp timestamp, Calendar calendar) {
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            calendar2 = Calendar.getInstance();
        }
        calendar2.setTime(timestamp);
        int n = calendar2.get(1);
        int n2 = calendar2.get(2) + 1;
        int n3 = calendar2.get(5);
        int n4 = calendar2.get(11);
        int n5 = calendar2.get(12);
        int n6 = calendar2.get(13);
        int n7 = timestamp.getNanos();
        return new Decimal(n, n2, n3, n4, n5, n6, n7 / 10000);
    }

    public static Decimal convertTimeToDecimal(Time time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        return new Decimal(0, 0, 0, n, n2, n3, 0);
    }

    public static String convertIntervalToString(IntervalDF intervalDF) {
        StringBuffer stringBuffer = new StringBuffer();
        short s = intervalDF.getQualifier();
        int n = IntervalDF.getStartCode(s);
        byte by = IntervalDF.getEndCode(s);
        int n2 = intervalDF.getLength() - (by - n);
        long l = intervalDF.getSeconds();
        long l2 = intervalDF.getNanoSeconds();
        if (l < 0L || l == 0L && l2 < 0L) {
            stringBuffer.append("-");
            l = -l;
            l2 = -l2;
        }
        int n3 = n;
        Object var12_9 = null;
        block6: while (by >= n3) {
            int n4;
            switch (n3) {
                case 4: {
                    n4 = (int)Math.floor(l / 86400L);
                    stringBuffer.append(JavaToIfxType.stringWithLFP(n4, n2));
                    l %= 86400L;
                    n3 += 2;
                    continue block6;
                }
                case 6: {
                    n4 = (int)Math.floor(l / 3600L);
                    if (n3 == n) {
                        stringBuffer.append(JavaToIfxType.stringWithLFP(n4, n2));
                    } else {
                        if (n4 < 10 && n3 != n) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(String.valueOf(n4));
                    }
                    l %= 3600L;
                    n3 += 2;
                    continue block6;
                }
                case 8: {
                    n4 = (int)Math.floor(l / 60L);
                    if (n3 == n) {
                        stringBuffer.append(JavaToIfxType.stringWithLFP(n4, n2));
                    } else {
                        if (n4 < 10 && n3 != n) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(String.valueOf(n4));
                    }
                    l %= 60L;
                    n3 += 2;
                    continue block6;
                }
                case 10: {
                    if (n3 == n) {
                        stringBuffer.append(JavaToIfxType.stringWithLFP((int)l, n2));
                    } else {
                        if (l < 10L && n3 != n) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(String.valueOf(l));
                    }
                    ++n3;
                    continue block6;
                }
            }
            stringBuffer.append(".");
            n4 = 15 - by - 1 + 4;
            for (int i = 0; i <= n4; ++i) {
                l2 /= 10L;
            }
            stringBuffer.append(String.valueOf(l2));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static Decimal convertIntervalToDecimal(IntervalDF intervalDF) {
        byte[] byArray = new byte[20];
        boolean bl = false;
        int n = 0;
        short s = intervalDF.getQualifier();
        int n2 = IntervalDF.getStartCode(s);
        int n3 = IntervalDF.getEndCode(s);
        int n4 = intervalDF.getLength() - (n3 - n2);
        long l = intervalDF.getSeconds();
        long l2 = intervalDF.getNanoSeconds();
        if (l < 0L || l == 0L && l2 < 0L) {
            bl = true;
            l = -l;
            l2 = -l2;
        }
        if (n2 == 12) {
            n2 = 11;
        }
        int n5 = 0;
        for (int i = n2; n3 >= i; i += n5) {
            int n6;
            int n7;
            int n8;
            switch (i) {
                case 4: {
                    n8 = (int)(l / 86400L);
                    l %= 86400L;
                    n5 = 2;
                    break;
                }
                case 6: {
                    n8 = (int)(l / 3600L);
                    l %= 3600L;
                    n5 = 2;
                    break;
                }
                case 8: {
                    n8 = (int)(l / 60L);
                    l %= 60L;
                    n5 = 2;
                    break;
                }
                case 10: {
                    n8 = (int)l;
                    n5 = 1;
                    break;
                }
                default: {
                    n8 = 15 - n3 - 1 + 4;
                    for (n7 = 0; n7 <= n8; ++n7) {
                        l2 /= 10L;
                    }
                    for (n8 = n3 - i + 1; n8 > 0; n8 -= 2) {
                        n7 = 1;
                        for (n6 = n8 - 2; n6 > 0; --n6) {
                            n7 *= 10;
                        }
                        if (n8 == 1) {
                            l2 *= 10L;
                        }
                        byArray[n] = (byte)(l2 / (long)n7);
                        l2 %= (long)n7;
                        ++n;
                    }
                    i += 10;
                }
            }
            if (i == n2) {
                if (n4 % 2 > 0) {
                    n7 = 1;
                    for (n6 = --n4; n6 > 0; --n6) {
                        n7 *= 10;
                    }
                    byArray[n] = (byte)(n8 / n7);
                    n8 %= n7;
                    ++n;
                }
                while (n4 > 0) {
                    n7 = 1;
                    for (n6 = n4 -= 2; n6 > 0; --n6) {
                        n7 *= 10;
                    }
                    byArray[n] = (byte)(n8 / n7);
                    n8 %= n7;
                    ++n;
                }
                continue;
            }
            if (i > n3) continue;
            byArray[n] = (byte)n8;
            ++n;
        }
        return new Decimal(bl, byArray, n, intervalDF.getQualifier());
    }

    private static String stringWithLFP(int n, int n2) {
        int n3;
        String string = "";
        String string2 = String.valueOf(n);
        for (int i = n3 = n2 - string2.length(); i > 0; --i) {
            string = string + "0";
        }
        string = string + string2;
        return string;
    }

    public static String convertIntervalToString(IntervalYM intervalYM) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        short s = intervalYM.getQualifier();
        byte by = IntervalYM.getStartCode(s);
        byte by2 = IntervalYM.getEndCode(s);
        int n = intervalYM.getLength() - (by2 - by);
        long l = intervalYM.getMonths();
        if (l < 0L) {
            l = -l;
            stringBuffer.append("-");
        }
        if (by == 2) {
            stringBuffer.append(JavaToIfxType.stringWithLFP((int)l, n));
        } else {
            int n2 = (int)(l / 12L);
            stringBuffer.append(JavaToIfxType.stringWithLFP(n2, n));
            if (by2 == 2) {
                string = String.valueOf(l % 12L);
                if (string.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static Decimal convertIntervalToDecimal(IntervalYM intervalYM) {
        byte[] byArray = new byte[20];
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        short s = intervalYM.getQualifier();
        byte by = IntervalYM.getStartCode(s);
        byte by2 = IntervalYM.getEndCode(s);
        int n2 = intervalYM.getLength() - (by2 - by);
        long l = intervalYM.getMonths();
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        if (by == 2) {
            int n3;
            int n4;
            if (n2 % 2 > 0) {
                n4 = 1;
                for (n3 = --n2; n3 > 0; --n3) {
                    n4 *= 10;
                }
                byArray[n] = (byte)(l / (long)n4);
                l %= (long)n4;
                ++n;
            }
            while (n2 > 0) {
                n4 = 1;
                for (n3 = n2 -= 2; n3 > 0; --n3) {
                    n4 *= 10;
                }
                byArray[n] = (byte)(l / (long)n4);
                l %= (long)n4;
                ++n;
            }
        } else {
            int n5;
            int n6;
            int n7 = (int)(l / 12L);
            if (n2 % 2 > 0) {
                n6 = 1;
                for (n5 = --n2; n5 > 0; --n5) {
                    n6 *= 10;
                }
                byArray[n] = (byte)(n7 / n6);
                n7 %= n6;
                ++n;
            }
            while (n2 > 0) {
                n6 = 1;
                for (n5 = n2 -= 2; n5 > 0; --n5) {
                    n6 *= 10;
                }
                byArray[n] = (byte)(n7 / n6);
                n7 %= n6;
                ++n;
            }
            if (by2 == 2) {
                byArray[n] = (byte)(l % 12L);
                ++n;
            }
        }
        return new Decimal(bl, byArray, n, intervalYM.getQualifier());
    }

    public static byte[] JavaToIfxDateTime(Timestamp timestamp) {
        return JavaToIfxType.JavaToIfxDateTime(timestamp, null);
    }

    public static byte[] JavaToIfxDateTime(Timestamp timestamp, Calendar calendar) {
        return JavaToIfxType.convertTimestampToDecimal(timestamp, calendar).javaToIfx();
    }

    public static byte[] JavaToIfxDateTime(Time time) {
        return JavaToIfxType.convertTimeToDecimal(time).javaToIfx();
    }

    public static byte[] JavaToIfxInterval(IntervalDF intervalDF) {
        byte[] byArray = JavaToIfxType.convertIntervalToDecimal(intervalDF).javaToIfx();
        return byArray;
    }

    public static byte[] JavaToIfxInterval(IntervalYM intervalYM) {
        byte[] byArray = JavaToIfxType.convertIntervalToDecimal(intervalYM).javaToIfx();
        return byArray;
    }

    public static final byte[] JavaToIfxDecimalNull(short s) {
        byte by = (byte)(s >> 8 & 0xFF);
        byte by2 = (byte)(s & 0xF);
        byte by3 = (byte)((by + (by2 & 1) + 1) / 2);
        byte[] byArray = new byte[by3 + 1];
        memoryUtil.byfill(byArray, (byte)0);
        return byArray;
    }

    public static final byte[] JavaToIfxDecimal(BigDecimal bigDecimal) {
        Decimal decimal;
        byte[] byArray = new byte[18];
        if (bigDecimal == null) {
            for (int i = 0; i < 18; ++i) {
                byArray[i] = 0;
            }
            decimal = new Decimal(byArray);
        } else {
            decimal = new Decimal(bigDecimal);
        }
        return decimal.javaToIfx();
    }

    public static final byte[] JavaToIfxDouble(Double d) {
        return JavaToIfxType.JavaToIfxDouble((double)d);
    }

    public static final byte[] JavaToIfxDouble(double d) {
        byte[] byArray = new byte[8];
        long l = Double.doubleToLongBits(d);
        byArray[0] = (byte)(l >> 56 & 0xFFL);
        byArray[1] = (byte)(l >> 48 & 0xFFL);
        byArray[2] = (byte)(l >> 40 & 0xFFL);
        byArray[3] = (byte)(l >> 32 & 0xFFL);
        byArray[4] = (byte)(l >> 24 & 0xFFL);
        byArray[5] = (byte)(l >> 16 & 0xFFL);
        byArray[6] = (byte)(l >> 8 & 0xFFL);
        byArray[7] = (byte)(l & 0xFFL);
        return byArray;
    }

    public static final byte[] JavaToIfxReal(Float f) {
        return JavaToIfxType.JavaToIfxReal(f.floatValue());
    }

    public static byte[] JavaToIfxReal(float f) {
        int n = Float.floatToIntBits(f);
        return JavaToIfxType.JavaToIfxInt(n);
    }

    public static byte[] JavaToIfxSmallInt(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8), (byte)s};
        return byArray;
    }

    public static byte[] JavaToIfxLongInt(long l) {
        byte[] byArray = new byte[10];
        short s = 1;
        if (l < 0L) {
            s = -1;
            l = -l;
        }
        byte[] byArray2 = JavaToIfxType.JavaToIfxSmallInt(s);
        System.arraycopy(byArray2, 0, byArray, 0, 2);
        long l2 = l & 0xFFFFFFFFL;
        byte[] byArray3 = JavaToIfxType.JavaToIfxInt((int)l2);
        System.arraycopy(byArray3, 0, byArray, 2, 4);
        int n = (int)(l >> 32);
        byte[] byArray4 = JavaToIfxType.JavaToIfxInt(n);
        System.arraycopy(byArray4, 0, byArray, 6, 4);
        return byArray;
    }

    public static byte[] JavaToIfxLongBigInt(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        return byArray;
    }

    private byte[] doConversion(String string, String string2) throws IOException {
        if (JavaToIfxType.compareJDKVer("1.4") >= 0) {
            byte[] byArray = null;
            CharsetEncoder charsetEncoder = null;
            if (!string2.equals(defaultEncoding)) {
                if (this.enc == null) {
                    this.enc = Charset.forName(string2).newEncoder();
                }
                charsetEncoder = this.enc;
            } else {
                if (this.defenc == null) {
                    this.defenc = Charset.forName(string2).newEncoder();
                }
                charsetEncoder = this.defenc;
            }
            charsetEncoder.reset();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
                byArray = JavaToIfxType.copyToByteArray(byteBuffer.array(), byteBuffer.limit());
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IOException(IfxErrMsg.getMessage(-23103, string, (String)null));
            }
            return byArray;
        }
        throw new IOException("Unsupported JDK version exception, Supported JDK version is 1.4 or higher");
    }

    private static byte[] copyToByteArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < Math.min(n, byArray.length); ++i) {
            byArray2[i] = byArray[i];
        }
        return byArray2;
    }

    protected static int compareJDKVer(String string) {
        Object var1_1 = null;
        boolean bl = false;
        String string2 = null;
        String string3 = System.getProperty("java.version");
        if (string3 != null && string != null) {
            int n = string3.length();
            int n2 = 0;
            while (!bl && n2 < n) {
                char c = string3.charAt(n2);
                if (c >= '0' && c <= '9') {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            string2 = string3.substring(n2);
            return string2.compareTo(string);
        }
        throw new Error("Error In Comparing JDK Versions");
    }

    static {
        Decimal.encodeDateTimePrecision(DATETIME_PREC, (byte)0, (byte)15);
        DP_SHORT = (short)(DATETIME_PREC[0] * 256 + DATETIME_PREC[1]);
    }
}

