/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nws.ffdc;

import com.ibm.nws.ffdc.CallStack;
import com.ibm.nws.ffdc.Configure;
import com.ibm.nws.ffdc.DiagnosticModule;
import com.ibm.nws.ffdc.IncidentStream;
import com.ibm.nws.ffdc.IncidentStreamManager;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class DiagnosticEngine {
    private static int processLevel = 0;
    private static Hashtable globalHashTableOfDM = new Hashtable();
    private static final ThreadLocal threadLocalIncidentStream = new ThreadLocal();
    private static final ThreadLocal threadLocalHTofDM = new ThreadLocal();

    private DiagnosticEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerDM(DiagnosticModule diagnosticModule, String string) {
        Hashtable hashtable = globalHashTableOfDM;
        synchronized (hashtable) {
            Integer n = new Integer(string.hashCode());
            if (globalHashTableOfDM.containsKey(n)) {
                return false;
            }
            globalHashTableOfDM.put(n, diagnosticModule);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processIncident(Object object, Throwable throwable, String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, long l, String string5, Object[] objectArray) {
        processLevel = Configure.processLevel;
        String string6 = null;
        String string7 = null;
        int n = 0;
        int n2 = 2;
        Hashtable hashtable = (Hashtable)threadLocalHTofDM.get();
        if (hashtable == null) {
            hashtable = new Hashtable();
            threadLocalHTofDM.set(hashtable);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Date date = new Date();
        FieldPosition fieldPosition = new FieldPosition(0);
        IncidentStream incidentStream = (IncidentStream)threadLocalIncidentStream.get();
        if (incidentStream == null) {
            incidentStream = IncidentStreamManager.getIncidentStream();
            threadLocalIncidentStream.set(incidentStream);
        } else {
            IncidentStreamManager.openIncidentStream();
        }
        date.setTime(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        DiagnosticEngine.formatTime(stringBuffer, simpleDateFormat, date, fieldPosition);
        incidentStream.write("------Start of DE processing------", stringBuffer.toString());
        incidentStream.writeLine(", key", string5);
        if (object != null) {
            string7 = DiagnosticEngine.analyzeObject(object);
        } else {
            n = CallStack.currentExecutionPoint(stringArray2);
            if (stringArray2 != null && n > 0 && n < stringArray2.length) {
                string6 = stringArray2[n];
                string7 = DiagnosticEngine.getPackageName(string6);
            }
        }
        switch (processLevel) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                incidentStream.introspectAndWriteLine("Stack Dump", string4);
                break;
            }
            case 3: {
                DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
                break;
            }
            case 4: {
                n2 = 0;
                DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
                DiagnosticModule diagnosticModule = null;
                Hashtable hashtable2 = globalHashTableOfDM;
                synchronized (hashtable2) {
                    diagnosticModule = DiagnosticEngine.findDM(string7);
                }
                if (diagnosticModule == null) {
                    n2 = 3;
                    DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
                    break;
                }
                try {
                    diagnosticModule.dumpComponentData(stringArray, throwable, incidentStream, object, objectArray, string2, stringArray2);
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    private static DiagnosticModule findDM(String string) {
        String string2 = string;
        boolean bl = false;
        DiagnosticModule diagnosticModule = null;
        while (!bl) {
            Integer n = new Integer(string2.hashCode());
            if (globalHashTableOfDM.containsKey(n)) {
                diagnosticModule = (DiagnosticModule)globalHashTableOfDM.get(n);
                bl = true;
                continue;
            }
            if ((string2 = DiagnosticEngine.trim(string2)) != null) continue;
            return null;
        }
        return diagnosticModule;
    }

    private static String trim(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    private static void dumpObjectAndStack(String string, String string2, String string3, Object object, String string4, int n, IncidentStream incidentStream) {
        incidentStream.writeLine("Exception", string);
        incidentStream.writeLine("Source", string2);
        incidentStream.writeLine("probeid", string3);
        if (n < 3) {
            incidentStream.writeLine("Stack Dump", string4);
        }
        incidentStream.introspectAndWriteLine("Dump of callerThis", object, n);
    }

    private static String analyzeObject(Object object) {
        return object.getClass().getName();
    }

    private static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private static void formatTime(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        stringBuffer.setLength(0);
        stringBuffer.append('[');
        dateFormat.format(date, stringBuffer, fieldPosition);
        stringBuffer.append("] ");
    }
}

