/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.lateattach;

import com.ibm.java.diagnostics.healthcenter.agent.lateattach.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.tools.attach.AgentInitializationException;
import com.ibm.tools.attach.AgentLoadException;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.VirtualMachine;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Logger;

public class AttachAgent {
    public static final int attachAgent_OK = 0;
    public static final int attachAgent_ERR = -1;
    public static final int attachAgent_ALREADY_LOADED = -2;
    public static final int attachAgent_JVMTI_ERR = -3;
    public static final int attachAgent_MBEAN_ERR = -4;
    public static final int attachAgent_MBEAN_EXC = -5;
    private static final String[] attachAgent_message_keys;
    private static String CONFIG;
    private static List<VirtualMachineDescriptor> vmList;
    private static final Class<?> thisClass;
    private static final Logger logger;
    private static final String ID_KEY = "ID";
    private static final String NORETRY_OPTION = "-noretry";
    private static final String EXTRACT_OPTION = "-extract";
    private static final String OVERRIDE_OPTION = "-override";
    private static final String BIN = "bin";
    private static final String EXT = "ext";
    private static final String HC_DLL = "healthcenter.dll";
    private static final String HC_SO = "libhealthcenter.so";
    private static String remoteAgentPath;
    private static final String REMOTE_AGENT_PROPERTY = "-Dcom.ibm.java.diagnostics.healthcenter.agent.path";

    public static void init(String[] args) {
        int libraryLoaded = -1;
        boolean noretry = false;
        int vmNumber = -1;
        String targetVM = null;
        String hcOptions = null;
        Properties hcProps = null;
        String VMid = null;
        for (int arg_index = 0; arg_index < args.length; ++arg_index) {
            String overridePath;
            String id = HealthCenterOptionHandler.processOption(args[arg_index], ID_KEY);
            if (id != null) {
                VMid = id;
                args[arg_index] = null;
            }
            if (NORETRY_OPTION.equalsIgnoreCase(args[arg_index])) {
                noretry = true;
                args[arg_index] = null;
            }
            if (EXTRACT_OPTION.equalsIgnoreCase(args[arg_index])) {
                AttachAgent.extractPropertyFiles();
                System.exit(0);
            }
            if (!OVERRIDE_OPTION.equalsIgnoreCase(args[arg_index])) continue;
            File f = new File(".");
            String path = f.getAbsolutePath();
            if (path.length() > 0 && path.charAt(path.length() - 1) == '.') {
                path = path.substring(0, path.length() - 2);
            }
            path = path.replace('\\', '/');
            args[arg_index] = overridePath = String.format(CONFIG, path);
        }
        hcOptions = AttachAgent.buildOptions(args);
        if (hcOptions == null) {
            System.exit(1);
        }
        if (!hcOptions.contains("event=") && !hcOptions.contains("com.ibm.java.diagnostics.healthcenter.data.collection.event")) {
            String value = System.getProperty("com.ibm.java.diagnostics.healthcenter.data.collection.event", "");
            hcOptions = value.equals("") ? "event=none," + hcOptions : "event=" + value + "," + hcOptions;
        }
        if (!hcOptions.contains("level=") && !hcOptions.contains("com.ibm.java.diagnostics.healthcenter.data.collection.level")) {
            String value = System.getProperty("com.ibm.java.diagnostics.healthcenter.data.collection.level", "");
            hcOptions = value.equals("") ? "level=full," + hcOptions : "level=" + value + "," + hcOptions;
        }
        while (libraryLoaded != 0 && VMid != null) {
            hcProps = new Properties();
            libraryLoaded = AttachAgent.ConnectandLoadLibrary(VMid, hcOptions, hcProps);
            if (libraryLoaded == 0) {
                targetVM = VMid;
                continue;
            }
            if (noretry) break;
            Messages.issueMessage("AttachAgent.pid.prompt", new Object[0]);
            VMid = AttachAgent.readLine();
            if (VMid.length() != 0) continue;
            Messages.issueMessage("AttachAgent.pid.empty", new Object[0]);
            VMid = null;
        }
        while (libraryLoaded != 0 && !noretry) {
            vmList = VirtualMachine.list();
            String vmNumberString = "";
            if (vmList != null && vmList.size() > 0) {
                Messages.issueMessage("AttachAgent.vmlist.header", new Object[0]);
                for (int i = 0; i < vmList.size(); ++i) {
                    Messages.issueMessage("AttachAgent.vmlist.entry", i + 1, vmList.get(i).displayName(), vmList.get(i).id());
                }
                Messages.issueMessage("AttachAgent.vmlist.prompt", vmList.size());
                vmNumberString = AttachAgent.readLine();
                if (vmNumberString.length() == 0) {
                    Messages.issueMessage("AttachAgent.vmlist.quit", new Object[0]);
                    break;
                }
                vmNumber = AttachAgent.validVMNumber(vmNumberString);
                if (vmNumber == 0) {
                    Messages.issueMessage("AttachAgent.vm.invalid", new Object[0]);
                    continue;
                }
                VirtualMachineDescriptor VMdesc = vmList.get(vmNumber - 1);
                hcProps = new Properties();
                libraryLoaded = AttachAgent.ConnectandLoadLibrary(VMdesc.id(), hcOptions, hcProps);
                if (libraryLoaded != 0) continue;
                targetVM = VMdesc.displayName();
                continue;
            }
            Messages.issueMessage("AttachAgent.vm.none", new Object[0]);
            break;
        }
        if (libraryLoaded == 0) {
            Messages.issueMessage("AttachAgent.vm.connected", targetVM);
            AttachAgent.restrictHCPropertiesForDisplay(hcProps);
            if (hcProps.size() > 0) {
                StringWriter propWriter = new StringWriter();
                hcProps.list(new PrintWriter(propWriter));
                Messages.issueMessage("AttachAgent.vm.properties", propWriter.toString());
            } else {
                Messages.issueMessage("AttachAgent.vm.noprops", new Object[0]);
            }
        }
        System.exit(libraryLoaded);
    }

    private static void extractPropertyFiles() {
        String prefix = "/com/ibm/java/diagnostics/healthcenter/agent/dataproviders/capabilities/";
        String[] names = new String[]{"Cpu", "JLA", "Memory", "Threads", "TRACE"};
        InputStream inStream = null;
        for (String name : names) {
            String fname = name + "SourceConfiguration.properties";
            inStream = AttachAgent.class.getResourceAsStream(prefix + fname);
            if (inStream == null) {
                Messages.issueMessage("AttachAgent.warn.noprop", fname);
                continue;
            }
            AttachAgent.extractPropertyFile(inStream, fname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractPropertyFile(InputStream in, String fname) {
        FileOutputStream out;
        block9: {
            block8: {
                byte[] buffer = new byte[4096];
                int read = 0;
                out = null;
                try {
                    File f = new File(fname);
                    if (f.exists()) {
                        Messages.issueMessage("AttachAgent.warn.skipprop", fname);
                        AttachAgent.close(out);
                        break block8;
                    }
                    out = new FileOutputStream(f);
                    while ((read = in.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                    Messages.issueMessage("AttachAgent.extract.prop", fname);
                    AttachAgent.close(out);
                    break block9;
                }
                catch (IOException e) {
                    Messages.issueMessage("AttachAgent.warn.extractprop", fname);
                    return;
                }
            }
            AttachAgent.close(in);
            return;
        }
        AttachAgent.close(in);
        return;
        finally {
            AttachAgent.close(out);
            AttachAgent.close(in);
        }
    }

    private static void close(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String buildOptions(String[] args) {
        try {
            ByteArrayOutputStream hcOptionsOut = new ByteArrayOutputStream();
            OutputStreamWriter hcOptionWriter = new OutputStreamWriter((OutputStream)hcOptionsOut, "UTF-8");
            StringWriter hcPropertyWriter = new StringWriter();
            for (String arg : args) {
                if (null == arg) continue;
                if (arg.startsWith("-D")) {
                    String argument;
                    if (arg.startsWith(REMOTE_AGENT_PROPERTY)) {
                        remoteAgentPath = HealthCenterOptionHandler.processOption(arg, REMOTE_AGENT_PROPERTY);
                        argument = "-Dcom.ibm.java.diagnostics.healthcenter.agent.path=" + remoteAgentPath.replace("\\", "\\\\");
                    } else {
                        argument = arg;
                    }
                    hcPropertyWriter.write(argument, 2, argument.length() - 2);
                    hcPropertyWriter.append('\n');
                    continue;
                }
                hcOptionWriter.append(arg);
                hcOptionWriter.append(',');
                hcOptionWriter.flush();
                int pathIndex = arg.indexOf("path=");
                if (pathIndex == -1) continue;
                remoteAgentPath = HealthCenterOptionHandler.processOption(arg.substring(pathIndex).split(",")[0], "path");
            }
            hcPropertyWriter.flush();
            HealthCenterOptionHandler hcohDummy = new HealthCenterOptionHandler(logger);
            boolean optionsOK = hcohDummy.validateOptions(hcOptionsOut.toString("UTF-8"));
            Properties hcProps = new Properties();
            ByteArrayInputStream hcPropInput = new ByteArrayInputStream(hcPropertyWriter.toString().getBytes("ISO8859-1"));
            hcProps.load(hcPropInput);
            boolean propsOK = HealthCenterOptionHandler.validateHCProperties(hcProps, logger);
            if (!optionsOK || !propsOK) {
                return null;
            }
            if (!hcProps.isEmpty()) {
                hcProps.storeToXML(hcOptionsOut, null);
                hcOptionsOut.flush();
            }
            String hcOptionsString = hcOptionsOut.toString("UTF-8");
            hcOptionsString = hcOptionsString.replace('\n', ' ');
            hcOptionsString = hcOptionsString.replace('\r', ' ');
            return hcOptionsString;
        }
        catch (IOException e) {
            Messages.issueMessage("AttachAgent.error.exception", e.toString());
            Messages.printException(e);
            return null;
        }
    }

    private static int ConnectandLoadLibrary(String vmID, String hcOptions, Properties hcProps) {
        try {
            int agentLoaded;
            VirtualMachine vm = VirtualMachine.attach((String)vmID);
            Properties targetProps = vm.getSystemProperties();
            hcProps.putAll((Map<?, ?>)targetProps);
            String isAgentRunning = hcProps.getProperty("com.ibm.java.diagnostics.healthcenter.running");
            if (isAgentRunning != null && isAgentRunning.equals("true")) {
                System.out.println("");
                Messages.issueMessage("AttachAgent.native.loaded", new Object[0]);
                System.out.println("");
                agentLoaded = -2;
            } else {
                String value;
                if (remoteAgentPath == null && !(value = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.path", "")).equals("")) {
                    remoteAgentPath = value;
                }
                if (remoteAgentPath == null) {
                    vm.loadAgentLibrary("healthcenter", hcOptions);
                } else {
                    File file = new File(remoteAgentPath + File.separator + "jre");
                    if (file.exists()) {
                        remoteAgentPath = remoteAgentPath + File.separator + "jre";
                    }
                    if ((file = new File(remoteAgentPath + File.separator + BIN + File.separator + HC_DLL)).exists()) {
                        remoteAgentPath = file.getAbsolutePath();
                    } else {
                        remoteAgentPath = remoteAgentPath + File.separator + "lib";
                        file = new File(remoteAgentPath);
                        File[] files = file.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].isDirectory() || files[i].toString().endsWith(EXT)) continue;
                            remoteAgentPath = files[i].getAbsolutePath() + File.separator + HC_SO;
                            break;
                        }
                    }
                    vm.loadAgentPath(remoteAgentPath, hcOptions);
                }
                targetProps = vm.getSystemProperties();
                hcProps.putAll((Map<?, ?>)targetProps);
                agentLoaded = 0;
            }
            vm.detach();
            return agentLoaded;
        }
        catch (AttachNotSupportedException e) {
            Messages.issueMessage("AttachAgent.vm.unsupported", new Object[0]);
            return -1;
        }
        catch (IOException e) {
            Messages.issueMessage("AttachAgent.error.io", e.getMessage());
            return -1;
        }
        catch (AgentLoadException e) {
            Messages.issueMessage("AttachAgent.error.load", new Object[0]);
            return -1;
        }
        catch (AgentInitializationException e) {
            String message;
            int rc_index;
            int rc = e.returnValue();
            if (0 == rc && (rc_index = (message = e.getMessage()).lastIndexOf("-")) >= 0) {
                try {
                    rc = Integer.parseInt(message.substring(rc_index));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            Messages.issueMessage("AttachAgent.error.init", rc);
            String messagekey = null;
            try {
                messagekey = attachAgent_message_keys[-rc];
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                // empty catch block
            }
            if (null == messagekey) {
                messagekey = attachAgent_message_keys[0];
            }
            Messages.issueMessage(messagekey, new Object[0]);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLine() {
        Scanner kb = new Scanner(System.in);
        try {
            String string = kb.nextLine().trim();
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            kb.close();
        }
    }

    private static void restrictHCPropertiesForDisplay(Properties props) {
        Enumeration<Object> hcPropKeys = props.keys();
        while (hcPropKeys.hasMoreElements()) {
            String hcPropKey = (String)hcPropKeys.nextElement();
            if (hcPropKey.equals("com.ibm.java.diagnostics.healthcenter.agent.port") || hcPropKey.equals("com.ibm.java.diagnostics.healthcenter.data.collection.event") || hcPropKey.equals("com.ibm.java.diagnostics.healthcenter.data.collection.level")) continue;
            props.remove(hcPropKey);
        }
    }

    private static int validVMNumber(String vmNumberString) {
        int vmNum = 0;
        if (AttachAgent.isNumeric(vmNumberString)) {
            try {
                vmNum = Integer.parseInt(vmNumberString);
            }
            catch (NumberFormatException e) {
                Messages.issueMessage("AttachAgent.vm.invalid", new Object[0]);
            }
            if (vmNum > vmList.size()) {
                vmNum = 0;
            }
        }
        return vmNum;
    }

    private static boolean isNumeric(String vmNumberString) {
        char[] vmchars;
        for (char vmchar : vmchars = vmNumberString.toCharArray()) {
            if (Character.isDigit(vmchar)) continue;
            return false;
        }
        return true;
    }

    static {
        Class<?> tempClass;
        attachAgent_message_keys = new String[]{"AttachAgent.native.invresp", "AttachAgent.native.error", "AttachAgent.native.loaded", "AttachAgent.native.jvmtierr", "AttachAgent.native.mbeanerr", "AttachAgent.native.mbeanexc", null, null, null, null, null};
        CONFIG = "-Dcom.ibm.java.diagnostics.healthcenter.config=%s";
        vmList = null;
        try {
            tempClass = Class.forName("com.ibm.java.diagnostics.healthcenter.agent.lateattach.AttachAgent");
        }
        catch (Exception e) {
            tempClass = null;
        }
        thisClass = tempClass;
        logger = AgentLogFactory.setUpLogging(thisClass);
        remoteAgentPath = null;
    }
}

