/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.net.IDN;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;

public final class SNIHostName
extends SNIServerName {
    private final String d;
    private static final String[] z;

    public SNIHostName(String string) {
        string = IDN.toASCII(Objects.requireNonNull(string, z[4]), 2);
        super(0, string.getBytes(StandardCharsets.US_ASCII));
        this.d = string;
        this.a();
    }

    public SNIHostName(byte[] byArray) {
        super(0, byArray);
        try {
            CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.d = IDN.toASCII(charsetDecoder.decode(ByteBuffer.wrap(byArray)).toString());
        }
        catch (RuntimeException | CharacterCodingException exception) {
            throw new IllegalArgumentException(z[1], exception);
        }
        this.a();
    }

    public String getAsciiName() {
        return this.d;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SNIHostName) {
            return this.d.equalsIgnoreCase(((SNIHostName)object).d);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 31 * n + this.d.toUpperCase(Locale.ENGLISH).hashCode();
        return n;
    }

    @Override
    public String toString() {
        return z[5] + this.d;
    }

    public static SNIMatcher createSNIMatcher(String string) {
        if (string == null) {
            throw new NullPointerException(z[0]);
        }
        return new SNIHostNameMatcher(string);
    }

    private void a() {
        if (this.d.isEmpty()) {
            throw new IllegalArgumentException(z[2]);
        }
        if (this.d.endsWith(".")) {
            throw new IllegalArgumentException(z[3]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "!1-\n\u001d\u0010>=F\u000e\u0007y-R\u001f\u0007<;Y\u0006\u001a7hI\u000e\u001b7'^O\u0017<hD\u001a\u00195";
        int n2 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block17;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 117;
                                break;
                            }
                            case 1: {
                                n8 = 89;
                                break;
                            }
                            case 2: {
                                n8 = 72;
                                break;
                            }
                            case 3: {
                                n8 = 42;
                                break;
                            }
                            default: {
                                n8 = 111;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "!1-\n\n\u001b:'N\n\u0011y;O\u001d\u0003<:\n\u0001\u00144-\n\u0019\u00145=OO\u001c*hC\u0001\u00038$C\u000b";
                    n2 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "&<:\\\n\u0007y&K\u0002\u0010y>K\u0003\u0000<hE\tU1'Y\u001b*7)G\nU:)D\u0001\u001a-hH\nU<%Z\u001b\f";
                    n2 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "&<:\\\n\u0007y&K\u0002\u0010y>K\u0003\u0000<hE\tU1'Y\u001b*7)G\nU:)D\u0001\u001a-hB\u000e\u0003<h^\u0007\u0010y<X\u000e\u001c5!D\bU='^";
                    n2 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "&<:\\\n\u0007y&K\u0002\u0010y>K\u0003\u0000<hE\tU1'Y\u001b*7)G\nU:)D\u0001\u001a-hH\nU7=F\u0003";
                    n2 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0001 8OR\u001d6;^0\u001b8%OO]ia\u0006O\u00038$_\nH";
                    n2 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }

    private static final class SNIHostNameMatcher
    extends SNIMatcher {
        private final Pattern b;
        private static final String[] z;

        SNIHostNameMatcher(String string) {
            super(0);
            this.b = Pattern.compile(string, 2);
        }

        @Override
        public boolean matches(SNIServerName sNIServerName) {
            SNIHostName sNIHostName;
            block12: {
                block13: {
                    if (sNIServerName == null) {
                        throw new NullPointerException(z[0]);
                    }
                    if (sNIServerName instanceof SNIHostName) break block12;
                    if (sNIServerName.getType() == 0) break block13;
                    throw new IllegalArgumentException(z[1]);
                }
                try {
                    sNIHostName = new SNIHostName(sNIServerName.getEncoded());
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    return false;
                }
            }
            sNIHostName = (SNIHostName)sNIServerName;
            String string = sNIHostName.getAsciiName();
            if (this.b.matcher(string).matches()) {
                return true;
            }
            return this.b.matcher(IDN.toUnicode(string)).matches();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "abxU:{CN\u0010\u001bCoo;\bXo=\u0014\u001bR\u007fp\u0010\u0007A*~\u0014\u0007[eiU\u000bP*s\u0000\u0005Y";
            int n2 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block13;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 53;
                                    break;
                                }
                                case 1: {
                                    n8 = 10;
                                    break;
                                }
                                case 2: {
                                    n8 = 29;
                                    break;
                                }
                                case 3: {
                                    n8 = 117;
                                    break;
                                }
                                default: {
                                    n8 = 105;
                                }
                            }
                            cArray4[n7] = (char)(c ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = "abxU\u001aPxk\u0010\u001b\u0015d|\u0018\f\u0015~d\u0005\f\u0015cnU\u0007Z~=\u001d\u0006F~B\u001b\bXo";
                        n2 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            z = stringArray3;
        }
    }
}

