/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.JavaConstructorWrapper;
import com.ibm.xylem.JavaMethodWrapper;
import com.ibm.xylem.Type;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.interpreter.ListStream;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.JavaUtil;
import com.ibm.xylem.utils.XylemError;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;

public class JavaClassWrapper {
    private Class javaClass;

    public JavaClassWrapper(Class clazz) {
        this.javaClass = clazz;
    }

    public JavaClassWrapper newArrayClass(int n) {
        return new JavaClassWrapper(Array.newInstance(this.javaClass, new int[n]).getClass());
    }

    public boolean isPrimitive() {
        return this.javaClass.isPrimitive();
    }

    public boolean isSameClass(Class clazz) {
        return this.javaClass == clazz;
    }

    public String getName() {
        return this.javaClass.getName();
    }

    public com.ibm.xtq.bcel.generic.Type getBCELType() {
        return com.ibm.xtq.bcel.generic.Type.getType(this.javaClass);
    }

    public boolean isAssignableFrom(Class clazz) {
        return this.javaClass.isAssignableFrom(clazz);
    }

    public static Object convertListStream(ListStream listStream, Type type) {
        if (type instanceof StreamType) {
            Type type2 = ((StreamType)type).getElementType();
            JavaClassWrapper javaClassWrapper = type2.getJavaType();
            int[] nArray = new int[]{listStream.size()};
            Object object = Array.newInstance(javaClassWrapper.javaClass, nArray);
            for (int i = 0; i < listStream.size(); ++i) {
                Object object2 = listStream.get(i);
                if (object2 instanceof IConvertible) {
                    object2 = ((IConvertible)object2).convert(type2);
                }
                Array.set(object, i, object2);
            }
            return object;
        }
        if (type.equals(JavaObjectType.s_javaStringType)) {
            return listStream.toString();
        }
        throw new XylemError("ERR_SYSTEM", "Can't convert ListStream to " + type);
    }

    public static JavaMethodWrapper getMethod(JavaClassWrapper javaClassWrapper, String string, JavaClassWrapper[] javaClassWrapperArray) {
        Class clazz = javaClassWrapper.javaClass;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPackageAccess(JavaUtil.getPackageName(clazz.getName()));
        }
        Class[] classArray = JavaClassWrapper.getArgTypes(javaClassWrapperArray);
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new RuntimeException(securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length && method == null; ++i) {
                Class<?>[] classArray2;
                Method method2 = methodArray[i];
                if (!method2.getName().equals(string) || (classArray2 = method2.getParameterTypes()).length != classArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < classArray2.length && bl; ++j) {
                    if (classArray2[j].isAssignableFrom(classArray[j])) continue;
                    bl = false;
                }
                if (!bl) continue;
                method = method2;
            }
        }
        if (method == null) {
            throw new XylemError("ERR_SYSTEM", "Method not found: class = " + clazz + " method = " + string + " args = " + Arrays.asList(classArray));
        }
        return new JavaMethodWrapper(method);
    }

    public static JavaConstructorWrapper getConstructor(JavaClassWrapper javaClassWrapper, JavaClassWrapper[] javaClassWrapperArray) {
        Class clazz = javaClassWrapper.javaClass;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPackageAccess(JavaUtil.getPackageName(clazz.getName()));
        }
        Class[] classArray = JavaClassWrapper.getArgTypes(javaClassWrapperArray);
        Constructor<Object> constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new RuntimeException(securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor == null) {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructorArray.length && constructor == null; ++i) {
                Constructor<?> constructor2 = constructorArray[i];
                Class<?>[] classArray2 = constructor2.getParameterTypes();
                if (classArray2.length != classArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < classArray2.length && bl; ++j) {
                    if (classArray2[j].isAssignableFrom(classArray[j])) continue;
                    bl = false;
                }
                if (!bl) continue;
                constructor = constructor2;
            }
        }
        if (constructor == null) {
            throw new XylemError("ERR_SYSTEM", "Constructor not found: class = " + clazz + " args = " + classArray);
        }
        return new JavaConstructorWrapper(constructor);
    }

    private static Class[] getArgTypes(JavaClassWrapper[] javaClassWrapperArray) {
        Class[] classArray = new Class[javaClassWrapperArray.length];
        for (int i = 0; i < javaClassWrapperArray.length; ++i) {
            classArray[i] = javaClassWrapperArray[i].javaClass;
        }
        return classArray;
    }
}

