/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xylem.JavaClassWrapper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.codegen.bcel.SwitchBuilder;
import com.ibm.xylem.types.PrimitiveNumericalType;
import java.io.ObjectStreamException;

public final class IntType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = -8782130193357845114L;
    public static final IntType s_intType = new IntType();
    private static short[] s_branchOpcode = new short[]{0, 0, 0, 0, 0, 164, 161, 162, 163, 160};

    private IntType() {
    }

    @Override
    public Type getImplementationType(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        return BasicType.INT;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "int";
    }

    @Override
    public JavaClassWrapper getJavaType() {
        return new JavaClassWrapper(Integer.TYPE);
    }

    @Override
    public Object evaluateOperation(Object object, Object object2, int n) {
        switch (n) {
            case 0: {
                return new Integer((Integer)object + (Integer)object2);
            }
            case 1: {
                return new Integer((Integer)object - (Integer)object2);
            }
            case 2: {
                return new Integer((Integer)object * (Integer)object2);
            }
            case 3: {
                return new Integer((Integer)object / (Integer)object2);
            }
            case 4: {
                return new Integer((Integer)object % (Integer)object2);
            }
            case 10: {
                return new Integer((Integer)object & (Integer)object2);
            }
            case 11: {
                return new Integer((Integer)object | (Integer)object2);
            }
            case 12: {
                return new Integer((Integer)object ^ (Integer)object2);
            }
            case 14: {
                return new Integer((Integer)object >> (Integer)object2);
            }
            case 15: {
                return new Integer((Integer)object >>> (Integer)object2);
            }
            case 13: {
                return new Integer((Integer)object << (Integer)object2);
            }
            case 16: {
                return new Integer(-((Integer)object).intValue());
            }
        }
        return super.evaluateComparisonOperation(object, object2, n);
    }

    @Override
    public void generateCodeForOperation(InstructionListBuilder instructionListBuilder, int n) {
        if (n == 16) {
            instructionListBuilder.append(InstructionConstants.INEG);
        } else if (n < 5 || n > 9) {
            super.generateCodeForOperation(instructionListBuilder, n);
        } else {
            IntType.generateCodeForIntegerOperation(instructionListBuilder, n);
        }
    }

    public static final void generateCodeForIntegerOperation(InstructionListBuilder instructionListBuilder, int n) {
        SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
        switchBuilder.startTest(s_branchOpcode[n]);
        instructionListBuilder.appendConstant(true);
        switchBuilder.endTest();
        switchBuilder.startElse();
        instructionListBuilder.appendConstant(false);
        switchBuilder.endElse();
    }

    private Object readResolve() throws ObjectStreamException {
        return s_intType;
    }

    @Override
    public String getDefaultValue() {
        return "0";
    }
}

