/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.ILogIndication;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.internal.config.LogIPFControlInternal;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LogIndication
implements ILogIndication {
    private static final long serialVersionUID = -1957601317810529490L;
    protected final int MAX_UTF_BUFFER_SIZE = 65535;
    protected final int UNICODE_STREAM_MAGIC_NUMBER = 40000;
    public static final byte NONE = 0;
    public static final byte AUDIT = 1;
    public static final byte PERF = 2;
    public static final byte TRACE = 3;
    public static final int OFF = Integer.MAX_VALUE;
    public static final int LEVEL1 = 50000;
    public static final int LEVEL2 = 40000;
    public static final int LEVEL3 = 30000;
    public static final int LEVEL4 = 20000;
    public static final int LEVEL5 = 10000;
    public static final int ALL = Integer.MIN_VALUE;
    public static final boolean LOG_PERF_ENABLED = true;
    public static final String SESSION_ID_FLAG_PREFIX = "f:";
    public static final int SESSION_ID_FLAG_PREFIX_LENGTH = 4;
    private byte m_version = 1;
    protected byte[] m_ipaddr;
    protected String m_ipaddrStr;
    protected short m_tzOffset;
    protected char m_port;
    protected int m_procID = LogIPFConfigure.DispatcherID;
    protected long m_time;
    private boolean ipfHasTimeStampControl = true;
    protected String m_loggerName = "";
    protected String m_session = "";
    protected String m_request = "";
    protected String m_step = "";
    protected String m_subRequest = "";
    protected String m_thread = Thread.currentThread().getName();
    protected String m_compid;
    protected int m_buildnum;
    protected byte m_group;
    protected int m_level;
    public static final char FieldSeparator = '\t';

    @Override
    public byte getVersion() {
        return this.m_version;
    }

    @Override
    public byte[] getIPAddr() {
        return this.m_ipaddr;
    }

    @Override
    public String getIPAddrStr() {
        return this.m_ipaddrStr;
    }

    @Override
    public void setPort(int port) {
        if (0 >= port || port > 65535) {
            port = 0;
        }
        this.m_port = (char)port;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public int getProcID() {
        return this.m_procID;
    }

    @Override
    public void setTime() {
        this.m_tzOffset = LogIPFControlInternal.getTimeZoneOffset();
        this.m_time = System.currentTimeMillis();
    }

    @Override
    public long getTime() {
        return this.m_time;
    }

    @Override
    public void setTimeStampedControlledByIPF(boolean bIpfHasControl) {
        this.ipfHasTimeStampControl = bIpfHasControl;
    }

    @Override
    public boolean isTimeStampedControlledByIPF() {
        return this.ipfHasTimeStampControl;
    }

    @Override
    public void setTime(long t) {
        if (t <= 0L) {
            LogIPFLog.warn("Attempting to apply zero timestamp to indication");
            LogIPFLog.warn("Time left uninitialized");
            return;
        }
        this.setTimeStampedControlledByIPF(false);
        this.m_time = t;
    }

    @Override
    public void setLoggerName(String lName) {
        if (null == lName) {
            lName = "";
        }
        this.m_loggerName = lName;
    }

    @Override
    public String getLoggerName() {
        return this.m_loggerName;
    }

    @Override
    public void setSessionID(String session) {
        this.m_session = null == session || session.length() == 0 ? "" : this.processSessionID(session);
    }

    private String processSessionID(String session) {
        String newSessionID = session;
        if (session.startsWith("101:") || session.startsWith("111:") || session.startsWith("110:") || session.startsWith("010:")) {
            LogIPFLog.warn("LogIndication::processSessionID -- An clear text passport id is used by component " + this.m_compid + ", logger: " + this.m_loggerName);
            boolean[] flags = new boolean[]{true};
            try {
                newSessionID = LogIPFControl.generateSessionID(session, flags);
            }
            catch (Exception e) {
                LogIPFLog.error("LogIndication::processSessionID -- Cannot generate hash for session id.", e);
                newSessionID = LogIPFControlInternal.addFlagToSessionID(session, flags);
            }
        }
        return newSessionID;
    }

    @Override
    public String getSessionID() {
        return this.m_session;
    }

    @Override
    public String getRenderedSessionID() {
        if (this.m_session != null && this.m_session.startsWith(SESSION_ID_FLAG_PREFIX)) {
            String sessId = this.m_session.substring(4);
            return sessId;
        }
        return this.m_session;
    }

    @Override
    public void setRequestID(String request) {
        if (null == request) {
            request = "";
        }
        this.m_request = request;
    }

    @Override
    public String getRequestID() {
        if (null == this.m_request) {
            LogIPFLog.warn("Missing eequest ID (Level " + this.getLevel() + "). The logger is " + this.getLoggerName());
            this.m_request = "";
        }
        return this.m_request;
    }

    @Override
    public void setStepID(String step) {
        if (null == step) {
            step = "";
        }
        this.m_step = step;
    }

    @Override
    public String getStepID() {
        return this.m_step;
    }

    @Override
    public void setSubRequestID(String srequest) {
        if (null == srequest) {
            srequest = "";
        }
        this.m_subRequest = srequest;
    }

    @Override
    public String getSubRequestID() {
        return this.m_subRequest;
    }

    @Override
    public String getThreadID() {
        return this.m_thread;
    }

    @Override
    public void setThreadID(String threadId) {
        if (null != threadId) {
            this.m_thread = threadId;
        }
    }

    @Override
    public String getComponentID() {
        return this.m_compid;
    }

    @Override
    public int getBuildNumber() {
        return this.m_buildnum;
    }

    @Override
    public byte getGroup() {
        return this.m_group;
    }

    @Override
    public short getTimeZoneOffset() {
        return this.m_tzOffset;
    }

    @Override
    public void setLevel(int level) {
        this.m_level = level;
    }

    @Override
    public int getLevel() {
        return this.m_level;
    }

    public LogIndication() {
        this("", 0);
    }

    LogIndication(String component, int buildnum) {
        this.m_compid = null == component ? "" : component;
        this.m_buildnum = buildnum;
        this.m_group = 0;
        this.m_level = 10000;
        this.m_time = 0L;
        this.setPort(LogIPFConfigure.getDispatcherPort());
        this.m_ipaddr = LogIPFControlInternal.get_ipaddr();
        this.m_ipaddrStr = LogIPFControlInternal.get_ipaddrStr();
        this.m_tzOffset = LogIPFControlInternal.getTimeZoneOffset();
    }

    public static int toInteger(int detail) {
        return Math.abs(detail / 10000 - 6);
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        try {
            out.writeByte(this.m_version);
            out.writeUTF(this.m_ipaddrStr);
            out.writeChar(this.m_port);
            out.writeInt(this.m_procID);
            out.writeLong(this.m_time);
            out.writeUTF(this.m_session);
            out.writeUTF(this.m_request);
            out.writeUTF(this.m_step);
            out.writeUTF(this.m_subRequest);
            out.writeUTF(this.m_thread);
            out.writeUTF(this.m_compid);
            out.writeInt(this.m_buildnum);
            out.writeByte(this.m_group);
            out.writeShort(this.m_tzOffset);
            out.writeInt(this.m_level);
            out.writeUTF(this.m_loggerName);
            out.flush();
        }
        catch (Exception e) {
            LogIPFLog.warn("Indication could not be sent to the log server.", e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) {
        try {
            this.m_version = in.readByte();
            this.m_ipaddrStr = in.readUTF();
            this.m_port = in.readChar();
            this.m_procID = in.readInt();
            this.m_time = in.readLong();
            this.m_session = in.readUTF();
            this.m_request = in.readUTF();
            this.m_step = in.readUTF();
            this.m_subRequest = in.readUTF();
            this.m_thread = in.readUTF();
            this.m_compid = in.readUTF();
            this.m_buildnum = in.readInt();
            this.m_group = in.readByte();
            this.m_tzOffset = in.readShort();
            this.m_level = in.readInt();
            this.m_loggerName = in.readUTF();
        }
        catch (Exception e) {
            LogIPFLog.warn("Received a corrupted indication.", e);
        }
    }

    protected int getUTF8ByteSize(String inStr) {
        int byteSize = 0;
        int strLen = inStr.length();
        for (int ii = 0; ii < strLen; ++ii) {
            char aChar = inStr.charAt(ii);
            if (aChar == '\u0000') {
                byteSize += 2;
                continue;
            }
            if (aChar < '\u0080') {
                ++byteSize;
                continue;
            }
            if (aChar < '\u0800') {
                byteSize += 2;
                continue;
            }
            byteSize += 3;
        }
        return byteSize;
    }

    protected String checkUTFDataFormatException(String inStr, String msgToInsert) {
        int byteSize = this.getUTF8ByteSize(inStr);
        if (65535 < byteSize) {
            return msgToInsert + " given to IPF exceeded the maximum Java modified UTF representation of a String";
        }
        return inStr;
    }
}

