/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.ILogTraceIndication;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogTraceRenderer;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LogTraceIndication
extends LogIndication
implements ILogTraceIndication {
    public static final byte UNDEFINED = 0;
    public static final byte START = 1;
    public static final byte STOP = 2;
    public static final byte CALL = 3;
    public static final byte RETURN = 4;
    public static final byte ENTER = 5;
    public static final byte EXIT = 6;
    public static final byte SEND = 7;
    public static final byte RECEIVE = 8;
    public static final byte VERSION = 9;
    public static final byte BUILDNUM = 10;
    public static final byte TRACE = 11;
    private static final long serialVersionUID = 9132866834182702628L;
    protected String m_annotation;
    protected String m_object;
    public static String[] m_actionList = new String[12];
    protected byte m_action = 0;
    protected String m_requester;

    @Override
    public void setMessage(String msg) {
        if (null == msg) {
            msg = "";
        }
        this.m_annotation = msg;
    }

    @Override
    public String getMessage() {
        return this.m_annotation;
    }

    @Override
    public void setObject(String obj) {
        if (null == obj) {
            obj = "";
        }
        this.m_object = obj;
    }

    @Override
    public String getObject() {
        return this.m_object;
    }

    @Override
    public void setAction(byte act) {
        this.m_action = act >= 0 && act <= 11 ? act : (byte)0;
    }

    @Override
    public byte getAction() {
        return this.m_action;
    }

    @Override
    public String getActionString() {
        if (this.m_action >= 0 && this.m_action <= 11) {
            return m_actionList[this.m_action];
        }
        return "";
    }

    @Override
    public void setRequester(String requester) {
        this.m_requester = null == requester ? "" : requester;
    }

    @Override
    public String getRequester() {
        return this.m_requester;
    }

    public LogTraceIndication(String component, int buildnum) {
        super(component, buildnum);
        this.m_group = (byte)3;
        this.m_annotation = "";
        this.m_object = "";
        this.m_requester = "";
    }

    public LogTraceIndication() {
        this("", 0);
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        try {
            int logDataUTF8ByteSize = this.getUTF8ByteSize(this.m_annotation);
            if (65535 >= logDataUTF8ByteSize) {
                out.writeInt(1);
                out.writeUTF(this.m_annotation);
            } else {
                int logDataChunks = this.m_annotation.length() / 40000 + 1;
                out.writeInt(logDataChunks);
                int ii = 0;
                for (ii = 0; ii < logDataChunks - 1; ++ii) {
                    out.writeUTF(this.m_annotation.substring(ii * 40000, (ii + 1) * 40000));
                }
                out.writeUTF(this.m_annotation.substring(ii * 40000));
            }
            out.writeUTF(this.m_object);
            out.writeByte(this.m_action);
            out.writeUTF(this.m_requester);
            super.writeExternal(out);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogTraceIndication could not be sent to the log server.", e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) {
        try {
            int logDataChunks = in.readInt();
            if (1 == logDataChunks) {
                this.m_annotation = in.readUTF();
            } else {
                StringBuilder tmpLogData = new StringBuilder(65535);
                for (int ii = 0; ii < logDataChunks; ++ii) {
                    tmpLogData.append(in.readUTF());
                }
                this.m_annotation = tmpLogData.toString();
            }
            this.m_object = in.readUTF();
            this.m_action = in.readByte();
            this.m_requester = in.readUTF();
            super.readExternal(in);
        }
        catch (Exception e) {
            LogIPFLog.warn("Received a corrupted indication.", e);
        }
    }

    public String toString() {
        StringBuilder msg = new StringBuilder(512);
        LogTraceRenderer.render(msg, this);
        return msg.toString();
    }

    static {
        LogTraceIndication.m_actionList[0] = "UNDEFINED";
        LogTraceIndication.m_actionList[1] = "START";
        LogTraceIndication.m_actionList[2] = "STOP";
        LogTraceIndication.m_actionList[3] = "CALL";
        LogTraceIndication.m_actionList[4] = "RETURN";
        LogTraceIndication.m_actionList[5] = "ENTER";
        LogTraceIndication.m_actionList[6] = "EXIT";
        LogTraceIndication.m_actionList[7] = "SEND";
        LogTraceIndication.m_actionList[8] = "RECEIVE";
        LogTraceIndication.m_actionList[9] = "VERSION";
        LogTraceIndication.m_actionList[10] = "BUILDNUM";
        LogTraceIndication.m_actionList[11] = "TRACE";
    }
}

