/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.appenders;

import com.cognos.cclcfgapi.CCLResolveInetAddress;
import com.cognos.indications.ILogAuditIndication;
import com.cognos.indications.ILogIndication;
import com.cognos.indications.ILogPerfIndication;
import com.cognos.indications.ILogTraceIndication;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import com.cognos.indications.appenders.IndByteArrayOutputStream;
import com.cognos.indications.appenders.LogAbstractAppender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="LogLocalUDPAppender", category="Core", elementType="appender", printObject=true)
public class LogLocalUDPAppender
extends LogAbstractAppender {
    static final int DEFAULT_PORT = LogIPFConfigure.getServerPort();
    private static final int IPF_MAX_UDP_BUFFER = 65536;
    private boolean m_useInProcessCalls = true;
    InetAddress address;
    DatagramSocket ds;
    int port = DEFAULT_PORT;
    static final int MAX_IND_SIZE = Integer.getInteger("loglocaludpappender.max.size", 65536);
    private Object inProcessServer = null;
    private Method inProcessServerLogMethod = null;
    private boolean inProcessServerSet = false;

    private void directAppend(LogEvent event) {
        LogIndication ind = this.toLogIndication(event);
        if (ind == null) {
            return;
        }
        try (ByteArrayOutputStream directBos = new ByteArrayOutputStream(MAX_IND_SIZE);
             ObjectOutputStream oos = new ObjectOutputStream(directBos);){
            oos.writeUTF(event.getLoggerName());
            oos.writeObject(ind);
            this.inProcessServerLogMethod.invoke(this.inProcessServer, new Object[]{directBos.toByteArray()});
        }
        catch (Exception e) {
            LogIPFLog.warn("exception in direct append: ", e);
        }
    }

    private void socketAppend(LogEvent event) {
        if (this.address == null) {
            LogIPFLog.error("LogLocalUDPAppender::socketAppend() - No host is set for LogLocalUDPAppender -- cannot log");
            return;
        }
        LogIndication ind = this.toLogIndication(event);
        if (ind == null) {
            return;
        }
        try {
            IndByteArrayOutputStream bos = new IndByteArrayOutputStream(MAX_IND_SIZE);
            this.serializeIndication(bos, event.getLoggerName(), ind);
            if (bos.getCount() > 65536) {
                LogIPFLog.debug("LogLocalUDPAppender::socketAppend() - Stream buffer size exceeds the size:" + bos.getCount() + ". Maximum allowed is: " + 65536 + ". The data will be truncated.");
                if (ind instanceof ILogAuditIndication) {
                    ILogAuditIndication indAudit = (ILogAuditIndication)((Object)ind);
                    indAudit.setLogData(this.truncateLongLogMessage(bos.getCount(), indAudit.getLogData()));
                } else if (ind instanceof ILogPerfIndication) {
                    ILogPerfIndication indPerf = (ILogPerfIndication)((Object)ind);
                    indPerf.setLogData(this.truncateLongLogMessage(bos.getCount(), indPerf.getLogData()));
                } else if (ind instanceof ILogTraceIndication) {
                    ILogTraceIndication indTrace = (ILogTraceIndication)((Object)ind);
                    indTrace.setMessage(this.truncateLongLogMessage(bos.getCount(), indTrace.getMessage()));
                }
                bos.reset();
                this.serializeIndication(bos, event.getLoggerName(), ind);
            }
            this.ds.send(new DatagramPacket(bos.getBuffer(), bos.getCount(), this.address, this.port));
        }
        catch (Exception e) {
            LogIPFLog.warn("LogLocalUDPAppender::socketAppend() - Detected problem with connection: ", e);
        }
    }

    private void serializeIndication(ByteArrayOutputStream bos, String loggerName, ILogIndication ind) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeUTF(loggerName);
            oos.writeObject(ind);
            oos.reset();
        }
    }

    private String truncateLongLogMessage(int targetSize, String longStr) {
        String resultStr = "";
        int exceedingBytes = targetSize - 65536 + 8;
        if (exceedingBytes >= longStr.length()) {
            resultStr = "...";
        } else if (exceedingBytes > 0) {
            LogIPFLog.debug("LogLocalUDPAppender::truncateLongLogMessage() - Number of characters to be removed from LogData is: " + exceedingBytes);
            StringBuffer str = new StringBuffer(longStr.substring(0, longStr.length() - exceedingBytes));
            str.append("...");
            resultStr = str.toString();
        }
        return resultStr;
    }

    public LogLocalUDPAppender(String name, Filter filter) {
        super(name, filter, null, true, Property.EMPTY_ARRAY);
        try {
            this.address = CCLResolveInetAddress.getLoopbackAddress();
            this.ds = new DatagramSocket(0, this.address);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogLocalUDPAppender() - Exception when get ipaddress of localhost: ", e);
            this.address = null;
        }
        this.port = this.ds.getPort();
        this.m_useInProcessCalls = true;
    }

    @PluginFactory
    public static LogLocalUDPAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter) {
        LogIPFLog.info("LogLocalUDPAppender() name = " + name);
        return new LogLocalUDPAppender(name, filter);
    }

    @PluginFactory
    public static LogLocalUDPAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="Port") int port) {
        LogIPFLog.info("LogLocalUDPAppender() name = " + name + ", port = " + port);
        return new LogLocalUDPAppender(name, filter, port);
    }

    public LogLocalUDPAppender(String name, Filter filter, int port) {
        super(name, filter, null, true, Property.EMPTY_ARRAY);
        try {
            this.address = CCLResolveInetAddress.getLoopbackAddress();
            this.ds = new DatagramSocket(port, this.address);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogLocalUDPAppender(port) - Exception when get ipaddress of localhost: ", e);
            this.address = null;
        }
        this.port = port;
        this.m_useInProcessCalls = true;
    }

    @Override
    public void append(LogEvent event) {
        if (event == null) {
            return;
        }
        if (!this.m_useInProcessCalls) {
            this.socketAppend(event);
            return;
        }
        if (!this.inProcessServerSet) {
            this.inProcessServerSet = true;
            this.inProcessServer = LogIPFControl.getInProcessServer();
            if (this.inProcessServer != null) {
                try {
                    Class<?> inProcessServerClass = Class.forName("com.cognos.logserver.LogService");
                    if (inProcessServerClass != null) {
                        this.inProcessServerLogMethod = inProcessServerClass.getMethod("log", byte[].class);
                    } else {
                        this.inProcessServer = null;
                    }
                }
                catch (Exception e) {
                    this.inProcessServer = null;
                }
            }
        }
        if (this.inProcessServer != null) {
            this.directAppend(event);
        } else {
            this.socketAppend(event);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUseInProcessServer(boolean useInProc) {
        this.m_useInProcessCalls = useInProc;
    }

    public String toString() {
        return "LogLocalUDPAppender [useInProcessCalls=" + this.m_useInProcessCalls + ", address=" + this.address + ", port=" + this.port + "]";
    }
}

