/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.appenders;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.ILogIndication;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import com.cognos.indications.appenders.LogAbstractAppender;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="LogTCPSocketAppender", category="Core", elementType="appender", printObject=true)
public class LogTCPSocketAppender
extends LogAbstractAppender {
    private static final String KEY_IPF = "<initializeDocument><serviceID>IPF</serviceID></initializeDocument>";
    protected static final int DEFAULT_PORT = 9362;
    protected static final int DEFAULT_RECONNECTION_DELAY = 30000;
    protected static final int MAX_RECONNECTION = 5;
    protected static final int RECOVERY_FILE_MAX_SIZE = 0x100000;
    protected String m_remoteHost;
    protected int m_port = 9362;
    protected int m_reconnectionDelay = 30000;
    protected boolean m_locationInfo = false;
    private boolean m_secure = false;
    protected ObjectOutputStream m_appendStream;
    protected ObjectOutputStream m_recoveryObjectStream;
    protected File m_recoveryFile;
    protected String m_recoveryDirectory;
    protected volatile boolean m_closed;
    private Connector m_connector;
    private Object m_inProcessServer;
    private Method m_inProcessServerLogMethod;
    private boolean m_inProcessServerInitialized;
    private static CAMFactory m_cf = new CAMFactory();

    public LogTCPSocketAppender(String name, Filter filter, String host, int port) {
        super(name, filter, null, true, Property.EMPTY_ARRAY);
        this.m_remoteHost = host;
        this.m_port = port;
        this.activateOptions();
    }

    @PluginFactory
    public static LogTCPSocketAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="Host") String host, @PluginAttribute(value="Port") int port) {
        return new LogTCPSocketAppender(name, filter, host, port);
    }

    private void initDirectAppend() {
        Class<?> inProcessServerClass;
        this.m_inProcessServer = LogIPFControl.getInProcessServer();
        if (null != this.m_inProcessServer && null != (inProcessServerClass = this.m_inProcessServer.getClass())) {
            try {
                this.m_inProcessServerLogMethod = inProcessServerClass.getMethod("log", byte[].class);
            }
            catch (NoSuchMethodException nsme) {
                LogIPFLog.warn("LogTCPSocketAppender:initDirectAppend() -- Could not find the log method in the Log Service.  The appender will use a TCP/IP socket to send indications.", nsme);
                this.m_inProcessServerLogMethod = null;
            }
        }
    }

    public void setRemoteHost(String host) {
        this.m_remoteHost = host;
    }

    public String getRemoteHost() {
        return this.m_remoteHost;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean getSecure() {
        return this.m_secure;
    }

    public void setSecure(boolean val) {
        this.m_secure = val;
    }

    public void setReconnectionDelay(int delay) {
        this.m_reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.m_reconnectionDelay;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.m_locationInfo = locationInfo;
    }

    public boolean getLocationInfo() {
        return this.m_locationInfo;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void activateOptions() {
        if (!this.m_closed) {
            if (!this.m_inProcessServerInitialized) {
                this.initDirectAppend();
            }
            if (this.isUsingRemoteConnection()) {
                this.connect();
            }
        }
    }

    private boolean isUsingRemoteConnection() {
        return null == this.m_inProcessServerLogMethod && null == this.m_appendStream && null == this.m_connector && this.m_remoteHost.length() > 0;
    }

    protected boolean connect() {
        if (null != m_cf) {
            try {
                Socket socket = m_cf.createSocket(this.m_remoteHost, this.m_port, this.m_secure);
                socket.setSoLinger(true, 65700);
                this.m_appendStream = new ObjectOutputStream(socket.getOutputStream());
                this.recoverFiles();
                return true;
            }
            catch (Exception e) {
                LogIPFLog.error("LogTCPSocketAppender:connect() -- Could not connect to Log Service [" + this.m_remoteHost + ":" + this.m_port + "].  ", e);
                this.m_appendStream = null;
                this._fireConnector();
            }
        }
        return false;
    }

    public void close() {
        if (!this.m_closed) {
            this.m_closed = true;
            this.cleanUp();
        }
    }

    public void cleanUp() {
        if (this.m_appendStream != null) {
            try {
                this.m_appendStream.close();
            }
            catch (IOException e) {
                LogIPFLog.error("LogTCPSocketAppender:cleanUp() -- Error closing the stream to the target host.  ", e);
            }
            this.m_appendStream = null;
        }
        if (this.m_connector != null) {
            this.m_connector.interrupt();
            try {
                this.m_connector.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_connector = null;
        }
    }

    @Override
    public void append(LogEvent event) {
        LogIndication ind = this.toLogIndication(event);
        if (ind == null) {
            return;
        }
        String loggerName = event.getLoggerName();
        if (null != this.m_inProcessServerLogMethod) {
            this.directAppend(loggerName, ind);
        } else {
            this.socketAppend(loggerName, ind);
        }
    }

    private void directAppend(String loggerName, ILogIndication ind) {
        if (!this.m_closed) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
                 ObjectOutputStream appendStream = new ObjectOutputStream(baos);){
                appendStream.writeUTF(loggerName);
                appendStream.writeObject(ind);
                appendStream.close();
                this.m_inProcessServerLogMethod.invoke(this.m_inProcessServer, new Object[]{baos.toByteArray()});
            }
            catch (Exception e) {
                LogIPFLog.warn("LogTCPSocketAppender:directAppend() -- IOException while appending indication.  ", e);
            }
        }
    }

    protected void socketAppend(String loggerName, ILogIndication ind) {
        if (!this.m_closed) {
            this.writeIndication(loggerName, ind);
        } else {
            LogIPFLog.debug("LogTCPSocketAppender:socketAppend() -- Cannot send indication because the appender has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndication(String loggerName, ILogIndication ind) {
        if (null != loggerName && null != ind) {
            LogTCPSocketAppender logTCPSocketAppender = this;
            synchronized (logTCPSocketAppender) {
                if (null != this.m_appendStream) {
                    try {
                        this.m_appendStream.writeUTF(loggerName);
                        this.m_appendStream.writeObject(ind);
                        this.m_appendStream.reset();
                        this.m_appendStream.flush();
                    }
                    catch (IOException ioe) {
                        LogIPFLog.warn("LogTCPSocketAppender:writeIndication() -- Error occurred while sending indication to target host.  Launching failover mechanism.  ", ioe);
                        this.m_appendStream = null;
                        this._fireConnector();
                        this.writeIndicationToRecoveryFile(loggerName, ind);
                    }
                } else {
                    this.writeIndicationToRecoveryFile(loggerName, ind);
                }
            }
        }
    }

    private synchronized void writeIndicationToRecoveryFile(String loggerName, ILogIndication ind) {
        if (null != this.m_recoveryObjectStream && this.m_recoveryFile.length() > 0x100000L) {
            try {
                this.m_recoveryObjectStream.close();
                this.m_recoveryObjectStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null == this.m_recoveryObjectStream) {
            this.generateRecoveryStream();
        }
        if (null != this.m_recoveryObjectStream) {
            try {
                this.m_recoveryObjectStream.writeUTF(loggerName);
                this.m_recoveryObjectStream.writeObject(ind);
                this.m_recoveryObjectStream.reset();
                this.m_recoveryObjectStream.flush();
            }
            catch (IOException ioe) {
                LogIPFLog.error("LogTCPSocketAppender.writeIndicationToRecoveryFile() -- Error occurred while writing indication to recovery file.  ", ioe);
            }
        }
    }

    private void generateRecoveryStream() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        StringBuffer filename = new StringBuffer();
        filename.append(cal.get(1));
        filename.append(cal.get(2));
        filename.append(cal.get(5));
        filename.append(cal.get(11));
        filename.append(cal.get(12));
        filename.append(cal.get(13));
        if (null == this.m_recoveryDirectory) {
            ICCLConfiguration config = CCLConfigurationFactory.getInstance();
            try {
                config.init();
                this.m_recoveryDirectory = config.resolveEffectivePath("../logs/recovery/remote");
                LogIPFLog.debug("LogTCPSocketAppender::generateRecoveryStream() - Setting recovery directory to: " + this.m_recoveryDirectory);
                File dir = new File(this.m_recoveryDirectory);
                if (!dir.exists()) {
                    LogIPFLog.debug("LogTCPSocketAppender::generateRecoveryStream() - Recovery directory does not exist.  Creating it.");
                    dir.mkdirs();
                }
            }
            catch (Exception e) {
                LogIPFLog.error("LogTCPSocketAppender:generateRecoveryStream() -- Error occurred while trying to resolve the effective path of the recovery directory.", e);
            }
        }
        File f = new File(this.m_recoveryDirectory + "/" + filename.toString());
        try {
            if (f.createNewFile()) {
                this.m_recoveryObjectStream = new ObjectOutputStream(new FileOutputStream(f));
                this.m_recoveryFile = f;
            }
        }
        catch (IOException ioe) {
            LogIPFLog.error("LogTCPSocketAppender:generateRecoveryStream() -- Error while creating the recovery stream.  ", ioe);
            this.m_recoveryObjectStream = null;
        }
    }

    private synchronized void recoverFiles() {
        File dir;
        if (null == this.m_recoveryDirectory) {
            ICCLConfiguration config = CCLConfigurationFactory.getInstance();
            try {
                config.init();
                this.m_recoveryDirectory = config.resolveEffectivePath("../logs/recovery/remote");
                File dir2 = new File(this.m_recoveryDirectory);
                if (!dir2.exists()) {
                    dir2.mkdirs();
                }
            }
            catch (CCLConfigurationException ccle) {
                LogIPFLog.warn("LogTCPSocketAppender:recoverFiles() -- CCLConfigurationException when resolve file path '../logs/recovery/remote'.", ccle);
            }
        }
        if (this.m_recoveryObjectStream != null) {
            try {
                this.m_recoveryObjectStream.close();
            }
            catch (IOException ioe) {
                LogIPFLog.debug("LogTCPSocketAppender:recoverFiles() -- Caught IOException while trying to close the recovery stream.", ioe);
            }
            this.m_recoveryObjectStream = null;
        }
        if ((dir = new File(this.m_recoveryDirectory)).exists() && dir.canRead() && dir.isDirectory()) {
            File[] recoveryFiles = dir.listFiles();
            for (int i = 0; i < recoveryFiles.length; ++i) {
                File f = recoveryFiles[i];
                this.recoverFile(f);
                try {
                    f.delete();
                    continue;
                }
                catch (Exception e) {
                    LogIPFLog.debug("Exception caught while trying to delete recovery file.\n\t", e);
                }
            }
        }
    }

    private void recoverFile(File file) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ObjectInputStream ois = new ObjectInputStream(bis);
            while (0 < ois.available()) {
                String loggerName = ois.readUTF();
                ILogIndication ind = (ILogIndication)ois.readObject();
                this.writeIndication(loggerName, ind);
            }
            ois.close();
        }
        catch (IOException e) {
            LogIPFLog.warn("LogTCPSocketAppender:recoverFile() -- Error occurred while recovering the recovery file.", e);
        }
        catch (ClassNotFoundException cnfe) {
            LogIPFLog.warn("LogTCPSocketAppender:recoverFile() -- Class for indication missing.  Check the classpath.  ", cnfe);
        }
    }

    protected void _fireConnector() {
        if (this.m_connector == null) {
            LogIPFLog.debug("LogTCPSocketAppender:_fireConnector() -- Starting a new connector thread.");
            this.m_connector = new Connector();
            this.m_connector.setDaemon(true);
            this.m_connector.setPriority(1);
            this.m_connector.start();
        }
    }

    public String toString() {
        return "LogTCPSocketAppender [remoteHost=" + this.m_remoteHost + ", port=" + this.m_port + "]";
    }

    static {
        byte[] initDocument = KEY_IPF.getBytes();
        try {
            m_cf.initialize(initDocument);
        }
        catch (Exception e) {
            LogIPFLog.error("LogTCPSocketAppender -- Cannot initialize CAMFactory.", e);
            m_cf = null;
        }
        Object var0 = null;
    }

    class Connector
    extends Thread {
        Connector() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Connector.sleep(LogTCPSocketAppender.this.m_reconnectionDelay);
                    LogIPFLog.debug("LogTCPSocketAppender.Connector::run() - Attempting connection to " + LogTCPSocketAppender.this.m_remoteHost + ":" + LogTCPSocketAppender.this.m_port);
                    if (!LogTCPSocketAppender.this.connect()) continue;
                    LogTCPSocketAppender.this.m_connector = null;
                    LogIPFLog.debug("LogTCPSocketAppender.Connection:run() -- Connection established.  Exiting connector thread.");
                }
                catch (InterruptedException e) {
                    LogTCPSocketAppender.this.m_connector = null;
                }
                break;
            }
        }
    }
}

