/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.appenders;

import com.cognos.indications.ILogAuditAccessIndication;
import com.cognos.indications.LogIndication;
import com.cognos.indications.appenders.LogAbstractAppender;
import java.util.Optional;
import org.apache.log4j.nt.NTEventLogAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="LogWindowsEventLogAppender", category="Core", elementType="appender", printObject=true)
public class LogWindowsEventLogAppender
extends LogAbstractAppender {
    private static final String SUCCESS = "success";
    private final NTEventLogAppender ntAppender = new NTEventLogAppender();

    public LogWindowsEventLogAppender(String name, Filter filter, Layout<String> layout, String server, String source) {
        super(name, filter, layout, true, Property.EMPTY_ARRAY);
        this.ntAppender.setSource(Optional.ofNullable(source).orElse("IBM Cognos"));
        this.ntAppender.activateOptions();
    }

    @PluginFactory
    public static LogWindowsEventLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<String> loyout, @PluginAttribute(value="String") String server, @PluginAttribute(value="String") String source) {
        return new LogWindowsEventLogAppender(name, filter, loyout, server, source);
    }

    @Override
    public void append(LogEvent event) {
        String status;
        if (event == null) {
            return;
        }
        int nt_category = event.getLevel().intLevel();
        LogIndication ind = this.toLogIndication(event);
        if (ind == null) {
            return;
        }
        Level newLevel = Level.INFO;
        if (ind instanceof ILogAuditAccessIndication && SUCCESS.equalsIgnoreCase(status = ((ILogAuditAccessIndication)((Object)ind)).getStatus())) {
            newLevel = Level.WARN;
        }
        ind.setLevel(newLevel.intLevel());
        this.ntAppender.append(ind.toString(), nt_category);
    }
}

