/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.internal;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LogIPFUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document loadIPFConfigFile(File file) throws Exception {
        EntityResolver resolver = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId.endsWith("log4j.dtd")) {
                    Class<?> clazz = this.getClass();
                    InputStream in = clazz.getResourceAsStream("/com/cognos/indications/log4j.dtd");
                    return new InputSource(in);
                }
                return null;
            }
        };
        try (BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(file));){
            DocumentBuilderFactory build = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuilder = build.newDocumentBuilder();
            InputSource input = new InputSource(fileStream);
            docbuilder.setEntityResolver(resolver);
            Document document = docbuilder.parse(input);
            return document;
        }
    }

    public static void updateDocWithResolvedPath(Document w3cDoc) {
        LogIPFUtils.updateDocWithResolvedPath(w3cDoc, true);
    }

    public static void updateDocWithResolvedPath(Document w3cDoc, boolean gAddProcID) {
        boolean bAddProcID = gAddProcID;
        Element root = w3cDoc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int childListLength = children.getLength();
        block0: for (int i = 0; i < childListLength; ++i) {
            Element currentElement;
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1 || !(currentElement = (Element)currentNode).getTagName().equals("appender")) continue;
            String sAddProdID = currentElement.getAttribute("addProcID");
            bAddProcID = sAddProdID != null && sAddProdID.equalsIgnoreCase("false") ? false : gAddProcID;
            NodeList params = currentElement.getChildNodes();
            int paramsListLength = params.getLength();
            for (int j = 0; j < paramsListLength; ++j) {
                String paramName;
                Element paramElement;
                Node paramNode = params.item(j);
                if (paramNode.getNodeType() != 1 || !(paramElement = (Element)paramNode).getTagName().equals("param") || null == (paramName = paramElement.getAttribute("name")) || !paramName.equals("File")) continue;
                String filePath = paramElement.getAttribute("value");
                String resolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(filePath);
                if (resolvedPath == null) continue block0;
                if (bAddProcID) {
                    resolvedPath = LogIPFUtils.addProcIDToFileName(resolvedPath, String.valueOf(LogIPFConfigure.DispatcherID));
                }
                paramElement.setAttribute("value", resolvedPath);
                continue block0;
            }
        }
    }

    public static String addProcIDToFileName(String resolvedFilePath, String procID) {
        String result = resolvedFilePath;
        if (procID == null || procID.length() == 0) {
            return result;
        }
        int dotidx = resolvedFilePath.lastIndexOf(".");
        result = dotidx > 0 ? resolvedFilePath.substring(0, dotidx) + "_" + procID + "." + resolvedFilePath.substring(dotidx + 1) : (dotidx == 0 ? procID + resolvedFilePath : resolvedFilePath + "_" + procID);
        return result;
    }

    public static ArrayList<File> getXmlFiles(File parentFolder) {
        if (parentFolder == null || !parentFolder.exists() || !parentFolder.isDirectory()) {
            LogIPFLog.debug("LogIPFUtils:getXmlFiles - The parent folder '" + parentFolder + "' doesn't exist or is not a folder, return empty list.");
            return new ArrayList<File>();
        }
        FileFilter xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String filename;
                int i;
                return f != null && f.isFile() && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1 && filename.substring(i + 1).toLowerCase().compareTo("xml") == 0;
            }
        };
        File[] xmlfiles = parentFolder.listFiles(xmlFilter);
        if (xmlfiles != null && xmlfiles.length > 0) {
            return new ArrayList<File>(Arrays.asList(xmlfiles));
        }
        return new ArrayList<File>();
    }
}

