/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.internal.config;

import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.CCLResolveInetAddress;
import com.cognos.cclcfgapi.CCLStartupConfiguration;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.internal.config.IPFConfigNotifyAcceptor;
import com.cognos.indications.internal.config.LogConfigurationObservable;
import com.cognos.indications.internal.config.LogFileWatcher;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class LogIPFControlInternal {
    protected static byte[] m_ipaddr;
    protected static String m_ipaddrStr;
    protected static short m_tzOffset;
    private static SigningSession m_CAMSigningSession;
    private static boolean m_bIsForIPFTest;
    private static boolean m_bIsInitUsingConfigFile;
    private static final char[] hex_chars;
    static String[] m_errMsgString;
    protected static long counterRef;
    protected static boolean m_isConfigurationDone;
    protected static ArrayList<Thread> m_listWatchThreads;
    protected static LogConfigurationObservable m_configObservable;

    public static byte[] get_ipaddr() {
        return m_ipaddr;
    }

    public static String get_ipaddrStr() {
        return m_ipaddrStr;
    }

    private static String hexify(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(hex_chars[b & 0xF]).append(hex_chars[(b & 0xF0) >> 4]);
        }
        return sb.toString();
    }

    public static void setForIPFTesting() {
        m_bIsForIPFTest = true;
    }

    public static void setPropForIPFTesting(String ipstr, int procID) {
        m_bIsForIPFTest = true;
        m_ipaddrStr = ipstr;
        LogIPFConfigure.DispatcherID = procID;
    }

    public static boolean isInitUsingConfigFile() {
        return m_bIsInitUsingConfigFile;
    }

    public static synchronized boolean initialize(String configFilename) {
        LogIPFLog.debug("LogIPFControlInternal::initialize(configFilename) - begin. config file name: " + configFilename);
        boolean result = true;
        if (counterRef > 0L) {
            LogIPFLog.debug("LogIPFControlInternal::initialize(configFilename) - counterRef > 0, IPF has been initialized, return true.");
            ++counterRef;
            return result;
        }
        if (!LogIPFControlInternal.initCAMCrypto()) {
            LogIPFLog.warn("LogIPFControlInternal::initialize() - initCAMCrypto() failed, return false.");
            return false;
        }
        try {
            String fileName;
            ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
            try {
                myConf.init();
                fileName = myConf.resolveEffectivePath(configFilename);
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.warn("LogIPFControlInternal::initialize(configFilename) - ICCLConfiguration.init() call failed with ", e);
                fileName = configFilename;
            }
            LogIPFLog.debug("LogIPFControlInternal::initialize(configFilename) - resolved file name: " + fileName);
            if (new File(fileName).exists()) {
                LogIPFConfigure.configAndInitIPFLoggers(fileName);
                ++counterRef;
                LogIPFControlInternal.getStrings();
                m_bIsInitUsingConfigFile = true;
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFControlInternal::initialize(configFilename) - Exception ", e);
            result = false;
        }
        LogIPFLog.debug("LogIPFControlInternal::initialize(configFilename) - end");
        return result;
    }

    private static synchronized void startWatchThreads() {
        LogIPFLog.debug("LogIPFControlInternal::startWatchThreads().");
        for (Thread th : m_listWatchThreads) {
            if (th == null) continue;
            th.setDaemon(true);
            th.start();
        }
    }

    private static synchronized void stopWatchThreads() {
        LogIPFLog.debug("LogIPFControlInternal::stopWatchThreads().");
        for (Thread th : m_listWatchThreads) {
            if (th == null) continue;
            th.interrupt();
            try {
                th.join();
            }
            catch (InterruptedException e) {
                LogIPFLog.debug("LogIPFControlInternal::stopWatchThreads() - file watch thread interrupted during join.", e);
            }
            LogIPFLog.debug("LogIPFControlInternal::stopWatchThreads() - " + th.getClass());
        }
    }

    public static synchronized boolean initialize() {
        LogIPFLog.debug("LogIPFControlInternal::initialize() - begin.");
        boolean result = true;
        if (counterRef > 0L) {
            LogIPFLog.debug("LogIPFControlInternal::initialize() - counterRef > 0, IPF has been initialized, return true.");
            ++counterRef;
            return result;
        }
        LogIPFControlInternal.getStrings();
        if (!LogIPFControlInternal.initCAMCrypto()) {
            LogIPFLog.warn("LogIPFControlInternal::initialize() - initCAMCrypto() failed, return false.");
            return false;
        }
        try {
            m_configObservable = new LogConfigurationObservable();
            ICCLConfiguration aConf = CCLConfigurationFactory.createConfiguration();
            aConf.init();
            String log4j2configfilePath = aConf.resolveEffectivePath("../configuration/data/logging");
            m_listWatchThreads.add(new LogFileWatcher(log4j2configfilePath, new IPFConfigNotifyAcceptor()));
            LogIPFControlInternal.startWatchThreads();
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFControlInternal::initialize() - Unknown error during initialize:", e);
        }
        try {
            LogIPFConfigure.configWithDefaultClientSettings();
            ++counterRef;
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFControlInternal::initialize() -  exception while calling LogIPFConfigure.clientIniBering(null)", e);
            result = false;
        }
        LogIPFLog.debug("LogIPFControlInternal::initialize() - end with counterRef = '" + counterRef + "'");
        return result;
    }

    public static synchronized boolean configure(ICCLConfiguration cclConfig) {
        LogIPFLog.debug("LogIPFControlInternal::configure(cclConfig) - begin.");
        boolean result = true;
        if (LogIPFControlInternal.isInitUsingConfigFile()) {
            LogIPFLog.debug("LogIPFControlInternal::configure(cclConfig) -  IPF is initialized by an specified config file, return true.");
            return result;
        }
        if (counterRef == 0L) {
            LogIPFLog.warn("LogIPFControlInternal::configure(cclConfig) - not initialized yet, call LogIPFControl.initialize first. return false");
            return false;
        }
        if (cclConfig == null) {
            LogIPFLog.debug("LogIPFControlInternal::configure(cclConfig) - ICCLConfiguration is null, return false");
            return false;
        }
        try {
            LogIPFConfigure.clientInitialize(cclConfig);
            if (!m_isConfigurationDone) {
                m_isConfigurationDone = true;
            }
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFControlInternal::configure(cclConfig) - exception while calling LogIPFConfigure.clientInitialize(cclConfig):", e);
            result = false;
        }
        LogIPFLog.debug("LogIPFControlInternal::configure(cclConfig) - end.");
        return result;
    }

    public static synchronized void stop() {
        LogIPFLog.debug("LogIPFControlInternal::stop() - begin.");
        if (counterRef > 0L && --counterRef == 0L) {
            LogIPFLog.debug("LogIPFControlInternal::stop() - (--counterRef == 0), stop watch dog thread and shutdown loggers.");
            LogIPFControlInternal.stopWatchThreads();
            LogIPFConfigure.stopIPFLoggers();
            m_isConfigurationDone = false;
        }
        LogIPFLog.debug("LogIPFControlInternal::stop() - end.");
    }

    public static void getStrings() {
        Locale here;
        ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
        try {
            myConf.init();
            String localeString = myConf.getValue("serverLocale", false);
            if (localeString.length() != 0) {
                StringTokenizer st = new StringTokenizer(localeString, "_-", false);
                String languageLoc = st.nextToken();
                if (st.hasMoreTokens()) {
                    String countryLoc = st.nextToken();
                    here = new Locale(languageLoc, countryLoc);
                } else {
                    here = new Locale(languageLoc, "");
                }
            } else {
                here = Locale.getDefault();
            }
        }
        catch (CCLConfigurationException e) {
            here = Locale.getDefault();
        }
        try {
            ResourceBundle textvals = ResourceBundle.getBundle("Log", here);
            LogIPFControlInternal.m_errMsgString[0] = textvals.getString("err0");
            LogIPFControlInternal.m_errMsgString[1] = textvals.getString("err1");
            LogIPFControlInternal.m_errMsgString[2] = textvals.getString("err2");
            LogIPFControlInternal.m_errMsgString[3] = textvals.getString("err3");
            LogIPFControlInternal.m_errMsgString[4] = textvals.getString("err4");
            LogIPFControlInternal.m_errMsgString[5] = textvals.getString("err5");
            LogIPFControlInternal.m_errMsgString[6] = textvals.getString("err6");
        }
        catch (MissingResourceException e) {
            LogIPFLog.debug("LogIPFControlInternal::getStrings() - Log_" + here.getLanguage() + ".properties missing.");
        }
    }

    public static String getErrMsg(short errCode) {
        if (errCode < 0 || errCode > 6) {
            return null;
        }
        return m_errMsgString[errCode];
    }

    public static void addConfigObserver(Observer o) {
        if (m_configObservable != null) {
            m_configObservable.addObserver(o);
        }
    }

    public static void notifyConfigObservers() {
        if (m_configObservable != null) {
            m_configObservable.setChanged();
            m_configObservable.notifyObservers();
        }
    }

    private static synchronized boolean initCAMCrypto() {
        LogIPFLog.debug("LogIPFControlInternal::initCAMCrypto() - begin.");
        if (m_bIsForIPFTest) {
            LogIPFLog.debug("LogIPFControlInternal::initCAMCrypto() - This is just for IPF testing, no need to initialize CAMCrypto stuff, return true.");
            return true;
        }
        if (m_CAMSigningSession == null) {
            m_CAMSigningSession = LogIPFConfigure.initCAMCrypto();
        }
        return m_CAMSigningSession != null;
    }

    public static String generateSessionID(String passportId, boolean[] flags) throws Exception {
        if (passportId == null || passportId.length() == 0) {
            return LogIPFControlInternal.addFlagToSessionID(passportId, flags);
        }
        String sessionID = "";
        if (m_CAMSigningSession != null) {
            try {
                byte[] hashObj = m_CAMSigningSession.hash(passportId.getBytes("UTF-8"));
                if (hashObj != null) {
                    sessionID = LogIPFControlInternal.hexify(hashObj);
                }
                LogIPFLog.warn("LogIPFControlInternal::generateSessionID -- m_CAMSigningSession.hash() return null. ");
            }
            catch (Exception e) {
                LogIPFLog.error("LogIPFControlInternal::generateSessionID -- Could not hash the session id, throw the exception. ", e);
                throw e;
            }
        } else if (m_bIsForIPFTest) {
            LogIPFLog.debug("LogIPFControlInternal::generateSessionId -- m_CAMSigningSession == null and this is just for testing, we don't need to hash the passport id for real, just use as it is.");
            byte[] hashObj = passportId.getBytes();
            sessionID = LogIPFControlInternal.hexify(hashObj);
        } else {
            String msg = "LogIPFControlInternal::generateSessionID -- the CAM signing session is null, could not hash the session id.";
            LogIPFLog.error(msg);
            throw new Exception(msg);
        }
        return LogIPFControlInternal.addFlagToSessionID(sessionID, flags);
    }

    public static String addFlagToSessionID(String sessionId, boolean[] flags) {
        String enableDyeTrace = "1";
        if (flags != null && flags.length > 0 && !flags[0]) {
            enableDyeTrace = "0";
        }
        return "f:" + enableDyeTrace + ":" + sessionId;
    }

    public static short getTimeZoneOffset() {
        Calendar cal = Calendar.getInstance();
        m_tzOffset = (short)((cal.get(15) + cal.get(16)) / 60000);
        return m_tzOffset;
    }

    static {
        m_CAMSigningSession = null;
        m_bIsForIPFTest = false;
        m_bIsInitUsingConfigFile = false;
        InetAddress addr = null;
        StringBuffer buffer = new StringBuffer();
        CCLStartupConfiguration startupConfig = new CCLStartupConfiguration();
        int result = startupConfig.getValue("externalDispatcher", false, buffer);
        String dispatcherValue = buffer.toString();
        try {
            URI uri = new URI(dispatcherValue);
            String domain = uri.getHost();
            InetAddress dispatcherAddr = InetAddress.getByName(domain);
            if (domain != null && dispatcherAddr != null && domain.equals(dispatcherAddr.getHostAddress())) {
                addr = dispatcherAddr;
            }
        }
        catch (URISyntaxException e) {
            LogIPFLog.error("LogIPFControl Dispatcher domain is not valid format.");
        }
        catch (UnknownHostException e) {
            LogIPFLog.error("LogIPFControl couldn't find host name network interface");
        }
        if (addr == null) {
            try {
                addr = CCLResolveInetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                LogIPFLog.error("LogIPFControl couldn't find host name network interface");
                addr = CCLResolveInetAddress.getLoopbackAddress();
            }
        }
        if (addr != null) {
            m_ipaddr = addr.getAddress();
            m_ipaddrStr = addr.getHostAddress();
            if (m_ipaddrStr.indexOf(58) != -1) {
                m_ipaddrStr = "[" + m_ipaddrStr + "]";
            }
        } else {
            LogIPFLog.error("LogIPFControl couldn't find local loopback network interface");
        }
        Calendar cal = Calendar.getInstance();
        m_tzOffset = (short)((cal.get(15) + cal.get(16)) / 60000);
        hex_chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        m_errMsgString = new String[7];
        counterRef = 0L;
        m_isConfigurationDone = false;
        m_listWatchThreads = new ArrayList();
        m_configObservable = null;
    }
}

