/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tasks.thread.CommonTimerTasks;
import com.cognos.jsmcommon.util.Controller;
import java.util.TimerTask;

public class AgentHouseKeeper
extends TimerTask
implements Controller {
    public static final long DEFAULT_INTERVAL = 8L;
    public static final boolean DEFAULT_RUN_STARTUP = false;

    public synchronized void start() {
        long interval = 8L;
        boolean atStartup = false;
        String sInt = this.getProperty("housekeeping.run.interval");
        String sStart = this.getProperty("housekeeping.run.startup");
        try {
            interval = sInt != null ? (long)Integer.valueOf(sInt).intValue() : interval;
        }
        catch (NumberFormatException e) {
            interval = 8L;
        }
        atStartup = sStart != null ? "TRUE".equalsIgnoreCase(sStart) : atStartup;
        interval = interval > 0L ? interval * 3600000L : 28800000L;
        this.schedule(interval, atStartup);
    }

    protected void schedule(long interval, boolean atStartup) {
        CommonTimerTasks.getInstance().schedule((TimerTask)this, atStartup ? 0L : interval, interval);
    }

    protected String getProperty(String key) {
        try {
            return CRNProperties.getInstance().getProperty(key);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)e);
            SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).debug("Error when retrieving the property [" + key + "] for the agentState housekeeping thread. " + "Default value will be used.");
            return null;
        }
    }

    public synchronized void stop() {
        this.cancel();
    }

    @Override
    public void run() {
        ContentManagerServiceClientPort cm = null;
        try {
            cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(new BiBusHeader()));
            this.cleanupAgentState(cm);
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Error running the agent house keeping thread.");
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug((Throwable)e);
            SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        finally {
            if (cm != null) {
                cm.close();
            }
        }
    }

    public void cleanupAgentState(ContentManagerServiceClientPort cm) {
        try {
            String path = "/transientStateFolder/agentState[not(@definition)]";
            PropEnum[] props = new PropEnum[]{PropEnum.storeID, PropEnum.searchPath};
            cm.signNextRequest("ASV");
            BaseClass[] objects = cm.query(path, props, new Sort[0], new QueryOptions());
            if (objects != null) {
                AgentHouseKeeper.debugLog(objects.length + " agentState objects found for deletion.");
                DeleteOptions opts = new DeleteOptions();
                opts.setRecursive(true);
                opts.setForce(true);
                int deleteCount = 0;
                for (int i = 0; i < objects.length; ++i) {
                    cm.signNextRequest("ASV");
                    Integer count = cm.delete(new BaseClass[]{objects[i]}, opts);
                    if (count > 0) {
                        ++deleteCount;
                    }
                    Thread.sleep(100L);
                }
                AgentHouseKeeper.debugLog("Total number of agentState objects deleted :" + deleteCount);
            } else {
                AgentHouseKeeper.debugLog("No agentState objects found for deletion.");
            }
        }
        catch (SDKClientException e) {
            AgentHouseKeeper.debugLog(e.getMessage());
        }
        catch (EMFSecurityException e) {
            AgentHouseKeeper.debugLog(e.getMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void debugLog(String msg) {
        SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(AgentHouseKeeper.class + " " + msg);
    }
}

