/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVVersionInfo;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.AgentDefinition;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryFrameworkSpecification;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.jsmcommon.audit.CommonServiceLogUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.UserAccountUtil;

public class AgentMonitorUtil {
    private static CommonServiceLogUtil m_CommonServiceLogUtil = null;
    private static final String category = "Audit.RTUsage.ASV";

    public static AsynchReply run(AsyncConversation conversation_handler, Client.ServiceEnum service, String searchPath, JobBiBusHeaders headers, BaseClass baseClass, ParameterValue[] parameters, Option[] options) throws LocalizableException {
        ServiceAPI servicePort = null;
        AsynchReply reply = null;
        SearchPathSingleObject sp = new SearchPathSingleObject();
        sp.set_value(searchPath);
        String agentRunStatus = "Success";
        String agentRunError = "";
        try {
            AgentMonitorUtil.debugLog(searchPath, headers).logASVDebug("Start Agent object " + searchPath + " on " + service.toString());
            if (service == Client.ServiceEnum.MONITOR_SERVICE) {
                if (OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)AsynchOptionEnum.runContext) == null) {
                    ContentManagerServiceClientPort cm = Client.instance().getContentManagerServiceClient(headers);
                    BaseClass bc = ObjectModelUtil.getBaseClass((ContentManagerServiceClientPort)cm, (SearchPathSingleObject)sp, (PropEnum[])ObjectModelUtil.PERMISSSION_PROPS);
                    servicePort = Client.instance().getServiceAPI(headers, bc);
                } else {
                    options = OptionUtils.removeOption((Option[])options, (String)AsynchOptionEnum.primaryWaitThreshold.getValue());
                }
            }
            if (servicePort == null) {
                servicePort = Client.instance().getServiceAPI(headers, service);
            }
            reply = servicePort.run(sp, parameters, options);
            reply = conversation_handler.doConversationWithRelease(servicePort, reply);
        }
        catch (EMFSecurityException cse) {
            AgentMonitorUtil.debugLog(searchPath, headers).logASVError("Finish Agent object " + searchPath + " on " + service.toString() + " with EMFSecurityException");
            agentRunStatus = "Failed";
            AgentServiceException aex = new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{cse});
            agentRunError = aex.getMessage();
            throw aex;
        }
        catch (LocalizableException eee) {
            AgentMonitorUtil.debugLog(searchPath, headers).logASVError("Finish Agent object " + searchPath + " on " + service.toString() + " with LocalizableException " + eee.getMessage());
            agentRunStatus = "Failed";
            agentRunError = eee.getMessage();
            throw eee;
        }
        finally {
            if (servicePort != null) {
                servicePort.close();
            }
            AgentMonitorUtil.getLogUtil(searchPath, headers, baseClass).logAgentRun(parameters, options, "", agentRunStatus, agentRunError);
        }
        AgentMonitorUtil.debugLog(searchPath, headers).logASVDebug("Finish Agent object " + searchPath + " on " + service.toString() + " NORMAL Reply");
        return reply;
    }

    public static AsynchReply runSpecification(AsyncConversation conversation_handler, Client.ServiceEnum service, QueryFrameworkSpecification spec, JobBiBusHeaders headers, BaseClass baseClass, ParameterValue[] parameters, Option[] options) throws LocalizableException {
        ServiceAPI servicePort = null;
        AsynchReply reply = null;
        String agentRunStatus = "Success";
        String agentRunError = "";
        try {
            AgentMonitorUtil.debugLog("No SearchPath - SPEC", headers).logASVDebug("Start Agent specification on " + service.toString());
            servicePort = Client.instance().getServiceAPI(headers, service);
            reply = servicePort.runSpecification((AsynchSpecification)spec, parameters, options);
            reply = conversation_handler.doConversationWithRelease(servicePort, reply);
        }
        catch (EMFSecurityException cse) {
            AgentMonitorUtil.debugLog("No SearchPath - SPEC", headers).logASVError("Finish Agent specification on " + service.toString() + " with EMFSecurityException");
            agentRunStatus = "Failed";
            AgentServiceException aex = new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{cse});
            agentRunError = aex.getMessage();
            throw aex;
        }
        catch (LocalizableException eee) {
            AgentMonitorUtil.debugLog("No SearchPath - SPEC", headers).logASVError("Finish Agent specification on " + service.toString() + " with LocalizableException");
            agentRunStatus = "Failed";
            agentRunError = eee.getMessage();
            throw eee;
        }
        finally {
            if (servicePort != null) {
                servicePort.close();
            }
            AgentMonitorUtil.getLogUtil(spec.getValue().get_value(), headers, baseClass).logAgentRun(parameters, options, "", agentRunStatus, agentRunError);
        }
        AgentMonitorUtil.debugLog("No SearchPath - SPEC", headers).logASVDebug("Finish Agent specification on " + service.toString() + " NORMAL Reply");
        return reply;
    }

    private static CommonServiceLogUtil getLogUtil(String searchPath, JobBiBusHeaders headers, BaseClass baseClass) {
        String targetName;
        if (null == m_CommonServiceLogUtil) {
            Integer build_number = ASVVersionInfo.getBuild();
            m_CommonServiceLogUtil = CommonServiceLogUtil.getLogUtil((String)category, (Integer)build_number);
        }
        m_CommonServiceLogUtil.setTrackingInfo(headers.getBiBusHeader());
        UserAccountUtil uau = new UserAccountUtil(headers);
        m_CommonServiceLogUtil.setUserName(uau.getUserName());
        String objectPath = baseClass.getSearchPath() != null ? baseClass.getSearchPath().getValue() : "";
        String agentPath = baseClass.getSearchPath() != null ? baseClass.getSearchPath().getValue() : "";
        String string = targetName = baseClass.getDefaultName() != null ? baseClass.getDefaultName().getValue() : "";
        if (baseClass.getParent() != null && baseClass.getParent().getValue()[0] instanceof AgentDefinition) {
            agentPath = baseClass.getParent().getValue()[0].getSearchPath().getValue();
        }
        m_CommonServiceLogUtil.setObjectPath(objectPath);
        m_CommonServiceLogUtil.setAgentPath(agentPath);
        m_CommonServiceLogUtil.setTargetName(targetName);
        return m_CommonServiceLogUtil;
    }

    private static CommonServiceLogUtil debugLog(String searchPath, JobBiBusHeaders headers) {
        if (null == m_CommonServiceLogUtil) {
            Integer build_number = ASVVersionInfo.getBuild();
            m_CommonServiceLogUtil = CommonServiceLogUtil.getLogUtil((String)category, (Integer)build_number);
        }
        m_CommonServiceLogUtil.setObjectPath(searchPath);
        m_CommonServiceLogUtil.setTrackingInfo(headers.getBiBusHeader());
        if (m_CommonServiceLogUtil.isDebugOn()) {
            UserAccountUtil uau = new UserAccountUtil(headers);
            m_CommonServiceLogUtil.setUserName(uau.getUserName());
        } else {
            m_CommonServiceLogUtil.setUserName("-");
        }
        return m_CommonServiceLogUtil;
    }
}

