/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.AgentDefinition;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventRecord;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.HistoryDetailReportService;
import com.cognos.developer.schemas.bibus._3.MonitorServiceSpecification;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportVersion;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.MonitorServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskPropertyRecord;
import com.cognos.spec.previewAgent.castor.AgentPreview;
import com.cognos.spec.previewAgent.castor.AgentTaskPreview;
import com.cognos.spec.previewAgent.castor.OutputInfo;
import com.cognos.spec.previewAgent.castor.OutputInfos;
import com.cognos.spec.previewAgent.castor.TaskRunPreview;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class AgentPreviewBuilder {
    private static String eventSpecByEventIdStart = "<queryEventSpecification xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"eventSpecification.xsd\"><sort><order>ascending</order><sortItem>startTime</sortItem></sort><scope><eventID>";
    private static String eventSpecByEventIdEnd = "</eventID></scope><filters/></queryEventSpecification>";
    private static String eventSpecByParentEventIdStart = "<queryEventSpecification xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"eventSpecification.xsd\"><sort><order>ascending</order><sortItem>startTime</sortItem></sort><scope><parentEventID>";
    private static String eventSpecByParentEventIdEnd = "</parentEventID></scope><filters/></queryEventSpecification>";
    private static String AGENT_TASK_DEF_NAME = "AgentTaskDefinition.name:";
    private static String EMPTY_PREVIEW = "<agentPreview/>";
    private JobBiBusHeaders m_headers;

    public AgentPreviewBuilder(JobBiBusHeaders headers) {
        this.m_headers = headers;
    }

    public String getAgentPreview(String eventId) throws AgentServiceException {
        AgentPreview agentPreview = new AgentPreview();
        String eventSpecification = eventSpecByEventIdStart + eventId + eventSpecByEventIdEnd;
        AsynchDetail[] details = this.getDetails(eventSpecification);
        String agentName = null;
        String agentStoreId = null;
        AsynchDetailEventRecord agentEventRecordDetail = null;
        for (int i = 0; i < details.length; ++i) {
            AsynchDetailEventRecord eventRecordDetail;
            BaseClass[] runnableClasses;
            if (!(details[i] instanceof AsynchDetailEventRecord) || (runnableClasses = (eventRecordDetail = (AsynchDetailEventRecord)details[i]).getRunnable()) == null || runnableClasses.length <= 0 || !(runnableClasses[0] instanceof AgentDefinition)) continue;
            agentEventRecordDetail = eventRecordDetail;
            agentName = runnableClasses[0].getDefaultName().getValue();
            agentStoreId = runnableClasses[0].getStoreID().getValue().get_value();
        }
        String agentPreviewString = EMPTY_PREVIEW;
        if (agentEventRecordDetail != null) {
            agentPreview.setName(agentName);
            agentPreview.setAgentStoreId(agentStoreId);
            String parentEventId = agentEventRecordDetail.getEventID();
            this.addAgentTaskPreviews(agentPreview, parentEventId);
            StringWriter writer = new StringWriter();
            try {
                Marshaller marsh = new Marshaller((Writer)writer);
                marsh.setMarshalAsDocument(false);
                marsh.marshal((Object)agentPreview);
            }
            catch (IOException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            catch (MarshalException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            catch (ValidationException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            agentPreviewString = writer.toString();
        }
        return agentPreviewString;
    }

    private void addAgentTaskPreviews(AgentPreview agentPreview, String parentEventId) throws AgentServiceException {
        String eventSpecificationByParentId = eventSpecByParentEventIdStart + parentEventId + eventSpecByParentEventIdEnd;
        AsynchDetail[] childDetails = this.getDetails(eventSpecificationByParentId);
        for (int i = 0; i < childDetails.length; ++i) {
            if (!(childDetails[i] instanceof AsynchDetailEventRecord)) continue;
            AsynchDetailEventRecord eventRecordDetail = (AsynchDetailEventRecord)childDetails[i];
            String status = eventRecordDetail.getStatus();
            BaseClass[] runnableClasses = eventRecordDetail.getRunnable();
            if (runnableClasses == null || runnableClasses.length <= 0) continue;
            String targetStoreId = runnableClasses[0].getStoreID().getValue().get_value();
            String name = runnableClasses[0].getDefaultName().getValue();
            AgentTaskPreview agentTaskPreview = new AgentTaskPreview();
            agentTaskPreview.setTargetStoreId(targetStoreId);
            agentTaskPreview.setName(name);
            agentTaskPreview.setFailed(status.equalsIgnoreCase("failed"));
            agentPreview.addAgentTaskPreview(agentTaskPreview);
            this.addTaskRunPreview(agentTaskPreview, eventRecordDetail.getEventID());
        }
    }

    private void addTaskRunPreview(AgentTaskPreview agentTaskPreview, String eventId) throws AgentServiceException {
        String eventSpecificationChild = eventSpecByEventIdStart + eventId + eventSpecByEventIdEnd;
        AsynchDetail[] childDetails = this.getDetails(eventSpecificationChild);
        for (int i = 0; i < childDetails.length; ++i) {
            if (!(childDetails[i] instanceof AsynchDetailEventRecord)) continue;
            AsynchDetailEventRecord eventRecordDetail = (AsynchDetailEventRecord)childDetails[i];
            Object[] names = null;
            try {
                names = TaskPropertyRecord.getValues((TaskID)TaskID.fromEventId((String)eventId), (String)AGENT_TASK_DEF_NAME);
            }
            catch (TaskPersistLayerException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            if (names.length > 0) {
                agentTaskPreview.setName((String)names[0]);
            }
            String status = eventRecordDetail.getStatus();
            TaskRunPreview taskRunPreview = new TaskRunPreview();
            taskRunPreview.setEventId(eventId);
            if (this.isCompletedStatus(status)) {
                taskRunPreview.setStatus("COMPLETED");
            }
            agentTaskPreview.addTaskRunPreview(taskRunPreview);
            BaseClass[] runnableClasses = eventRecordDetail.getRunnable();
            if (runnableClasses == null || runnableClasses.length <= 0 || !(runnableClasses[0] instanceof Report)) continue;
            this.addOutputInfo(taskRunPreview, (Report)runnableClasses[0], eventRecordDetail);
        }
    }

    public AsynchDetail[] getDetails(String eventSpecification) throws AgentServiceException {
        Specification spec = new Specification();
        spec.set_value(eventSpecification);
        MonitorServiceSpecification asynchSpec = new MonitorServiceSpecification();
        asynchSpec.setValue(spec);
        AsynchReply reply = null;
        MonitorServiceClientPort msPort = Client.instance().getMonitorServiceClient(this.m_headers);
        msPort.setLogCategory(ASVCategory.RUNTIME);
        try {
            reply = msPort.runSpecification((AsynchSpecification)asynchSpec, null, null);
            AsyncConversation conversation = new AsyncConversation();
            reply = conversation.doWaitConversation((ServiceAPI)msPort, reply);
        }
        catch (LocalizableException e) {
            throw new AgentServiceException(e);
        }
        catch (EMFSecurityException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        finally {
            msPort.close();
        }
        if (reply.getDetails() != null) {
            return reply.getDetails();
        }
        return new AsynchDetail[0];
    }

    private boolean isCompletedStatus(String status) {
        boolean isCompleted = false;
        if (status.equalsIgnoreCase("succeeded")) {
            isCompleted = true;
        }
        return isCompleted;
    }

    private void addOutputInfo(TaskRunPreview taskRunPreview, Report baseClass, AsynchDetailEventRecord eventRecordDetail) throws AgentServiceException {
        int i;
        OutputInfos outputInfos = new OutputInfos();
        String name = null;
        Locale locale = this.m_headers.getLocale();
        MultilingualTokenProp mltp = baseClass.getName();
        if (mltp != null && mltp.getValue() != null) {
            MultilingualToken[] mltArray = mltp.getValue();
            for (i = 0; i < mltArray.length; ++i) {
                if (!mltArray[i].getLocale().equalsIgnoreCase(locale.toString())) continue;
                name = mltArray[i].getValue();
                break;
            }
        }
        if (name == null) {
            name = baseClass.getDefaultName().getValue();
        }
        BaseClass[] details = eventRecordDetail.getHistoryDetails();
        for (i = 0; i < details.length; ++i) {
            HistoryDetailReportService hdrs;
            BaseClassArrayProp bcap;
            BaseClass[] value;
            if (!(details[i] instanceof HistoryDetailReportService) || !((value = (bcap = (hdrs = (HistoryDetailReportService)details[i]).getOutput()).getValue())[0] instanceof ReportVersion)) continue;
            ReportVersion reportVersion = (ReportVersion)value[0];
            Output[] outputs = this.getOutputs(reportVersion);
            for (int j = 0; j < outputs.length; ++j) {
                OutputInfo outputInfo = new OutputInfo();
                outputInfo.setId(baseClass.getStoreID().getValue().get_value());
                outputInfo.setName(name);
                outputInfo.setFormat(outputs[j].getFormat().getValue());
                outputInfo.setLocale(outputs[j].getLocale().getValue());
                outputInfos.addOutputInfo(outputInfo);
            }
        }
        if (outputInfos.getOutputInfoCount() > 0) {
            taskRunPreview.setOutputInfos(outputInfos);
        }
    }

    private Output[] getOutputs(ReportVersion reportVersion) throws AgentServiceException {
        ArrayList<Output> outputsList = new ArrayList<Output>();
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
        cmPort.setLogCategory(ASVCategory.RUNTIME);
        try {
            String outputStoreIdPath = reportVersion.getSearchPath().getValue() + "/output";
            PropEnum[] options = new PropEnum[]{PropEnum.storeID, PropEnum.defaultName, PropEnum.name, PropEnum.defaultOutputFormat, PropEnum.format, PropEnum.locale};
            QueryOptions queryOptions = new QueryOptions();
            BaseClass[] bases = cmPort.query(outputStoreIdPath, options, null, queryOptions);
            if (bases != null && bases.length > 0) {
                for (int i = 0; i < bases.length; ++i) {
                    outputsList.add((Output)bases[i]);
                }
            }
        }
        catch (SDKClientException e) {
            throw new AgentServiceException((LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        finally {
            cmPort.close();
        }
        return outputsList.toArray(new Output[0]);
    }
}

