/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.BaseStepObjectContainer;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.actions.PreviewAgentAction;
import com.cognos.asv.actions.ValidateAgentAction;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.parameters.TaskParamGenerator;
import com.cognos.asv.parameters.TaskParameterInfo;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetEmpty;
import com.cognos.asv.resultset.ResultSetFilterEnum;
import com.cognos.asv.resultset.ResultSetFiltered;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetSortTopic;
import com.cognos.asv.resultset.ResultSetSorted;
import com.cognos.asv.resultset.ResultSetTaskLevelFiltered;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.SuppressionFilters;
import com.cognos.asv.taskTargets.AgentReportTarget;
import com.cognos.asv.taskTargets.AgentTaskTarget;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseParameterAssignment;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.EventTypeEnum;
import com.cognos.developer.schemas.bibus._3.EventTypeEnumArrayProp;
import com.cognos.developer.schemas.bibus._3.MetadataModelItemNameProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterAssignmentDataItem;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.RunConditionEnum;
import com.cognos.developer.schemas.bibus._3.RunConditionEnumProp;
import com.cognos.developer.schemas.bibus._3.StringArrayProp;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.Iterator;

public class AgentTask
extends BaseStepObjectContainer {
    private ResultSet m_filtered_results;
    private BaseStepObject m_currentStep;
    private boolean m_byPassExecution;
    private String m_reportPath;

    public AgentTask(AgentTaskDefinition agentTaskDefinition, BaseStepObject parent, JobBiBusHeaders headers) {
        super((BaseClass)agentTaskDefinition, parent, headers);
    }

    public AgentTaskDefinition getAgentTaskDefinition() {
        return (AgentTaskDefinition)this.getBaseClass();
    }

    @Override
    public ParameterValue[] getParameters() throws AgentServiceException {
        String targetSearchPath = null;
        if (this.getCurrentStep() instanceof AgentTaskTarget) {
            AgentTaskTarget agentTaskTarget = (AgentTaskTarget)this.getCurrentStep();
            targetSearchPath = agentTaskTarget.getSearchPath() + "/report";
        } else if (this.getCurrentStep() instanceof AgentReportTarget) {
            targetSearchPath = this.getCurrentStep().getSearchPath();
        }
        TaskParamGenerator pgen = new TaskParamGenerator();
        TaskParameterInfo parameterInfo = pgen.makeParameterInfo(this, this.getResultSet(), targetSearchPath);
        this.setParameterInfo(parameterInfo);
        return this.getParameterInfo().getParameterValues();
    }

    @Override
    public Option[] getOptions() {
        return this.getAgentTaskDefinition().getOptions() != null ? this.getAgentTaskDefinition().getOptions().getValue() : null;
    }

    public BaseStepObject getCurrentStep() {
        return this.m_currentStep;
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        this.executeTask(new ValidateAgentAction(validateResult));
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        this.executeTask(new PreviewAgentAction(previewResult));
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        this.m_filtered_results = null;
        this.executeTask(action);
    }

    public void executeTask(AgentAction action) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        AgentServiceException rootException = null;
        boolean run_sub_steps = false;
        Iterator<BaseStepObject> iter = this.getSubSteps().iterator();
        while (iter.hasNext()) {
            ResultSet rs = this.getResultSet();
            boolean runOnFailure = this.getTaskRunCondition().equals((Object)RunConditionEnum.runOnFailure);
            ResultSet unfiltered_results = ((BaseAgent)this.getParent()).getResultSet();
            Iterator it = unfiltered_results.getData();
            int size = unfiltered_results.numDataItems();
            if (size == 0 || size == 1 && unfiltered_results.nullRow((ResultSetKey)it.next())) {
                if (this.getSuppressionFilters().containsFilter(ResultSetFilterEnum.NIL) || runOnFailure) {
                    run_sub_steps = true;
                    this.setResultSet(ResultSetEmpty.getResultSetMaintainMetadata(unfiltered_results));
                }
            } else {
                Iterator rsIt = rs.getData();
                int rsSize = rs.numDataItems();
                if (rsSize > 0 && !rs.nullRow((ResultSetKey)rsIt.next()) || runOnFailure) {
                    run_sub_steps = true;
                }
            }
            this.m_currentStep = iter.next();
            try {
                if (run_sub_steps && rootException == null) {
                    action.doActions(this.m_currentStep);
                    continue;
                }
                if (rootException != null) {
                    action.doFailActions(this.m_currentStep);
                    continue;
                }
                this.m_byPassExecution = true;
                action.doFailActions(this.m_currentStep);
            }
            catch (AgentServiceException e) {
                rootException = e;
            }
        }
        if (rootException == null) {
            if (this.getSuceeded() || this.m_byPassExecution) {
                this.setStatus(EventStatus.SUCCEEDED);
            } else {
                this.setStatus(EventStatus.FAILED);
            }
        } else {
            this.setStatus(EventStatus.FAILED);
            throw rootException;
        }
    }

    public boolean getSuceeded() {
        boolean succeeded = true;
        for (BaseStepObject step : this.getSubSteps()) {
            EventStatus status = step.getStatus();
            succeeded = succeeded && (status.isEqualTo(EventStatus.SUCCEEDED) || status.isEqualTo(EventStatus.PURGED));
        }
        return succeeded;
    }

    public void setResultSet(ResultSet rs) {
        this.m_filtered_results = rs;
    }

    public void setResultSetWithSuppressionFilters(ResultSet rs) {
        SuppressionFilters suppressionFilters = this.getSuppressionFilters();
        if (suppressionFilters != null) {
            rs = new ResultSetFiltered(rs, suppressionFilters);
        }
        this.setResultSet(rs);
    }

    public ResultSet getResultSet() {
        if (this.m_filtered_results == null) {
            ResultSetSortTopic[] topics;
            BaseStepObject parent;
            SuppressionFilters suppressionFilters;
            ResultSet agentRS;
            this.m_filtered_results = agentRS = ((BaseAgent)this.getParent()).getResultSet();
            ResultSetTopic filterTopic = this.getTaskLevelFilter();
            if (filterTopic != null) {
                this.m_filtered_results = new ResultSetTaskLevelFiltered(this.m_filtered_results, filterTopic, "True");
            }
            if ((suppressionFilters = this.getSuppressionFilters()) != null) {
                this.m_filtered_results = new ResultSetFiltered(this.m_filtered_results, suppressionFilters);
            }
            if ((parent = this.getParent()) instanceof BaseAgent && (topics = ((BaseAgent)parent).getSortTopics()) != null && topics.length > 0) {
                this.m_filtered_results = new ResultSetSorted(this.m_filtered_results, topics);
            }
        }
        return this.m_filtered_results;
    }

    public String getDrillThroughValue(ResultSetDataValue rsdv, ResultSetTopic paramTopic) {
        String drillValue = null;
        for (BaseStepObject step : this.getSubSteps()) {
            BaseClass targetBase = step.getBaseClass();
            if (!(targetBase instanceof BaseReport) && !(targetBase instanceof BaseAgentDefinition) || this.getAgentTaskDefinition().getParameterAssignments() == null || this.getAgentTaskDefinition().getParameterAssignments().getValue() == null) continue;
            BaseParameterAssignment[] assignments = this.getAgentTaskDefinition().getParameterAssignments().getValue();
            String parameterName = null;
            for (int i = 0; i < assignments.length; ++i) {
                ParameterAssignmentDataItem padi = (ParameterAssignmentDataItem)assignments[i];
                if (padi.getDataItemName() == null || padi.getDataItemName().get_value() == null || !padi.getDataItemName().get_value().equals(paramTopic.reference())) continue;
                parameterName = padi.getDataItemName().get_value();
            }
            if (parameterName == null) continue;
            drillValue = rsdv.getDrillValue(this.m_reportPath, parameterName);
        }
        return drillValue;
    }

    public ResultSetTopic getTaskLevelFilter() {
        String filter;
        ResultSetLinePieces filterLines;
        Iterator filterIt;
        ResultSetTopic topic = null;
        MetadataModelItemNameProp filterProp = this.getAgentTaskDefinition().getFilterDataItemName();
        if (filterProp != null && filterProp.getValue() != null && (filterIt = (filterLines = new ResultSetLinePieces(filter = filterProp.getValue().get_value())).getTopics().iterator()).hasNext()) {
            topic = (ResultSetTopic)filterIt.next();
        }
        return topic;
    }

    public SuppressionFilters getSuppressionFilters() {
        SuppressionFilters suppressionFilters = null;
        AgentTaskDefinition agentTaskDefinition = this.getAgentTaskDefinition();
        EventTypeEnumArrayProp eventTypeEnumArrayProp = agentTaskDefinition.getEventTypes();
        if (eventTypeEnumArrayProp != null) {
            EventTypeEnum[] eventTypeEnumArray = eventTypeEnumArrayProp.getValue();
            BaseStepObject currentStep = this.m_currentStep == null ? this : this.m_currentStep;
            ResultSetFilterEnum[] filterEnums = currentStep.getFilter(eventTypeEnumArray);
            StringArrayProp topic_filters = agentTaskDefinition.getEventKey();
            suppressionFilters = new SuppressionFilters(filterEnums, topic_filters);
        }
        return suppressionFilters;
    }

    public RunConditionEnum getTaskRunCondition() {
        RunConditionEnum runCondition = RunConditionEnum.runOnSuccess;
        RunConditionEnumProp runConditionProp = this.getAgentTaskDefinition().getRunCondition();
        if (runConditionProp != null && runConditionProp.getValue() != null) {
            runCondition = runConditionProp.getValue();
        }
        return runCondition;
    }

    public boolean byPassedExecution() {
        return this.m_byPassExecution;
    }

    @Override
    public ResultSetFilterEnum[] getFilter(EventTypeEnum[] eventTypeEnumArray) {
        ArrayList<ResultSetFilterEnum> enums = new ArrayList<ResultSetFilterEnum>();
        if (eventTypeEnumArray != null && eventTypeEnumArray.length > 0) {
            for (int i = 0; i < eventTypeEnumArray.length; ++i) {
                ResultSetFilterEnum xenum = ResultSetFilterEnum.getFilterEnum(eventTypeEnumArray[i].getValue());
                enums.add(xenum);
            }
        } else {
            enums.add(ResultSetFilterEnum.NEW);
            enums.add(ResultSetFilterEnum.CHANGED);
            enums.add(ResultSetFilterEnum.UNCHANGED);
        }
        return enums.toArray(new ResultSetFilterEnum[0]);
    }

    public BaseAgentTaskTarget getTarget() {
        BaseAgentTaskTarget target = null;
        for (BaseStepObject base : this.getSubSteps()) {
            if (!(base instanceof BaseAgentTaskTarget)) continue;
            target = (BaseAgentTaskTarget)base;
            break;
        }
        return target;
    }
}

