/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.parameters.TaskParameterInfo;
import com.cognos.asv.resultset.ResultSetFilterEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.EventTypeEnum;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseStepObject {
    private BaseStepObject m_parent;
    private BaseClass m_baseClass;
    private EventStatus m_eventStatus;
    private JobBiBusHeaders m_headers;
    private boolean m_isCancelled;
    private Set m_dependent_targets = new HashSet();
    private TaskParameterInfo m_parameterInfo;
    private Option[] m_submitOptions;
    private ParameterValue[] m_submitParameters;
    private AsynchReply m_reply;

    public BaseStepObject(BaseClass baseClass, BaseStepObject parent, JobBiBusHeaders headers) {
        this.m_parent = parent;
        this.m_baseClass = baseClass;
        this.m_headers = headers;
        this.m_eventStatus = EventStatus.PENDING;
    }

    public String getSearchPath() {
        return this.m_baseClass.getSearchPath() != null ? this.m_baseClass.getSearchPath().getValue() : null;
    }

    public Guid getStoreID() {
        return this.m_baseClass.getStoreID() != null ? this.m_baseClass.getStoreID().getValue() : null;
    }

    public String getSearchPathStoreID() {
        Guid storeID;
        String ret_value = null;
        Guid guid = storeID = this.m_baseClass.getStoreID() != null ? this.m_baseClass.getStoreID().getValue() : null;
        if (storeID != null) {
            ret_value = ObjectModelUtil.getSearchPath((Guid)storeID).get_value();
        }
        return ret_value;
    }

    public BaseClass getBaseClass() {
        return this.m_baseClass;
    }

    public BaseStepObject getParent() {
        return this.m_parent;
    }

    public JobBiBusHeaders getHeaders() {
        return this.m_headers;
    }

    public void setStatus(EventStatus status) {
        this.m_eventStatus = status;
    }

    public EventStatus getStatus() {
        return this.m_eventStatus;
    }

    public Option[] getSubmitOptions() {
        return this.m_submitOptions;
    }

    public void setSubmitOptions(Option[] submitOptions) {
        this.m_submitOptions = submitOptions;
    }

    public ParameterValue[] getSubmitParameters() {
        return this.m_submitParameters;
    }

    public void setSubmitParameters(ParameterValue[] submitParameters) {
        this.m_submitParameters = submitParameters;
    }

    public void addDependentStepId(Guid storeId) {
        if (storeId != null) {
            this.m_dependent_targets.add(storeId.get_value());
        }
    }

    public String[] getDependentStepIds() {
        return this.m_dependent_targets.toArray(new String[0]);
    }

    public ResultSetFilterEnum[] getFilter(EventTypeEnum[] eventTypeEnumArray) {
        ArrayList<ResultSetFilterEnum> enums = new ArrayList<ResultSetFilterEnum>();
        if (eventTypeEnumArray != null && eventTypeEnumArray.length > 0) {
            for (int i = 0; i < eventTypeEnumArray.length; ++i) {
                ResultSetFilterEnum xenum = ResultSetFilterEnum.getFilterEnum(eventTypeEnumArray[i].getValue());
                enums.add(xenum);
            }
        } else {
            enums.add(ResultSetFilterEnum.NEW);
            enums.add(ResultSetFilterEnum.CHANGED);
            enums.add(ResultSetFilterEnum.UNCHANGED);
        }
        return enums.toArray(new ResultSetFilterEnum[0]);
    }

    public abstract ParameterValue[] getParameters() throws AgentServiceException;

    public abstract Option[] getOptions();

    public abstract void run(AgentAction var1) throws AgentServiceException;

    public abstract void validate(ValidationResultHandler var1) throws AgentServiceException;

    public abstract void preview(PreviewResultHandler var1) throws AgentServiceException;

    public void onStepFailed(AgentAction action) throws AgentServiceException {
    }

    public void doAction(AgentAction action) throws AgentServiceException {
        action.doActions(this);
    }

    public synchronized void cancel() {
        this.m_isCancelled = true;
    }

    public synchronized boolean isCancelled() {
        return this.m_isCancelled;
    }

    public AsynchReply getReply() {
        return this.m_reply;
    }

    public void setReply(AsynchReply reply) {
        this.m_reply = reply;
    }

    public TaskParameterInfo getParameterInfo() {
        return this.m_parameterInfo;
    }

    public void setParameterInfo(TaskParameterInfo parameterInfo) {
        this.m_parameterInfo = parameterInfo;
    }
}

