/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.reportTemplates.TemplateTransformer;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetTaskParameters;
import com.cognos.asv.resultset.ResultSetToRawRS;
import com.cognos.asv.streams.StringEncodedDataSource;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.pogo.pdk.MessageContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.attachments.SourceDataSource;
import org.apache.soap.util.mime.MimeUtils;

public class PromptPageGenerator {
    private BaseParameter[] m_unresolvedParameters;
    private ResultSetTaskParameters m_param_rs;
    private String m_agentPath;
    private Option[] m_options;
    private ParameterValue[] m_pvs;
    private String m_output = null;

    public PromptPageGenerator(BaseParameter[] unresolvedParameters, ResultSet rs, String agentPath, Option[] options, ParameterValue[] pvs) {
        this.m_unresolvedParameters = unresolvedParameters;
        this.m_param_rs = new ResultSetTaskParameters(rs, unresolvedParameters);
        this.m_agentPath = agentPath;
        this.m_options = options;
        this.m_pvs = pvs;
    }

    public AsynchReply getPropmptReply() throws AgentServiceException {
        if (this.m_unresolvedParameters == null || this.m_unresolvedParameters.length == 0) {
            return null;
        }
        AsynchReply reply = null;
        reply = new AsynchReply();
        AsynchRequest request = new AsynchRequest();
        request.setObjectPath(ObjectModelUtil.makeSearPathSingleObject((String)this.m_agentPath));
        request.setOptions(this.m_options);
        request.setParameters(this.m_pvs);
        reply.setPrimaryRequest(request);
        reply.setStatus(AsynchReplyStatusEnum.complete);
        AsynchDetail[] details = new AsynchDetail[]{};
        reply.setDetails(details);
        return reply;
    }

    public void addPromptPageAttachment(MessageContext mc) {
        try {
            mc.setProperty("response.attachments", Arrays.asList(this.getRFC_822InputStream(this.getContent())));
            mc.setProperty("response.boundary", (Object)MimeUtils.getUniqueValue());
        }
        catch (Throwable e) {
            if (e instanceof LocalizableException) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)e);
            }
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_PROMPT_PAGE_GENERATION_ERROR, new Object[]{e.getMessage()});
        }
    }

    private String getContent() throws AgentServiceException {
        TransformerThread tt = null;
        if (this.m_output == null) {
            try {
                HashMap<String, String> userOptions = new HashMap<String, String>();
                userOptions.put("ui.object", this.m_agentPath);
                ResultSetToRawRS rsWriter = new ResultSetToRawRS(this.m_param_rs, true, userOptions);
                PipedWriter pWriter = new PipedWriter();
                PipedReader pReader = new PipedReader(pWriter);
                tt = new TransformerThread(pReader);
                Thread trans = new Thread(tt);
                trans.start();
                rsWriter.convert(pWriter);
                pWriter.flush();
                pWriter.close();
                trans.join();
                String output = tt.getOutput();
                tt.throwError();
                this.m_output = tt.getOutput();
            }
            catch (Throwable e) {
                if (tt != null && tt.err != null) {
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_PROMPT_PAGE_GENERATION_ERROR, new Object[]{tt.err.getMessage()});
                }
                if (e instanceof LocalizableException) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)e);
                    throw new AgentServiceException((LocalizableException)e);
                }
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_PROMPT_PAGE_GENERATION_ERROR, new Object[]{e.getMessage()});
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_PROMPT_PAGE_GENERATION_ERROR, new Object[]{e.getMessage()});
            }
        }
        return this.m_output;
    }

    private InputStream getRFC_822InputStream(String content) throws MessagingException, IOException {
        StringEncodedDataSource ds = new StringEncodedDataSource(content, "UTF-8", "text/html");
        DataHandler dh = new DataHandler((DataSource)ds);
        MimeBodyPart mp = new MimeBodyPart();
        mp.setDataHandler(dh);
        mp.setHeader("Content-Type", "text/html");
        return mp.getInputStream();
    }

    private InputStream getRFC_822InputStream(InputStream content) throws IOException, MessagingException {
        SourceDataSource ds = new SourceDataSource("asvPromptPage", "text/html", new StreamSource(content));
        DataHandler dh = new DataHandler((DataSource)ds);
        MimeBodyPart mp = new MimeBodyPart();
        mp.setDataHandler(dh);
        mp.setHeader("Content-Type", "text/html");
        return mp.getInputStream();
    }

    public static void main(String[] args) {
        TransformerThread tt = null;
        try {
            HashMap userOptions = new HashMap();
            ResultSetToRawRS rsWriter = new ResultSetToRawRS(ResultSetTaskParameters.makeTestresultSet(), true, userOptions);
            PipedWriter pWriter = new PipedWriter();
            PipedReader pReader = new PipedReader(pWriter);
            tt = new TransformerThread(pReader);
            Thread trans = new Thread(tt);
            trans.start();
            rsWriter.convert(pWriter);
            pWriter.flush();
            pWriter.close();
            trans.join();
            String output = tt.getOutput();
            System.out.println(output);
            FileOutputStream fos = new FileOutputStream("..\\webcontent\\ags\\promptPageSample.htm");
            fos.write(tt.getOutput().getBytes("UTF-8"));
            fos.flush();
            fos.close();
        }
        catch (Throwable e) {
            if (tt != null && tt.err != null) {
                tt.err.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private static class TransformerThread
    implements Runnable {
        private String output;
        private Throwable err;
        private Reader reader;
        private static Properties TRANS_PROPS = new Properties();
        private static String m_gateway = "http://localhost:9300/p2pd/servlet/dispatch";

        public TransformerThread(Reader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                TemplateTransformer tt = new TemplateTransformer(TemplateTransformer.ASVPROMPT_PATH, TRANS_PROPS);
                this.output = tt.transformData(this.reader);
            }
            finally {
                Throwable t;
                this.err = t;
                try {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                }
                catch (IOException e) {
                    this.err = t;
                }
            }
        }

        public String getOutput() throws Throwable {
            return this.output;
        }

        public void throwError() throws Throwable {
            if (this.err != null) {
                throw this.err;
            }
        }

        private static String getGateway() {
            if (m_gateway == null) {
                try {
                    m_gateway = CRNProperties.getInstance().getProperty("gateway");
                }
                catch (Throwable e) {
                    m_gateway = "http://localhost:9300/p2pd/servlet/dispatch";
                }
            }
            return m_gateway;
        }

        static {
            TRANS_PROPS.setProperty("firstPage", "true");
            TRANS_PROPS.setProperty("htmlFragment", "true");
            TRANS_PROPS.setProperty("promptSupport", "true");
            TRANS_PROPS.setProperty("gatewayPath", TransformerThread.getGateway());
        }
    }
}

