/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class WSClassLoader {
    URLClassLoader m_cl;

    public WSClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this.m_cl = new URLClassLoader(WSClassLoader.addUserDir(), parent, factory);
    }

    public WSClassLoader(URL[] urls) {
        ClassLoader cl = this.getClass().getClassLoader();
        this.m_cl = new URLClassLoader(WSClassLoader.addUserDir(), cl);
    }

    public WSClassLoader(URL[] urls, ClassLoader parent) {
        this.m_cl = new URLClassLoader(WSClassLoader.addUserDir(), parent);
    }

    public static final URLClassLoader newInstance(final URL[] urls) {
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new WSClassLoader(urls);
            }
        });
    }

    public static final URLClassLoader newInstance(final URL[] urls, final ClassLoader parent) {
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new WSClassLoader(urls, parent);
            }
        });
    }

    public final synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> obj = this.m_cl.loadClass(name);
        return obj;
    }

    public static String getWSClassesFolder() {
        String result = "";
        try {
            result = CRNProperties.getInstance().getProperty("pwd") + File.separator + ".." + File.separator + "webapps" + File.separator + "p2pd" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator + "es_ws_objs" + File.separator;
            String str = CRNProperties.getInstance().getProperty("ES.webservice.objs.folder");
            if (str != null && str.trim().length() > 0) {
                result = str;
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, (LocalizableException)((Object)ex));
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        return result;
    }

    private static URL[] addUserDir() {
        File file = null;
        URL[] urls = new URL[]{};
        try {
            String dirLoc = WSClassLoader.getWSClassesFolder();
            file = new File(dirLoc);
            String[] dirLst = file.list();
            if (null != dirLst && dirLst.length > 0) {
                urls = new URL[dirLst.length];
                for (int i = 0; i < dirLst.length; ++i) {
                    URL jarFile;
                    file = new File(dirLoc + dirLst[i]);
                    urls[i] = jarFile = file.toURL();
                }
            }
        }
        catch (IOException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, (Throwable)ex);
        }
        return urls;
    }

    public static void main(String[] args) {
        WSClassLoader wcl = new WSClassLoader(null);
        try {
            Class clazz = wcl.loadClass("org.tempuri.WebService4.Service1.SystemInfo", false);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("ok");
    }
}

