/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.actions;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.TseRunSpec;
import com.cognos.asv.actions.RunAgentAction;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskPropertyRecord;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class QueueAction
extends RunAgentAction {
    protected TseRunSpec m_runSpec = new TseRunSpec();
    protected List<BiBusRunSpec> specs = new ArrayList<BiBusRunSpec>();

    public QueueAction() {
    }

    public QueueAction(BaseStepObject step) {
        super(step);
    }

    @Override
    public void doActions(BaseStepObject stepObject) throws AgentServiceException {
        this.specs.clear();
        super.doActions(stepObject);
    }

    @Override
    public AsynchReply runAgentTaskTarget(Client.ServiceEnum service, String searchPath, ParameterValue[] parameters, Option[] options) throws LocalizableException {
        BiBusRunSpec spec = new BiBusRunSpec(this.step.getHeaders().getBiBusHeader());
        spec.options = options;
        spec.parameters = parameters;
        spec.searchPath = searchPath;
        this.specs.add(spec);
        return null;
    }

    protected BiBusRunSpec getRunSpec() {
        return this.specs.get(0);
    }

    public List<BiBusRunSpec> getRunSpecs() {
        return this.specs;
    }

    @Override
    public void reset() {
        this.specs.clear();
        super.reset();
    }

    protected void queueAgentTasks(BaseAgent agent) throws TaskPersistLayerException {
        if (this.m_runSpec.isEmpty()) {
            return;
        }
        for (TseRunSpec.Task task : this.m_runSpec.getAllTasks()) {
            if (!(task.step instanceof BaseAgentTaskTarget)) continue;
            ((BaseAgentTaskTarget)task.step).preQueueTask((BiBusRunSpec)task.spec.getTask());
        }
        SequenceSpec[] spec = new SequenceSpec[this.m_runSpec.size()];
        int pos = 0;
        Iterator<TseRunSpec.Task> iter = this.m_runSpec.iterator();
        while (iter.hasNext()) {
            spec[pos++] = iter.next().spec;
        }
        TaskPersistLayer.TaskRecords[] records = TaskPersistLayer.getInstance().addTasksAndReturnAll(agent.getParentTaskID(), spec, true, false);
        this.addAgentTaskNameHistoryDetails(records);
    }

    protected void addAgentTaskNameHistoryDetails(TaskPersistLayer.TaskRecords[] records) throws TaskPersistLayerException, IllegalArgumentException {
        SpecRecord[] specRecords;
        SpecRecordMap specRecordMap = new SpecRecordMap(this.m_runSpec.getAllTasks(), records);
        for (SpecRecord specRecord : specRecords = specRecordMap.getSpecRecords()) {
            AgentTask parentTask;
            TseRunSpec.Task task = specRecord.runSpecTask;
            TaskRecord record = specRecord.TseRecords.taskRecord;
            String eventID = record.getTaskId().getID();
            BaseStepObject parent = task.step.getParent();
            if (!(parent instanceof AgentTask) || !((parentTask = (AgentTask)parent).getBaseClass() instanceof AgentTaskDefinition)) continue;
            AgentTaskDefinition taskDef = (AgentTaskDefinition)parentTask.getBaseClass();
            String storeID = taskDef.getStoreID().getValue().get_value();
            TaskPropertyRecord.addProperty((TaskID)TaskID.fromEventId((String)eventID), (String)"agentTaskDefinitionName", (Object)storeID);
        }
    }

    public TseRunSpec getTseRunSpec() {
        return this.m_runSpec;
    }

    private class SpecRecordMap {
        private Map<String, SpecRecord> specRecordMap = new HashMap<String, SpecRecord>();

        public SpecRecordMap(List<TseRunSpec.Task> runSpectasks, TaskPersistLayer.TaskRecords[] records) {
            for (TaskPersistLayer.TaskRecords taskRecord : records) {
                TaskRunSpec spec = taskRecord.taskRecord.getRunSpec();
                if (!(spec instanceof BiBusRunSpec)) continue;
                BiBusRunSpec biBusSpec = (BiBusRunSpec)spec;
                SpecRecord specrecord = new SpecRecord();
                specrecord.TseRecords = taskRecord;
                this.specRecordMap.put(biBusSpec.searchPath, specrecord);
            }
            for (TseRunSpec.Task runSpecTask : runSpectasks) {
                String searchpath = runSpecTask.step.getSearchPath();
                SpecRecord specrecord = this.specRecordMap.get(searchpath);
                if (specrecord == null) continue;
                specrecord.runSpecTask = runSpecTask;
            }
        }

        public SpecRecord[] getSpecRecords() {
            return this.specRecordMap.values().toArray(new SpecRecord[this.specRecordMap.size()]);
        }
    }

    private class SpecRecord {
        public TseRunSpec.Task runSpecTask;
        public TaskPersistLayer.TaskRecords TseRecords;

        private SpecRecord() {
        }
    }
}

