/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.actions;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.BaseStepObjectContainer;
import com.cognos.asv.TseRunSpec;
import com.cognos.asv.actions.QueueAction;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.taskTargets.AgentMemoTarget;
import com.cognos.developer.schemas.bibus._3.RunConditionEnum;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.util.Validate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueueAgentAction
extends QueueAction {
    private boolean newSequenceStep = true;
    private boolean parallelExecutionMode = true;

    private void addSteps(List<BaseStepObject> parallelSortedTasks, List<BaseStepObject> agentSubSteps, boolean memo) {
        for (BaseStepObject baseStepObject : agentSubSteps) {
            if (!(baseStepObject instanceof BaseStepObjectContainer)) continue;
            BaseStepObjectContainer container = (BaseStepObjectContainer)baseStepObject;
            List<BaseStepObject> steps = container.getSubSteps();
            for (int j = 0; j < steps.size(); ++j) {
                BaseStepObject obj = steps.get(j);
                if (obj instanceof AgentMemoTarget) {
                    if (!memo) continue;
                    parallelSortedTasks.add(baseStepObject);
                    continue;
                }
                if (memo) continue;
                parallelSortedTasks.add(baseStepObject);
            }
        }
    }

    public void queueAgentTasks(BaseAgent agent, boolean parallel) throws AgentServiceException, TaskPersistLayerException {
        this.parallelExecutionMode = parallel;
        int forceNewStepAfter = -1;
        if (parallel) {
            ArrayList<BaseStepObject> parallelSortedTasks = new ArrayList<BaseStepObject>();
            this.addSteps(parallelSortedTasks, agent.getSubSteps(), false);
            forceNewStepAfter = parallelSortedTasks.size();
            this.addSteps(parallelSortedTasks, agent.getSubSteps(), true);
            this.setCurrentAgentTaskIterator(parallelSortedTasks.iterator());
        } else {
            this.setCurrentAgentTaskIterator(agent.getSubSteps().iterator());
        }
        int i = 0;
        while (this.getCurrentAgentTaskIterator().hasNext()) {
            BaseStepObject next = this.getCurrentAgentTaskIterator().next();
            boolean isFailTask = false;
            if (next instanceof BaseStepObjectContainer) {
                if (next instanceof AgentTask) {
                    AgentTask taskStep = (AgentTask)next;
                    RunConditionEnum runCondition = taskStep.getTaskRunCondition();
                    isFailTask = RunConditionEnum.runOnFailure.equals((Object)runCondition);
                }
                if (!isFailTask) {
                    if (forceNewStepAfter == i) {
                        this.newSequenceStep = true;
                    }
                    BaseStepObject stepObject = next;
                    this.reset();
                    stepObject.run(this);
                    if (next instanceof AgentTask) {
                        AgentTask at = (AgentTask)next;
                        if (this.newSequenceStep && at.byPassedExecution()) {
                            ++forceNewStepAfter;
                            this.newSequenceStep = false;
                        }
                    }
                    this.queueAgentTaskTarget();
                    this.newSequenceStep = false;
                }
            }
            ++i;
        }
        this.queueAgentTasks(agent);
    }

    protected void queueAgentTaskTarget() {
        BaseAgentTaskTarget task = (BaseAgentTaskTarget)this.step;
        SequenceSpec.SeqType specType = null;
        specType = this.newSequenceStep ? SequenceSpec.SEQ_NEW : (this.parallelExecutionMode ? SequenceSpec.SEQ_SAME : SequenceSpec.SEQ_NEW);
        boolean firstOfBurst = true;
        for (BiBusRunSpec specNext : this.getRunSpecs()) {
            SequenceSpec seqSpec;
            if (!(specNext instanceof TaskRunSpec)) continue;
            if (firstOfBurst) {
                seqSpec = new SequenceSpec(specType, (TaskRunSpec)specNext);
                firstOfBurst = false;
            } else {
                seqSpec = new SequenceSpec(SequenceSpec.SEQ_SAME, (TaskRunSpec)specNext);
            }
            seqSpec.setStopOnError(!this.parallelExecutionMode);
            this.m_runSpec.addTask(task, seqSpec);
        }
    }

    public void queueAgentFailureTasks(BaseAgent agent) throws AgentServiceException, TaskPersistLayerException {
        List<BaseStepObject> subSteps = agent.getSubSteps();
        Iterator<BaseStepObject> iter = subSteps.iterator();
        TseRunSpec runSpec = new TseRunSpec();
        while (iter.hasNext()) {
            AgentTask taskStep;
            RunConditionEnum runCondition;
            BaseStepObject next = iter.next();
            if (!(next instanceof BaseStepObjectContainer) || !(next instanceof AgentTask) || !RunConditionEnum.runOnFailure.equals((Object)(runCondition = (taskStep = (AgentTask)next).getTaskRunCondition()))) continue;
            BaseStepObject stepObject = next;
            this.reset();
            stepObject.run(this);
            List<BaseStepObject> steps = ((BaseStepObjectContainer)next).getSubSteps();
            Validate.isTrue((steps.size() == 1 && steps.get(0) instanceof BaseAgentTaskTarget ? 1 : 0) != 0);
            BaseAgentTaskTarget task = (BaseAgentTaskTarget)steps.get(0);
            for (BiBusRunSpec specNext : this.getRunSpecs()) {
                SequenceSpec seqSpec = new SequenceSpec(SequenceSpec.SEQ_ON_FAILED, (TaskRunSpec)specNext);
                seqSpec.setStopOnError(false);
                runSpec.addTask(task, seqSpec);
            }
        }
        if (!runSpec.isEmpty()) {
            this.m_runSpec = runSpec;
        }
        this.queueAgentTasks(agent);
    }
}

