/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.actions;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.BaseStepObjectContainer;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ValidateAgentAction
extends AgentAction {
    private ValidationResultHandler m_validateResult;

    public ValidateAgentAction(ValidationResultHandler validateResult) {
        this.m_validateResult = validateResult;
    }

    @Override
    public void doActions(BaseStepObject step) throws AgentServiceException {
        try {
            if (this.checkAction(step)) {
                step.validate(this.m_validateResult);
            }
        }
        catch (AgentServiceException e) {
            this.m_validateResult.addValidationMessage(new I18NMessage((LocalizableException)e));
        }
    }

    public void executeInSeries(BaseAgent agent) throws AgentServiceException {
        for (BaseStepObject step : agent.getSubSteps()) {
            try {
                if (!this.checkAction(step)) continue;
                step.validate(this.m_validateResult);
            }
            catch (AgentServiceException e) {
                this.m_validateResult.addValidationMessage(new I18NMessage((LocalizableException)e));
            }
        }
    }

    @Override
    public void doFailActions(BaseStepObject step) throws AgentServiceException {
        this.doActions(step);
    }

    public void validateAgentTaskDependencies(BaseAgent agent) {
        if ("parallel".equals(agent.getSequencing())) {
            return;
        }
        List<BaseStepObject> steps = agent.getSubSteps();
        HashSet<String> executedTasks = new HashSet<String>();
        HashMap<String, String> taskNames = this.getTaskNameSet(steps);
        for (BaseStepObject object : steps) {
            if (!(object instanceof BaseStepObjectContainer)) continue;
            BaseStepObjectContainer bsoContainer = (BaseStepObjectContainer)object;
            List<BaseStepObject> subSteps = bsoContainer.getSubSteps();
            BaseAgentTaskTarget target = (BaseAgentTaskTarget)(subSteps.size() == 1 ? subSteps.get(0) : null);
            executedTasks.add(target.getStoreID().get_value());
            String[] dependentIds = target.getDependentStepIds();
            for (int i = 0; i < dependentIds.length; ++i) {
                if (!executedTasks.contains(dependentIds[i])) continue;
                Object[] params = new Object[]{taskNames.get(dependentIds[i]), taskNames.get(target.getSearchPathStoreID())};
                this.m_validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_INVALID_TASK_DEPENDENCY, params, SeverityEnum.warn));
            }
        }
    }

    private HashMap<String, String> getTaskNameSet(List<BaseStepObject> steps) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (BaseStepObject object : steps) {
            String id;
            if (!(object instanceof BaseStepObjectContainer)) continue;
            BaseStepObjectContainer bsoContainer = (BaseStepObjectContainer)object;
            List<BaseStepObject> subSteps = bsoContainer.getSubSteps();
            BaseAgentTaskTarget target = (BaseAgentTaskTarget)(subSteps.size() == 1 ? subSteps.get(0) : null);
            String name = id = target.getStoreID() != null ? target.getStoreID().get_value() : target.getSearchPath();
            if (target.getBaseClass() != null && target.getBaseClass().getDefaultName() != null) {
                name = target.getBaseClass().getDefaultName().getValue();
            }
            nameMap.put(id, name);
        }
        return nameMap;
    }

    private boolean checkAction(BaseStepObject step) {
        boolean doAction = true;
        if (step instanceof BaseAgentTaskTarget) {
            BaseAgentTaskTarget target = (BaseAgentTaskTarget)step;
            SeverityEnum severity_interest = this.m_validateResult.getValidationSeverity();
            SeverityEnum step_max_severity = target.getMaximumValidationSeverity();
            doAction = ObjectModelUtil.compareSeverity((SeverityEnum)step_max_severity, (SeverityEnum)severity_interest) >= 0;
        }
        return doAction;
    }
}

