/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.api;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentPreviewBuilder;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.factory.AgentFactory;
import com.cognos.asv.factory.AgentObjects;
import com.cognos.asv.factory.AsvRunnableAbstractFactory;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.AgentDefinition;
import com.cognos.developer.schemas.bibus._3.AgentDefinitionView;
import com.cognos.developer.schemas.bibus._3.AgentService_PortType;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportOutput;
import com.cognos.developer.schemas.bibus._3.AsynchDetailUnstructuredData;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.AuthoredReport;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.MonitorServiceEventID;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.AttachmentFactory;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.service.ServiceImplBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.HistoryTopicsEnum;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.RunOptionsInformation;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.util.TrackingThreadProperties;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import com.cognos.jsmcommon.util.ZipUtils;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;

public class AgentServiceImpl
extends ServiceImplBase
implements AgentService_PortType {
    public AsynchReply back(AsynchRequest arg0, ParameterValue[] arg1, Option[] arg2) throws RemoteException {
        return null;
    }

    public AsynchReply forward(AsynchRequest asynchRequest, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AsynchRequest conversation) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            Object ctxObj = this.getContextObject();
            if (ctxObj != null && ctxObj instanceof BaseStepObject) {
                BaseStepObject bso = (BaseStepObject)ctxObj;
                bso.cancel();
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public String[] getTranslatedHistoryTopic(String locale) throws RemoteException {
        ArrayList<String> result = new ArrayList<String>();
        if (locale == null || locale.length() == 0) {
            AgentServiceException e = new AgentServiceException(AsvI18NCode.MSG_ASV_MISSING_LOCALE_PARAMETER);
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)e);
            this.asvThrowAxisFault((Exception)((Object)e));
        }
        Locale localeObject = LocaleUtil.getLocale((String)locale);
        for (HistoryTopicsEnum enumTopic : HistoryTopicsEnum.getTopics()) {
            result.add(enumTopic.getTopicName(localeObject));
        }
        return result.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deleteHotList(SearchPathSingleObject objectPath) throws RemoteException {
        block18: {
            PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
            try {
                BiBusHeader header = this.extractBiBusHeader();
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                JobBiBusHeaders headers = new JobBiBusHeaders(header);
                this.authenticate(headers);
                if (objectPath == null) {
                    return;
                }
                String objectPathStr = objectPath.get_value();
                ContentManagerServiceClientPort contentManager = null;
                try {
                    contentManager = Client.instance().getContentManagerServiceClient(headers);
                    AgentObjects agentObjects = new AgentObjects();
                    agentObjects.cacheObjectsfromCM(objectPathStr, headers);
                    BaseStepObject runnable = AsvRunnableAbstractFactory.getRunnable(agentObjects, headers, new Option[0], new ParameterValue[0]);
                    BaseClass theAgent = runnable.getBaseClass();
                    if (!(theAgent instanceof AgentDefinition) && !(theAgent instanceof AgentDefinitionView)) {
                        throw new AgentServiceException(I18NCode.AGENT_INVALID_ERROR, new String[]{objectPathStr});
                    }
                    if (!AuthenticatorFactory.getInstance().hasPermission(theAgent, "write")) {
                        throw new AgentServiceException(I18NCode.SEC_NO_PRIVELEDGES);
                    }
                    StringProp theAgentSearchPath = theAgent.getSearchPath();
                    if (theAgentSearchPath != null) {
                        String agentStateSP = "/transientStateFolder/agentState[containsReferences(@definition, " + theAgentSearchPath.getValue() + ")]";
                        this.deleteAgentStateOutputs(agentStateSP, contentManager);
                        break block18;
                    }
                    throw new AgentServiceException(I18NCode.AGENT_INVALID_ERROR, new String[]{objectPathStr});
                }
                catch (AgentServiceException e) {
                    this.asvThrowAxisFault((Exception)((Object)e));
                }
                catch (SDKClientException e) {
                    this.asvThrowAxisFault((Exception)((Object)e));
                }
                catch (EMFSecurityException e2) {
                    this.asvThrowAxisFault((Exception)((Object)e2));
                    break block18;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (contentManager != null) {
                        contentManager.close();
                    }
                }
            }
            finally {
                ThreadProperties.clear();
                perf.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply validateAgent(AgentDefinition agent, Report report, AgentTaskDefinition[] agentTasks, ParameterValue[] parametervalues, Option[] options) throws RemoteException {
        AsynchReply asyncReply = null;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            RunOptionsInformation roi = new RunOptionsInformation(options);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            AgentObjects agent_objects = new AgentObjects(agent, (AuthoredReport)report, agentTasks, null);
            agent_objects.cacheObjectsfromCM(headers);
            agent_objects.populateTargetStoreIdsForValidate();
            AgentFactory factory = new AgentFactory(headers, agent_objects, new Option[0], new ParameterValue[0]);
            BaseAgent runnable = factory.getRunnableObject();
            this.setContextObject(runnable);
            ValidationResultHandler validateResult = new ValidationResultHandler(headers, roi.getValidationSeverity());
            runnable.validate(validateResult);
            this.debugWait("primary.wait.asv");
            validateResult.validate();
            asyncReply = new AsynchReply();
            asyncReply.setStatus(AsynchReplyStatusEnum.conversationComplete);
        }
        catch (AgentServiceException e) {
            this.asvThrowAxisFault((Exception)((Object)e));
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return asyncReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply previewRunningAgent(MonitorServiceEventID eventId) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply asynch_reply = null;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            AgentPreviewBuilder builder = new AgentPreviewBuilder(headers);
            String previewXml = builder.getAgentPreview(eventId.getEventID());
            AsynchDetailUnstructuredData adud = new AsynchDetailUnstructuredData();
            XmlEncodedXML xmlData = new XmlEncodedXML();
            xmlData.set_value(previewXml);
            adud.setData(xmlData);
            asynch_reply = new AsynchReply();
            asynch_reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
            asynch_reply.setDetails(new AsynchDetail[]{adud});
        }
        catch (AgentServiceException ase) {
            this.asvThrowAxisFault((Exception)((Object)ase));
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return asynch_reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply previewAgent(AgentDefinition agent, Report report, AgentTaskDefinition[] agentTasks) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply asynch_reply = null;
        AsynchDetailReportOutput asynch_report_output = null;
        SearchPathSingleObject ret_value = null;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            AgentObjects agent_objects = new AgentObjects(agent, (AuthoredReport)report, agentTasks, null);
            agent_objects.cacheObjectsfromCM(headers);
            AgentFactory factory = new AgentFactory(headers, agent_objects, new Option[0], new ParameterValue[0]);
            Agent baseAgent = (Agent)factory.getRunnableObject();
            this.setContextObject(baseAgent);
            PreviewResultHandler previewResult = new PreviewResultHandler(baseAgent);
            baseAgent.preview(previewResult);
            String previewSearchPath = previewResult.generatePreview(headers);
            ret_value = new SearchPathSingleObject();
            ret_value.set_value(previewSearchPath);
            asynch_report_output = new AsynchDetailReportOutput();
            Report preview_report = new Report();
            StringProp preview_report_searchpath = new StringProp();
            preview_report_searchpath.setValue(previewSearchPath);
            preview_report.setSearchPath(preview_report_searchpath);
            asynch_report_output.setOutputObjects(new BaseClass[]{preview_report});
            asynch_reply = new AsynchReply();
            asynch_reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
            asynch_reply.setDetails(new AsynchDetail[]{asynch_report_output});
            this.debugWait("primary.wait.asv");
        }
        catch (AgentServiceException e) {
            this.asvThrowAxisFault((Exception)((Object)e));
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return asynch_reply;
    }

    public void release(AsynchRequest conversation) throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply run(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        AsynchReply reply = null;
        try {
            BaseStepObject runnable;
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            String sessionUser = this.getSessionUser();
            if (sessionUser != null) {
                CAM cam = new CAM();
                cam.setCAMCredentialPath(sessionUser);
                cam.setAction("logonAs");
                header.setCAM(cam);
                try {
                    this.getAuthenticator().logon(headers);
                    TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)headers.getBiBusHeader());
                }
                catch (EMFSecurityException e) {
                    throw AxisFault.makeFault((Exception)((Object)e));
                }
                catch (SDKClientException e) {
                    throw AxisFault.makeFault((Exception)((Object)e));
                }
            }
            this.authenticate(headers);
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)headers.getBiBusHeader());
            String objectPathStr = objectPath.get_value();
            AgentObjects agentObjects = new AgentObjects();
            agentObjects.cacheObjectsfromCM(objectPathStr, headers);
            if (null == parameterValues) {
                Message currentMessage = MessageContext.getCurrentContext().getRequestMessage();
                Attachment[] attachments = new Attachment[]{};
                try {
                    attachments = AttachmentFactory.getAttachments((Message)currentMessage);
                    if (null != attachments && attachments.length > 0) {
                        InputStream is = attachments[0].getDataHandler().getInputStream();
                        parameterValues = (ParameterValue[])ZipUtils.gunzip((InputStream)is);
                    }
                }
                catch (Exception e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
                    this.asvThrowAxisFault(e);
                }
            }
            if ((runnable = AsvRunnableAbstractFactory.getRunnable(agentObjects, headers, options, parameterValues)) instanceof BaseAgent) {
                ((BaseAgent)runnable).checkForRecursion();
            }
            this.setContextObject(runnable);
            runnable.run(null);
            if (runnable instanceof BaseAgent) {
                reply = ((BaseAgent)runnable).getReply();
            }
            this.setContextObject(runnable);
            this.debugWait("primary.wait.asv");
        }
        catch (AgentServiceException e) {
            this.asvThrowAxisFault((Exception)((Object)e));
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply == null ? this.getDefaultAsynchReply(objectPath, parameterValues, options) : reply;
    }

    public AsynchReply runSpecification(AsynchSpecification specification, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        this.throwUnsupportedOperation();
        return null;
    }

    public AsynchReply wait(AsynchRequest conversation, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        return null;
    }

    public AsynchReply getDefaultAsynchReply(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        AsynchReply reply = new AsynchReply();
        reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
        return reply;
    }

    private void deleteAgentStateOutputs(String agentStateSP, ContentManagerServiceClientPort cm) throws SDKClientException, EMFSecurityException {
        String reportVersionSP = agentStateSP + "/reportView/reportVersion/*";
        String agentOutputHotListSP = agentStateSP + "/agentOutputHotList/*";
        String[] paths = new String[]{reportVersionSP, agentOutputHotListSP};
        BaseClass[] tobeDeleted = new BaseClass[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            Nil nilObject = new Nil();
            StringProp searchPath = new StringProp();
            searchPath.setValue(path);
            nilObject.setSearchPath(searchPath);
            tobeDeleted[i] = nilObject;
        }
        cm.signNextRequest("ASV");
        DeleteOptions options = new DeleteOptions();
        options.setForce(true);
        options.setRecursive(true);
        cm.delete(tobeDeleted, options);
    }

    private void logException(Exception e) {
        if (e instanceof LocalizableException) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
        } else {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)e);
    }

    public void asvThrowAxisFault(Exception e) throws AxisFault {
        this.logException(e);
        if (e instanceof APIException) {
            super.throwAxisFault((APIException)e);
        } else if (e instanceof LocalizableException) {
            super.throwAxisFault((LocalizableException)((Object)e));
        } else {
            AgentServiceException ase = new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
            super.throwAxisFault(new APIException((LocalizableException)ase));
        }
    }
}

