/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.condition;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentConditionException;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.formatters.XMLDecodeFormatter;
import com.cognos.asv.formatters.XMLEncodeFormatter;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.mht.MHTResourceCache;
import com.cognos.asv.reportTemplates.TemplateBuilder;
import com.cognos.asv.reportTemplates.TemplateTransformer;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.streams.StringEncodedDataSource;
import com.cognos.asv.xhtml.XHTML;
import com.cognos.asv.xhtml.XHTMLGetTextResult;
import com.cognos.asv.xhtml.XHTMLNode;
import com.cognos.asv.xhtml.XHTMLSAXHandler;
import com.cognos.asv.xhtml.XHTMLTag;
import com.cognos.asv.xhtml.XHTML_HotlistVisitor;
import com.cognos.asv.xhtml.XHTML_ResourceVisitor;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AgentOptionBoolean;
import com.cognos.developer.schemas.bibus._3.AgentOptionEnum;
import com.cognos.developer.schemas.bibus._3.AgentOutputHotList;
import com.cognos.developer.schemas.bibus._3.AgentState;
import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.LanguageProp;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RetentionRule;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.util.IMimeHeaderConstants;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ZipUtils;
import com.cognos.jsmcommon.util.datasource.DataSourceFactory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.axis.attachments.AttachmentPart;

public class AgentHotlist
implements IMimeHeaderConstants {
    private BaseAgent m_agent;

    public AgentHotlist(BaseAgent agent) {
        this.m_agent = agent;
    }

    public void buildHotlist(ResultSet rs) throws AgentConditionException {
        this.checkHotlistRetentionRules();
        AgentOptionBoolean agentOptionAllowAnnotation = (AgentOptionBoolean)OptionUtils.findFirstOptionWithNameEnum((Option[])this.m_agent.getOptions(), (Object)AgentOptionEnum.allowAnnotations);
        String intermediateXMLTemplate = null;
        try {
            intermediateXMLTemplate = TemplateBuilder.instance().build("/com/cognos/asv/reportTemplates/hotlistReport.xml", this.getAgent().getHeaders());
        }
        catch (AgentServiceException e) {
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_TEMPLATE_BUILD_ERROR, e);
        }
        XHTMLTag hotlistRootNode = null;
        if (intermediateXMLTemplate != null) {
            XHTMLSAXHandler handler = new XHTMLSAXHandler();
            XHTML XHTML_processor = new XHTML(new StringReader(intermediateXMLTemplate), handler);
            XHTML_processor.parse();
            hotlistRootNode = handler.getRoot();
            hotlistRootNode.visit(new XHTML_HotlistVisitor(rs, LocaleUtil.getLocale((String)this.getAgent().getHeaders().getUserPreferenceContentLocale())));
        } else {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_HOTLIST_MHT_ERROR, new Object[]{"no report template produced for agent hotlist."});
        }
        String hotlistHTML = null;
        String hotlistMHTString = null;
        XHTMLGetTextResult hotlistGetTextResult = null;
        if (hotlistRootNode != null) {
            hotlistGetTextResult = ((XHTMLNode)hotlistRootNode).getText(new XMLEncodeFormatter(), new XMLDecodeFormatter());
            TemplateTransformer templateTransformer = new TemplateTransformer();
            try {
                hotlistHTML = templateTransformer.transformData(hotlistGetTextResult.getReader());
            }
            catch (AgentServiceException e) {
                throw new AgentConditionException(AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, e);
            }
            Properties properties = new Properties();
            properties.setProperty("mht", "true");
            TemplateTransformer templateMHTTransformer = new TemplateTransformer(TemplateTransformer.V5HTML_PATH, properties);
            try {
                hotlistMHTString = templateMHTTransformer.transformData(hotlistGetTextResult.getReader());
            }
            catch (AgentServiceException e) {
                throw new AgentConditionException(AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, e);
            }
        }
        if (hotlistMHTString != null) {
            try {
                byte[] hotlistMHT = this.buildHotlistMHT(hotlistGetTextResult.getReader(), hotlistMHTString);
                BaseClass hotlistOutput = this.saveHotlistToCM(ZipUtils.gzip(hotlistHTML), hotlistMHT, agentOptionAllowAnnotation);
                if (hotlistOutput != null) {
                    this.updateMostRecentEventList(hotlistOutput);
                }
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_HOTLIST_MHT_ERROR, new Object[]{"search path for output is null."});
            }
            catch (IOException e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)e);
                throw new AgentConditionException(AsvI18NCode.MSG_ASV_HOTLIST_CREATE_ERROR);
            }
        } else {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_HOTLIST_MHT_ERROR, new Object[]{"no agent hotlist saved."});
        }
    }

    private byte[] buildHotlistMHT(Reader sourceXML, String hotlistHTML) {
        TreeSet<String> allowed_elements = new TreeSet<String>();
        allowed_elements.add("cssUrl");
        allowed_elements.add("OIMG");
        XHTMLSAXHandler xhtmlSaxHandler = new XHTMLSAXHandler(allowed_elements);
        XHTML XHTML_processor = new XHTML(sourceXML, xhtmlSaxHandler);
        XHTML_processor.parse();
        XHTMLTag hotlistRootNode = xhtmlSaxHandler.getRoot();
        XHTML_ResourceVisitor resourceVisitor = new XHTML_ResourceVisitor();
        hotlistRootNode.visit(resourceVisitor);
        Iterator it = resourceVisitor.resourceIterator();
        byte[] hotlistMHT = null;
        try {
            String HOST = "mail.smtp.host";
            String PORT = "mail.smtp.port";
            String USER = "mail.smtp.user";
            String PASSWORD = "mail.smtp.password";
            String EMAIL_ENCODING = "email.encoding";
            String DEFAULT_SENDER = "default.sender";
            Properties props = new Properties();
            props.put("mail.smtp.host", "dummyHost");
            props.put("mail.smtp.port", "25");
            props.put("mail.smtp.user", "dummyDummy");
            props.put("mail.smtp.password", "dummyPassword");
            props.put("email.encoding", "utf-8");
            props.put("default.sender", "dummy@dummy.com");
            Session session = Session.getInstance((Properties)props);
            MimeMessage mimeMessage = new MimeMessage(session);
            MimeMultipart mimeMultiPart = new MimeMultipart("related");
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            StringEncodedDataSource stringEncodedDataSource = new StringEncodedDataSource(hotlistHTML, "UTF-8", "text/html");
            DataHandler dh = new DataHandler((DataSource)stringEncodedDataSource);
            mimeBodyPart.setDataHandler(dh);
            mimeBodyPart.addHeader("Content-Type", "text/html; charset=utf-8");
            mimeBodyPart.addHeader("Content-Transfer-Encoding", "quoted-printable");
            mimeBodyPart.addHeader("Content-Location", "hotlist.mht");
            mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart);
            MHTResourceCache resourceCache = MHTResourceCache.getInstance();
            while (it.hasNext()) {
                String resourcePath = (String)it.next();
                if (!resourceCache.loadResource(resourcePath)) continue;
                byte[] resourceData = resourceCache.getResourceData(resourcePath);
                String contentTypeHeader = resourceCache.getResourceHeader(resourcePath, "Content-Type");
                mimeBodyPart = new MimeBodyPart();
                NCDataSource ds = DataSourceFactory.getDataSource((byte[])resourceData, (String)"text/html; charset=utf-8");
                dh = new DataHandler((DataSource)ds);
                mimeBodyPart.setDataHandler(dh);
                if (contentTypeHeader != null) {
                    if (contentTypeHeader.indexOf("text/") != -1) {
                        mimeBodyPart.addHeader("Content-Transfer-Encoding", "quoted-printable");
                    } else {
                        mimeBodyPart.addHeader("Content-Transfer-Encoding", "base64");
                    }
                    mimeBodyPart.addHeader("Content-Type", contentTypeHeader);
                } else {
                    mimeBodyPart.addHeader("Content-Transfer-Encoding", "base64");
                }
                mimeBodyPart.addHeader("Content-Location", resourcePath);
                mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setContent((Multipart)mimeMultiPart);
            mimeMessage.saveChanges();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)byteArrayOutputStream);
            hotlistMHT = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (MessagingException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_HOTLIST_MHT_ERROR, new Object[]{e.getMessage()});
        }
        catch (UnsupportedEncodingException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_HOTLIST_MHT_ERROR, new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_HOTLIST_MHT_ERROR, new Object[]{e.getMessage()});
        }
        return hotlistMHT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseClass saveHotlistToCM(byte[] compressedHotlistHTML, byte[] hotlistMHT, AgentOptionBoolean agentOptionAllowAnnotation) {
        BaseClass HTMLOutput = null;
        AgentOutputHotList agentOutputHotlist = new AgentOutputHotList();
        AddOptions addOptions = new AddOptions();
        addOptions.setDataEncoding(EncodingEnum.MIME);
        addOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID});
        addOptions.setUpdateAction(UpdateActionEnum.fail);
        BooleanProp annotationProp = new BooleanProp();
        if (null != agentOptionAllowAnnotation) {
            annotationProp.setValue(agentOptionAllowAnnotation.isValue());
        } else {
            annotationProp.setValue(false);
        }
        agentOutputHotlist.setAllowAnnotations(annotationProp);
        ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(this.getAgent().getHeaders());
        try {
            cmsp.signNextRequest("ASV");
            BaseClass addedBase = cmsp.add(this.getAgentStateSearchPath(), (BaseClass)agentOutputHotlist, addOptions);
            String agentOutputHotlistSearchPath = null;
            if (addedBase != null && addedBase.getSearchPath() != null) {
                AttachmentPart ap;
                agentOutputHotlistSearchPath = addedBase.getSearchPath().getValue();
                agentOutputHotlist.setSearchPath(addedBase.getSearchPath());
                agentOutputHotlist.setStoreID(addedBase.getStoreID());
                if (compressedHotlistHTML != null) {
                    ap = this.getAttachmentPartFromZippedContent(compressedHotlistHTML);
                    compressedHotlistHTML = null;
                    Output htmlOutput = this.buildOutput("HTML", ap.getContentIdRef());
                    cmsp.addAttachment((Object)ap);
                    cmsp.signNextRequest("ASV");
                    HTMLOutput = cmsp.add(agentOutputHotlistSearchPath, (BaseClass)htmlOutput, addOptions);
                }
                if (hotlistMHT != null) {
                    ap = this.getAttachmentPartFromZippedContent(ZipUtils.gzip((byte[])hotlistMHT));
                    Output mhtOutput = this.buildOutput("MHT", ap.getContentIdRef());
                    cmsp.addAttachment((Object)ap);
                    cmsp.signNextRequest("ASV");
                    cmsp.add(agentOutputHotlistSearchPath, (BaseClass)mhtOutput, addOptions);
                }
                if (this.getAgent().usesEventOutput()) {
                    this.getAgent().setEventOutput(DataSourceFactory.getZippedDataSource((byte[])hotlistMHT, (String)"text/html", (String)"identity", (String)(this.getAgent().getBaseClass().getDefaultName().getValue() + ".mht")));
                }
                this.getAgent().setAgentOutputHotlist(agentOutputHotlist);
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_HOTLIST_CREATE_ERROR, new Object[]{e.getMessage()});
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_HOTLIST_CREATE_ERROR, new Object[]{e.getMessage()});
        }
        catch (UnsupportedEncodingException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_HOTLIST_CREATE_ERROR, new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_HOTLIST_CREATE_ERROR, new Object[]{e.getMessage()});
        }
        finally {
            cmsp.close();
        }
        return HTMLOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMostRecentEventList(BaseClass hotlistOutput) {
        if (this.getAgent() == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_HOTLIST_MHT_ERROR, new Object[]{"no agent to save the most recent event list."});
            return;
        }
        BaseAgentDefinition agentDef = (BaseAgentDefinition)this.getAgent().getBaseClass();
        BaseAgentDefinition agentDefClone = null;
        try {
            agentDefClone = (BaseAgentDefinition)agentDef.getClass().newInstance();
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(e.getMessage());
        }
        StringProp agentDefCloneStoreIDSearchPath = new StringProp();
        agentDefCloneStoreIDSearchPath.setValue(ObjectModelUtil.getSearchPath((Guid)agentDef.getStoreID().getValue()).get_value());
        agentDefClone.setSearchPath(agentDefCloneStoreIDSearchPath);
        BaseClassArrayProp newEventListId = new BaseClassArrayProp();
        newEventListId.setValue(new BaseClass[]{hotlistOutput});
        agentDefClone.setMostRecentEventList(newEventListId);
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(this.getAgent().getHeaders());
        cmPort.signNextRequest("ASV");
        try {
            cmPort.update(new BaseClass[]{agentDefClone}, new UpdateOptions());
        }
        catch (SDKClientException e) {
            String msg = "[SDKClientException] Unable to update the hotlist retention rules.";
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(msg);
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            String msg = "[EMFSecurityException] Unable to update the hotlist retention rules.";
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("Security error: " + e.getMessage());
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(msg);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
    }

    private AttachmentPart getAttachmentPartFromZippedContent(byte[] content) throws UnsupportedEncodingException, IOException {
        NCDataSource ds = DataSourceFactory.getGZippedDataSource((byte[])content, (String)"text/html", (String)"gzip");
        DataHandler dh = new DataHandler((DataSource)ds);
        AttachmentPart ap = new AttachmentPart(dh);
        ap.setMimeHeader("Content-Encoding", "gzip");
        return ap;
    }

    private String getAgentStateSearchPath() {
        return ObjectModelUtil.getSearchPath((Guid)this.getAgent().getAgentState().getStoreID().getValue()).get_value();
    }

    private Output buildOutput(String format, String contentId) {
        Output output = new Output();
        NmtokenProp formatTokenProp = new NmtokenProp();
        formatTokenProp.setValue(format);
        output.setFormat(formatTokenProp);
        LanguageProp language = new LanguageProp();
        String languageString = this.getAgent().getHeaders().getLocale().toString();
        languageString = languageString.replace('_', '-').toLowerCase();
        language.setValue(languageString);
        output.setLocale(language);
        Base64BinaryMIMEProp data = new Base64BinaryMIMEProp();
        try {
            String content = "[attribute]" + contentId;
            data.setValue(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        output.setData(data);
        return output;
    }

    private void checkHotlistRetentionRules() {
        AgentState agentState;
        RetentionRule agentDefHistoryRule = null;
        RetentionRule agentStateHotlistRule = null;
        BaseAgentDefinition agentDef = (BaseAgentDefinition)this.getAgent().getBaseClass();
        if (agentDef.getRetentions() != null && agentDef.getRetentions().getValue() != null) {
            RetentionRule[] agentDefRules = agentDef.getRetentions().getValue();
            for (int i = 0; i < agentDefRules.length; ++i) {
                RetentionRule rr = agentDefRules[i];
                if (!rr.getObjectClass().getValue().equals("history")) continue;
                agentDefHistoryRule = rr;
                break;
            }
        }
        if ((agentState = this.getAgent().getAgentState()) == null) {
            String debugMsg = "AgentState not found - hotlist retention rule check aborted";
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(debugMsg);
            return;
        }
        if (agentState.getRetentions() != null && agentState.getRetentions().getValue() != null) {
            RetentionRule[] agentStateRules = agentState.getRetentions().getValue();
            for (int i = 0; i < agentStateRules.length; ++i) {
                RetentionRule rr = agentStateRules[i];
                if (!rr.getObjectClass().getValue().equals("agentOutputHotList")) continue;
                agentStateHotlistRule = rr;
                break;
            }
        }
        boolean updateAgentStateRule = false;
        if (agentDefHistoryRule != null && agentStateHotlistRule != null) {
            if (agentDefHistoryRule.getMaxObjects() == null) {
                if (agentStateHotlistRule.getMaxObjects() != null) {
                    updateAgentStateRule = true;
                }
            } else if (agentStateHotlistRule.getMaxObjects() != null && !agentStateHotlistRule.getMaxObjects().equals(agentDefHistoryRule.getMaxObjects())) {
                updateAgentStateRule = true;
            }
            if (agentDefHistoryRule.getMaxDuration() == null) {
                if (agentStateHotlistRule.getMaxDuration() != null) {
                    updateAgentStateRule = true;
                }
            } else if (agentStateHotlistRule.getMaxDuration() != null && !agentStateHotlistRule.getMaxDuration().equals(agentDefHistoryRule.getMaxDuration())) {
                updateAgentStateRule = true;
            }
        }
        if (updateAgentStateRule) {
            this.updateAgentStateHotlistRetentionRule(agentStateHotlistRule, agentDefHistoryRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgentStateHotlistRetentionRule(RetentionRule existingStateRule, RetentionRule historyRule) {
        AgentState agentState = this.getAgent().getAgentState();
        existingStateRule.setMaxDuration(historyRule.getMaxDuration());
        existingStateRule.setMaxObjects(historyRule.getMaxObjects());
        existingStateRule.setProp(historyRule.getProp());
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(this.getAgent().getHeaders());
        StringProp agentStateSearchPath = agentState.getSearchPath();
        try {
            StringProp agentStateStoreIDSearchPath = new StringProp();
            agentStateStoreIDSearchPath.setValue(ObjectModelUtil.getSearchPath((Guid)agentState.getStoreID().getValue()).get_value());
            agentState.setSearchPath(agentStateStoreIDSearchPath);
            cmPort.update(new BaseClass[]{agentState}, new UpdateOptions());
        }
        catch (SDKClientException e) {
            String msg = "[SDKClientException] Unable to update the hotlist retention rules.";
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(msg);
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            String msg = "[EMFSecurityException] Unable to update the hotlist retention rules.";
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("Security error: " + e.getMessage());
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(msg);
        }
        finally {
            agentState.setSearchPath(agentStateSearchPath);
            if (cmPort != null) {
                cmPort.close();
            }
        }
    }

    private BaseAgent getAgent() {
        return this.m_agent;
    }
}

