/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.condition;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSetSortTopic;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.XMLParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.dom4j.util.NodeComparator;
import org.xml.sax.SAXException;

public class ReportSpecificationParser {
    private Document m_specDoc;
    private ISpecUpgrader m_upgrader;
    private static final String TOPIC_NAME = "@refDataItem";
    private static final String SORT_ORDER = "@sortOrder";
    private static final String SORT_ITEMS = "//*[local-name()='list']/*[local-name()='sortList']/*[local-name()='sortItem']";
    private static final String ASCENDING = "ascending";

    public ReportSpecificationParser(String specs) throws AgentServiceException {
        try {
            if (specs == null || specs.length() == 0) {
                specs = "<report xmlns=\"http://developer.cognos.com/schemas/report/5.0/\" expressionLocale=\"en-CA\"><layouts><layout/></layouts></report>";
            }
            this.m_specDoc = DocumentHelper.parseText((String)specs);
            this.m_specDoc.normalize();
        }
        catch (DocumentException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_CANNOT_PARSE_REPORT_SPEC, new Object[]{e.getLocalizedMessage()});
        }
    }

    public ResultSetSortTopic[] getSortTopics() throws AgentServiceException {
        ArrayList<ResultSetSortTopic> result = new ArrayList<ResultSetSortTopic>();
        try {
            List sortListElements = this.m_specDoc.selectNodes(SORT_ITEMS);
            for (Element element : sortListElements) {
                Node topicValueNode = element.selectSingleNode(TOPIC_NAME);
                Node sortOrderNode = element.selectSingleNode(SORT_ORDER);
                String topicValue = topicValueNode.getText();
                String sortOrder = sortOrderNode != null ? sortOrderNode.getText() : ASCENDING;
                MetadataItem item = new MetadataItem(topicValue, topicValue, topicValue);
                ResultSetSortTopic topic = new ResultSetSortTopic(item.makeTopic(), sortOrder);
                result.add(topic);
            }
        }
        catch (Exception e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_SORT_RESULTSET, e);
        }
        return result.toArray(new ResultSetSortTopic[0]);
    }

    public String asXML() throws IOException {
        return this.m_specDoc.asXML();
    }

    public boolean specEqualTo(Object obj) {
        boolean result = true;
        if (obj instanceof ReportSpecificationParser) {
            ReportSpecificationParser parser = (ReportSpecificationParser)obj;
            result = this.compareNodes(parser.m_specDoc, this.m_specDoc, "//*[local-name()='selection'][./*[local-name()='dataItem']]");
            result = result && this.compareNodes(parser.m_specDoc, this.m_specDoc, "//*[local-name()='detailFilters']");
            result = result && this.compareNodes(parser.m_specDoc, this.m_specDoc, "//*[local-name()='summaryFilters']");
            String nameSpace1 = parser.m_specDoc.getRootElement().getNamespaceURI();
            String nameSpace2 = this.m_specDoc.getRootElement().getNamespaceURI();
            if (!result && nameSpace1 != null && nameSpace2 != null && !nameSpace1.equals(nameSpace2)) {
                String debugMsg = "ReportSpecificationParser SpecUpgrader: Previous event run's report specification version does not match with current report specification. \n found: " + nameSpace1 + ", expected: " + nameSpace2 + ", so will proceed with upgrade for event runs's report spcification";
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(debugMsg);
                try {
                    ISpecUpgrader upgrader = this.getUpgrader();
                    parser.m_specDoc = upgrader.upgrade(parser.m_specDoc);
                    this.m_specDoc = upgrader.upgrade(this.m_specDoc);
                    result = this.specEqualTo(obj);
                }
                catch (AgentServiceException e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)e);
                }
            }
        }
        return result;
    }

    private boolean compareNodes(Document doc1, Document doc2, String xPath) {
        Node node1 = doc1.selectSingleNode(xPath);
        Node node2 = doc2.selectSingleNode(xPath);
        NodeComparator comp = new NodeComparator();
        boolean result = false;
        result = node1 != null && node2 != null ? comp.compare(node1, node2) == 0 : node1 == null && node2 == null;
        return result;
    }

    public int hashCode() {
        return this.m_specDoc.hashCode();
    }

    public void setUpgrader(ISpecUpgrader upgrader) {
        this.m_upgrader = upgrader;
    }

    public ISpecUpgrader getUpgrader() {
        if (this.m_upgrader == null) {
            this.m_upgrader = new SpecUpgrader();
        }
        return this.m_upgrader;
    }

    class SpecUpgrader
    implements ISpecUpgrader {
        private Object messages = null;
        private Object config = null;
        private Object upgrader = null;

        SpecUpgrader() {
        }

        @Override
        public Document upgrade(Document document) throws AgentServiceException {
            Object doc = this.dom4jToW3c(document);
            try {
                String debugMsg = "ReportSpecificationParser SpecUpgrader: report specification upgrade started";
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(debugMsg);
                doc = this.getUpgradeMethod().invoke(this.getUpgrader(), doc);
                debugMsg = "ReportSpecificationParser SpecUpgrader: report specification upgraded with success.";
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(debugMsg);
            }
            catch (ClassNotFoundException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, e);
            }
            catch (IllegalArgumentException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, e);
            }
            catch (SecurityException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, e);
            }
            catch (IllegalAccessException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, e);
            }
            catch (InvocationTargetException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, e);
            }
            catch (NoSuchMethodException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, e);
            }
            catch (InstantiationException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, e);
            }
            return this.w3cToDom4j((org.w3c.dom.Document)doc);
        }

        private Document w3cToDom4j(org.w3c.dom.Document w3cDoc) {
            DOMReader reader = new DOMReader();
            return reader.read(w3cDoc);
        }

        private org.w3c.dom.Document dom4jToW3c(Document dom4jDoc) throws AgentServiceException {
            org.w3c.dom.Document doc = null;
            try {
                StringReader reader = new StringReader(dom4jDoc.asXML());
                XMLParser parser = new XMLParser((Reader)reader);
                doc = parser.parse();
            }
            catch (ParserConfigurationException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, new Object[]{e.getLocalizedMessage()});
            }
            catch (IOException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, new Object[]{e.getLocalizedMessage()});
            }
            catch (SAXException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_UNABLE_TO_UPGRADE_REPORT_SPEC, new Object[]{e.getLocalizedMessage()});
            }
            return doc;
        }

        private Object getUpgrader() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
            if (this.upgrader == null) {
                Class<?> upgradeReportSpecClass = Class.forName("com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeReportSpecification");
                Class<?> messagesClass = Class.forName("com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages");
                Class<?> configClass = Class.forName("com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration");
                Constructor<?> constructor = upgradeReportSpecClass.getConstructor(messagesClass, configClass);
                this.upgrader = constructor.newInstance(this.getMessages(), this.getConfig());
            }
            return this.upgrader;
        }

        private Method getUpgradeMethod() throws SecurityException, IllegalArgumentException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
            return this.getUpgrader().getClass().getMethod("upgrade", org.w3c.dom.Document.class);
        }

        private Object getMessages() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            if (this.messages == null) {
                Class<?> messagesClass = Class.forName("com.cognos.rspecupgrade.rsupgrade.internal.messages.MessagesImpl");
                this.messages = messagesClass.newInstance();
            }
            return this.messages;
        }

        private Object getConfig() throws ClassNotFoundException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (null == this.config) {
                Class<?> configClass = Class.forName("com.cognos.rspecupgrade.rsupgrade.internal.configuration.Configuration");
                Class<?> messagesClass = Class.forName("com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages");
                Constructor<?> configConst = configClass.getConstructor(messagesClass, File.class, Properties.class);
                this.config = configConst.newInstance(this.getMessages(), null, null);
            }
            return this.config;
        }
    }

    static interface ISpecUpgrader {
        public Document upgrade(Document var1) throws AgentServiceException;
    }
}

